/*  File: tags.h
 *  Author: Danielle et Jean Thierry-Mieg (mieg@mrc-lmb.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1994
 *-------------------------------------------------------------------
 * Acedb is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * or see the on-line version at http://www.gnu.org/copyleft/gpl.txt
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (Sanger Centre, UK) rd@sanger.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@crbm.cnrs-mop.fr
 *
 * Description:
 * Exported functions:
 *              classInit
 *              tagInit
 * HISTORY:
 * Last edited: Aug 26 08:08 2002 (edgrif)
 * Created: Tue Aug 30 19:02:26 1994 (mieg)
 * CVS info:   $Id: tags.h,v 1.16 2002/08/26 08:48:42 edgrif Exp $
 *-------------------------------------------------------------------
 */
#ifndef DEF_TAG_H
#define DEF_TAG_H

/*
   As from release 3-4, the tags are declared as dynamical KEY
 for convenience they can be listed here, but it is not imperative.

 After they are declared here as external, they must also be 
 ALLOCATED and INITIALISED (via a lexaddkey) either in tags.c or
 in your application code.
*/


void classInit (void);
void tagInit (void);

/************************************************/

extern KEY
  _1_does_not_include_2,
  _1_includes_2,
  _2_point,
  _A1_labelling,
  _A_non_B,
  _Abstract,
  _Address,
  _Aligned,
  _Aligned_into,
  _Allele,
  _Allele_designation,
  _Alu_segment,
  _Amber,
  _Approximate_Match_to,
  _Assembly_repeat,
  _Assembly_tags,
  _Ace_mbly_tags,
  _Author,
  _Autopos,
  _B_non_A,
  _Back_one,
  _Backcross,
  _Balances,
  _Bands,
  _Bitnet,
  _Brief_identification,
  _CDS,
  _CDS_predicted_by,
  _CGC,
  _Calc,
  _Calc_distance,
  _Calc_lower_conf,
  _Calc_upper_conf,
  _Calculation,
  _Calculation_1,
  _Calculation_2,
  _Canon_for_cosmid,
  _Canonical_for,
  _Chromosome,
  _Cleavage,
  _Clone,
  _Subclone, 
  _Clone_as_locus,
  _Clone_inside,
  _Clone_outside,
  _Cloning_vector,
  _Coding,
  _Cold_sensitive,
  _Columns,
  _Combined,
  _Comment,
  _Company,
  _Complementation_data,
  _Complex_mixed,
  _Compound,
  _Compression,
  _Contained_in,
  _Contains,
  _Contents,
  _Contig,
  _Contig9,
  _Contiguous,
  _Correct_name,
  _Corresponding_DNA,
  _Corresponding_peptide,
  _Cosmid_grid,
  _Cosmid_vector,
  _Covers,
  _DB_remark,
  _DB_searched,
  _DNA,
  _DNA_homol,
  _Deletion,
  _Description,
  _Designating_laboratory,
  _Detection_method,
  _Df_Dup,
  _Direct,
  _Display,
  _Distance,
  _Does_not_hybridize_to,
  _Dom_let,
  _Dom_one,
  _Dom_selected,
  _Dom_semi,
  _Dominant,
  _Duplication,
  _E_mail,
  _End_not_found,
  _Error,
  _Error_scale,
  _Exact_Match_to,
  _Experiment,
  _Expression_construct,
  _Extent,
  _Fax,
  _Features,
  _FingerPrint,
  _Finished,
  _Flag,
  _Float_Params,
  _Free_dup,
  _Freezer,
  _From,
  _From_Author,
  _From_Laboratory,
  _From_Library,
  _From_left_end,
  _From_map,
  _Full,
  _Full_name,
  _Function,
  _Funny_Match_to,
  _Gel_Number,
  _Gel_length,
  _Gene,
  _Gene_class,
  _Gene_classes,
  _General,
  _General_remark,
  _Genetics,
  _Genomic_Canonical,
  _Genotype,
  _Gridded,
  _Heat_sensitive,
  _Homol,
  _Hybrid_cell_line,
  _Hybridizes_to,
  _In_Situ,
  _In_pool,
  _Inherits,
  _Inside,
  _Int_Params,
  _Internet,
  _Interval,
  _Intragenic_revertant_of_dominant,
  _Inverted,
  _Isolation,
  _Isoschizomers,
  _Journal,
  _Keyword,
  _Laboratory,
#if !defined(MACINTOSH)
  _Layout,
#endif
  _Left,
  _Length,
  _Library,
  _Lines_at,
  _Linkage,
  _LiquidN2,
  _Location,
  _Locus,
  _Locus_1,
  _Locus_2,
  _Locus_A,
  _Locus_B,
  _Loop,
  _Mail,
  _Males,
  _Map,
  _Mapper,
  _Mapping_data,
  _Maps_with,
  _Marker_locus,
  _Matching_Genomic,
  _Matching_cDNA,
  _Maternal,
  _Max,
  _Min,
  _Min_score,
  _Minus70,
  _Molecular_information,
  _Multi_point,
  _Muscle,
  _Mutagen,
  _N_gaps,
  _Name,
  _Negative_clone,
  _Negative_locus,
  _Negative_probe,
  _Nick_name,
  _No_overlap,
  _No_stagger,
  _Offset,
  _Old_CGC_distance,
  _Old_CGC_results,
  _Oligo,
  _One_all,
  _One_let,
  _One_recombinant,
  _Origin,
  _Other_name,
  _Outside,
  _Overhang,
  _Overlap,
  _PCR_product,
  _PCR_remark,
  _Page,
  _Paper,
  _Parameters,
  _Paternal,
  _Pattern,
  _Pep_homol,
  _Peptide,
  _Percent_Identity,
  _Phenotype,
  _Phone,
  _Polymorphism,
  _Position,
  _Positive_clone,
  _Positive_locus,
  _Positive_pool_probe,
  _Positive_probe,
  _Possible_exon,
  _Precursor,
  _Primers,
  _Procedure,
  _Processed_mRNA,
  _Product,
  _Properties,
  _Protocol,
  _Pseudogene,
  _Publisher,
  _Qualifier,
  _RFLP,
  _RNA,
  _Rearrangement,
  _Rearrangement_1,
  _Rearrangement_2,
  _Recessive,
  _Recs_all,
  _Reference,
  _Reference_Allele,
  _Reference_strain,
  _Refers_to,
  _Rejected,
  _Rejected_from,
  _Rejected_Reads,
  _Related_Sequence,
  _Remark,
  _Repeats,
  _Representative,
  _Results,
  _Right,
  _Row,
  _Score,
  _Search_Method,
  _Selected,
  _Selected_loci,
  _Selected_trans,
  _SELF,
  _Semi_dominant,
  _Seq_length,
  _Sequence,
  _Sequencing_vector,
  _Sex_cis,
  _Sex_full,
  _Sex_one,
  _Shotgun,
  _Significant_bases,
  _Similarity,
  _Site,
  _Source,
  _Source_Exons,
  _Space_at,
  _Species,
  _Staff,
  _Start_not_found,
#if !defined(MACINTOSH)
  _Status,
#endif
  _Stop,
  _Strain,
  _Strain_designation,
  _Strictly_Maternal,
  _Structure,
  _Subsequence,
  _TATA_signal,
  _TSL,
  _TSL_site,
  _Tandem,
  _Temperature,
  _Temperature_sensitive,
  _Tested,
  _Text_Params,
  _Title,
  _To_right_end,
  _Trace_quality,
  _Excellent_upto,
  _Good_upto,
  _Fair_upto,
  _Transcript,
  _Translocation,
  _Transposon,
  _Transposon_insertion,
  _Type,
  _Type_1,
  _Type_2,
  _Unit_Length,
  _Unprocessed_mRNA,
  _Variant,
  _Variant_of,
  _Vaxmap,
  _Vector,
  _Version,
  _Volume,
  _Weak,
  _Well_ordered,
  _With_Maternal_Effect,
  _Y_remark,
  _Year,
  _cDNA,
  _mRNA,
  _mat_peptide,
  _misc_feature,
  _misc_signal,
  _modified_base,
  _mutation,
  _old_sequence,
  _pMap,
  _polyA_signal,
  _polyA_site,
  _promoter,
  _rRNA,
  _repeat_region,
  _repeat_unit,
  _sig_peptide,
  _snRNA,
  _tRNA,
  _A_Repeat,
  _Note,
  _Subpool,
  _Colour,
  _ORF,
  _ATG,
  _Splice3,
  _Splice5,
  _Coding_seg,
  _Foreign_Reference,
  _Virtual_row,
  _In_grid,
  _Chrom_Band,
  _Centromere,
  _Dark,
  _NOR,
  _Inherits_from,
  _Fate,
  _Lineage,
  _Parent,
  _Daughter,
  _Group,
  _In_group,
  _Group_member,
  _Neurodata,
  _Send,
  _Send_joint,
  _Receive,
  _Receive_joint,
  _Gap_junction,
  _Contact,
  _Lineage_name,
  _Equivalence_fate,
  _Equivalence_origin,
  _Embryo_division_time,
  _Clone_left_end,
  _Clone_right_end,
  _Derived_from,
  _Derivative,
  _Isolated_for,
  _Wormpep,
  _Replaces,
  _Replaced_by,
  _Confidential_remark,
  _Submitted,
  _Overlap_right,
  _Overlap_left,
  _Repeat_consensus,
  _cDNA_EST,
  _Archived,
  _Lethal,
  _Hand_fixed,
  _Balancer,
  _Region,
  _Hand_verified,
  _YAC,
  _Cytogenetic,
  _Inside_YAC,
  _Inside_Fragment,
  _Bibliography,
  _Links,
  _Link,
  _Chimeric,
  _Non_Chimeric,
  _Size,
  _Interval_Mapping,
  _Main_Marker,
  _Ends,
  _Mapping,
  _p_Telomere,
  _q_Telomere,
  _Drawing,
  _Multi_Position,
  _Multiplet,
  _Does_not_Contain,
  _Contained_Locus,
  _Exterior_Locus,
  _Inside_Rearr,
  _Outside_Rearr,
  _Overlaps,
  _Does_not_Overlap,
  _No_Overlap_Rearr,
  _Overlapping_Rearr,
  _Contained_Rearr,
  _Email,
  _Flipped,
  _Assembled_as_dummy,
  _Previous_contig,
  _Assembled_from,
  _Assembled_into,
  _Proposed,
  _BaseCall,
  _Genetic,
  _Physical,
  _Restriction_Enzyme,
  _AA,
  _Clone_Grid,
  _Df_Dup_data,
  _Fragment,
  _Pages,
  _Medline_ID,
  _Lab_Location,
  _Match,
  _Method,
  _Motif,
  _MultiMap,
  _Multi_counts,
  _Multi_pt_data,
  _Pool,
  _Unpublished,
  _EC_enzyme,
  _Document,
  _Unit,
  _Enzyme,
  _GDB_id,
  _OMIM,
  _Probe,
  _ATCC_ref,
  _Add_date,
  _Annotation,
  _Approval_date,
  _Approved,
  _Assign_mode,
  _Availability,
  _CS,
  _Cosmid_clones,
  _Created,
  _Current_symbol,
  _Cytogenetic_location,
  _DNA_type,
  _Data_source,
  _EC_ref,
  _Editing_Date,
  _Excision_Data,
  _GDB,
  _GenBank_ref,
  _HGML_ref,
  _KW,
  _Links_to,
  _Max_heterozygosity,
  _Modification_date,
  _Modified,
  _OMIM_document,
  _Old_Num,
  _Originator,
  _Polymorphism_Data,
  _Previous_symbol,
  _Vector_type,
  _Primer,
  _SCF_File,
  _PCR,
  _Cor,
  _Neighbours,
  _Common_bands,
  _Band_Values,
  _Segment_Lengths,
  _Fragment_of,
  _ABI,
  _Wild_type,
  _ABI_Date,
  _ABI_Comment,
  _ABI_Machine,
  _Sample,
  _ABI_Analysis,
  _Run_Start,
  _Run_Stop,
  _Clipped,
  _Clipping,
  _Old_Clipping,
  _Vector_Clipping,
  _Hand_Clipping,
  _Symbol,
  _Anchor,
  _Band,
  _Gel,
  _Band_Lengths,
  _Otto,
  _Main_Locus,
  _STS,
  _Checked_individually,
  _Outside_YAC,
  _STS_out,
  _AluPCR,
  _by_AluPCR_Hybridisation,
  _by_Finger_Printing,
  _Kpn,
  _THE,
  _Somatic_hybrid,
  _Genethon,
  _Route_2,
  _Inside_YAC_Not_Verified,
  _Locus_Not_Verified,
  _Possibly_Contains_Locus,
  _Possibly_Inside_YAC,
  _Locus_Out,
  _Allelic_Variants,
  _Clinical_Synopses,
  _Cross_References,
  _Diagnosis,
  _Evolution,
  _Historical_Information,
  _Index_Terms,
  _Last_Edited,
  _Locus_Description,
  _MIM_Number,
  _Old_MIM_Number,
  _Population_Genetics,
  _References,
  _Treatment,
  _Main_Text,
  _Animal_Models,
  _map_location,
  _map_error,
  _LongText,
  _PCR_data,
  _Clone_data,
  _Oligo_DNA,
  _Allelep,
  _Allelem,
  _Gametep,
  _Gametem,
  _Tetrad,
  _Centromere_segregation,
  _Genetic_code, 
  _Lethal_tested,

/* for Action class (added by P.Kocab) */

  _description,
  _used_in,
  _action_type,
  _internal,
  _ace_query,
  _ace_dump,
  _name_dump,
  _tace_command,
  _external,
  _compound,
  _action_element,
  _params,
  _no_report_status,
  _read_ace,
  _synchro,
  _import_keyset,

/* for comparative maps (added by jld) */

  _Homology,
  _Doc,
  _Pairwise,
  _Fuzzy,
  _Symbol,
  _SMAP, 
  _S_Parent ;
 

#endif /*  !defined DEF_TAG_H */
