C  Copyright (c) 2003-2010 University of Florida
C
C  This program is free software; you can redistribute it and/or modify
C  it under the terms of the GNU General Public License as published by
C  the Free Software Foundation; either version 2 of the License, or
C  (at your option) any later version.

C  This program is distributed in the hope that it will be useful,
C  but WITHOUT ANY WARRANTY; without even the implied warranty of
C  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C  GNU General Public License for more details.

C  The GNU General Public License is included in this distribution
C  in the file COPYRIGHT.
      SUBROUTINE IRREPS(Q,PTGRP,NDEG,V,LENV,IRREP,SCRATCH)
C
C SUBROUTINE DETERMINES THE IRREDUCIBLE REPRESENTATION TO WHICH
C  VECTOR V BELONGS, GIVEN THE MOLECULAR POINT GROUP.
C  LENV IS EQUAL TO 3*NATOMS.  NDEG IS THE DEGENERACY OF THE PARTICULAR
C  NORMAL MODE, MAKING THE LENGTH OF THE V VECTOR EQUAL TO NDEG*LENV.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "mxatms.par"
      PARAMETER (TOL = 1.D-2)
      CHARACTER*4 PTGRP
      CHARACTER*4 IRREP
      CHARACTER*2 GREEK(4)     
      DIMENSION V(NDEG*LENV),SCRATCH(3*LENV),NORD(2*MXATMS),Q(LENV)
      DATA GREEK /'SG','PI','DE','PH'/
      IRREP='    '
      NPOS=LENV/3
      RT2=DSQRT(2.D0)
      RT3=DSQRT(3.D0)
      C72=2.D0*DCOS(0.4*DACOS(-1.D0))
      C144=2.D0*DCOS(0.8*DACOS(-1.D0))
C
C   GET SORTED COORDINATE VECTOR FOR Q AND HOLD IN LOW END OF
C   SCRATCH VECTOR.  BOTTOM END OF NORD CONTAINS POSITIONING LIST
C   RETURNED BY SORTXYZ.  
C
       CALL ZERO(SCRATCH,3*LENV)
C
C Note that LENV is 3*NATOMS and SORTXYZ needs only the number of
C atoms. 06/2006, Ajith Perera.
C
       CALL SORTXYZ(Q,SCRATCH,NORD,LENV/3)
C
C ABELIAN GROUPS FIRST!
C
C DEAL WITH TRIVIAL CASE OF C1 SYMMETRY HERE AND DO EASY POINT GROUPS
C  WHICH HAVE ONLY ONE SYMMETRY OPERATION.
C
      IF(PTGRP(1:3).EQ.'C 1'.OR.PTGRP(1:3).EQ.'C1 ')THEN
       IRREP='   A'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'C s')THEN
       CALL COMVEC(NDEG,'P',0,0,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       IRREP=' A'' '
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP=' A'''''
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'C i')THEN
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       IRREP='  Ag'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP='  Au'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'C2 ')THEN
       CALL COMVEC(NDEG,'C',2,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       IRREP='   A'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP='   B'
       RETURN
C
C NOW DO ALL POINT GROUPS WITH JUST TWO OR THREE NONTRIVIAL OPERATIONS.
C
      ELSEIF(PTGRP(1:3).EQ.'C2h')THEN
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',2,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       IRREP='  Ag'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='u'
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(3:3)='B'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'C2v')THEN
       CALL COMVEC(NDEG,'C',2,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'P',0,0,2,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       IRREP='  A1'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(3:3)='B'
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(4:4)='2'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D2h')THEN
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',2,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       CALL COMVEC(NDEG,'C',2,1,2,NPOS,Q,SCRATCH,NORD,V,OVRLP3)
       IRREP='  Ag'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='u'
       IF(DABS(OVRLP2+1.D0).LT.TOL.AND.DABS(OVRLP3+1.D0).LT.TOL)
     &  IRREP(2:3)='B3'
       IF(DABS(OVRLP2+1.D0).LT.TOL.AND.DABS(OVRLP3-1.D0).LT.TOL)
     &  IRREP(2:3)='B2'
       IF(DABS(OVRLP2-1.D0).LT.TOL.AND.DABS(OVRLP3+1.D0).LT.TOL)
     &  IRREP(2:3)='B1'
       RETURN
C
C NOW DO GROUPS CONTAINING DOUBLY DEGENERATE REPRESENTATIONS.
C
       ELSEIF(PTGRP(1:3).EQ.'C3v')THEN
        CALL COMVEC(NDEG,'P',0,0,2,NPOS,Q,SCRATCH,NORD,V,OVRLP)
        IF(DABS(OVRLP-1.D0).LT.TOL)IRREP='  A1'
        IF(DABS(OVRLP+1.D0).LT.TOL)IRREP='  A2'
        IF(NDEG.EQ.2)IRREP='   E'
       RETURN
       ELSEIF(PTGRP(1:3).EQ.'C4v')THEN
        IRREP='  A1'
        CALL COMVEC(NDEG,'C',4,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
        CALL COMVEC(NDEG,'P',0,0,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
        IF(NDEG.EQ.2)IRREP='   E'
        IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(3:3)='A'
        IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(3:3)='B'
        IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(4:4)='2'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'C5v')THEN
       CALL COMVEC(NDEG,'C',5,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'P',0,0,2,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP='  A1'
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP='  A2'
       IF(ABS(OVRLP-C72).LT.TOL)IRREP='  E1'
       IF(ABS(OVRLP-C144).LT.TOL)IRREP='  E2'
      RETURN
      ELSEIF(PTGRP(1:3).EQ.'C6v')THEN
       CALL COMVEC(NDEG,'C',6,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'P',0,0,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(3:3)='A'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(3:3)='B'
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(4:4)='1'
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(4:4)='2'
       IF(NDEG.EQ.2)THEN
        IF(DABS(OVRLP-1.D0).LT.TOL)IRREP='  E1'
        IF(DABS(OVRLP+1.D0).LT.TOL)IRREP='  E2'
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'C3h')THEN
       CALL COMVEC(NDEG,'P',0,0,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP=' A'''''
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP=' A'' '
       IF(NDEG.EQ.2)THEN
        IF(DABS(OVRLP+2.D0).LT.TOL)IRREP=' E'''''
        IF(DABS(OVRLP-2.D0).LT.TOL)IRREP=' E'' '
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'C4h')THEN
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',4,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='u'
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(4:4)='g'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(3:3)='B'
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(3:3)='A'
       IF(NDEG.EQ.2)THEN
        IF(DABS(OVRLP+2.D0).LT.TOL)IRREP='  Eu'
        IF(DABS(OVRLP-2.D0).LT.TOL)IRREP='  Eg'
       ENDIF       
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'C5h')THEN
       CALL COMVEC(NDEG,'P',0,0,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       OVRLP=OVRLP/FLOAT(NDEG)
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(3:4)=''''''
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(3:4)=''' '
       IF(NDEG.EQ.1)IRREP(2:2)='A'
       IF(NDEG.EQ.2)THEN
        IRREP(1:1)='E'
        CALL COMVEC(NDEG,'C',5,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
        IF(DABS(OVRLP-C72).LT.TOL)IRREP(3:3)='1'
        IF(DABS(OVRLP-C144).LT.TOL)IRREP(3:3)='2'
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'C6h')THEN
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',6,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       CALL COMVEC(NDEG,'C',2,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP3)
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(4:4)='g'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='u'
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(3:3)='B'
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(3:3)='A'
       IF(NDEG.EQ.2)THEN
        IF(DABS(OVRLP3-2.D0).LT.TOL)IRREP(2:3)='E2'
        IF(DABS(OVRLP3+2.D0).LT.TOL)IRREP(2:3)='E1'
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D2d')THEN
       IF(NDEG.EQ.2)THEN
        IRREP='   E'
        RETURN
       ENDIF
       CALL COMVEC(NDEG,'S',4,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(3:3)='A'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(3:3)='B'
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(4:4)='1'
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(4:4)='2'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D3d')THEN
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(2:3)='A2'
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(2:3)='A1'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='u'
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(4:4)='g'
       IF(NDEG.EQ.2)THEN
        IF(DABS(OVRLP+2.D0).LT.TOL)IRREP(3:4)='Eu'
        IF(DABS(OVRLP-2.D0).LT.TOL)IRREP(3:4)='Eg'
        RETURN
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D4d')THEN
       CALL COMVEC(NDEG,'S',8,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(3:3)='B'
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(3:3)='A'
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(4:4)='2'
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(4:4)='1'
       IF(NDEG.EQ.2)THEN
        IF(DABS(OVRLP-RT2).LT.TOL)IRREP='  E1'
        IF(DABS(OVRLP).LT.TOL)IRREP='  E2'
        IF(DABS(OVRLP+RT2).LT.TOL)IRREP='  E3'
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D5d')THEN
       CALL COMVEC(NDEG,'C',5,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP3)
       IRREP=' A1g'
       OVRLP3=OVRLP3/FLOAT(NDEG)
       IF(DABS(OVRLP3+1.D0).LT.TOL)IRREP(4:4)='u'
       IF(DABS(OVRLP3-1.D0).LT.TOL)IRREP(4:4)='g'
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(2:3)='A2'
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(2:3)='A1'
       IF(NDEG.EQ.2)THEN
        IF(DABS(OVRLP-C144).LT.TOL)IRREP(2:3)='E2'
        IF(DABS(OVRLP+C144).LT.TOL)IRREP(2:3)='E1'
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D6d')THEN
       CALL COMVEC(NDEG,'S',12,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       IF(NDEG.EQ.2)THEN
        IF(DABS(OVRLP-RT3).LT.TOL)IRREP='  E1'
        IF(DABS(OVRLP-1.D0).LT.TOL)IRREP='  E2'
        IF(DABS(OVRLP).LT.TOL)IRREP='  E3'
        IF(DABS(OVRLP+1.D0).LT.TOL)IRREP='  E4'
        IF(DABS(OVRLP+RT3).LT.TOL)IRREP='  E5'
       ELSE
        IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(3:3)='B'
        IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(3:3)='A'
        IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(4:4)='2'
        IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(4:4)='1'
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'S4 ')THEN
       CALL COMVEC(NDEG,'S',4,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP='   A'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP='   B'
       IF(NDEG.EQ.2)IRREP='   E'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'S6 ')THEN
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       IRREP(3:3)='A'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='u'
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(4:4)='g'
       IF(NDEG.EQ.2)IRREP(3:3)='E'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'S8 ')THEN
       CALL COMVEC(NDEG,'S',8,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       IF(NDEG.EQ.1)THEN
        IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(3:4)='A '
        IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(3:4)='B '
       ELSE
        IF(DABS(OVRLP-RT2).LT.TOL)IRREP(3:4)='E1'
        IF(DABS(OVRLP).LT.TOL)IRREP(3:4)='E2'
        IF(DABS(OVRLP+RT2).LT.TOL)IRREP(3:4)='E3'  
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D3h')THEN
       CALL COMVEC(NDEG,'P',0,0,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       OVRLP=OVRLP/FLOAT(NDEG)
       OVRLP2=OVRLP2/FLOAT(NDEG)
       IF(NDEG.EQ.1)IRREP(1:1)='A'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(3:4)=''''''
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(3:4)=''' '
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(2:2)='2'
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(2:2)='1'
       IF(NDEG.EQ.2)IRREP(2:2)='E'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D4h')THEN
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRL2)
       CALL COMVEC(NDEG,'C',4,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       OVRLP=OVRLP/FLOAT(NDEG)
       IF(DABS(OVRL2-1.D0).LT.TOL)IRREP(3:3)='1'
       IF(DABS(OVRL2+1.D0).LT.TOL)IRREP(3:3)='2'
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(4:4)='g'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='u'
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(2:2)='A'
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(2:2)='B'
       IF(NDEG.EQ.2)IRREP(2:3)=' E'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D5h')THEN
       CALL COMVEC(NDEG,'P',0,0,3,NPOS,Q,SCRATCH,NORD,V,OVRLPP)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       CALL COMVEC(NDEG,'C',5,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       PDP=OVRLPP/FLOAT(NDEG)
       IF(NDEG.EQ.1)IRREP(1:1)='A'
       IF(DABS(PDP+1.D0).LT.TOL)IRREP(3:4)=''''''
       IF(DABS(PDP-1.D0).LT.TOL)IRREP(3:4)=''' '
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(2:2)='2'
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(2:2)='1'
       IF(NDEG.EQ.2)THEN
        IF(DABS(OVRLP-C72).LT.TOL)IRREP(1:2)='E1'
        IF(DABS(OVRLP-C144).LT.TOL)IRREP(1:2)='E2'
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D6h')THEN
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',6,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP3)
       OVRLP=OVRLP/FLOAT(NDEG)
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(4:4)='g'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='u'
       IF(NDEG.EQ.1)THEN
        IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(2:2)='A'
        IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(2:2)='B'
        IF(DABS(OVRLP3-1.D0).LT.TOL)IRREP(3:3)='1'
        IF(DABS(OVRLP3+1.D0).LT.TOL)IRREP(3:3)='2'
       ELSE
        IRREP(2:2)='E'
        CALL COMVEC(NDEG,'C',2,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
        IF(DABS(OVRLP2-2.D0).LT.TOL)IRREP(3:3)='2'
        IF(DABS(OVRLP2+2.D0).LT.TOL)IRREP(3:3)='1'
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D7h')THEN
       CALL COMVEC(NDEG,'P',0,0,3,NPOS,Q,SCRATCH,NORD,V,OVRLPP)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       CALL COMVEC(NDEG,'C',7,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       PDP=OVRLPP/FLOAT(NDEG)
       IF(NDEG.EQ.1)IRREP(1:1)='A'
       IF(DABS(PDP+1.D0).LT.TOL)IRREP(3:4)=''''''
       IF(DABS(PDP-1.D0).LT.TOL)IRREP(3:4)=''' '
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(2:2)='2'
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(2:2)='1'
       IF(NDEG.EQ.2)THEN
        A=2.0*DACOS(-1.D0)/7.0
        C1=2.D0*DCOS(A)
        C2=2.D0*DCOS(2.0*A)
        C3=2.D0*DCOS(4.0*A)
        IF(DABS(OVRLP-C1).LT.TOL)IRREP(1:2)='E1'
        IF(DABS(OVRLP-C2).LT.TOL)IRREP(1:2)='E2'
        IF(DABS(OVRLP-C3).LT.TOL)IRREP(1:2)='E3'
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D8h')THEN
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',8,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP3)
       OVRLP=OVRLP/FLOAT(NDEG)
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(4:4)='g'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='u'
       IF(NDEG.EQ.1)THEN
        IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(2:2)='A'
        IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(2:2)='B'
        IF(DABS(OVRLP3-1.D0).LT.TOL)IRREP(3:3)='1'
        IF(DABS(OVRLP3+1.D0).LT.TOL)IRREP(3:3)='2'
       ELSE
        IRREP(2:2)='E'
        A=2.0*DACOS(-1.D0)/8.0
        C1=2.D0*DCOS(A)
        C2=2.D0*DCOS(2.0*A)
        C3=2.D0*DCOS(4.0*A)
        IF(DABS(OVRLP2-C1).LT.TOL)IRREP(3:3)='1'
        IF(DABS(OVRLP2-C2).LT.TOL)IRREP(3:3)='2'
        IF(DABS(OVRLP2-C3).LT.TOL)IRREP(3:3)='3'
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D9h')THEN
       CALL COMVEC(NDEG,'P',0,0,3,NPOS,Q,SCRATCH,NORD,V,OVRLPP)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       CALL COMVEC(NDEG,'C',9,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       PDP=OVRLPP/FLOAT(NDEG)
       IF(NDEG.EQ.1)IRREP(1:1)='A'
       IF(DABS(PDP+1.D0).LT.TOL)IRREP(3:4)=''''''
       IF(DABS(PDP-1.D0).LT.TOL)IRREP(3:4)=''' '
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(2:2)='2'
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(2:2)='1'
       IF(NDEG.EQ.2)THEN
        A=2.0*DACOS(-1.D0)/9.0
        C1=2.D0*DCOS(A)
        C2=2.D0*DCOS(2.0*A)
        C3=2.D0*DCOS(4.0*A)
        C4=2.D0*DCOS(6.0*A)
        IF(DABS(OVRLP-C1).LT.TOL)IRREP(1:2)='E1'
        IF(DABS(OVRLP-C2).LT.TOL)IRREP(1:2)='E2'
        IF(DABS(OVRLP-C3).LT.TOL)IRREP(1:2)='E3'
        IF(DABS(OVRLP-C4).LT.TOL)IRREP(1:2)='E4'
       ENDIF
       RETURN
      ELSEIF(PTGRP.EQ.'D10h')THEN
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',10,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP3)
       OVRLP=OVRLP/FLOAT(NDEG)
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(4:4)='g'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='u'
       IF(NDEG.EQ.1)THEN
        IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(2:2)='A'
        IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(2:2)='B'
        IF(DABS(OVRLP3-1.D0).LT.TOL)IRREP(3:3)='1'
        IF(DABS(OVRLP3+1.D0).LT.TOL)IRREP(3:3)='2'
       ELSE
        IRREP(2:2)='E'
        C36=2.D0*DCOS(0.2*DACOS(-1.D0))
        C72=2.D0*DCOS(0.4*DACOS(-1.D0))
        C108=2.D0*DCOS(0.6*DACOS(-1.D0))
        C144=2.D0*DCOS(0.8*DACOS(-1.D0))
        IF(DABS(OVRLP2-C36).LT.TOL)IRREP(3:3)='1'
        IF(DABS(OVRLP2-C72).LT.TOL)IRREP(3:3)='2'
        IF(DABS(OVRLP2-C108).LT.TOL)IRREP(3:3)='3'
        IF(DABS(OVRLP2-C144).LT.TOL)IRREP(3:3)='4'
       ENDIF
       RETURN
C
C Dn AND Cn GROUPS
C
      ELSEIF(PTGRP(1:3).EQ.'D2 ')THEN
       CALL COMVEC(NDEG,'C',2,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLPZ)
       CALL COMVEC(NDEG,'C',2,1,2,NPOS,Q,SCRATCH,NORD,V,OVRLPY)
       IF(DABS(OVRLPZ-1.D0).LT.TOL.AND.DABS(OVRLPY-1.D0).LT.TOL)
     &   IRREP='   A'
       IF(DABS(OVRLPZ-1.D0).LT.TOL.AND.DABS(OVRLPY+1.D0).LT.TOL)
     &   IRREP='  B1'
       IF(DABS(OVRLPZ+1.D0).LT.TOL.AND.DABS(OVRLPY-1.D0).LT.TOL)
     &   IRREP='  B2'
       IF(DABS(OVRLPZ+1.D0).LT.TOL.AND.DABS(OVRLPY+1.D0).LT.TOL)
     &   IRREP='  B3'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D3 ')THEN
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP='  A2'
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP='  A1'
       IF(NDEG.EQ.2)IRREP='   E'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D4 ')THEN
       CALL COMVEC(NDEG,'C',4,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(3:3)='A'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(3:3)='B'
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(4:4)='2'
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(4:4)='1'
       IF(NDEG.EQ.2)IRREP='   E'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D5 ')THEN
       CALL COMVEC(NDEG,'C',5,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP='  A2'
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP='  A1'
       IF(DABS(OVRLP-C72).LT.TOL)IRREP='  E1'
       IF(DABS(OVRLP-C144).LT.TOL)IRREP='  E2'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'D6 ')THEN
       CALL COMVEC(NDEG,'C',6,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',2,1,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(3:3)='A'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(3:3)='B'
       IF(DABS(OVRLP2-1.D0).LT.TOL)IRREP(4:4)='1'
       IF(DABS(OVRLP2+1.D0).LT.TOL)IRREP(4:4)='2'
       IF(NDEG.EQ.2)THEN
        IF(DABS(OVRLP-1.D0).LT.TOL)IRREP='  E1'
        IF(DABS(OVRLP+1.D0).LT.TOL)IRREP='  E2'
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'C2 ')THEN
       CALL COMVEC(NDEG,'C',2,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP='   A'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP='   B'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'C3 ')THEN  
       IF(NDEG.EQ.1)IRREP='   A'
       IF(NDEG.EQ.2)IRREP='   E'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'C4 ')THEN
       CALL COMVEC(NDEG,'C',4,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP='   A'
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP='   B'
       IF(NDEG.EQ.2)IRREP='   E'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'C5 ')THEN
       IF(NDEG.EQ.1)IRREP='   A'
       IF(NDEG.EQ.2)THEN
        CALL COMVEC(NDEG,'C',5,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
        IF(DABS(OVRLP-C72).LT.TOL)IRREP='  E1'
        IF(DABS(OVRLP-C144).LT.TOL)IRREP='  E2'
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'C6 ')THEN
       CALL COMVEC(NDEG,'C',6,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP='   B'
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP='   A'
       IF(DABS(OVRLP+2.D0).LT.TOL)IRREP='  E2'
       IF(DABS(OVRLP-2.D0).LT.TOL)IRREP='  E1'
       RETURN
C
C BIG SCARY CUBIC GROUPS - MUST ASSUME SOME SORT OF STANDARD ORIENTATION
C  FOR THESE BEASTS.  
C
      ELSEIF(PTGRP(1:3).EQ.'T d')THEN
C
C Td PLACES SUCH THAT THE Z AXIS IS ONE OF THE C2'S.
C
       IF(NDEG.EQ.2)THEN
        IRREP='   E'
        RETURN
       ELSE
        CALL COMVEC(NDEG,'S',4,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
        IF(NDEG.EQ.1)THEN
         IF(DABS(OVRLP+1.D0).LT.TOL)IRREP='  A2'
         IF(DABS(OVRLP-1.D0).LT.TOL)IRREP='  A1'
        ELSE
         IF(DABS(OVRLP+1.D0).LT.TOL)IRREP='  T2'
         IF(DABS(OVRLP-1.D0).LT.TOL)IRREP='  T1'
        ENDIF
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'O h')THEN
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       Z=OVRLP/FLOAT(NDEG)
       IF(DABS(Z+1.D0).LT.TOL)IRREP(4:4)='u'
       IF(DABS(Z-1.D0).LT.TOL)IRREP(4:4)='g'
       IF(NDEG.EQ.2)THEN
        IRREP(2:3)=' E'
        RETURN
       ENDIF
       CALL COMVEC(NDEG,'C',4,1,3,NPOS,Q,SCRATCH,NORD,V,Z1)
       IF(DABS(Z1+1.D0).LT.TOL)IRREP(3:3)='2'
       IF(DABS(Z1-1.D0).LT.TOL)IRREP(3:3)='1'
       IF(NDEG.EQ.3)IRREP(2:2)='T'
       IF(NDEG.EQ.1)IRREP(2:2)='A'
       RETURN
C
C ESOTERIC CUBIC GROUPS.  THIS CODE WILL NEVER BE TOUCHED!
C
      ELSEIF(PTGRP(1:3).EQ.'O  ')THEN
       CALL COMVEC(NDEG,'C',4,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(4:4)='1'
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='2'
       IF(NDEG.EQ.1)IRREP(3:3)='A'
       IF(NDEG.EQ.2)IRREP='   E'
       IF(NDEG.EQ.3)IRREP(3:3)='T'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'T  ')THEN
       IF(NDEG.EQ.1)IRREP='   A'
       IF(NDEG.EQ.2)IRREP='   E'
       IF(NDEG.EQ.3)IRREP='   T'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'T h')THEN
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       OVRLP=OVRLP/FLOAT(NDEG)
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='u'
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(4:4)='g'
       IF(NDEG.EQ.1)IRREP(1:3)='  A'
       IF(NDEG.EQ.2)IRREP(1:3)='  E'
       IF(NDEG.EQ.3)IRREP(1:3)='  T'
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'I h')THEN
C
C NOTE THAT THIS ASSUMES THAT THE C5 AXIS IS ALONG Z.
C
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       OVRLP=OVRLP/FLOAT(NDEG)
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='u'
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(4:4)='g'
       IF(NDEG.EQ.1)IRREP(3:3)='A'
       IF(NDEG.EQ.4)IRREP(3:3)='G'
       IF(NDEG.EQ.5)IRREP(3:3)='H'
       IF(NDEG.EQ.3)THEN
        ETAP=0.5D0*(1.D0+DSQRT(5.D0))
        ETAM=0.5D0*(1.D0-DSQRT(5.D0))
        CALL COMVEC(NDEG,'C',5,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
        IF(DABS(OVRLP-ETAP).LT.TOL)IRREP(2:3)='T1'
        IF(DABS(OVRLP-ETAM).LT.TOL)IRREP(2:3)='T2'
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'I  ')THEN
       IF(NDEG.EQ.1)IRREP(4:4)='A'
       IF(NDEG.EQ.2)IRREP(4:4)='E'
       IF(NDEG.EQ.4)IRREP(4:4)='G'
       IF(NDEG.EQ.5)IRREP(4:4)='H'
       IF(NDEG.EQ.3)THEN
        ETAP=0.5D0*(1.D0+DSQRT(5.D0))
        ETAM=0.5D0*(1.D0-DSQRT(5.D0))
        CALL COMVEC(NDEG,'C',5,1,3,NPOS,Q,SCRATCH,NORD,V,OVRLP)
        IF(DABS(OVRLP-ETAP).LT.TOL)IRREP(3:4)='T1'
        IF(DABS(OVRLP-ETAM).LT.TOL)IRREP(3:4)='T2'
       ENDIF
       RETURN
C
C LINEAR MOLECULES!
C
      ELSEIF(PTGRP(1:3).EQ.'DXh')THEN
       CALL COMVEC(NDEG,'I',0,0,0,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'P',0,0,1,NPOS,Q,SCRATCH,NORD,V,OVRLP2)
       CALL COMVEC(NDEG,'C',16,0,3,NPOS,Q,SCRATCH,NORD,V,OVRLP3)
       IF(NDEG.EQ.1)IRREP(1:2)='SG'
       IF(NDEG.EQ.2)THEN
       IRREP(1:2)='PI'
        DO 3100 J=1,3
         Z=2.D0*DCOS(FLOAT(J)*DACOS(-1.D0)/8.D0)
         IF(DABS(OVRLP3-Z).LT.TOL)IRREP(1:2)=GREEK(J+1)
 3100   CONTINUE
       ENDIF
       OVRLP=OVRLP/FLOAT(NDEG)
       OVRLP2=OVRLP2/FLOAT(NDEG)
       IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(3:3)='u'
       IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(3:3)='g'
       IF(NDEG.EQ.1)THEN
        IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='-'
        IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(4:4)='+'
       ENDIF
       RETURN
      ELSEIF(PTGRP(1:3).EQ.'CXv')THEN
       CALL COMVEC(NDEG,'P',0,0,1,NPOS,Q,SCRATCH,NORD,V,OVRLP)
       CALL COMVEC(NDEG,'C',16,0,3,NPOS,Q,SCRATCH,NORD,V,OVRLP3)
       IF(NDEG.EQ.1)THEN
        IRREP(2:3)='SG'
        IF(DABS(OVRLP+1.D0).LT.TOL)IRREP(4:4)='-'
        IF(DABS(OVRLP-1.D0).LT.TOL)IRREP(4:4)='+'
       ELSE
        IRREP(3:4)='PI'
        DO 3101 J=1,3
         Z=2.D0*DCOS(FLOAT(J)*DACOS(-1.D0)/8.D0)
         IF(DABS(OVRLP3-Z).LT.TOL)IRREP(3:4)=GREEK(J+1)
 3101   CONTINUE
       ENDIF
       ELSE
C
C
       WRITE(6,*)' DON''T KNOW HOW TO GENERATE IRREPS FOR ',PTGRP,
     &' LEAVE ME ALONE! '
      ENDIF
      RETURN
      END
