/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.NestedClassTestDescriptor;
import org.junit.jupiter.engine.discovery.TestContainerResolver;
import org.junit.jupiter.engine.discovery.predicates.IsNestedTestClass;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

class NestedTestsResolver
extends TestContainerResolver {
    private static final IsNestedTestClass isNestedTestClass = new IsNestedTestClass();
    static final String SEGMENT_TYPE = "nested-class";

    public NestedTestsResolver(JupiterConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected Class<? extends TestDescriptor> requiredParentType() {
        return ClassTestDescriptor.class;
    }

    @Override
    protected String getClassName(TestDescriptor parent, String segmentValue) {
        return ((ClassTestDescriptor)parent).getTestClass().getName() + "$" + segmentValue;
    }

    @Override
    protected String getSegmentType() {
        return SEGMENT_TYPE;
    }

    @Override
    protected String getSegmentValue(Class<?> testClass) {
        return testClass.getSimpleName();
    }

    @Override
    protected boolean isPotentialCandidate(Class<?> element) {
        return isNestedTestClass.test(element);
    }

    @Override
    protected TestDescriptor resolveClass(Class<?> testClass, UniqueId uniqueId) {
        return new NestedClassTestDescriptor(uniqueId, testClass, this.configuration);
    }
}

