/*
 *   DIS/x : An implementation of the IEEE 1278.1 protocol
 *
 *   Copyright (C) 1996, Riley Rainey (rainey@netcom.com)
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of either:
 *
 *   a) the GNU Library General Public License as published by the Free
 *   Software Foundation; either version 2 of the License, or (at your
 *   option) any later version.  A description of the terms and conditions
 *   of the GLPL may be found in the "COPYING.LIB" file.
 *
 *   b) the "Artistic License" which comes with this Kit.  Information
 *   about this license may be found in the "Artistic" file.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License or the Artistic License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Information describing how to contact the author can be found in the
 *   README file.
 */
#include <string.h>
#include <stdlib.h>
#include "simmgr.h"
#include <rpc/rpc.h>
#include <server.h>

#define SIMX_TOP_APPL_ID	0xfffd;

unsigned short site_id = 1;
unsigned short application_id = SIMX_TOP_APPL_ID;


extern int FetchEntity (dis_entity_type *, char *, int);
extern int OpenDatabase(void);
extern simx_site_info *LocateSiteByName(char *);

static int init = 0;

simx_lookup_entity_type_result *
#ifdef HAVE_NEW_RPCGEN
simxlookupentitynamep_1_svc
#else
simxlookupentitynamep_1
#endif
(dis_entity_type *p, struct svc_req *req)
{
	static simx_lookup_entity_type_result res;
	char	s[1024];

#ifdef DEBUG	
	printf ("Entity lookup : ");
	PrintEntityType (p);
	printf ("\n");
#endif

	if (init == 0) {
		if (OpenDatabase() != 0) {
			exit (1);
		}
		init = 1;
	}

	res.status_code	 = SIMx_SUCCESS;
	res.value = s; 
	s[0] = '\0';
	if (FetchEntity(p, s, sizeof(s)) != 0) {
		res.status_code	 = SIMx_NOT_FOUND;
	}
	return &res;
}

simx_lookup_complete_entity_type_result *
#ifdef HAVE_NEW_RPCGEN
simxlookupentitynamesp_1_svc
#else
simxlookupentitynamesp_1
#endif
(dis_entity_type *p, struct svc_req *req)
{
	static simx_lookup_complete_entity_type_result res;
	char	s[1024];
	int	i = 6;
	dis_entity_type	e = *p, e1;

#ifdef DEBUG	
	printf ("Entity Names lookup : ");
	PrintEntityType (p);
	printf ("\n");
#endif

	if (init == 0) {
		if (OpenDatabase() != 0) {
			exit (1);
		}
		init = 1;
	}

	s[0] = '\0';
	if (e.extra != 0 && FetchEntity(&e, s, sizeof(s)) == 0) {
		res.extra_value = strdup(s);
	}
	else {
		res.extra_value = strdup("");
	}
	e.extra = 0;

	s[0] = '\0';
	if (e.specific != 0 && FetchEntity(&e, s, sizeof(s)) == 0) {
		res.specific_value = strdup(s);
	}
	else {
		res.specific_value = strdup("");
	}
	e.specific = 0;

	s[0] = '\0';
	if (e.subcategory != 0 && FetchEntity(&e, s, sizeof(s)) == 0) {
		res.subcategory_value = strdup(s);
	}
	else {
		res.subcategory_value = strdup("");
	}
	e.subcategory = 0;

	s[0] = '\0';
	if (e.category != 0 && FetchEntity(&e, s, sizeof(s)) == 0) {
		res.category_value = strdup(s);
	}
	else {
		res.category_value = strdup("");
	}
	e.category = 0;

/*
 *  Country names are stored in the entity database, as well.
 *  Their keys have the country code set with everything else zeroed.
 */

	e1 = e;
	e1.kind = 0;
	e1.domain = 0;
	res.country_value = strdup("");
	s[0] = '\0';
	if (e1.country != 0 && FetchEntity(&e1, s, sizeof(s)) == 0) {
		res.country_value = strdup(s);
	}
	else {
		res.country_value = strdup("");
	}
	e.country = 0;

	s[0] = '\0';
	if (e.domain != 0 && FetchEntity(&e, s, sizeof(s)) == 0) {
		res.domain_value = strdup(s);
	}
	else {
		res.domain_value = strdup("");
	}
	e.domain = 0;

	s[0] = '\0';
	if (e.kind != 0 && FetchEntity(&e, s, sizeof(s)) == 0) {
		res.kind_value = strdup(s);
	}
	else {
		res.kind_value = strdup("");
	}

	res.status_code	 = SIMx_SUCCESS;
	return &res;
}


dis_entity_type *
#ifdef HAVE_NEW_RPCGEN
simxlookupentitytypefrompatternp_1_svc (simx_string *foo, struct svc_req *bar)
#else
simxlookupentitytypefrompatternp_1 (simx_string *foo, struct svc_req *bar)
#endif
{
	return 0;
}

simx_lookup_entity_type_result *
#ifdef HAVE_NEW_RPCGEN
simxlookupentityattributep_1_svc(simx_entity_type_attr *foo, struct svc_req *bar)
#else
simxlookupentityattributep_1(simx_entity_type_attr *foo, struct svc_req *bar)
#endif
{ return 0; }

simx_register_app_result *
#ifdef HAVE_NEW_RPCGEN
simxregisterapplicationp_1_svc
#else
simxregisterapplicationp_1
#endif
(simx_register_app_args *p, struct svc_req *req)
{
	static simx_register_app_result r;
	simx_site_info *p1;

	r.status_code = SIMx_SUCCESS;
	if (strcmp(p->site_name, "0x") == 0) {
		r.result.site_id = atoi(p->site_name);
	}
	else {
		p1 = LocateSiteByName (p->site_name);
		r.result.site_id = p1->site_id;
		r.result.application_id = p1->application_id--;
	}
	
	if (r.result.application_id == 0) {
		r.result.application_id = 
			p1->application_id = 0xfffd;
	}
	return &r;
}

#ifdef DEBUG
void
PrintEntityType (dis_entity_type *p)
{
	printf ("%d.%d.%d.%d.%d.%d.%d", p->kind, p->domain,
		p->country, p->category, p->subcategory,
		p->specific, p->extra);
}
#endif
