#include <stdio.h>
#include <stdlib.h>
#include <QtWidgets/QWidget>
#include <QtWidgets/QHBoxLayout>
#include <QtWidgets/QVBoxLayout>
#include <QtWidgets/QTabWidget>
#include <QtWidgets/QMainWindow>
#include <QtCore/QFile>
#include <QtWidgets/QFileDialog>
#include <QtWidgets/QMessageBox>
#include <QtWidgets/QLabel>
#include <QtWidgets/QGroupBox>
#include <QtWidgets/QRadioButton>
#include <QtWidgets/QButtonGroup>
#include <QtWidgets/QTreeWidget>
#include <QtWidgets/QTreeWidgetItem>
#include <QtWidgets/QPushButton>
#include <QtWidgets/QCheckBox>
#include <QtWidgets/QInputDialog>
#include <QtCore/QTextStream>
#include <QtCore/QStringList>
#include <QtCore/QXmlStreamWriter>  
#include <QtXml/QXmlDefaultHandler>
#include <QDebug>
#include "model.h"
#include "synth.h"
#include "harmonics.h"
#include "filter.h"
#include "multislider.h"
#include "modslider.h"
#include "gui.h"
#include "jackprocessor.h"
#include "scaladialog.h"

Gui::Gui(Model *p_model, QWidget *parent) : QWidget(parent) {

  QWidget *harmonicWidget[MAX_PARAMS];
  QVBoxLayout *harmonicLayout[MAX_PARAMS];
  QWidget *scaleBox[MAX_PARAMS];
  QHBoxLayout *scaleLayout[MAX_PARAMS];
  QLabel *scaleLabel[MAX_PARAMS];
  QWidget *randomContainer;
  QGroupBox *randomBox;
  QHBoxLayout *randomLayout, *randomContainerLayout;
  QLabel *randomLabel[2];
  QString labels[MAX_PARAMS], groupLabels[MAX_SCENES], radioLabels[MAX_SOURCES];
  QVBoxLayout *spectrumLayout[2], *spectrumComboLayout[2];
  QHBoxLayout *spectrumHLayout[2];
  QWidget *spectrumHFrame[2], *spectrumComboFrame[2];
  QVBoxLayout *spectrumLayoutL[2], *spectrumLayoutR[2];
  QWidget *spectrumBox[2], *spectrumBoxL[2], *spectrumBoxR[2];
  QGroupBox *evenOddBox;
  QVBoxLayout *evenOddLayout;
  QLabel *spectrumLabel[8];
  int i1, i2, i3, i4, index;
  QVBoxLayout *filterMainLayout[2];
  QWidget *filterFrame[2], *filterHSubFrame[2], *filterVSubFrame[6];
  QWidget *filterMixFrame[2], *filterMixVSubFrame[MAX_SOURCES][3];
  QWidget *filterModFrame[2], *filterModHSubFrame[2][6], *filterModVSubFrame[2][12];
  QGroupBox *filterMixBox[MAX_SOURCES];
  QGroupBox *filterModBox[2][3];
  QString filterMixBoxLabels[MAX_SOURCES], filterMixLabels[9];
  QString filterModBoxLabels[2][3], filterModLabels[2][20], filterModLongLabels[2][20];
  QHBoxLayout *filterHSubFrameLayout[2];
  QVBoxLayout *filterVSubFrameLayout[6];
  QVBoxLayout *filterMixMainLayout[2];
  QHBoxLayout *filterMixHSubFrameLayout[MAX_SOURCES];
  QVBoxLayout *filterMixVSubFrameLayout[MAX_SOURCES][3];
  QVBoxLayout *filterModMainLayout[2];
  QHBoxLayout *filterModHSubFrameLayout[2][6];
  QVBoxLayout *filterModVSubFrameLayout[2][12];
  QVBoxLayout *filterModGroupBoxLayout[2][3];
  QLabel *filterCutoffLabel[4], *filterSpacingLabel[4], *filterKeyTrackingLabel[2], *filterDepthLabel[2];
  QWidget *noiseFrame;
  QVBoxLayout *noiseFrameLayout;
  QGroupBox *noiseBox[2];
  QVBoxLayout *noiseBoxLayout[2];
  QString noiseLabels[4];
  QGroupBox *compressorBox;
  QVBoxLayout *compressorLayout;
  QString compressorLabels[4];
  QGroupBox *panBox;
  QVBoxLayout *panLayout;
  QString panLabels[3];
  QWidget *voiceFrame;
  QVBoxLayout *voiceLayout;
  QGroupBox *voiceFileFrame;
  QHBoxLayout *voiceFileLayout;
  QGroupBox *voiceRangeFrame;    
  QHBoxLayout *voiceRangeLayout;
  QGroupBox *voiceTreeFrame;    
  QHBoxLayout *voiceTreeLayout;
  QStringList voiceTreeHeaders;
  QString unitLabels[MAX_PARAMS];
  
  model = p_model;
  QObject::connect(model, SIGNAL(xmlData(tokenCodeEnum, int, int, int, int, double)), this, SLOT(xmlInput(tokenCodeEnum, int, int, int, int, double)));
  systemMode = false;
  presetFolder = 0;
  presetBank = 0;
  presetNum = 0;
  textEditor = new TextEdit;
  textEditor->setAttribute(Qt::WA_QuitOnClose, false);
  QObject::connect(textEditor, SIGNAL(cancelText()), this, SLOT(cancelComment()));
  QObject::connect(textEditor, SIGNAL(textOK()), this, SLOT(commentOK()));
  scalaDialog = new ScalaDialog(model);
  jackProcessor = new JackProcessor(model);
  synth = new Synth(model);
  QVBoxLayout *mainLayout = new QVBoxLayout;
  mainTab = new QTabWidget;
  mainLayout->addWidget(mainTab);
  QVBoxLayout *harmonicMainLayout = new QVBoxLayout;
  QWidget *harmonicFrame = new QWidget;
  harmonicFrame->setLayout(harmonicMainLayout);
  harmonicTab = new QTabWidget;
  harmonicTab->setTabPosition(QTabWidget::South);
  harmonicMainLayout->addWidget(harmonicTab);
  mainTab->addTab(harmonicFrame, "Harmonics");

  QVBoxLayout *oscMainLayout = new QVBoxLayout;
  QWidget *oscFrame = new QWidget;
  oscFrame->setLayout(oscMainLayout);
  mainTab->addTab(oscFrame, "Oscillators");

  voiceFileName = "<No File>";
  noiseFrameLayout = new QVBoxLayout;
  noiseFrame = new QWidget;
  noiseFrame->setLayout(noiseFrameLayout);
  mainTab->addTab(noiseFrame, "Noise");
  
  noiseLabels[0] = "Offset";
  noiseLabels[1] = "Spacing";
  noiseLabels[2] = "Even/Odd";
  noiseLabels[3] = "Bandwidth";
  noiseBox[0] = new QGroupBox("Noise Spectrum");
  noiseBox[1] = new QGroupBox("Bandpass Filter");
  for (i1 = 0; i1 < 2; i1++) {
    noiseBoxLayout[i1] = new QVBoxLayout;
    noiseBox[i1]->setLayout(noiseBoxLayout[i1]);
    noiseFrameLayout->addWidget(noiseBox[i1]);
  } 
  for (i1 = 0; i1 < 4; i1++) {
    noiseSlider[i1] = new ModSlider(model, Qt::Horizontal); 
    noiseSlider[i1]->setMinimum(0);
    noiseSlider[i1]->setMaximum(1000);
    noiseSlider[i1]->setTickInterval(1);
    QObject::connect(noiseSlider[i1], SIGNAL(valueChanged(int)), this, SLOT(setNoise(int)));
  }
  noiseFreqDiffusionSlider = new ModSlider(model, Qt::Horizontal);
  noiseFreqDiffusionSlider->setMinimum(0);
  noiseFreqDiffusionSlider->setMaximum(1000);
  noiseFreqDiffusionSlider->setTickInterval(1);
  QObject::connect(noiseFreqDiffusionSlider, SIGNAL(valueChanged(int)), this, SLOT(setNoiseFreqDiffusion(int)));
  for (i1 = 0; i1 < 3; i1++) {
    noiseBoxLayout[0]->addWidget(new QLabel(noiseLabels[i1]));
    noiseBoxLayout[0]->addWidget(noiseSlider[i1]);
    noiseSlider[i1]->setValue(500);
  }
  noiseBoxLayout[0]->addWidget(new QLabel("Frequency Diffusion"));
  noiseBoxLayout[0]->addWidget(noiseFreqDiffusionSlider);
  noiseSlider[1]->setValue(0);
  noiseBoxLayout[1]->addWidget(new QLabel(noiseLabels[3]));
  noiseBoxLayout[1]->addWidget(noiseSlider[3]);
  noiseSlider[3]->setValue(500);
  noiseSubHarmonicCheck = new QCheckBox("SubHarmonic Mode");
  noiseSubHarmonicCheck->setChecked(false);
  QObject::connect(noiseSubHarmonicCheck, SIGNAL(stateChanged(int)), this, SLOT(noiseSubHarmonicToggled(int)));
  noiseFrameLayout->addWidget(new QWidget); // Dummy
  noiseFrameLayout->addWidget(noiseSubHarmonicCheck);
  noiseFrameLayout->addWidget(new QWidget, 2); // Dummy
  noiseFrameLayout->setContentsMargins(10, 40, 10, 40); 
  
  filterMixBoxLabels[0] = "Spectral Oscillator 1";  
  filterMixBoxLabels[1] = "Spectral Oscillator 2";
  filterMixBoxLabels[2] = "Spectral Oscillator 3";
  filterMixBoxLabels[3] = "Noise";
  for (i1 = 0; i1 < 2; i1++) {
    filterMixFrame[i1] = new QWidget;
    filterMixMainLayout[i1] = new QVBoxLayout;
    filterMixFrame[i1]->setLayout(filterMixMainLayout[i1]);
  }  
  for (i1 = 0; i1 < MAX_SOURCES; i1++) {
    filterMixLabels[0] = "Filter 1/2 Morph ";
    filterMixLabels[1] = "Serial/Parallel ";
    filterMixLabels[2] = "LFO Mode ";
    filterMixLabels[3] = "Envelope Amount ";
    filterMixLabels[4] = "Delay ";
    filterMixLabels[5] = "LFO Retrigger ";
    filterMixLabels[6] = "Attack ";
    filterMixLabels[7] = "Decay ";
    filterMixLabels[8] = "Hold ";
    filterMixBox[i1] = new QGroupBox(filterMixBoxLabels[i1]);
    filterMixHSubFrameLayout[i1] = new QHBoxLayout; 
    filterMixBox[i1]->setLayout(filterMixHSubFrameLayout[i1]);
    for (i2 = 0; i2 < 3; i2++) {
      filterMixVSubFrameLayout[i1][i2] = new QVBoxLayout; 
      filterMixVSubFrame[i1][i2] = new QWidget;
      filterMixVSubFrame[i1][i2]->setLayout(filterMixVSubFrameLayout[i1][i2]);
    }
    for (i2 = 0; i2 < 6; i2++) {
      filterMixSlider[i1][i2] = new ModSlider(model, Qt::Horizontal); 
      filterMixSlider[i1][i2]->setMinimum(0);
      filterMixSlider[i1][i2]->setMaximum(1000);
      filterMixSlider[i1][i2]->setTickInterval(1);
      QObject::connect(filterMixSlider[i1][i2], SIGNAL(valueChanged(int)), this, SLOT(setFilterMix(int)));
    }
    filterMixSlider[i1][0]->setValue(500);
    filterMixSlider[i1][1]->setValue(1000);
    filterMixSlider[i1][2]->setValue(100);
    filterMixSlider[i1][3]->setValue(100);
    filterMixSlider[i1][4]->setValue(100);
    filterMixSlider[i1][5]->setValue(100);
    for (i2 = 0; i2 < 3; i2++) {  
      filterMixCheckBox[i1][i2] = new QCheckBox(filterMixLabels[3 * i2 + 2]);
      QObject::connect(filterMixCheckBox[i1][i2], SIGNAL(stateChanged(int)), this, SLOT(filterMixToggled(int)));
      filterMixCheckBox[i1][i2]->setChecked(false);
    }
    for (i3 = 0; i3 < 2; i3++) {
      for (i2 = 0; i2 < 3; i2++) {
        filterMixVSubFrameLayout[i1][i3]->addWidget(new QLabel(filterMixLabels[3 * i2 + i3]));
        filterMixVSubFrameLayout[i1][i3]->addWidget(filterMixSlider[i1][2 * i2 + i3]);
      }
      filterMixHSubFrameLayout[i1]->addWidget(filterMixVSubFrame[i1][i3]);
    }
    for (i2 = 0; i2 < 3; i2++) {
      filterMixVSubFrameLayout[i1][2]->addWidget(filterMixCheckBox[i1][i2]);
    }
    filterMixHSubFrameLayout[i1]->addWidget(filterMixVSubFrame[i1][2]);
    filterMixMainLayout[i1 / 2]->addWidget(filterMixBox[i1]);
  }
  mainTab->addTab(filterMixFrame[0], "Mixer 1/2");
  mainTab->addTab(filterMixFrame[1], "Mixer 3/Noise");

  for (i1 = 0; i1 < 2; i1++) {
    filterMainLayout[i1] = new QVBoxLayout;
    filterFrame[i1] = new QWidget;
    filterFrame[i1]->setLayout(filterMainLayout[i1]);
    filter[i1] = new Filter(model, i1, this, 800, 450);
    filterMainLayout[i1]->addWidget(filter[i1]);
    filterHSubFrameLayout[i1] = new QHBoxLayout; 
    filterHSubFrame[i1] = new QWidget;
    filterHSubFrame[i1]->setLayout(filterHSubFrameLayout[i1]);
    filterVSubFrameLayout[3 * i1] = new QVBoxLayout; 
    filterVSubFrame[3 * i1] = new QWidget;
    filterVSubFrame[3 * i1]->setLayout(filterVSubFrameLayout[3 * i1]);
    filterVSubFrameLayout[3 * i1 + 1] = new QVBoxLayout; 
    filterVSubFrame[3 * i1 + 1] = new QWidget;
    filterVSubFrame[3 * i1 + 1]->setLayout(filterVSubFrameLayout[3 * i1 + 1]);
    filterVSubFrameLayout[3 * i1 + 2] = new QVBoxLayout; 
    filterVSubFrame[3 * i1 + 2] = new QWidget;
    filterVSubFrame[3 * i1 + 2]->setLayout(filterVSubFrameLayout[3 * i1 + 2]);
    
    for (i2 = 0; i2 < 2; i2++) {
      filterCutoff[2 * i1 + i2] = new ModSlider(model, Qt::Horizontal); 
      filterSpacing[2 * i1 + i2] = new ModSlider(model, Qt::Horizontal);
      filterCutoff[2 * i1 + i2]->setMinimum(0);
      filterCutoff[2 * i1 + i2]->setMaximum(1000);
      filterCutoff[2 * i1 + i2]->setTickInterval(1);
      filterSpacing[2 * i1 + i2]->setMinimum(0);
      filterSpacing[2 * i1 + i2]->setMaximum(1000);
      filterSpacing[2 * i1 + i2]->setTickInterval(1);
    }  
    filterCutoffLabel[2 * i1] = new QLabel("Cutoff " + QString::number(i1 + 1) + " Coarse");
    filterSpacingLabel[2 * i1] = new QLabel("Spacing " + QString::number(i1 + 1) + " Coarse");
    filterCutoffLabel[2 * i1 + 1] = new QLabel("Cutoff " + QString::number(i1 + 1) + " Fine");
    filterSpacingLabel[2 * i1 + 1] = new QLabel("Spacing " + QString::number(i1 + 1) + " Fine");
    filterVSubFrameLayout[3 * i1]->addWidget(filterCutoffLabel[2 * i1]);
    filterVSubFrameLayout[3 * i1]->addWidget(filterCutoff[2 * i1]);
    filterVSubFrameLayout[3 * i1]->addWidget(filterSpacingLabel[2 * i1]);
    filterVSubFrameLayout[3 * i1]->addWidget(filterSpacing[2 * i1]);
    filterKeyTracking[i1] = new ModSlider(model, Qt::Horizontal); 
    filterKeyTracking[i1]->setMinimum(0);
    filterKeyTracking[i1]->setMaximum(1000);
    filterKeyTracking[i1]->setTickInterval(1);
    filterKeyTrackingLabel[i1] = new QLabel("KeyTracking " + QString::number(i1 + 1));
    filterVSubFrameLayout[3 * i1]->addWidget(filterKeyTrackingLabel[i1]);
    filterVSubFrameLayout[3 * i1]->addWidget(filterKeyTracking[i1]);
    
    filterDepth[i1] = new ModSlider(model, Qt::Horizontal);
    filterDepth[i1]->setMinimum(0);
    filterDepth[i1]->setMaximum(1000);
    filterDepth[i1]->setTickInterval(1);
    filterDepthLabel[i1] = new QLabel("Mix " + QString::number(i1 + 1));
    filterVSubFrameLayout[3 * i1 + 1]->addWidget(filterCutoffLabel[2 * i1 + 1]);
    filterVSubFrameLayout[3 * i1 + 1]->addWidget(filterCutoff[2 * i1 + 1]);
    filterVSubFrameLayout[3 * i1 + 1]->addWidget(filterSpacingLabel[2 * i1 + 1]);
    filterVSubFrameLayout[3 * i1 + 1]->addWidget(filterSpacing[2 * i1 + 1]);
    filterVSubFrameLayout[3 * i1 + 1]->addWidget(filterDepthLabel[i1]);
    filterVSubFrameLayout[3 * i1 + 1]->addWidget(filterDepth[i1]);

    filterCutoffCombo[i1] = new QComboBox;
    filterCutoffCombo[i1]->addItem("Free");
    for (i2 = 0; i2 < 14; i2++) {
      filterCutoffCombo[i1]->addItem(QString::number(i2 * 12 - 108));
    }
    filterSpacingCombo[i1] = new QComboBox;
    filterSpacingCombo[i1]->addItem("Free");
    for (i2 = 1; i2 < 25; i2++) {
      filterSpacingCombo[i1]->addItem(QString::number((double)i2 * 0.5, 'f', 2));
    }
    filterTrackingCombo[i1] = new QComboBox;
    filterTrackingCombo[i1]->addItem("Free");
    for (i2 = 0; i2 < 5; i2++) {
      filterTrackingCombo[i1]->addItem(QString::number((double)i2 / 4.0, 'f', 2));
    }
    filterVSubFrameLayout[3 * i1 + 2]->addWidget(new QLabel("Cutoff"));
    filterVSubFrameLayout[3 * i1 + 2]->addWidget(filterCutoffCombo[i1]);
    filterVSubFrameLayout[3 * i1 + 2]->addWidget(new QLabel("Spacing"));
    filterVSubFrameLayout[3 * i1 + 2]->addWidget(filterSpacingCombo[i1]);
    filterVSubFrameLayout[3 * i1 + 2]->addWidget(new QLabel("Tracking"));
    filterVSubFrameLayout[3 * i1 + 2]->addWidget(filterTrackingCombo[i1]);
    
    filterHSubFrameLayout[i1]->addWidget(filterVSubFrame[3 * i1]);
    filterHSubFrameLayout[i1]->addWidget(filterVSubFrame[3 * i1 + 1]);
    filterHSubFrameLayout[i1]->addWidget(filterVSubFrame[3 * i1 + 2]);
    filterMainLayout[i1]->addWidget(filterHSubFrame[i1]);
    mainTab->addTab(filterFrame[i1], "Filter " + QString::number(i1 + 1));
    for (i2 = 0; i2 < 2; i2++) {
      QObject::connect(filterCutoff[2 * i1 + i2], SIGNAL(valueChanged(int)), this, SLOT(setFilterCutoff(int)));
      QObject::connect(filterSpacing[2 * i1 + i2], SIGNAL(valueChanged(int)), this, SLOT(setFilterSpacing(int)));
    }  
    QObject::connect(filterKeyTracking[i1], SIGNAL(valueChanged(int)), this, SLOT(setFilterKeyTracking(int)));
    QObject::connect(filterDepth[i1], SIGNAL(valueChanged(int)), this, SLOT(setFilterDepth(int)));
    QObject::connect(filterCutoffCombo[i1], SIGNAL(currentIndexChanged(int)), this, SLOT(setFilterCutoffCombo(int)));
    QObject::connect(filterSpacingCombo[i1], SIGNAL(currentIndexChanged(int)), this, SLOT(setFilterSpacingCombo(int)));
    QObject::connect(filterTrackingCombo[i1], SIGNAL(currentIndexChanged(int)), this, SLOT(setFilterTrackingCombo(int)));
    filterCutoff[2 * i1]->setValue(500);
    filterSpacing[2 * i1]->setValue(400);
    filterCutoff[2 * i1 + 1]->setValue(500);
    filterSpacing[2 * i1 + 1]->setValue(500);
    filterKeyTracking[i1]->setValue(500);
  }
  filterDepth[0]->setValue(500);
  filterDepth[1]->setValue(500);
  for (i1 = 0; i1 < 2; i1++) {
    filterModMainLayout[i1] = new QVBoxLayout;
    filterModFrame[i1] = new QWidget;
    filterModFrame[i1]->setLayout(filterModMainLayout[i1]);
    filterModBoxLabels[i1][0] = "Envelope";  
    filterModBoxLabels[i1][1] = "Cutoff LFO";
    filterModBoxLabels[i1][2] = "Spacing LFO";
    filterModLongLabels[i1][0] = "Delay";
    filterModLongLabels[i1][1] = "Attack";
    filterModLongLabels[i1][2] = "Decay 1";
    filterModLongLabels[i1][3] = "Decay 2";
    filterModLongLabels[i1][4] = "Level";
    filterModLongLabels[i1][5] = "Release";
    filterModLongLabels[i1][6] = "Envelope Amount";
    filterModLongLabels[i1][7] = " LFO Freq";
    filterModLongLabels[i1][8] = " LFO Depth";
    filterModLongLabels[i1][9] = " LFO Delay";
    filterModLongLabels[i1][10] = "Spacing LFO Freq";
    filterModLongLabels[i1][11] = "Spacing LFO Depth";
    filterModLongLabels[i1][12] = "Spacing LFO Delay";
    filterModLongLabels[i1][13] = "Inverse Envelope";
    filterModLongLabels[i1][14] = "Fast LFO";
    filterModLongLabels[i1][15] = "Retrigger LFO";
    filterModLongLabels[i1][16] = "Inverse LFO";
    filterModLongLabels[i1][17] = "Fast Spacing LFO";
    filterModLongLabels[i1][18] = "Retrigger Spacing LFO";
    filterModLongLabels[i1][19] = "Inverse Spacing LFO";

    filterModLabels[i1][0] = "Delay";
    filterModLabels[i1][1] = "Attack";
    filterModLabels[i1][2] = "Decay 1";
    filterModLabels[i1][3] = "Decay 2";
    filterModLabels[i1][4] = "Level";
    filterModLabels[i1][5] = "Release";
    filterModLabels[i1][6] = "Envelope Amount";
    filterModLabels[i1][7] = "Frequency";
    filterModLabels[i1][8] = "Depth";
    filterModLabels[i1][9] = "Delay";
    filterModLabels[i1][10] = "Frequency";
    filterModLabels[i1][11] = "Depth";
    filterModLabels[i1][12] = "Delay";
    filterModLabels[i1][13] = "Inverse";
    filterModLabels[i1][14] = "Fast";
    filterModLabels[i1][15] = "Retrigger";
    filterModLabels[i1][16] = "Inverse";
    filterModLabels[i1][17] = "Fast ";
    filterModLabels[i1][18] = "Retrigger ";
    filterModLabels[i1][19] = "Inverse ";
    for (i2 = 0; i2 < 3; i2++) {
      filterModBox[i1][i2] = new QGroupBox(filterModBoxLabels[i1][i2]);
      filterModGroupBoxLayout[i1][i2] = new QVBoxLayout; 
      filterModBox[i1][i2]->setLayout(filterModGroupBoxLayout[i1][i2]);
      for (i4 = 0; i4 < 2; i4++) {
        filterModHSubFrameLayout[i1][2 * i2 + i4] = new QHBoxLayout;
        filterModHSubFrameLayout[i1][2 * i2 + i4]->setContentsMargins(0, 0, 0, 0);
        filterModHSubFrame[i1][2 * i2 + i4] = new QWidget;
        filterModHSubFrame[i1][2 * i2 + i4]->setLayout(filterModHSubFrameLayout[i1][2 * i2 + i4]);
        filterModGroupBoxLayout[i1][i2]->addWidget(filterModHSubFrame[i1][2 * i2 + i4]);
        for (i3 = 0; i3 < 2; i3++) {
          filterModVSubFrameLayout[i1][4 * i2 + 2 * i4 + i3] = new QVBoxLayout; 
          filterModVSubFrame[i1][4 * i2 + 2 * i4 + i3] = new QWidget;
          filterModVSubFrame[i1][4 * i2 + 2 * i4 + i3]->setLayout(filterModVSubFrameLayout[i1][4 * i2 + 2 * i4 + i3]);
          filterModHSubFrameLayout[i1][2 * i2 + i4]->addWidget(filterModVSubFrame[i1][4 * i2 + + 2 * i4 + i3]);
        }
      }    
    }
    for (i2 = 0; i2 < 13; i2++) {
      filterModSlider[i1][i2] = new ModSlider(model, Qt::Horizontal); 
      filterModSlider[i1][i2]->setMinimum(0);
      filterModSlider[i1][i2]->setMaximum(1000);
      filterModSlider[i1][i2]->setTickInterval(1);
      QObject::connect(filterModSlider[i1][i2], SIGNAL(valueChanged(int)), this, SLOT(setFilterMod(int)));
    }
    filterModSlider[i1][0]->setValue(100);
    filterModSlider[i1][1]->setValue(100);
    filterModSlider[i1][2]->setValue(100);
    filterModSlider[i1][3]->setValue(100);
    filterModSlider[i1][4]->setValue(100);
    filterModSlider[i1][5]->setValue(100);
    filterModSlider[i1][6]->setValue(100);
    filterModSlider[i1][7]->setValue(100);
    filterModSlider[i1][8]->setValue(100);
    filterModSlider[i1][9]->setValue(100);
    filterModSlider[i1][10]->setValue(100);
    filterModSlider[i1][11]->setValue(100);
    filterModSlider[i1][12]->setValue(100);

    for (i2 = 0; i2 < 7; i2++) {  
      filterModCheckBox[i1][i2] = new QCheckBox(filterModLabels[i1][13 + i2]);
      QObject::connect(filterModCheckBox[i1][i2], SIGNAL(stateChanged(int)), this, SLOT(filterModToggled(int)));
      filterModCheckBox[i1][i2]->setChecked(true);
      filterModCheckBox[i1][i2]->setChecked(false);
    }
    for (i2 = 0; i2 < 3; i2++) {
      for (i3 = 0; i3 < 2; i3++) {
        filterModVSubFrameLayout[i1][i3]->addWidget(new QLabel(filterModLabels[i1][2 * i2 + i3]));
        filterModVSubFrameLayout[i1][i3]->addWidget(filterModSlider[i1][2 * i2 + i3]);
      }
    }
    filterModVSubFrameLayout[i1][2]->addWidget(new QLabel(filterModLabels[i1][6]));
    filterModVSubFrameLayout[i1][2]->addWidget(filterModSlider[i1][6]);
    filterModVSubFrameLayout[i1][3]->addWidget(filterModCheckBox[i1][0]);
    for (i2 = 0; i2 < 2; i2++) {
      filterModVSubFrameLayout[i1][4 * i2 + 4]->addWidget(new QLabel(filterModLabels[i1][7 + 3 * i2 + 2]));
      filterModVSubFrameLayout[i1][4 * i2 + 4]->addWidget(filterModSlider[i1][7 + 3 * i2 + 2]);
      filterModVSubFrameLayout[i1][4 * i2 + 5]->addWidget(new QLabel(filterModLabels[i1][7 + 3 * i2 + 1]));
      filterModVSubFrameLayout[i1][4 * i2 + 5]->addWidget(filterModSlider[i1][7 + 3 * i2 + 1]);
      filterModVSubFrameLayout[i1][4 * i2 + 6]->addWidget(new QLabel(filterModLabels[i1][7 + 3 * i2]));
      filterModVSubFrameLayout[i1][4 * i2 + 6]->addWidget(filterModSlider[i1][7 + 3 * i2]);
      filterModVSubFrameLayout[i1][4 * i2 + 7]->addWidget(filterModCheckBox[i1][3 * i2 + 1]);
      filterModVSubFrameLayout[i1][4 * i2 + 7]->addWidget(filterModCheckBox[i1][3 * i2 + 2]);
      filterModVSubFrameLayout[i1][4 * i2 + 7]->addWidget(filterModCheckBox[i1][3 * i2 + 3]);
    }
    for (i2 = 0; i2 < 3; i2++) {
      filterModMainLayout[i1]->addWidget(filterModBox[i1][i2]);
    }  
    mainTab->addTab(filterModFrame[i1], "Filter " + QString::number(i1 + 1) + " Modulation");
  }
  QVBoxLayout *commonMainLayout = new QVBoxLayout;
  QWidget *commonFrame = new QWidget;
  commonFrame->setLayout(commonMainLayout);
  mainTab->addTab(commonFrame, "Main");

  voiceFrame = new QWidget;
  voiceLayout = new QVBoxLayout;
  voiceFrame->setLayout(voiceLayout);
  voiceFileFrame = new QGroupBox("Sound File");
  voiceFileLayout = new QHBoxLayout;
  voiceFileFrame->setLayout(voiceFileLayout);
  voiceFileLabel = new QLabel(voiceFileName);
  voiceFileLayout->addWidget(voiceFileLabel);
  voiceRangeFrame = new QGroupBox("Edit Range && MIDI Channel");
  voiceRangeLayout = new QHBoxLayout;
  voiceRangeFrame->setLayout(voiceRangeLayout);
  voiceRangeStart = new QSpinBox;
  voiceRangeStart->setRange(1, model->getPoly());
  voiceRangeEnd = new QSpinBox;
  voiceRangeEnd->setRange(1, model->getPoly());
  voiceRangeEnd->setValue(model->getPoly());
  voiceChannel = new QSpinBox;
  voiceChannel->setRange(1, 16);
  QObject::connect(voiceRangeStart, SIGNAL(valueChanged(int)), this, SLOT(voiceRangeStartChanged(int)));
  QObject::connect(voiceRangeEnd, SIGNAL(valueChanged(int)), this, SLOT(voiceRangeEndChanged(int)));
  QObject::connect(voiceChannel, SIGNAL(valueChanged(int)), this, SLOT(voiceChannelChanged(int)));
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeLayout->addWidget(new QLabel("Start: "));  
  voiceRangeLayout->addWidget(voiceRangeStart);
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeLayout->addWidget(new QLabel("End: "));  
  voiceRangeLayout->addWidget(voiceRangeEnd);  
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeLayout->addWidget(new QLabel("Channel: "));  
  voiceRangeLayout->addWidget(voiceChannel);  
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeSetButton = new QPushButton("Set");
  QObject::connect(voiceRangeSetButton, SIGNAL(clicked()), this, SLOT(voiceRangeSet()));
  voiceRangeLayout->addWidget(voiceRangeSetButton);
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceRangeLayout->addWidget(new QWidget); // Dummy 
  voiceTreeFrame = new QGroupBox("Voice List");
  voiceTreeLayout = new QHBoxLayout;
  voiceTreeFrame->setLayout(voiceTreeLayout);
  voiceTreeHeaders.append("Voice");
  voiceTreeHeaders.append("Channel");
  voiceTreeHeaders.append("Sound File");
  voiceTree = new QTreeWidget();
  voiceTree->setColumnCount(3);
  QObject::connect(voiceTree, SIGNAL(currentItemChanged(QTreeWidgetItem *, QTreeWidgetItem *)), this, SLOT(voiceTreeChanged(QTreeWidgetItem *, QTreeWidgetItem *)));
  voiceTree->setHeaderLabels(voiceTreeHeaders);  
  voiceTreeLayout->addWidget(voiceTree);
  voiceLayout->addWidget(voiceFileFrame);
  voiceLayout->addWidget(voiceRangeFrame);
  voiceLayout->addWidget(voiceTreeFrame);
  voiceLayout->addWidget(new QWidget); // Dummy
  voiceLayout->addWidget(new QWidget); // Dummy
  mainTab->addTab(voiceFrame, "Voice Assign");

  QVBoxLayout *settingsMainLayout = new QVBoxLayout;
  QWidget *settingsFrame = new QWidget;
  settingsFrame->setLayout(settingsMainLayout);
  mainTab->addTab(settingsFrame, "MIDI");
  QWidget *treeFrame = new QWidget;
  settingsMainLayout->addWidget(treeFrame);
  QHBoxLayout *treeLayout = new QHBoxLayout;
  treeFrame->setLayout(treeLayout);
  midiControllerTree = new QTreeWidget();
  midiControllerTree->setColumnCount(1);
  midiControllerTree->setHeaderLabel("MIDI Input");
  treeLayout->addWidget(midiControllerTree);
  controlObjectTree = new QTreeWidget();
  controlObjectTree->setColumnCount(1);
  controlObjectTree->setHeaderLabel("Destination");
  treeLayout->addWidget(controlObjectTree);
  QTreeWidgetItem *commonItem = new QTreeWidgetItem(controlObjectTree);
  commonItem->setText(0, "Main");
  QWidget *buttonFrame = new QWidget;
  settingsMainLayout->addWidget(buttonFrame);  
  QHBoxLayout *buttonLayout = new QHBoxLayout;
  buttonFrame->setLayout(buttonLayout);
  
  buttonLayout->addWidget(new QLabel("Midi Switch Group:"));
  midiGroupCombo = new QComboBox;
  midiGroupCombo->addItem("(0) Always Active");
  midiGroupCombo->addItem("(1) Harmonics / Amplitude Switch");
  midiGroupCombo->addItem("(2) Oscillators / Delay Switch");
  midiGroupCombo->addItem("(3) Noise / Attack Switch");
  midiGroupCombo->addItem("(4) Filter 1 / Decay 1 Switch");
  midiGroupCombo->addItem("(5) Filter 2 / Decay 2 Switch");
  midiGroupCombo->addItem("(6) Filter 1 Modulation / Level Switch");
  midiGroupCombo->addItem("(7) Filter 2 Modulation / Release Switch");
  midiGroupCombo->addItem("(8) Main / Env Amount Switch");
  midiGroupCombo->addItem("(9) Mixer 1/2 / Env Freq Switch");
  midiGroupCombo->addItem("(10) Mixer 3/Noise / Env Random Switch");
  midiGroupCombo->addItem("(11) Filter Curve Switch 1");
  midiGroupCombo->addItem("(12) Filter Curve Switch 2");
  midiGroupCombo->addItem("(13) Osc 1 Switch");
  midiGroupCombo->addItem("(14) Osc 2 Switch");
  midiGroupCombo->addItem("(15) Osc 3 Switch");
  midiGroupCombo->addItem("(16) Noise Switch");
  buttonLayout->addWidget(midiGroupCombo);
  buttonLayout->addWidget(new QWidget);
  QObject::connect(midiGroupCombo, SIGNAL(currentIndexChanged(int)), this, SLOT(setMidiGroup(int)));

  QPushButton *connectButton = new QPushButton("Connect");
  QPushButton *disconnectButton = new QPushButton("Disconnect");
  buttonLayout->addWidget(connectButton); 
  buttonLayout->addWidget(disconnectButton); 
  QObject::connect(connectButton, SIGNAL(clicked()), this, SLOT(connectController()));
  QObject::connect(disconnectButton, SIGNAL(clicked()), this, SLOT(disconnectController()));
  QObject::connect(midiControllerTree, SIGNAL(currentItemChanged(QTreeWidgetItem *, QTreeWidgetItem *)), this,
                                       SLOT(midiCurrentItemChanged(QTreeWidgetItem *, QTreeWidgetItem *)));
  followMidi = true;
  QHBoxLayout *modSettingsLayout = new QHBoxLayout;
  QWidget *modSettingsFrame = new QWidget;
  modSettingsFrame->setLayout(modSettingsLayout);
  settingsMainLayout->addWidget(modSettingsFrame);
  QVBoxLayout *modSettingsLayoutL = new QVBoxLayout;
  QVBoxLayout *modSettingsLayoutR = new QVBoxLayout;
  QWidget *modSettingsFrameL = new QWidget;
  modSettingsFrameL->setLayout(modSettingsLayoutL);
  modSettingsLayout->addWidget(modSettingsFrameL);
  QWidget *modSettingsFrameR = new QWidget;
  modSettingsFrameR->setLayout(modSettingsLayoutR);
  modSettingsLayout->addWidget(modSettingsFrameR);
  modDepthLabel = new QLabel("Modulation Depth");
  modSettingsLayoutL->addWidget(modDepthLabel);
  modDepthSlider = new QSlider(Qt::Horizontal);
  modSettingsLayoutL->addWidget(modDepthSlider);
  modDepthSlider->setMinimum(0);
  modDepthSlider->setMaximum(1000);
  modDepthSlider->setTickInterval(1);
  QObject::connect(modDepthSlider, SIGNAL(valueChanged(int)), this, SLOT(setModDepth(int)));
  modFullToggle = new QCheckBox("Full Range");
  modSettingsLayoutR->addWidget(modFullToggle);
  modInverseToggle = new QCheckBox("Inverse");
  QObject::connect(modFullToggle, SIGNAL(stateChanged(int)), this, SLOT(modFullToggled(int)));
  modFullToggle->setChecked(true);
  QObject::connect(modInverseToggle, SIGNAL(stateChanged(int)), this, SLOT(modInverseToggled(int)));
  modSettingsLayoutR->addWidget(modInverseToggle);
  modInverseToggle->setChecked(false);
  modFullToggle->setChecked(true);
  
  QVBoxLayout *volumeMainLayout = new QVBoxLayout;
  QWidget *volumeFrame = new QWidget;
  volumeFrame->setLayout(volumeMainLayout);
  mainTab->addTab(volumeFrame, "Volume");
  QGroupBox *masterBox = new QGroupBox("Master");
  QVBoxLayout *masterLayout = new QVBoxLayout;
  masterBox->setLayout(masterLayout);
  masterVolume = new ModSlider(model, Qt::Horizontal);
  masterLayout->addWidget(masterVolume); 
  masterVolume->setMinimum(0);
  masterVolume->setMaximum(1000);
  masterVolume->setTickInterval(1);
  QObject::connect(masterVolume, SIGNAL(valueChanged(int)), this, SLOT(setMasterVolume(int)));
  addControlObject("Master Volume", 0, 0);
  masterVolume->setValue(300);
  QGroupBox *volumeTrackingBox = new QGroupBox("Volume Tracking");
  QVBoxLayout *volumeTrackingLayout = new QVBoxLayout;
  volumeTrackingBox->setLayout(volumeTrackingLayout);
  volumeTrackingSlider = new ModSlider(model, Qt::Horizontal);
  volumeTrackingSlider->setMinimum(0);
  volumeTrackingSlider->setMaximum(1000);
  volumeTrackingSlider->setTickInterval(1);
  volumeTrackingLayout->addWidget(volumeTrackingSlider);
  QGroupBox *velocityDepthBox = new QGroupBox("Velocity Depth");
  QVBoxLayout *velocityDepthLayout = new QVBoxLayout;
  velocityDepthBox->setLayout(velocityDepthLayout);
  velocityDepthSlider = new ModSlider(model, Qt::Horizontal); 
  velocityDepthSlider->setMinimum(0);
  velocityDepthSlider->setMaximum(1000);
  velocityDepthSlider->setTickInterval(1);
  velocityDepthLayout->addWidget(velocityDepthSlider);
  volumeMainLayout->addWidget(masterBox);
  volumeMainLayout->addWidget(volumeTrackingBox);
  volumeMainLayout->addWidget(velocityDepthBox);
  volumeMainLayout->addWidget(new QWidget, 2);
  QObject::connect(volumeTrackingSlider, SIGNAL(valueChanged(int)), this, SLOT(setVolumeTracking(int)));
  volumeTrackingSlider->setValue(500);   
  QObject::connect(velocityDepthSlider, SIGNAL(valueChanged(int)), this, SLOT(setVelocityDepth(int)));
  velocityDepthSlider->setValue(500);
  
  setLayout(mainLayout);

  labels[0] = "Amplitude";
  labels[1] = "Delay";
  labels[2] = "Attack";
  labels[3] = "Decay 1";
  labels[4] = "Decay 2";
  labels[5] = "Level";
  labels[6] = "Release";
  labels[7] = "Env Amount";
  labels[8] = "Env Freq";
  labels[9] = "Env Random";
  
  groupLabels[0] = "Scene 1";
  groupLabels[1] = "Scene 2";
  radioLabels[0] = "Spectral Oscillator 1";
  radioLabels[1] = "Spectral Oscillator 2";
  radioLabels[2] = "Spectral Oscillator 3";
  radioLabels[3] = "Noise";

  harmonicMainLayout->addWidget(new QWidget);
  randomContainer = new QWidget;
  randomContainerLayout = new QHBoxLayout;
  randomContainer->setLayout(randomContainerLayout);
  randomBox = new QGroupBox("Random && Polygon Settings");
  harmonicMainLayout->addWidget(randomContainer);
  randomLayout = new QHBoxLayout;
  randomBox->setLayout(randomLayout);
  randomContainerLayout->addWidget(randomBox);
  randomLabel[0] = new QLabel("Lower Random ");
  randomLayout->addWidget(randomLabel[0]);
  lowerRandomLevel = 200;
  lowerHarmonicRandomLevelSlider = new QSlider(Qt::Horizontal);
  lowerHarmonicRandomLevelSlider->setMinimum(0);
  lowerHarmonicRandomLevelSlider->setMaximum(1000);
  lowerHarmonicRandomLevelSlider->setTickInterval(1);
  lowerHarmonicRandomLevelSlider->setValue(lowerRandomLevel);
  randomLayout->addWidget(lowerHarmonicRandomLevelSlider);
  QObject::connect(lowerHarmonicRandomLevelSlider, SIGNAL(valueChanged(int)), this, SLOT(lowerRandomLevelChanged(int)));
  randomLayout->addWidget(new QWidget);
  randomLabel[1] = new QLabel("Upper Random ");
  randomLayout->addWidget(randomLabel[1]);
  upperRandomLevel = 200;
  upperHarmonicRandomLevelSlider = new QSlider(Qt::Horizontal);
  upperHarmonicRandomLevelSlider->setMinimum(0);
  upperHarmonicRandomLevelSlider->setMaximum(1000);
  upperHarmonicRandomLevelSlider->setTickInterval(1);
  upperHarmonicRandomLevelSlider->setValue(upperRandomLevel);
  randomLayout->addWidget(upperHarmonicRandomLevelSlider);
  QObject::connect(upperHarmonicRandomLevelSlider, SIGNAL(valueChanged(int)), this, SLOT(upperRandomLevelChanged(int)));
  randomLayout->addWidget(new QWidget);
  randomizeHarmonicsButton = new QPushButton("Randomize");
  randomLayout->addWidget(randomizeHarmonicsButton);
  QObject::connect(randomizeHarmonicsButton, SIGNAL(clicked()), this, SLOT(randomizeHarmonics()));
  randomLayout->addWidget(new QWidget);
  addRandomCheck = new QCheckBox("Add Random");
  addRandomCheck->setChecked(true);
  randomLayout->addWidget(addRandomCheck);
  addRandomFlag= addRandomCheck->isChecked();
  randomLayout->addWidget(new QWidget);
  QObject::connect(addRandomCheck, SIGNAL(stateChanged(int)), this, SLOT(addRandomToggled(int)));
  showPolygonCheck = new QCheckBox("Show Polygon");
  showPolygonCheck->setChecked(true);
  randomLayout->addWidget(showPolygonCheck);
  showPolygonFlag = showPolygonCheck->isChecked();
  QObject::connect(showPolygonCheck, SIGNAL(stateChanged(int)), this, SLOT(showPolygonToggled(int)));
  groupSelector = new QButtonGroup;
  QHBoxLayout *radioFrameLayout = new QHBoxLayout; 
  QWidget *radioFrame = new QWidget;
  harmonicMainLayout->addWidget(radioFrame);
  radioFrame->setLayout(radioFrameLayout);
  for (i1 = 0; i1 < MAX_SCENES; i1++) {
    groupBox[i1] = new QGroupBox(groupLabels[i1]);
    radioLayout[i1] = new QHBoxLayout;
    for (i2 = 0; i2 < MAX_SOURCES; i2++) {
      radio[i1][i2] = new QRadioButton(radioLabels[i2]);
      radioLayout[i1]->addWidget(radio[i1][i2]);
      groupSelector->addButton(radio[i1][i2]);
      groupSelector->setId(radio[i1][i2], i1 * MAX_SOURCES + i2);
    }  
    groupBox[i1]->setLayout(radioLayout[i1]);
    radioFrameLayout->addWidget(groupBox[i1]);
    QObject::connect(groupSelector, SIGNAL(buttonClicked(int)), this, SLOT(selectGroup(int)));
  }  
  radio[0][0]->setChecked(true);
  for (i1 = 0; i1 < MAX_PARAMS; i1++) {
    harmonicWidget[i1] = new QWidget;
    harmonicTab->addTab(harmonicWidget[i1], labels[i1]);
    harmonicLayout[i1] = new QVBoxLayout;
    harmonicWidget[i1]->setLayout(harmonicLayout[i1]);
    if (i1 == 0) {
      unitLabels[i1] = " ";
    } else {
      unitLabels[i1] = " ";
    }
    harmonics[i1] = new Harmonics(model, unitLabels[i1], i1, this, 800, 450);
    harmonicLayout[i1]->addWidget(harmonics[i1]);
    scaleBox[i1] = new QWidget;
    harmonicLayout[i1]->addWidget(scaleBox[i1]);
    scaleLayout[i1] = new QHBoxLayout;
    scaleBox[i1]->setLayout(scaleLayout[i1]);
    scaleLabel[i1] = new QLabel("Scale  ");
    scaleLayout[i1]->addWidget(scaleLabel[i1]);
    harmonicScale[i1] = new MultiSlider(model, MAX_SCENES * MAX_SOURCES, Qt::Horizontal);
    harmonicScale[i1]->setMinimum(-1000);
    harmonicScale[i1]->setMaximum(1000);
    harmonicScale[i1]->setTickInterval(1);
    harmonicScale[i1]->writeValue(0, 0);
    scaleLayout[i1]->addWidget(harmonicScale[i1]);
    QObject::connect(harmonicScale[i1], SIGNAL(valueChanged(int)), this, SLOT(reScale(int)));
    harmonicLayout[i1]->setStretchFactor(harmonics[i1], 10);
    harmonicLayout[i1]->setStretchFactor(scaleBox[i1], 1);
    QObject::connect(harmonicTab, SIGNAL(currentChanged(int)), this, SLOT(updateTab(int)));
  }
  addControlFolder("Scales");
  for (i3 = 0; i3 < MAX_PARAMS; i3++) {
    addControlObject(labels[i3]+" Scale", 1, i3); // groupIndex 18
  }
  addControlFolder("Oscillators");
  addControlFolder("Noise");
  for (i1 = 0; i1 < 4; i1++) {
    addControlObject("Noise " + noiseLabels[i1], 3, i1);
  }
  addControlObject("Noise Frequency Diffusion", 3, 4);
  addControlObject("Noise SubHarmonic Mode", 3, 5);
  addControlFolder("Mixer");
  for (i2 = 0; i2 < 9; i2++) {
    addControlObject(filterMixLabels[i2], 4, i2);
  }
  addControlFolder("Filter 1 & 2");
  addControlObject("Filter Cutoff Coarse", 5, 0);
  addControlObject("Filter Cutoff Fine", 5, 1);
  addControlObject("Filter Spacing Coarse", 5, 2);
  addControlObject("Filter Spacing Fine", 5, 3);
  addControlObject("Filter Key Tracking", 5, 4);
  addControlObject("Filter Mix", 5, 5);
  addControlObject("Filter Cutoff Fixed Values", 5, 6);
  addControlObject("Filter Spacing Fixed Values", 5, 7);
  addControlObject("Filter Key Tracking Fixed Values", 5, 8);

  QGroupBox *detuneBox = new QGroupBox("Detune / Random");
  QHBoxLayout *detuneLayout = new QHBoxLayout;
  detuneBox->setLayout(detuneLayout);
  QVBoxLayout *detuneSliderLayout = new QVBoxLayout;
  QWidget *detuneSliderFrame = new QWidget;
  detuneSliderFrame->setLayout(detuneSliderLayout);
  detuneSliderLayout->addWidget(new QLabel("Env Detune"));
  detuneSlider = new ModSlider(model, Qt::Horizontal);
  detuneSliderLayout->addWidget(detuneSlider);
  detuneSlider->setMinimum(0);
  detuneSlider->setMaximum(1000);
  detuneSlider->setTickInterval(1);
  QObject::connect(detuneSlider, SIGNAL(valueChanged(int)), this, SLOT(setDetune(int)));
  detuneLayout->addWidget(detuneSliderFrame);
  QVBoxLayout *offsetDetuneSliderLayout = new QVBoxLayout;
  QWidget *offsetDetuneSliderFrame = new QWidget;
  offsetDetuneSliderFrame->setLayout(offsetDetuneSliderLayout);
  offsetDetuneSliderLayout->addWidget(new QLabel("Offset Detune"));
  offsetDetuneSlider = new ModSlider(model, Qt::Horizontal);
  offsetDetuneSliderLayout->addWidget(offsetDetuneSlider);
  offsetDetuneSlider->setMinimum(0);
  offsetDetuneSlider->setMaximum(1000);
  offsetDetuneSlider->setTickInterval(1);
  QObject::connect(offsetDetuneSlider, SIGNAL(valueChanged(int)), this, SLOT(setOffsetDetune(int)));
  detuneLayout->addWidget(offsetDetuneSliderFrame);
  QVBoxLayout *randomSliderLayout = new QVBoxLayout;
  QWidget *randomSliderFrame = new QWidget;
  randomSliderFrame->setLayout(randomSliderLayout);
  randomSliderLayout->addWidget(new QLabel("Voice Randomization"));
  randomSlider = new ModSlider(model, Qt::Horizontal);
  randomSliderLayout->addWidget(randomSlider);
  randomSlider->setMinimum(0);
  randomSlider->setMaximum(1000);
  randomSlider->setTickInterval(1);
  QObject::connect(randomSlider, SIGNAL(valueChanged(int)), this, SLOT(setVoiceRandom(int)));
  commonMainLayout->addWidget(detuneBox);
  
  QHBoxLayout *pitchLFOlayout = new QHBoxLayout;
  QVBoxLayout *pitchLFOlayoutL = new QVBoxLayout;
  QVBoxLayout *pitchLFOlayoutR = new QVBoxLayout;
  QGroupBox *pitchLFObox = new QGroupBox("Pitch");
  QWidget *pitchLFOboxL = new QWidget;
  QWidget *pitchLFOboxR = new QWidget;
  pitchLFOboxL->setLayout(pitchLFOlayoutL);
  pitchLFOboxR->setLayout(pitchLFOlayoutR);
  pitchLFOlayout->setContentsMargins(0, 10, 0, 10);
  pitchLFOlayout->addWidget(pitchLFOboxL);
  pitchLFOlayout->addWidget(pitchLFOboxR);
  QLabel *pitchLFOfreqLabel = new QLabel("LFO Freq ");
  QLabel *pitchLFOdepthLabel = new QLabel("LFO Depth ");
  pitchLFOfreq = new ModSlider(model, Qt::Horizontal); 
  pitchLFOdepth = new ModSlider(model, Qt::Horizontal);
  pitchLFOfreq->setMinimum(0);
  pitchLFOfreq->setMaximum(1000);
  pitchLFOfreq->setTickInterval(1);
  pitchLFOdepth->setMinimum(0);
  pitchLFOdepth->setMaximum(1000);
  pitchLFOdepth->setTickInterval(1);
  pitchLFOlayoutL->addWidget(pitchLFOfreqLabel);
  pitchLFOlayoutL->addWidget(pitchLFOfreq);
  pitchLFOlayoutR->addWidget(pitchLFOdepthLabel);
  pitchLFOlayoutR->addWidget(pitchLFOdepth);
  pitchLFObox->setLayout(pitchLFOlayout); 
  commonMainLayout->addWidget(pitchLFObox);
  addControlObject("LFO Freq", 0, 1);
  addControlObject("LFO Depth", 0, 2);

  evenOddBox = new QGroupBox("Spectrum 1");
  evenOddLayout = new QVBoxLayout;
  evenOddBox->setLayout(evenOddLayout);
  for (i1 = 0; i1 < 3; i1++) {
    evenOddSlider[i1] = new ModSlider(model, Qt::Horizontal);
    evenOddSlider[i1]->setMinimum(0);
    evenOddSlider[i1]->setMaximum(1000); 
    evenOddSlider[i1]->setTickInterval(1);
  }
  evenOddLayout->addWidget(new QLabel("Even/Odd"));
  evenOddLayout->addWidget(evenOddSlider[0]);
  QObject::connect(evenOddSlider[0], SIGNAL(valueChanged(int)), this, SLOT(setEvenOdd(int)));
  addControlObject("Even/Odd 1", 2, 0);
  evenOddSlider[0]->setValue(500); 
  oscMainLayout->addWidget(evenOddBox);   

  for (i1 = 0; i1 < 2; i1++) {
    spectrumLayout[i1] = new QVBoxLayout;
    spectrumHLayout[i1] = new QHBoxLayout;
    spectrumLayoutL[i1] = new QVBoxLayout;
    spectrumLayoutR[i1] = new QVBoxLayout;
    spectrumBox[i1] = new QGroupBox("Spectrum " + QString::number(i1 + 2));
    spectrumBox[i1]->setLayout(spectrumLayout[i1]); 
    spectrumHFrame[i1] = new QWidget;
    spectrumBoxL[i1] = new QWidget;
    spectrumBoxR[i1] = new QWidget;
    spectrumHFrame[i1]->setLayout(spectrumHLayout[i1]);
    spectrumHLayout[i1]->setContentsMargins(0, 10, 0, 10);
    spectrumLayoutL[i1]->setContentsMargins(0, 10, 0, 10);
    spectrumLayoutR[i1]->setContentsMargins(0, 10, 0, 10);
    spectrumBoxL[i1]->setLayout(spectrumLayoutL[i1]);
    spectrumBoxR[i1]->setLayout(spectrumLayoutR[i1]);
    spectrumLayout[i1]->addWidget(spectrumHFrame[i1]);
    spectrumHLayout[i1]->addWidget(spectrumBoxL[i1]);
    spectrumHLayout[i1]->addWidget(new QWidget); // Dummy
    spectrumHLayout[i1]->addWidget(new QWidget); // Dummy
    spectrumHLayout[i1]->addWidget(spectrumBoxR[i1]);
    spectrumHLayout[i1]->addWidget(new QWidget); // Dummy
    spectrumHLayout[i1]->addWidget(new QWidget); // Dummy
    spectrumComboLayout[i1] = new QVBoxLayout; 
    spectrumComboFrame[i1] = new QWidget;
    spectrumComboFrame[i1]->setLayout(spectrumComboLayout[i1]);
    spectrumHLayout[i1]->addWidget(spectrumComboFrame[i1]);
    spectrumOffsetCombo[i1] = new QComboBox;
    spectrumSpacingCombo[i1] = new QComboBox;
    spectrumComboLayout[i1]->addWidget(new QLabel("Offset"));
    spectrumComboLayout[i1]->addWidget(spectrumOffsetCombo[i1]);
    if (i1) {
      spectrumComboLayout[i1]->addWidget(new QLabel("Shift"));
    } else {
      spectrumComboLayout[i1]->addWidget(new QLabel("Spacing"));
    }
    spectrumComboLayout[i1]->addWidget(spectrumSpacingCombo[i1]);
    spectrumSpacingCombo[i1]->addItem("Free");
    for (i2 = -24; i2 < 25; i2++) {
      spectrumOffsetCombo[i1]->addItem(QString::number(i2));
    }
    spectrumOffsetCombo[i1]->setCurrentIndex(24);
    for (i2 = 0; i2 < 11; i2++) {
      spectrumSpacingCombo[i1]->addItem(QString::number((double)i2 / 10.0, 'f', 2));
    }
    if (i1) {
      spectrumLabel[4 * i1] = new QLabel("Main Frequency Offset Coarse");
      spectrumLabel[4 * i1 + 1] = new QLabel("Frequency Shifter Coarse");
      spectrumLabel[4 * i1 + 2] = new QLabel("Main Frequency Offset Fine");
      spectrumLabel[4 * i1 + 3] = new QLabel("Frequency Shifter Fine");
    } else {
      spectrumLabel[4 * i1] = new QLabel("Offset Coarse");
      spectrumLabel[4 * i1 + 1] = new QLabel("Spacing Coarse");
      spectrumLabel[4 * i1 + 2] = new QLabel("Offset Fine");
      spectrumLabel[4 * i1 + 3] = new QLabel("Spacing Fine");
    }
    spectrumOffset[2 * i1] = new ModSlider(model, Qt::Horizontal); 
    spectrumSpacing[2 * i1] = new ModSlider(model, Qt::Horizontal);
    spectrumOffset[2 * i1 + 1] = new ModSlider(model, Qt::Horizontal); 
    spectrumSpacing[2 * i1 + 1] = new ModSlider(model, Qt::Horizontal);
    spectrumOffset[2 * i1]->setMinimum(-1000);
    spectrumOffset[2 * i1]->setMaximum(1000);
    spectrumOffset[2 * i1]->setTickInterval(1);
    spectrumSpacing[2 * i1]->setMinimum(-1000);
    spectrumSpacing[2 * i1]->setMaximum(1000);
    spectrumSpacing[2 * i1]->setTickInterval(1);
    spectrumOffset[2 * i1 + 1]->setMinimum(-1000);
    spectrumOffset[2 * i1 + 1]->setMaximum(1000);
    spectrumOffset[2 * i1 + 1]->setTickInterval(1);
    spectrumSpacing[2 * i1 + 1]->setMinimum(-1000);
    spectrumSpacing[2 * i1 + 1]->setMaximum(1000);
    spectrumSpacing[2 * i1 + 1]->setTickInterval(1);
    spectrumLayoutL[i1]->addWidget(spectrumLabel[4 * i1]);
    spectrumLayoutL[i1]->addWidget(spectrumOffset[2 * i1]);
    spectrumLayoutL[i1]->addWidget(spectrumLabel[4 * i1 + 2]);
    spectrumLayoutL[i1]->addWidget(spectrumOffset[2 * i1 + 1]);
    spectrumLayoutR[i1]->addWidget(spectrumLabel[4 * i1 + 1]);
    spectrumLayoutR[i1]->addWidget(spectrumSpacing[2 * i1]);
    spectrumLayoutR[i1]->addWidget(spectrumLabel[4 * i1 + 3]);
    spectrumLayoutR[i1]->addWidget(spectrumSpacing[2 * i1 + 1]);
    spectrumLayout[i1]->addWidget(new QLabel("Even/Odd"));
    spectrumLayout[i1]->addWidget(evenOddSlider[i1 + 1]);
    if (i1) {
      QLabel *osc3FreqDiffusionLabel = new QLabel("Frequency Diffusion");
      osc3FreqDiffusionSlider = new ModSlider(model, Qt::Horizontal);
      osc3FreqDiffusionSlider->setMinimum(0);
      osc3FreqDiffusionSlider->setMaximum(1000);
      osc3FreqDiffusionSlider->setTickInterval(1);
      spectrumLayout[i1]->addWidget(osc3FreqDiffusionLabel);
      spectrumLayout[i1]->addWidget(osc3FreqDiffusionSlider);
      QObject::connect(osc3FreqDiffusionSlider, SIGNAL(valueChanged(int)), this, SLOT(setOsc3FreqDiffusion(int)));
      QVBoxLayout *osc3ModeComboLayout = new QVBoxLayout;
      QWidget *osc3ModeComboFrame = new QWidget;
      osc3ModeComboFrame->setLayout(osc3ModeComboLayout);
      osc3ModeCombo = new QComboBox;
      osc3ModeComboLayout->addWidget(new QLabel("Mode"));
      osc3ModeComboLayout->addWidget(osc3ModeCombo);
      osc3ModeCombo->addItem("Harmonics");
      osc3ModeCombo->addItem("Subharmonics");
      osc3ModeCombo->addItem("Mixed (16/16)");
      osc3ModeCombo->addItem("Mixed (8/24)");
      QHBoxLayout *osc3ModeDummyLayout = new QHBoxLayout;
      QWidget *osc3ModeDummyFrame = new QWidget;
      osc3ModeDummyFrame->setLayout(osc3ModeDummyLayout);
      osc3ModeDummyLayout->addWidget(osc3ModeComboFrame);
      osc3ModeDummyLayout->addWidget(new QWidget(), 2);
      spectrumLayout[i1]->addWidget(osc3ModeDummyFrame);
    }
    oscMainLayout->addWidget(spectrumBox[i1]);
    QObject::connect(spectrumOffset[2 * i1], SIGNAL(valueChanged(int)), this, SLOT(setSpectrumOffset(int)));
    QObject::connect(spectrumOffset[2 * i1 + 1], SIGNAL(valueChanged(int)), this, SLOT(setSpectrumOffset(int)));
    QObject::connect(spectrumSpacing[2 * i1], SIGNAL(valueChanged(int)), this, SLOT(setSpectrumSpacing(int)));
    QObject::connect(spectrumSpacing[2 * i1 + 1], SIGNAL(valueChanged(int)), this, SLOT(setSpectrumSpacing(int)));
    QObject::connect(evenOddSlider[1 + i1], SIGNAL(valueChanged(int)), this, SLOT(setEvenOdd(int)));
    QObject::connect(spectrumOffsetCombo[i1], SIGNAL(currentIndexChanged(int)), this, SLOT(setSpectrumOffsetCombo(int)));
    QObject::connect(spectrumSpacingCombo[i1], SIGNAL(currentIndexChanged(int)), this, SLOT(setSpectrumSpacingCombo(int)));
    addControlObject(spectrumLabel[4 * i1]->text() + " " + QString::number(i1 + 2), 2, 7 * i1 + 1);
    addControlObject(spectrumLabel[4 * i1 + 2]->text() + " " + QString::number(i1 + 2), 2, 7 * i1 + 2);
    addControlObject(spectrumLabel[4 * i1 + 1]->text() + " " + QString::number(i1 + 2), 2, 7 * i1 + 3);
    addControlObject(spectrumLabel[4 * i1 + 3]->text() + " " + QString::number(i1 + 2), 2, 7 * i1 + 4);
    addControlObject("Offset Fixed Values " + QString::number(i1 + 2), 2, 7 * i1 + 5);
    addControlObject("Spacing Fixed Values "  + QString::number(i1 + 2), 2, 7 * i1 + 6);
    addControlObject("Even/Odd " + QString::number(i1 + 2), 2, 7 * i1 + 7);
    if (i1) {
      QObject::connect(osc3ModeCombo, SIGNAL(currentIndexChanged(int)), this, SLOT(setOsc3ModeCombo(int)));
      addControlObject("Osc3 Frequency Diffusion ", 2, 15);
      addControlObject("Osc3 Mode ", 2, 16);
    }
    evenOddSlider[i1 + 1]->setValue(500); 
  }
  oscMainLayout->setSpacing(40); 
  oscMainLayout->setContentsMargins(10, 40, 10, 40); 
  addControlFolder("Filter Modulation");
  for (i2 = 0; i2 < 20; i2++) {
    addControlObject(filterModLongLabels[0][i2], 6, i2);
  }
  addControlFolder("Volume");
  addControlObject("Volume Tracking", 7, 0);
  addControlObject("Velocity Depth", 7, 1);
  QVBoxLayout *morphingLayout = new QVBoxLayout;
  QGroupBox *morphingBox = new QGroupBox("Scene Morphing");
  morphingBox->setLayout(morphingLayout);
  QLabel *morphingLabel = new QLabel("Scene 1 <---> Scene 2");
  morphingSlider = new ModSlider(model, Qt::Horizontal); 
  morphingSlider->setMinimum(0);
  morphingSlider->setMaximum(1000);
  morphingSlider->setTickInterval(1);
  morphingLayout->addWidget(morphingLabel);
  morphingLayout->addWidget(morphingSlider);
  commonMainLayout->addWidget(morphingBox);
  addControlObject("Scene 1 <---> Scene 2", 0, 3);

  compressorLabels[0] = "Linear Level";
  compressorLabels[1] = "Transition Width";
  compressorLabels[2] = "Compression";
  compressorLabels[3] = "Antialiasing";
  compressorLayout = new QVBoxLayout;
  compressorBox = new QGroupBox("Compressor");
  compressorBox->setLayout(compressorLayout);
  for (i1 = 0; i1 < 4; i1++) {
    QLabel *compressorLabel = new QLabel(compressorLabels[i1]);
    compressorSlider[i1] = new ModSlider(model, Qt::Horizontal); 
    compressorSlider[i1]->setMinimum(0);
    compressorSlider[i1]->setMaximum(1000);
    compressorSlider[i1]->setTickInterval(1);
    compressorLayout->addWidget(compressorLabel);
    compressorLayout->addWidget(compressorSlider[i1]);
    addControlObject("Compressor "+compressorLabels[i1], 0, 4+i1);
    QObject::connect(compressorSlider[i1], SIGNAL(valueChanged(int)), this, SLOT(setCompressor(int)));
  }  
  for (i1 = 0; i1 < 4; i1++) {
    compressorSlider[i1]->setValue(500);
  }  
  commonMainLayout->addWidget(compressorBox);
  panLayout = new QVBoxLayout;  
  panBox = new QGroupBox("Panning");
  panBox->setLayout(panLayout);   
  panLabels[0] = "Pan Center";
  panLabels[1] = "Pan Width";
  panLabels[2] = "Pan Mode";
  QHBoxLayout *panModeLayout = new QHBoxLayout;
  panModeLayout->setContentsMargins(0, 10, 0, 10);
  QWidget *panModeFrame = new QWidget;
  panModeFrame->setLayout(panModeLayout);
  QVBoxLayout *panModeLayoutL = new QVBoxLayout;
  QVBoxLayout *panModeLayoutR = new QVBoxLayout;
  panModeLayoutL->setContentsMargins(0, 0, 0, 0);
  panModeLayoutR->setContentsMargins(0, 0, 0, 0);
  QWidget *panModeFrameL = new QWidget;
  QWidget *panModeFrameR = new QWidget;
  panModeFrameL->setLayout(panModeLayoutL);
  panModeFrameR->setLayout(panModeLayoutR);
  for (i1 = 0; i1 < 2; i1++) {
    QLabel *panLabel = new QLabel(panLabels[i1]);
    panSlider[i1] = new ModSlider(model, Qt::Horizontal); 
    panSlider[i1]->setMinimum(0);
    panSlider[i1]->setMaximum(1000);
    panSlider[i1]->setTickInterval(1);
    if (i1) {
      panLayout->addWidget(panModeFrame);
      panModeLayout->addWidget(panModeFrameL);
      panModeLayout->addWidget(new QWidget); // Dummy
      panModeLayout->addWidget(new QWidget); // Dummy
      panModeLayout->addWidget(panModeFrameR);
      panModeLayoutL->addWidget(panLabel);
      panModeLayoutL->addWidget(panSlider[i1]);
    } else {
      panLayout->addWidget(panLabel);
      panLayout->addWidget(panSlider[i1]);
    }  
    addControlObject(panLabels[i1], 0, 8+i1);
    QObject::connect(panSlider[i1], SIGNAL(valueChanged(int)), this, SLOT(setPan(int)));
  }  
  panSlider[0]->setValue(500);
  panMode = new QComboBox;
  panMode->addItem("Pitch Up");
  panMode->addItem("Pitch Down");
  panMode->addItem("Alternating Up");
  panMode->addItem("Alternating Down");
  panModeLayoutR->addWidget(new QLabel(panLabels[2]));
  panModeLayoutR->addWidget(panMode);
  addControlObject(panLabels[2], 0, 8+2);
  QObject::connect(panMode, SIGNAL(currentIndexChanged(int)), this, SLOT(setPanMode(int)));
  commonMainLayout->addWidget(panBox);
  addControlObject("Env Detune", 0, 8+3);
  addControlObject("Offset Detune", 0, 8+4);
  commonMainLayout->setContentsMargins(10, 20, 10, 20);
  QObject::connect(pitchLFOfreq, SIGNAL(valueChanged(int)), this, SLOT(setPitchLFOfreq(int)));
  QObject::connect(pitchLFOdepth, SIGNAL(valueChanged(int)), this, SLOT(setPitchLFOdepth(int)));
  QObject::connect(morphingSlider, SIGNAL(valueChanged(int)), this, SLOT(setMorphing(int)));
  QObject::connect(jackProcessor, SIGNAL(MIDI_controlEvent(int, unsigned char, unsigned int, int, int)), this, SLOT(processMidiController(int, unsigned char, unsigned int, int, int)));
  QObject::connect(jackProcessor, SIGNAL(MIDI_noteOn(int)), this, SLOT(process_MidiNoteOn(int)));
  morphingSlider->setValue(500);
  addControlFolder("Harmonics");
  index = 0;
  for (i4 = 0; i4 < 8; i4++) {
    addControlObject("Harmonics " + QString::number(i4), 8, index++); // groupIndex 1
  }
  int num_controls = NUM_CONTROLPOINTS;
  for (i4 = 0; i4 < num_controls; i4++) {
    addControlObject("Harmonics y" + QString::number(i4), 8, index++); // groupIndex 1
  }
  addControlObject("Lower Harmonics", 8, index++); // groupIndex 1
  addControlObject("Upper Harmonics", 8, index++); // groupIndex 1
  spectrumOffset[0]->setValues(0, 0);
  spectrumSpacing[0]->setValues(0, 0);
  spectrumOffset[2]->setValues(0, 0);

  addControlFolder("Group Toggles");
  addControlObject("Mode Toggle", 9, 0);
  addGroupSwitch(0, 0); // Toggles, keine Radiogroup
  addControlObject("Scene Toggle", 9, 1);
  addGroupSwitch(0, 0); // Toggles, keine Radiogroup
  addControlFolder("Source Switches");
  addControlObject("Osc 1 Switch", 10, 0);
  addGroupSwitch(1, 0); // Radiogroup 1, groupIndex 14
  addControlObject("Osc 2 Switch", 10, 1);
  addGroupSwitch(1, 1); // Radiogroup 1, groupIndex 15
  addControlObject("Osc 3 Switch", 10, 2);
  addGroupSwitch(1, 2); // Radiogroup 1, groupIndex 16
  addControlObject("Noise Switch", 10, 3);
  addGroupSwitch(1, 3); // Radiogroup 1, groupIndex 17
  addControlFolder("Filter Switches");
  addControlObject("Filter Curve 1  Switch", 11, 0);
  addGroupSwitch(2, 0); // Radiogroup 2, groupIndex 2
  addControlObject("Filter Curve 2  Switch", 11, 1);
  addGroupSwitch(2, 1); // Radiogroup 2, groupIndex 3
  addControlFolder("Group Switches");
  addControlObject("(1) Amplitude Switch", 12, 0);
  addGroupSwitch(3, 0); // Radiogroup 3, groupIndex 4
  addControlObject("(2) Delay Switch", 12, 1);
  addGroupSwitch(3, 1); // Radiogroup 3, groupIndex 5
  addControlObject("(3) Attack Switch", 12, 2);
  addGroupSwitch(3, 2); // Radiogroup 3, groupIndex 6
  addControlObject("(4) Decay 1 Switch", 12, 3);
  addGroupSwitch(3, 3); // Radiogroup 3, groupIndex 7
  addControlObject("(5) Decay 2 Switch", 12, 4);
  addGroupSwitch(3, 4); // Radiogroup 3, groupIndex 8
  addControlObject("(6) Level Switch", 12, 5);
  addGroupSwitch(3, 5); // Radiogroup 3, groupIndex 9
  addControlObject("(7) Release Switch", 12, 6);
  addGroupSwitch(3, 6); // Radiogroup 3, groupIndex 10
  addControlObject("(8) Env Amount Switch", 12, 7);
  addGroupSwitch(3, 7); // Radiogroup 3, groupIndex 11
  addControlObject("(9) Env Freq Switch", 12, 8);
  addGroupSwitch(3, 8); // Radiogroup 3, groupIndex 12
  addControlObject("(10) Env Random Switch", 12, 9);
  addGroupSwitch(3, 9); // Radiogroup 3, groupIndex 13

  addControlFolder("Filter Curves");
  for (i3 = 0; i3 < FILTER_LEN; i3++) {
    addControlObject("Filter Point " + QString::number(i3), 13, i3); // groupIndex 19
  }

  modifiedFlag = false;
  comment = "";
  QObject::connect(mainTab, SIGNAL(currentChanged(int)), this, SLOT(mainTabChanged(int)));
  voiceRangeSet();
  jackProcessor->initJack();
  synth->start();
  QThread::msleep(300);
  loadMidi(true);
  QThread::msleep(300);
  loadXML(true, "");
}

Gui::~Gui() {

}

void Gui::showAbout() {

  QMessageBox::about(this, "Add64", "Add64  v.3.9.3\n(c)2011-2020 by Matthias Nagorni\n\nPlease refer to the documentation\nfor more information.");
}

void Gui::loadXML() {

  loadXML(false, "");
}

void Gui::loadXML(bool loadDefault, QString fileName) {

  int i1;
  QString fn, qs;
  QFile *f;
  int vStart, vEnd, currentIndex;
  VoiceData *vd;
    
  model->getEditRange(vStart, vEnd);
  QFileDialog *dialog = new QFileDialog;
  if (!loadDefault) {
    if (fileName.length()) {
      fn = fileName;
    } else {
      fn = dialog->getOpenFileName();
    }  
  } else {
    fn = presetPrefix.trimmed() + "Add64Preset_0_0_0";
  }  
  if (!fn.isEmpty()) {
    f = new QFile(fn);
    if (f->exists()) {
      if (systemMode) {
        presetIOsuccess();
      }
      voiceFileName = fn;
      voiceFileLabel->setText(fn);
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setFileName(fn);
      }  
      currentIndex = voiceTree->indexOfTopLevelItem(voiceTree->currentItem());
      if (currentIndex < 0) {
        currentIndex = vStart;
      }
      voiceTree->clear();
      for (i1 = 0; i1 < model->getPoly(); i1++) {
        vd = model->getVoiceData(i1);
        QTreeWidgetItem *item = new QTreeWidgetItem(voiceTree);
        qs = QString::number(i1 + 1);
        item->setText(0, qs);
        qs = QString::number(vd->getChannel() + 1);
        item->setText(1, qs);
        item->setText(2, vd->getFileName());
        if (i1 == currentIndex) {
          voiceTree->setCurrentItem(item);
        }
      }  
      f->close();
      loadVoiceXML(vStart);
    }
  }    
  updateMidiController(1);
  updateMidiController(3);
}                

void Gui::saveXML() {

  saveXML("");
}

void Gui::saveXML(QString fileName) {

  int i1;
  QString fn, qs;
  QFile *f;
  int vStart, vEnd, currentIndex;
  VoiceData *vd;
      
  model->getEditRange(vStart, vEnd);
  QFileDialog *dialog = new QFileDialog;
  if (fileName.length()) {
    fn = fileName;
  } else {
    fn = dialog->getSaveFileName();
  }  
  if (!fn.isEmpty()) {
    f = new QFile(fn);
    if (!f->open(QIODevice::WriteOnly)) {
      QMessageBox::warning(this, "Add64", "Could not save file.");
    } else {
      presetIOsuccess();
      f->close();
      voiceFileName = fn;
      voiceFileLabel->setText(fn);
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setFileName(fn);  
      }
      currentIndex = voiceTree->indexOfTopLevelItem(voiceTree->currentItem());
      if (currentIndex < 0) {
        currentIndex = vStart;
      }
      voiceTree->clear();
      for (i1 = 0; i1 < model->getPoly(); i1++) {
        vd = model->getVoiceData(i1);
        QTreeWidgetItem *item = new QTreeWidgetItem(voiceTree);
        qs = QString::number(i1 + 1);
        item->setText(0, qs);
        qs = QString::number(vd->getChannel() + 1);
        item->setText(1, qs);
        item->setText(2, vd->getFileName());
        if (i1 == currentIndex) {
          voiceTree->setCurrentItem(item);
        }
      }
      saveVoiceXML(vStart);  
    }  
  }   
}

void Gui::loadMidi() {
 
   loadMidi(false);
}

void Gui::loadMidi(bool loadDefault) {

  int i, d1, d2, d3, d4, d5, gi;
  QString fn, qs;
  char buf[256];
  QFile f;
  QTreeWidgetItem *m;
  QStringList connectionList;
  int connectionCounter;

  QFileDialog *dialog = new QFileDialog;
  if (!loadDefault) {
    fn = dialog->getOpenFileName();
  } else {
    fn = "Add64-MIDIconfig";
  }  
  if (!fn.isEmpty()) {
    f.setFileName(fn);
    if (f.exists()) {
      f.open(QIODevice::ReadOnly);
      midiControllerTree->clear();
      model->clearMidiControllerList();
      m = NULL;
      f.readLine(buf, sizeof(buf)); // first line is polyphony - this has been set in main.cpp and can be ignored here
      f.readLine(buf, sizeof(buf)); // second line is interpolate switch - this has been set in main.cpp and can be ignored here
      f.readLine(buf, sizeof(buf));
      presetPrefix = QString(buf);
      f.readLine(buf, sizeof(buf));
      qs = QString(buf);
      model->setMaxNoiseStep(qs.toInt());
      connectionCounter = 0;
      while(connectionCounter < 4) {
        f.readLine(buf, sizeof(buf));
        qs = QString(buf);
        connectionList.append(qs); 
        if (qs.contains("--")) { 
          connectionCounter++;
        }
      }
      jackProcessor->setConnections(connectionList);
      while (!f.atEnd()) {
        f.readLine(buf, sizeof(buf));
        qs = QString(buf);
        if (qs.contains("_MIDI_")) {
          f.readLine(buf, sizeof(buf));
          qs = QString(buf);
          d1 = qs.toInt();
          f.readLine(buf, sizeof(buf));
          qs = QString(buf);
          d2 = qs.toInt();
          f.readLine(buf, sizeof(buf));
          qs = QString(buf);
          d3 = qs.toInt();
          addMidiController(d1, d2, d3);
          m = midiControllerTree->topLevelItem(midiControllerTree->topLevelItemCount() - 1);
        } else {
          d1 = qs.toInt();
          f.readLine(buf, sizeof(buf)); 
          qs = QString(buf);
          d2 = qs.toInt();
          f.readLine(buf, sizeof(buf)); 
          qs = QString(buf);
          gi = qs.toInt();
          f.readLine(buf, sizeof(buf));
          qs = QString(buf);
          d3 = qs.toInt();
          f.readLine(buf, sizeof(buf));
          qs = QString(buf);
          d4 = qs.toInt();
          f.readLine(buf, sizeof(buf));
          qs = QString(buf);
          d5 = qs.toInt();
          connectController(m, d1, d2, gi, d3, d4, d5);
          if (m != NULL) {
            midiControllerTree->expandItem(m);
          }  
        }
      }
      for (i = 0; i < 127; i++) {
        model->addMidiEvent(0, 0xB0, 0, i, 0); // TODO Midikanal anpassen
      }
      QThread::msleep(50);
      setToggle(0, 0);
      setToggle(1, 0);
      setFilterSwitch(0, 127);
      setSourceSwitch(0, 127);
      setGroupSwitch(0, 127);
      updateMainTab(0);
      f.close();
    }
  }  
}

void Gui::saveMidi() {

  int i1, i2;
  QString fn, qs;
  FILE *f;
  midiController m;
  controlObject co;
  QStringList connectionList;

  QFileDialog *dialog = new QFileDialog;
  fn = dialog->getSaveFileName();
  if (!fn.isEmpty()) {
    if (!(f = fopen(fn.toLatin1(), "w"))) {
      QMessageBox::warning(this, "Add64", "Could not save file.");
    } else {
      fprintf(f, "%s\n", presetPrefix.toLatin1().constData());
      connectionList = jackProcessor->getConnections();
      for (i1 = 0; i1 < connectionList.count(); i1++) {
        fprintf(f, "%s\n", connectionList.at(i1).toLatin1().constData());
      }
      for (i1 = 0; i1 < model->midiControllerCount(); i1++) {
        m = model->getMidiController(i1);
        fprintf(f, "_MIDI_\n");
        fprintf(f, "%d\n", m.type);
        fprintf(f, "%d\n", m.eventChannel);
        fprintf(f, "%d\n", m.eventParam);
        for (i2 = 0; i2 < model->connectedObjectCount(i1); i2++) {
          co = model->getConnectedObject(i1, i2);
          fprintf(f, "%d\n", co.objectType);
          fprintf(f, "%d\n", co.objectIndex);
          fprintf(f, "%d\n", co.groupIndex);
          fprintf(f, "%d\n", co.modDepth);
          fprintf(f, "%d\n", co.full);
          fprintf(f, "%d\n", co.inverse);
        }
      }
      fclose(f);
    }  
  }   
}

void Gui::reScale(int value) {

  int i1;
  double val;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);    
  for (i1 = 0; i1 < MAX_PARAMS; i1++) {
    if (harmonicScale[i1] == sender()) {
      for (int vl = vStart; vl <= vEnd; vl++) {
        val = ((ModSlider *)sender())->getValue(vl);
        model->getVoiceData(vl)->setGroupScale(model->getEditGroup(), i1, val); // TODO Check if model->getEditGroup() correct
      }
      break;
    }
  }  
}

void Gui::selectGroup(int p_group) {

  int i;

  model->setEditGroup(p_group);
  for (i = 0; i < MAX_PARAMS; i++) {
    harmonicScale[i]->setLayer(p_group); 
  }  
  harmonics[harmonicTab->currentIndex()]->update(); // TODO Check if this should stay in model or move to VoiceData
}

void Gui::updateTab(int id) {

  harmonicScale[id]->setLayer(model->getEditGroup());
  harmonicScale[id]->updateSlider();
}

void Gui::setGlobalScale(int objectType, int objectIndex, int voiceIndex, double modValue, int value) {

  double val;
  int d1, d2;
  bool modFlag;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  modFlag = modValue < 1234;
  if ((harmonicScale[objectIndex]->getLayer() == (objectType - 1))
       && (objectIndex == harmonicTab->currentIndex())) {
    if (modFlag) {    
      harmonicScale[objectIndex]->setValues(voiceIndex, modValue, 1234);
    } else {
      harmonicScale[objectIndex]->setValues(voiceIndex, 1234, (int)((double)value * 2000.0 / 127.0 - 1000.0));
    }  
  } else {
    if (modFlag) { 
      harmonicScale[objectIndex]->writeBufValue(objectType - 1, 1234, voiceIndex, modValue);
    } else {
      harmonicScale[objectIndex]->writeBufValue(objectType - 1, (int)((double)value * 2000.0 / 127.0 - 1000.0), voiceIndex, 1234);
    }
    for (int vl = vStart; vl <= vEnd; vl++) {
      harmonicScale[objectIndex]->readBufValue(objectType - 1, d1, vl, d2);
      val = d1 + d2;
      if (val < -1000) {
        val = -1000;
      } else if (val > 1000) {
        val = 1000;
      }
      model->getVoiceData(vl)->setGroupScale(objectType - 1, objectIndex, (int)val); 
    }  
  }  
}

void Gui::setCommon(int objectType, int objectIndex, int voiceIndex, double modValue, int value) {

  double c;

  switch (objectIndex) {
    case 0:
      c = (masterVolume->maximum() - masterVolume->minimum()) / 127.0;
      masterVolume->setValues(voiceIndex, modValue, masterVolume->minimum() + (int)(c * (double)value));
      break;
    case 1:
      c = (pitchLFOfreq->maximum() - pitchLFOfreq->minimum()) / 127.0;
      pitchLFOfreq->setValues(voiceIndex, modValue, pitchLFOfreq->minimum() + (int)(c * (double)value));
      break;
    case 2:
      c = (pitchLFOdepth->maximum() - pitchLFOdepth->minimum()) / 127.0;
      pitchLFOdepth->setValues(voiceIndex, modValue, pitchLFOdepth->minimum() + (int)(c * (double)value));
      break;
    case 3:
      c = (morphingSlider->maximum() - morphingSlider->minimum()) / 127.0;
      morphingSlider->setValues(voiceIndex, modValue, morphingSlider->minimum() + (int)(c * (double)value));
      break;
    case 4:
      c = (compressorSlider[0]->maximum() - compressorSlider[0]->minimum()) / 127.0;
      compressorSlider[0]->setValues(voiceIndex, modValue, compressorSlider[0]->minimum() + (int)(c * (double)value));
      break;
    case 5:
      c = (compressorSlider[1]->maximum() - compressorSlider[1]->minimum()) / 127.0;
      compressorSlider[1]->setValues(voiceIndex, modValue, compressorSlider[1]->minimum() + (int)(c * (double)value));
      break;
    case 6:
      c = (compressorSlider[2]->maximum() - compressorSlider[2]->minimum()) / 127.0;
      compressorSlider[2]->setValues(voiceIndex, modValue, compressorSlider[2]->minimum() + (int)(c * (double)value));
      break;
    case 7:
      c = (compressorSlider[3]->maximum() - compressorSlider[3]->minimum()) / 127.0;
      compressorSlider[3]->setValues(voiceIndex, modValue, compressorSlider[3]->minimum() + (int)(c * (double)value));
      break;
    case 8:
      c = (panSlider[0]->maximum() - panSlider[0]->minimum()) / 127.0;
      panSlider[0]->setValues(voiceIndex, modValue, panSlider[0]->minimum() + (int)(c * (double)value));
      break;
    case 9:
      c = (panSlider[1]->maximum() - panSlider[1]->minimum()) / 127.0;
      panSlider[1]->setValues(voiceIndex, modValue, panSlider[1]->minimum() + (int)(c * (double)value));
      break;
    case 10:
      c = ((panMode->count() - 1.0) / 127.0);
      panMode->setCurrentIndex((int)(c * (double)value));
      break;
    case 11:
      c = (detuneSlider->maximum() - detuneSlider->minimum()) / 127.0;
      detuneSlider->setValues(voiceIndex, modValue, detuneSlider->minimum() + (int)(c * (double)value));
      break;
    case 12:
      c = (offsetDetuneSlider->maximum() - offsetDetuneSlider->minimum()) / 127.0;
      offsetDetuneSlider->setValues(voiceIndex, modValue, offsetDetuneSlider->minimum() + (int)(c * (double)value));
      break;
    case 13:
      c = (randomSlider->maximum() - randomSlider->minimum()) / 127.0;
      randomSlider->setValues(voiceIndex, modValue, randomSlider->minimum() + (int)(c * (double)value));
      break;
  }
}

void Gui::setOscillators(int objectType, int objectIndex, int voiceIndex, double modValue, int value) {

  double c;

  switch (objectIndex) {
    case 0:
      c = (evenOddSlider[0]->maximum() - evenOddSlider[0]->minimum()) / 127.0;
      evenOddSlider[0]->setValues(voiceIndex, modValue, evenOddSlider[0]->minimum() + (int)(c * (double)value));
      break;
    case 1:
      c = (spectrumOffset[0]->maximum() - spectrumOffset[0]->minimum()) / 127.0;
      spectrumOffset[0]->setValues(voiceIndex, modValue, spectrumOffset[0]->minimum() + (int)(c * (double)value));
      break;
    case 2:
      c = (spectrumOffset[1]->maximum() - spectrumOffset[1]->minimum()) / 127.0;
      spectrumOffset[1]->setValues(voiceIndex, modValue, spectrumOffset[1]->minimum() + (int)(c * (double)value));
      break;
    case 3:
      c = (spectrumSpacing[0]->maximum() - spectrumSpacing[0]->minimum()) / 127.0;
      spectrumSpacing[0]->setValues(voiceIndex, modValue, spectrumSpacing[0]->minimum() + (int)(c * (double)value));
      break;
    case 4:
      c = (spectrumSpacing[1]->maximum() - spectrumSpacing[1]->minimum()) / 127.0;
      spectrumSpacing[1]->setValues(voiceIndex, modValue, spectrumSpacing[1]->minimum() + (int)(c * (double)value));
      break;
    case 5:
      c = ((spectrumOffsetCombo[0]->count() - 1.0) / 127.0);
      spectrumOffsetCombo[0]->setCurrentIndex((int)(c * (double)value));
      break;
    case 6:
      c = ((spectrumSpacingCombo[0]->count() - 1.0) / 127.0);
      spectrumSpacingCombo[0]->setCurrentIndex((int)(c * (double)value));
      break;
    case 7: 
      c = (evenOddSlider[1]->maximum() - evenOddSlider[1]->minimum()) / 127.0;
      evenOddSlider[1]->setValues(voiceIndex, modValue, evenOddSlider[1]->minimum() + (int)(c * (double)value));
      break;
    case 8: 
      c = (spectrumOffset[2]->maximum() - spectrumOffset[2]->minimum()) / 127.0;
      spectrumOffset[2]->setValues(voiceIndex, modValue, spectrumOffset[2]->minimum() + (int)(c * (double)value));
      break;
    case 9:
      c = (spectrumOffset[3]->maximum() - spectrumOffset[3]->minimum()) / 127.0;
      spectrumOffset[3]->setValues(voiceIndex, modValue, spectrumOffset[3]->minimum() + (int)(c * (double)value));
      break;
    case 10:
      c = (spectrumSpacing[2]->maximum() - spectrumSpacing[2]->minimum()) / 127.0;
      spectrumSpacing[2]->setValues(voiceIndex, modValue, spectrumSpacing[2]->minimum() + (int)(c * (double)value));
      break;
    case 11:
      c = (spectrumSpacing[3]->maximum() - spectrumSpacing[3]->minimum()) / 127.0;
      spectrumSpacing[3]->setValues(voiceIndex, modValue, spectrumSpacing[3]->minimum() + (int)(c * (double)value));
      break;
    case 12:
      c = ((spectrumOffsetCombo[1]->count() - 1.0) / 127.0);
      spectrumOffsetCombo[1]->setCurrentIndex((int)(c * (double)value));
      break;
    case 13:
      c = ((spectrumSpacingCombo[1]->count() - 1.0) / 127.0);
      spectrumSpacingCombo[1]->setCurrentIndex((int)(c * (double)value));
      break;
    case 14:
      c = (evenOddSlider[2]->maximum() - evenOddSlider[2]->minimum()) / 127.0;
      evenOddSlider[2]->setValues(voiceIndex, modValue, evenOddSlider[2]->minimum() + (int)(c * (double)value));
      break;
    case 15:
      c = (osc3FreqDiffusionSlider->maximum() - osc3FreqDiffusionSlider->minimum()) / 127.0;
      osc3FreqDiffusionSlider->setValues(voiceIndex, modValue, osc3FreqDiffusionSlider->minimum() + (int)(c * (double)value));
      break;
    case 16:
      c = ((osc3ModeCombo->count() - 1.0) / 127.0);
      osc3ModeCombo->setCurrentIndex((int)(c * (double)value));
      break;
  }
}



void Gui::setPitchLFOdepth(int value) {

  double val;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  for (int vl = vStart; vl <= vEnd; vl++) {
    val = ((ModSlider *)sender())->getValue(vl);
    model->getVoiceData(vl)->setLfoDepth(val / 1500.0);
  }  
}

void Gui::setEvenOdd(int value) {

  int i;
  double val;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  for (i = 0; i < 3; i++) {
    if (evenOddSlider[i] == sender()) {
      for (int vl = vStart; vl <= vEnd; vl++) { 
        val = ((ModSlider *)sender())->getValue(vl);
        model->getVoiceData(vl)->setEvenOdd(i, val / 1000.0);
      }
      break;      
    }
  }            
}

void Gui::setSpectrumOffset(int value) {

  int i;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  for (i = 0; i < 4; i++) {
    if (spectrumOffset[i] == sender()) {
      switch (i) {
        case 0:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setDelta(0, (double)(spectrumOffsetCombo[0]->currentIndex() - 24) + 1.0 * (double)spectrumOffset[0]->getValue(vl) / 1000.0 + 0.125 * (double)spectrumOffset[1]->getValue(vl) / 1000.0);
          }  
          break;
        case 1:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setDelta(0, (double)(spectrumOffsetCombo[0]->currentIndex() - 24) + 1.0 * (double)spectrumOffset[0]->getValue(vl) / 1000.0 + 0.125 * (double)spectrumOffset[1]->getValue(vl) / 1000.0);
          }
          break;
        case 2:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setDelta(2, (double)(spectrumOffsetCombo[1]->currentIndex() - 24) + 1.0 * (double)spectrumOffset[2]->getValue(vl) / 1000.0 + 0.125 * (double)spectrumOffset[3]->getValue(vl) / 1000.0);
          }  
          break;
        case 3:
          for (int vl = vStart; vl <= vEnd; vl++) { 
            model->getVoiceData(vl)->setDelta(2, (double)(spectrumOffsetCombo[1]->currentIndex() - 24) + 1.0 * (double)spectrumOffset[2]->getValue(vl) / 1000.0 + 0.125 * (double)spectrumOffset[3]->getValue(vl) / 1000.0);
          }
          break;
      }
      break;
    }
  }
}

void Gui::setPitchLFOfreq(int value) {

  double val;
  int vStart, vEnd;

  model->getEditRange(vStart, vEnd);
  for (int vl = vStart; vl <= vEnd; vl++) {
    val = ((ModSlider *)sender())->getValue(vl);
    model->getVoiceData(vl)->setLfoFreq(0.1 + val / 50.0);
  }
}

void Gui::setSpectrumSpacing(int value) {

  int i;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  for (i = 0; i < 4; i++) {
    if (spectrumSpacing[i] == sender()) {
      switch (i) {
        case 0:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setDelta(1, 1.0 + 0.75 * spectrumSpacing[0]->getValue(vl) / 1000.0 + 0.249e-3 * spectrumSpacing[1]->getValue(vl));
          }
          break;
        case 1:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setDelta(1, 1.0 + 0.75 * spectrumSpacing[0]->getValue(vl) / 1000.0 + 0.249e-3 * spectrumSpacing[1]->getValue(vl));
          }
          break;
        case 2:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setDelta(3, spectrumSpacing[2]->getValue(vl) / 2000.0 + spectrumSpacing[3]->getValue(vl) / 20000.0);
          }
          break;
        case 3:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setDelta(3, spectrumSpacing[2]->getValue(vl) / 2000.0 + spectrumSpacing[3]->getValue(vl) / 20000.0);
          }
          break;
      }
      break;
    }
  }
}

void Gui::setSpectrumOffsetCombo(int index) {

  int i;
  int vStart, vEnd;

  model->getEditRange(vStart, vEnd);
  for (i = 0; i < 2; i++) {
    if (spectrumOffsetCombo[i] == sender()) {
      switch (i) {
        case 0:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setDelta(0, (double)(spectrumOffsetCombo[0]->currentIndex() - 24) + 1.0 * (double)spectrumOffset[0]->getValue(vl) / 1000.0 + 0.125 * (double)spectrumOffset[1]->getValue(vl) / 1000.0);
          }  
          break;
        case 1:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setDelta(2, (double)(spectrumOffsetCombo[1]->currentIndex() - 24) + 1.0 * (double)spectrumOffset[2]->getValue(vl) / 1000.0 + 0.125 * (double)spectrumOffset[3]->getValue(vl) / 1000.0);
          }  
          break;
      }
      break;
    }
  }  
}

void Gui::setSpectrumSpacingCombo(int index) {

  int i;

  if (index) {  
    for (i = 0; i < 2; i++) {
      if (spectrumSpacingCombo[i] == sender()) {
        switch (i) {
          case 0:
            if (index > 1) {
              spectrumSpacing[2 * i]->setValues(0, (int)round(125.0 * ((double)index - 1.0)));
            } else {
              spectrumSpacing[2 * i]->setValues(0, 0);
            } 
            spectrumSpacing[2 * i + 1]->setValues(0, 0);
            break;
          case 1:
            if (index >= 1) {
              spectrumSpacing[2 * i]->setValues(0, (int)round(100.0 * ((double)index - 1.0)));
            } else {
              spectrumSpacing[2 * i]->setValues(0, 0);
            } 
            spectrumSpacing[2 * i + 1]->setValues(0, 0);
            break;
        }
        break;
      }
    }
  }  
}

void Gui::setMorphing(int value) {

  double val;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  for (int vl = vStart; vl <= vEnd; vl++) {
    val = ((ModSlider *)sender())->getValue(vl);
    model->getVoiceData(vl)->setMorphing(pow(val / 1000.0, 0.5));
  }
}

void Gui::closeGui() {

  model->setSynthesis(false);
  QThread::msleep(100);
  model->quitWait.wakeAll();
}

void Gui::processMidiController(int type, unsigned char eventChannel,
                                unsigned int eventParam, int value, int voiceIndex) {
  if (!hasMidiController(type, eventChannel, eventParam, value, voiceIndex)) {
    addMidiController(type, eventChannel, eventParam);
  }
}                                

bool Gui::hasMidiController(int type, unsigned char eventChannel,
                            unsigned int eventParam, int value, int voiceIndex) {

  int i1, i2, i3, h;
  midiController m;
  double modValue, val;
  int controls, scn, src, grp, flt;
  int vStart, vEnd;
  bool groupActive;
  int objectCount;
  
  i1 = model->hasMidiController(type, eventChannel, eventParam); 
  if (i1 >= 0) {
    m = model->getMidiController(i1);
    if (followMidi) {
      midiControllerTree->setCurrentItem(m.treeWidgetItem);
    }
    objectCount = m.connectedObjects.count();
    for (i2 = 0; i2 < objectCount; i2++) {
      controlObject co = model->getConnectedObject(i1, i2);
      if (co.full) {
        val = value;
        modValue = 1234; // do not update modValue in ModSlider
      } else {
        modValue = (co.inverse) ? -(double)co.modDepth * (double)value/127.0 : (double)co.modDepth * (double)value/127.0;
        val = 1234; // do not update value in ModSlider
      }
      scn = (model->getSceneToggleState()) ? 1 : 0;
      src = model->getSourceSwitchState();
      grp = model->getGroupSwitchState(false);
      flt = model->getFilterSwitchState();                                  
      systemMode = model->getModeToggleState();
      switch (co.objectType) { 
        case 1:
          if (!model->getFilterCurveMode()) {
            setGlobalScale(1 + scn * MAX_SOURCES + src, co.objectIndex, voiceIndex, modValue, val);
          }  
          break;
        case 4:
          if (!model->getFilterCurveMode()) {
            setMixer(9 * src + co.objectIndex, voiceIndex, modValue, val);
          }  
          break;
        case 7:
          if (!model->getFilterCurveMode()) {
            if (co.objectIndex == 0) {
              setVolumeTrackingMidi(voiceIndex, (int)round((double)value * 1000.0 / 127.0));
            } else {
              setVelocityDepthMidi(voiceIndex, (int)round((double)value * 1000.0 / 127.0));
            }
          }
          break;  
        case 8:
          if (systemMode) {
            presetBank = co.objectIndex - 15 + 1;
            updatePresetLEDs();
          } else if (!model->getFilterCurveMode()) { 
            controls = 8 + NUM_CONTROLPOINTS + 2;
            if (src) controls -= 2;
            if (src == 3) controls = 8 + 2;
            if (co.objectIndex < controls - 2) { 
              h = co.objectIndex + grp * controls;
              harmonics[grp]->setHarmonic(15 + scn * MAX_SOURCES + src, h, voiceIndex, val); 
            } 
            if (co.objectIndex == 8 + NUM_CONTROLPOINTS) { 
              h = controls - 2 + grp * controls;
              harmonics[grp]->setHarmonic(15 + scn * MAX_SOURCES + src, h, voiceIndex, val);
              for (i3 = 0; i3 < 8; i3++) {
                harmonics[grp]->setHarmonic(15 + scn * MAX_SOURCES + src, i3 + grp * controls, voiceIndex, val);
              }
            } else if (co.objectIndex == 8 + NUM_CONTROLPOINTS + 1) {
              h = controls - 1 + grp * controls; 
              harmonics[grp]->setHarmonic(15 + scn * MAX_SOURCES + src, h, voiceIndex, val);
              for (i3 = 8; i3 < controls - 2; i3++) {
                harmonics[grp]->setHarmonic(15 + scn * MAX_SOURCES + src, i3 + grp * controls, voiceIndex, val);
              }
            }
          }  
          break;                          
        case 13:
          if (model->getFilterCurveMode()) {
            model->getEditRange(vStart, vEnd);
            for (int vl = vStart; vl <= vEnd; vl++) {
              model->getVoiceData(vl)->setFilter(flt, co.objectIndex, (int)round((double)value * 100.0 / 127.0));
            }  
            filter[flt]->repaint();
          }  
          break;
      }
      groupActive = (co.groupIndex == 0);
      if ((co.groupIndex > 3) && (co.groupIndex < 14) && (co.groupIndex == 4 + grp)) {
        groupActive = true;
      }
      if ((co.groupIndex > 1) && (co.groupIndex < 4) && (co.groupIndex == 2 + flt)) {
        groupActive = true;
      }
      if ((co.groupIndex > 13) && (co.groupIndex < 18) && (co.groupIndex == 14 + src)) {
        groupActive = true;
      }
      if (model->getFilterCurveMode()) {
        switch (co.objectType) {
          case 5: 
            setFilter(co.objectIndex + 9 * flt, voiceIndex, modValue, val);
            break;
          case 6:
            setModulation(flt, co.objectIndex, voiceIndex, modValue, val);
            break;
        }                          
      }
      if (groupActive && ((!model->getFilterCurveMode()) || (objectCount == 1))) { // TODO zusätzlicher Branch für filterCurveMode == true und flt == 0/1
        switch (co.objectType) {
          case 0:
            setCommon(co.objectType, co.objectIndex, voiceIndex, modValue, val);
            break;
          case 2:
            setOscillators(co.objectType, co.objectIndex, voiceIndex, modValue, val);
            break;
          case 3:
            setNoise(co.objectType, co.objectIndex, voiceIndex, modValue, val);
            break;
          case 9:
            setToggle(co.objectIndex, val);
            break;
          case 10:
            setSourceSwitch(co.objectIndex, val);  
            break;
          case 11:
            setFilterSwitch(co.objectIndex, val);
            break;      
          case 12:
            setGroupSwitch(co.objectIndex, val);  
            break;
        }    
      }  
      if (groupActive && model->getFilterCurveMode()) {
        switch (co.objectType) {
          case 9:
            setToggle(co.objectIndex, val);
            break;
          case 10:
            setSourceSwitch(co.objectIndex, val);  
            break;
          case 11:
            setFilterSwitch(co.objectIndex, val);
            break;      
          case 12:
            setGroupSwitch(co.objectIndex, val);  
            break;
        }    
      }
    }
    return(true);
  }
  return(false);    
} 

void Gui::setToggle(int objectIndex, int val) {

  int sceneIndex, sourceIndex;

  if (objectIndex) {
    if (!systemMode) {
      model->addMidiEvent(0, 0xB0, 15, 112, 0);
      model->setSceneToggleState(val > 63);
      sceneIndex = (model->getSceneToggleState()) ? 1 : 0;
      sourceIndex = model->getSourceSwitchState();
      selectGroup(sourceIndex + 4 * sceneIndex);  
      radio[sceneIndex][sourceIndex]->setChecked(true);
      model->setSourceSwitchState(sourceIndex); // Update filterCurveMode
      updateMainTab(0);
      updateMidiController(1);
      updateMidiController(3);
    } else {
      model->addMidiEvent(0, 0xB0, 15, 112, 1);
      presetBank = 0;
      updatePresetLEDs();
    }  
  } else {
    model->setModeToggleState(val > 63);
    systemMode = model->getModeToggleState();
    if (!systemMode) {
      model->addMidiEvent(0, 0xB0, 15, 112, 0);
      updateMainTab(0);
      updateSwitches();
    } else {
      model->addMidiEvent(0, 0xB0, 15, 112, 1);
      updatePresetLEDs();
    }
  }
}

void Gui::setSourceSwitch(int objectIndex, int val) {

  int sceneIndex;

  if (!systemMode) {
    model->setSourceSwitchState(objectIndex);  
    sceneIndex = (model->getSceneToggleState()) ? 1 : 0;
    selectGroup(objectIndex + 4 * sceneIndex);
    radio[sceneIndex][objectIndex]->setChecked(true);
    updateMainTab(0);
    updateMidiController(1);
    updateMidiController(3);
  } else {
    switch (objectIndex) {
      case 0:
        loadPreset();
        break;
      case 1:
        savePreset();
        break;
      case 2:
        if (presetFolder > 0) presetFolder--;
        break;
      case 3:
        if (presetFolder < 15) presetFolder++;
        break;
    }
    QThread::msleep(50);
    updatePresetLEDs();
  }  
}

void Gui::setFilterSwitch(int objectIndex, int val) {

  int tabIndex;

  if (!systemMode) {
    model->setFilterSwitchState(objectIndex);
    tabIndex = model->getFilterSwitchState() ? 6 : 5; 
    mainTab->setCurrentIndex(tabIndex);
    mainTabChanged(tabIndex);
    updateMidiController(2);
  } else {
    presetBank = 3 + objectIndex;
    updatePresetLEDs();
  }  
}

void Gui::updateMainTab(int groupSwitchState) {

  int tabIndex;

  tabIndex = 0;
  switch (groupSwitchState) {
    case 0: 
      tabIndex = 0;
      break;
    case 1: 
      tabIndex = 1;
      break;
    case 2: 
      tabIndex = 2;
      break;
    case 3: 
      tabIndex = 5;
      break;
    case 4: 
      tabIndex = 6;
      break;
    case 5: 
      tabIndex = 7;
      break;
    case 6: 
      tabIndex = 8;
      break;
    case 7: 
      tabIndex = 9;
      break;
    case 8: 
      tabIndex = 3;
      break;
    case 9: 
      tabIndex = 4;
      break;      
  }
  if (tabIndex >= 0) {
    mainTab->setCurrentIndex(tabIndex);
    mainTabChanged(tabIndex);
  }   
}

void Gui::setGroupSwitch(int objectIndex, int val) {
 
  model->setGroupSwitchState(model->getModeToggleState(), objectIndex);
  systemMode = model->getModeToggleState();
  if (!systemMode) {
    updateMainTab(0);
    harmonicTab->setCurrentIndex(objectIndex);
    updateTab(objectIndex);
    updateMidiController(3);
  } else {
    if (objectIndex < 7) {
      presetNum = objectIndex;
    } else if (objectIndex == 9) {  
      presetNum = 7;
    } else if ((objectIndex == 7) || (objectIndex == 8)) {
      presetBank = objectIndex - 7 + 5;
    }  
    updatePresetLEDs();
  }
}

void Gui::updateMidiController(int radioGroup) {

  int controls, scn, src, grp, flt, h, val, index, objectType, groupIndex, updateIndex;
  int i1, i2, i3;
  int d1, d2;
  int vStart, vEnd;
  int sendValue;

  model->getEditRange(vStart, vEnd);
  scn = (model->getSceneToggleState()) ? 1 : 0;
  src = model->getSourceSwitchState();
  grp = model->getGroupSwitchState(false);
  flt = model->getFilterSwitchState();

  if (!model->getFilterCurveMode()) {
    for (i2 = 0; i2 < model->midiControllerCount(); i2++) {
      midiController m = model->getMidiController(i2);
        for (i3 = 0; i3 < m.connectedObjects.count(); i3++) {
          groupIndex = m.connectedObjects.at(i3).groupIndex;
          objectType = m.connectedObjects.at(i3).objectType;
          updateIndex = groupIndex;
          if ((groupIndex > 3) && (groupIndex < 14)) {
            updateIndex = 4 + grp;    
          }
          if ((groupIndex > 1) && (groupIndex < 4)) {
            updateIndex = 2 + flt;
          }
          if ((groupIndex > 13) && (groupIndex < 18)) {
            updateIndex = 14 + src;
          }
          if ((updateIndex < 18) && (objectType < 9) && (m.connectedObjects.at(i3).groupIndex == updateIndex)) {
            index = m.connectedObjects.at(i3).objectIndex;
            val = -1;
            switch (objectType) {
              case 0:
                val = getCommon(objectType, index, vStart);
                break;
              case 2:
                val = getOscillators(objectType, index, vStart);
                break;
              case 3:
                val = getNoise(objectType, index, vStart);
                break;
              case 7:
                val = getVolume(objectType, index, vStart);  
                break;
            } 
            if (val >= 0) {
              model->addMidiEvent(0, 0xB0, m.eventChannel, m.eventParam, val);
            }  
          }
        }
      }
    }          
  
  switch (radioGroup) {
    case 1:
      for (i1 = 0; i1 < model->getGroupSwitchCount(); i1++) {
        if ((model->getGroupSwitch(i1).radioGroupID == 1) && (model->getGroupSwitch(i1).radioGroupIndex == src)) {
          groupSwitch g = model->getGroupSwitch(i1);
          for (i2 = 0; i2 < g.connectedControllers.count(); i2++) {
            midiController m = g.connectedControllers.at(i2);
            for (i3 = 0; i3 < m.connectedObjects.count(); i3++) {
              if (m.connectedObjects.at(i3).groupIndex == 18) { 
                index = m.connectedObjects.at(i3).objectIndex;
                if (m.connectedObjects.at(i3).objectType == 4) {
                  val = getMixer(9 * src + index, vStart);
                } else {
                  harmonicScale[index]->readBufValue(scn * MAX_SOURCES + src, d1, d2);
                  val = (int)round(127.0 / 2000.0 * ((double)d1 + 1000.0));
                }  
                model->addMidiEvent(0, 0xB0, m.eventChannel, m.eventParam, val);
              }  
            }  
          }
          break;
        }
      }
      model->addMidiEvent(0, 0xB0, 15, 111, src);
      break;
    case 2:
      for (i1 = 0; i1 < model->getGroupSwitchCount(); i1++) {
        if ((model->getGroupSwitch(i1).radioGroupID == 2) && (model->getGroupSwitch(i1).radioGroupIndex == flt)) {  
          groupSwitch g = model->getGroupSwitch(i1);
          for (i2 = 0; i2 < g.connectedControllers.count(); i2++) {
            midiController m = g.connectedControllers.at(i2);
            for (i3 = 0; i3 < m.connectedObjects.count(); i3++) {
              if (m.connectedObjects.at(i3).groupIndex == 19) {
                index = m.connectedObjects.at(i3).objectIndex;
                val = 0;
                switch (m.connectedObjects.at(i3).objectType) {
                  case 5:
                    val = getFilter(index + 9 * flt, vStart);
                    break;
                  case 6:
                    val = getModulation(flt, index, vStart);                  
                    break;
                  case 13:  
                    val = (int)round((double)model->getVoiceData(vStart)->getFilter(flt, index) * 127.0 / 100.0);
                    break;
                }  
                model->addMidiEvent(0, 0xB0, m.eventChannel, m.eventParam, val);
              }
            }
          }
          break;
        }
      }
      model->addMidiEvent(0, 0xB0, 15, 111, 4);
      for (i1 = 0; i1 < 4; i1++) {
        model->addMidiEvent(0, 0xB0, 0, 105 + i1, 0); 
      }
      break;          
    case 3:
      controls = 8 + NUM_CONTROLPOINTS + 2;
      if (src) controls -= 2;
      if (src == 3) controls = 8 + 2;
      for (i1 = 0; i1 < model->getGroupSwitchCount(); i1++) {
        if ((model->getGroupSwitch(i1).radioGroupID == 3) && (model->getGroupSwitch(i1).radioGroupIndex == grp)) {
          groupSwitch g = model->getGroupSwitch(i1);
          for (i2 = 0; i2 < g.connectedControllers.count(); i2++) {
            midiController m = g.connectedControllers.at(i2);
            for (i3 = 0; i3 < m.connectedObjects.count(); i3++) {
              if (m.connectedObjects.at(i3).groupIndex == 1) {
                index = m.connectedObjects.at(i3).objectIndex;
                if (index < controls - 2) {
                  h = index + grp * controls;
                  val = (int)round((double)harmonics[grp]->getHarmonic(15 + scn * MAX_SOURCES + src, h, vStart));
                  model->addMidiEvent(0, 0xB0, m.eventChannel, m.eventParam, val);
                }  
                if ((m.connectedObjects.count() < 2) && (index == 8 + NUM_CONTROLPOINTS)) {
                  h = controls - 2 + grp * controls;
                  val = (int)round((double)harmonics[grp]->getHarmonic(15 + scn * MAX_SOURCES + src, h, vStart));
                  model->addMidiEvent(0, 0xB0, m.eventChannel, m.eventParam, val);
                } else if ((m.connectedObjects.count() < 2) && (index == 8 + NUM_CONTROLPOINTS + 1)) {
                  h = controls - 1 + grp * controls;
                  val = (int)round((double)harmonics[grp]->getHarmonic(15 + scn * MAX_SOURCES + src, h, vStart));
                  model->addMidiEvent(0, 0xB0, m.eventChannel, m.eventParam, val);
                }
              }  
            }  
          }
          break;
        }
      }
      break;
  }
  if (!model->getFilterCurveMode()) {
    for (i1 = 0; i1 < 4; i1++) {
      sendValue = (model->getSourceSwitchState() == i1) ? 127 : 0;
      model->addMidiEvent(0, 0xB0, 0, 105 + i1, sendValue); //TODO use correct MIDI Channel
    }
  }              
}

void Gui::updatePresetLEDs() {

  int i1, sendValue;
  bool bits[4];

  for (i1 = 0; i1 < 7; i1++) {
    sendValue = (presetBank == i1) ? 127 : 0;
    model->addMidiEvent(0, 0xB0, 0, 66 + i1, sendValue); //TODO use correct MIDI Channel
  }  
  for (i1 = 0; i1 < 8; i1++) {
    sendValue = (presetNum == i1) ? 127 : 0;
    model->addMidiEvent(0, 0xB0, 0, 73 + i1, sendValue); //TODO use correct MIDI Channel
  }  
  switch (presetFolder) {
    case 0:
      bits[0] = 0;
      bits[1] = 0;
      bits[2] = 0;
      bits[3] = 0;
      break;
    case 1:
      bits[0] = 1;
      bits[1] = 0;
      bits[2] = 0;
      bits[3] = 0;
      break;
    case 2:
      bits[0] = 0;
      bits[1] = 1;
      bits[2] = 0;
      bits[3] = 0;
      break;
    case 3:
      bits[0] = 1;
      bits[1] = 1;
      bits[2] = 0;
      bits[3] = 0;
      break;
    case 4:
      bits[0] = 0;
      bits[1] = 0;
      bits[2] = 1;
      bits[3] = 0;
      break;
    case 5:
      bits[0] = 1;
      bits[1] = 0;
      bits[2] = 1;
      bits[3] = 0;
      break;
    case 6:
      bits[0] = 0;
      bits[1] = 1;
      bits[2] = 1;
      bits[3] = 0;
      break;
    case 7:
      bits[0] = 1;
      bits[1] = 1;
      bits[2] = 1;
      bits[3] = 0;
      break;
    case 8:
      bits[0] = 0;
      bits[1] = 0;
      bits[2] = 0;
      bits[3] = 1;
      break;
    case 9:
      bits[0] = 1;
      bits[1] = 0;
      bits[2] = 0;
      bits[3] = 1;
      break;
    case 10:
      bits[0] = 0;
      bits[1] = 1;
      bits[2] = 0;
      bits[3] = 1;
      break;
    case 11:
      bits[0] = 1;
      bits[1] = 1;
      bits[2] = 0;
      bits[3] = 1;
      break;
    case 12:
      bits[0] = 0;
      bits[1] = 0;
      bits[2] = 1;
      bits[3] = 1;
      break;
    case 13:
      bits[0] = 1;
      bits[1] = 0;
      bits[2] = 1;
      bits[3] = 1;
      break;
    case 14:
      bits[0] = 0;
      bits[1] = 1;
      bits[2] = 1;
      bits[3] = 1;
      break;
    case 15:
      bits[0] = 1;
      bits[1] = 1;
      bits[2] = 1;
      bits[3] = 1;
      break;
  }
  for (i1 = 0; i1 < 4; i1++) {
    sendValue = (bits[3 - i1]) ? 127 : 0;
    model->addMidiEvent(0, 0xB0, 0, 105 + i1, sendValue); //TODO use correct MIDI Channel
  }
}

void Gui::updateSwitches() {

  int i1, sendValue;
  int controls, scn, grp, src, h, val;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  scn = (model->getSceneToggleState()) ? 1 : 0;
  src = model->getSourceSwitchState();
  grp = model->getGroupSwitchState(false);
  controls = 8 + NUM_CONTROLPOINTS + 2;
  if (src) controls -= 2;
  if (src == 3) controls = 8 + 2;
  for (i1 = 1; i1 < 8; i1++) {
    switch (i1) {
      case 1:
        sendValue = (model->getSceneToggleState()) ? 127 : 0;
        break;
      case 2:
        h = controls - 2 + grp * controls;
        val = (int)round((double)harmonics[grp]->getHarmonic(15 + scn * MAX_SOURCES + src, h, vStart));
        sendValue = (val > 63) ? 127 : 0;
        break;
      case 3:
        h = controls - 1 + grp * controls;
        val = (int)round((double)harmonics[grp]->getHarmonic(15 + scn * MAX_SOURCES + src, h, vStart));
        sendValue = (val > 63) ? 127 : 0;
        break;
      case 4:
        sendValue = (!model->getFilterSwitchState()) ? 127 : 0;
        break;
      case 5:
        sendValue = (model->getFilterSwitchState()) ? 127 : 0;
        break;
      case 6:
        sendValue = (model->getGroupSwitchState(false) == 8) ? 127 : 0;
        break;
      case 7:
        sendValue = (model->getGroupSwitchState(false) == 9) ? 127 : 0;
        break;
    }  
    model->addMidiEvent(0, 0xB0, 0, 65 + i1, sendValue); //TODO use correct MIDI Channel
  }  
  for (i1 = 0; i1 < 8; i1++) {
    sendValue = (model->getGroupSwitchState(false) == i1) ? 127 : 0;
    model->addMidiEvent(0, 0xB0, 0, 73 + i1, sendValue); //TODO use correct MIDI Channel
  }  
  for (i1 = 0; i1 < 4; i1++) {
    sendValue = (model->getSourceSwitchState() == i1) ? 127 : 0;
    model->addMidiEvent(0, 0xB0, 0, 105 + i1, sendValue); //TODO use correct MIDI Channel
  }
}

void Gui::addMidiController(int type, unsigned char eventChannel,    
                            unsigned int eventParam) {
  QString qs;                     

  switch (type) {
    case 1:
      qs = "Ch " + QString::number(eventChannel) + " - Note";
      break;
    case 2:
      qs = "Ch " + QString::number(eventChannel) + " - Velocity";
      break;
    case 3:
      qs = "Ch " + QString::number(eventChannel) + " - Controller " + QString::number(eventParam);
      break;
    case 4:
      qs = "Ch " + QString::number(eventChannel) + " - Channel Pressure";
      break;
    case 5:
      qs = "Ch " + QString::number(eventChannel) + " - Key Pressure " + QString::number(eventParam);
      break;
  }
  QTreeWidgetItem *item = new QTreeWidgetItem(midiControllerTree);
  item->setText(0, qs);
  model->addMidiController(type, eventChannel, eventParam, item);
}

void Gui::addGroupSwitch(int radioGroupID, int radioGroupIndex) {
  
  model->addGroupSwitch(radioGroupID, radioGroupIndex);
}

void Gui::addControlFolder(QString name) {

  QTreeWidgetItem *item = new QTreeWidgetItem(controlObjectTree);
  item->setText(0, name);
}

void Gui::addControlObject(QString name, int objectType,
                           int objectIndex) {
  QString qs;                     

  QTreeWidgetItem *item = new QTreeWidgetItem;
  controlObjectTree->topLevelItem(objectType)->addChild(item);
  QTextStream(&qs) << name;
  item->setText(0, qs);
  model->addControlObject(controlObjectTree->topLevelItem(objectType)->text(0) + " - " + qs, objectType, objectIndex, item);
}

void Gui::connectController() {

  bool notInList;
  QString name;
  
  if (!midiControllerTree->topLevelItemCount() || (midiControllerTree->currentItem() == NULL) 
      || (controlObjectTree->currentItem() == NULL) || controlObjectTree->currentItem()->childCount()
      || !model->isMidiControllerItem(midiControllerTree->currentItem())) {
    return;
  }
  QTreeWidgetItem *m = midiControllerTree->currentItem();
  QTreeWidgetItem *c = controlObjectTree->currentItem();
  notInList = model->connectController(m, c);
  if (notInList) {
    QTreeWidgetItem *item = new QTreeWidgetItem(m);
    name = "(" + QString::number(getDisplayGroupIndex(model->getCurrentGroupIndex())) + ") " + c->parent()->text(0) + " - " + c->text(0);
    item->setText(0, name);
    midiControllerTree->expandItem(m);
    model->setControllerItem(m, c, item);
  }
}  

void Gui::connectController(QTreeWidgetItem *midiControllerItem, int objectType, int objectIndex, int groupIndex, int modDepth, bool full, bool inverse) {

  bool notInList;
  
  notInList = model->connectController(midiControllerItem, objectType, objectIndex, groupIndex, modDepth, full, inverse);
  if (notInList) {
    QTreeWidgetItem *item = new QTreeWidgetItem(midiControllerItem);
    item->setText(0, "(" + QString::number(getDisplayGroupIndex(groupIndex)) + ") " + model->getControlObjectName(objectType, objectIndex));
    midiControllerTree->expandItem(midiControllerItem);
    model->setControllerItem(midiControllerItem, objectType, objectIndex, item);
  }
}  

void Gui::disconnectController() {

  bool success;

  if (!midiControllerTree->topLevelItemCount() || (midiControllerTree->currentItem() == NULL)) {
    return;
  }
  QTreeWidgetItem *m = midiControllerTree->currentItem();
  success = model->disconnectController(m->parent(), m);
  if (success) {
    m->parent()->removeChild(m);
  }  
}

void Gui::setFilterCutoff(int value) {

  int i;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  for (i = 0; i < 4; i++) {
    if (filterCutoff[i] == sender()) {
      switch (i) {
        case 0:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setFilterCutoff(0, 160.0 * filterCutoff[0]->getValue(vl) / 1000.0 
                                     + 12.0 * (filterCutoff[1]->getValue(vl)-500.0) / 500.0 - 60.0);
          }
          break;
        case 1:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setFilterCutoff(0, 160.0 * filterCutoff[0]->getValue(vl) / 1000.0 
                                     + 12.0 * (filterCutoff[1]->getValue(vl)-500.0) / 500.0 - 60.0);
          }
          break;
        case 2:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setFilterCutoff(1, 160.0 * filterCutoff[2]->getValue(vl) / 1000.0 
                                     + 12.0 * (filterCutoff[3]->getValue(vl)-500.0) / 500.0 - 60.0);
          }
          break;
        case 3:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setFilterCutoff(1, 160.0 * filterCutoff[2]->getValue(vl) / 1000.0 
                                     + 12.0 * (filterCutoff[3]->getValue(vl)-500.0) / 500.0 - 60.0);
          }
          break;
      }
      break;
    }
  }
}

void Gui::setFilterSpacing(int value) {

  int i;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  for (i = 0; i < 4; i++) {
    if (filterSpacing[i] == sender()) {
      switch (i) {
        case 0:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setFilterSpacing(0, -0.5 + exp(2.52573 * filterSpacing[0]->getValue(vl) / 1000.0) 
                                     + 0.25 * (filterSpacing[1]->getValue(vl)-500.0) / 500.0);
          }
          break;
        case 1:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setFilterSpacing(0, -0.5 + exp(2.52573 * filterSpacing[0]->getValue(vl) / 1000.0) 
                                     + 0.25 * (filterSpacing[1]->getValue(vl)-500.0) / 500.0);
          }
          break;
        case 2:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setFilterSpacing(1, -0.5 + exp(2.52573 * filterSpacing[2]->getValue(vl) / 1000.0) 
                                     + 0.25 * (filterSpacing[3]->getValue(vl)-500.0) / 500.0);
          }
          break;
        case 3:
          for (int vl = vStart; vl <= vEnd; vl++) {
            model->getVoiceData(vl)->setFilterSpacing(1, -0.5 + exp(2.52573 * filterSpacing[2]->getValue(vl) / 1000.0) 
                                     + 0.25 * (filterSpacing[3]->getValue(vl)-500.0) / 500.0);
          }
          break;
      }
      break;
    }
  }
}

void Gui::setFilterCutoffCombo(int index) {

  int i;

  if (index) {  
    for (i = 0; i < 2; i++) {
      if (filterCutoffCombo[i] == sender()) {
        switch (i) {
          case 0:
            filterCutoff[2 * i]->setValues(0, (int)round((1000.0 / 160.0) * (double)(12 * index - 12)));
            filterCutoff[2 * i + 1]->setValues(0, 500);
            break;
          case 1:
            filterCutoff[2 * i]->setValues(0, (int)round((1000.0 / 160.0) * (double)(12 * index - 12)));
            filterCutoff[2 * i + 1]->setValues(0, 500);
            break;
        }
        break;
      }
    }
  }  
}

void Gui::setFilterSpacingCombo(int index) {

  int i;

  if (index) {  
    for (i = 0; i < 2; i++) {
      if (filterSpacingCombo[i] == sender()) {
        switch (i) {
          case 0:
            filterSpacing[2 * i]->setValues(0, (int)round(1000.0 / 2.52573 * log(0.5 * (double)index + 0.5)));
            filterSpacing[2 * i + 1]->setValues(0, 500);
            break;
          case 1:
            filterSpacing[2 * i]->setValues(0, (int)round(1000.0 / 2.52573 * log(0.5 * (double)index + 0.5)));
            filterSpacing[2 * i + 1]->setValues(0, 500);
            break;
        }
        break;
      }
    }
  }  
}

void Gui::setFilterKeyTracking(int value) {

  int i;
  double val;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  for (i = 0; i < 2; i++) {
    if (filterKeyTracking[i] == sender()) {
      switch (i) {
        case 0:
          for (int vl = vStart; vl <= vEnd; vl++) {
            val = ((ModSlider *)sender())->getValue(vl);
            model->getVoiceData(vl)->setFilterKeyTracking(0, val / 1000.0);
          }
          break;              
        case 1:
          for (int vl = vStart; vl <= vEnd; vl++) {
            val = ((ModSlider *)sender())->getValue(vl);
            model->getVoiceData(vl)->setFilterKeyTracking(1, val / 1000.0);
          }
          break;              
      }
      break;
    }  
  }   
}

void Gui::setFilterTrackingCombo(int index) {

  int i;

  if (index) {  
    for (i = 0; i < 2; i++) {
      if (filterTrackingCombo[i] == sender()) {
        switch (i) {
          case 0:
            filterKeyTracking[i]->setValues(0, 250 * (index - 1));
            break;
          case 1:
            filterKeyTracking[i]->setValues(0, 250 * (index - 1));
            break;
        }
        break;
      }
    }
  }  
}

void Gui::setFilterDepth(int value) {

  int i;
  double val;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  for (i = 0; i < 2; i++) {
    if (filterDepth[i] == sender()) {
      switch (i) {
        case 0:
          for (int vl = vStart; vl <= vEnd; vl++) {
            val = ((ModSlider *)sender())->getValue(vl);
            model->getVoiceData(vl)->setFilterDepth(0, log(1.0 + (exp(1.0) - 1.0) * val / 1000.0));
          }
          break;              
        case 1:
          for (int vl = vStart; vl <= vEnd; vl++) {
            val = ((ModSlider *)sender())->getValue(vl);
            model->getVoiceData(vl)->setFilterDepth(1, log(1.0 + (exp(1.0) - 1.0) * val / 1000.0));
          }
          break;              
      }
      break;
    }  
  }   
}

void Gui::setMixer(int index, int voiceIndex, double modValue, int value) {

  double c;
  int i1, i2;
 
  i1 = index / 9;
  i2 = index % 9;
  switch (i2) {
    case 0:
      c = (filterMixSlider[i1][0]->maximum() - filterMixSlider[i1][0]->minimum()) / 127.0;
      filterMixSlider[i1][0]->setValues(voiceIndex, modValue, filterMixSlider[i1][0]->minimum() + (int)(c * (double)value));
      break;
    case 1:
      c = (filterMixSlider[i1][1]->maximum() - filterMixSlider[i1][1]->minimum()) / 127.0;
      filterMixSlider[i1][1]->setValues(voiceIndex, modValue, filterMixSlider[i1][1]->minimum() + (int)(c * (double)value));
      break;
    case 2:
      filterMixCheckBox[i1][0]->setChecked(value > 62);
      break;
    case 3:
      c = (filterMixSlider[i1][2]->maximum() - filterMixSlider[i1][2]->minimum()) / 127.0;
      filterMixSlider[i1][2]->setValues(voiceIndex, modValue, filterMixSlider[i1][2]->minimum() + (int)(c * (double)value));
      break;
    case 4:
      c = (filterMixSlider[i1][3]->maximum() - filterMixSlider[i1][3]->minimum()) / 127.0;
      filterMixSlider[i1][3]->setValues(voiceIndex, modValue, filterMixSlider[i1][3]->minimum() + (int)(c * (double)value));
      break;
    case 5:
      filterMixCheckBox[i1][1]->setChecked(value > 62);
      break;
    case 6:
      c = (filterMixSlider[i1][4]->maximum() - filterMixSlider[i1][4]->minimum()) / 127.0;
      filterMixSlider[i1][4]->setValues(voiceIndex, modValue, filterMixSlider[i1][4]->minimum() + (int)(c * (double)value));
      break;
    case 7:
      c = (filterMixSlider[i1][5]->maximum() - filterMixSlider[i1][5]->minimum()) / 127.0;
      filterMixSlider[i1][5]->setValues(voiceIndex, modValue, filterMixSlider[i1][5]->minimum() + (int)(c * (double)value));
      break;
    case 8:
      filterMixCheckBox[i1][2]->setChecked(value > 62);
      break;
  }
}

void Gui::setFilter(int index, int voiceIndex, double modValue, int value) {

  double c;
 
  switch (index) {
    case 0:
      c = (filterCutoff[0]->maximum() - filterCutoff[0]->minimum()) / 127.0;
      filterCutoff[0]->setValues(voiceIndex, modValue, filterCutoff[0]->minimum() + (int)(c * (double)value));
      break;
    case 1:
      c = (filterCutoff[1]->maximum() - filterCutoff[1]->minimum()) / 127.0;
      filterCutoff[1]->setValues(voiceIndex, modValue, filterCutoff[1]->minimum() + (int)(c * (double)value));
      break;
    case 2:
      c = (filterSpacing[0]->maximum() - filterSpacing[0]->minimum()) / 127.0;
      filterSpacing[0]->setValues(voiceIndex, modValue, filterSpacing[0]->minimum() + (int)(c * (double)value));
      break;
    case 3:
      c = (filterSpacing[1]->maximum() - filterSpacing[1]->minimum()) / 127.0;
      filterSpacing[1]->setValues(voiceIndex, modValue, filterSpacing[1]->minimum() + (int)(c * (double)value));
      break;
    case 4:
      c = (filterKeyTracking[0]->maximum() - filterKeyTracking[0]->minimum()) / 127.0;
      filterKeyTracking[0]->setValues(voiceIndex, modValue, filterKeyTracking[0]->minimum() + (int)(c * (double)value));
      break;
    case 5:
      c = (filterDepth[0]->maximum() - filterDepth[0]->minimum()) / 127.0;
      filterDepth[0]->setValues(voiceIndex, modValue, filterDepth[0]->minimum() + (int)(c * (double)value));
      break;
    case 6:
      c = ((filterCutoffCombo[0]->count() - 1.0) / 127.0);
      filterCutoffCombo[0]->setCurrentIndex((int)(c * (double)value));
      break;
    case 7:
      c = ((filterSpacingCombo[0]->count() - 1.0) / 127.0);
      filterSpacingCombo[0]->setCurrentIndex((int)(c * (double)value));
      break;
    case 8:
      c = ((filterTrackingCombo[0]->count() - 1.0) / 127.0);
      filterTrackingCombo[0]->setCurrentIndex((int)(c * (double)value));
      break;
    case 9:
      c = (filterCutoff[2]->maximum() - filterCutoff[2]->minimum()) / 127.0;
      filterCutoff[2]->setValues(voiceIndex, modValue, filterCutoff[2]->minimum() + (int)(c * (double)value));
      break;
    case 10:
      c = (filterCutoff[3]->maximum() - filterCutoff[3]->minimum()) / 127.0;
      filterCutoff[3]->setValues(voiceIndex, modValue, filterCutoff[3]->minimum() + (int)(c * (double)value));
      break;
    case 11:
      c = (filterSpacing[2]->maximum() - filterSpacing[2]->minimum()) / 127.0;
      filterSpacing[2]->setValues(voiceIndex, modValue, filterSpacing[2]->minimum() + (int)(c * (double)value));
      break;
    case 12:
      c = (filterSpacing[3]->maximum() - filterSpacing[3]->minimum()) / 127.0;
      filterSpacing[3]->setValues(voiceIndex, modValue, filterSpacing[3]->minimum() + (int)(c * (double)value));
      break;
    case 13:
      c = (filterKeyTracking[1]->maximum() - filterKeyTracking[1]->minimum()) / 127.0;
      filterKeyTracking[1]->setValues(voiceIndex, modValue, filterKeyTracking[1]->minimum() + (int)(c * (double)value));
      break;
    case 14:
      c = (filterDepth[1]->maximum() - filterDepth[1]->minimum()) / 127.0;
      filterDepth[1]->setValues(voiceIndex, modValue, filterDepth[1]->minimum() + (int)(c * (double)value));
      break;
    case 15:
      c = ((filterCutoffCombo[1]->count() - 1.0) / 127.0);
      filterCutoffCombo[1]->setCurrentIndex((int)(c * (double)value));
      break;
    case 16:
      c = ((filterSpacingCombo[1]->count() - 1.0) / 127.0);
      filterSpacingCombo[1]->setCurrentIndex((int)(c * (double)value));
      break;
    case 17:
      c = ((filterTrackingCombo[1]->count() - 1.0) / 127.0);
      filterTrackingCombo[1]->setCurrentIndex((int)(c * (double)value));
      break;
  }
}

void Gui::setFilterMix(int value) {

  int i1, i2;
  bool found;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  found = false;
  for (i1 = 0; i1 < MAX_SOURCES; i1++) {
    for (i2 = 0; i2 < 6; i2++) {
      if (filterMixSlider[i1][i2] == sender()) {
        found = true;
        break;
      }
    }      
    if (found) {
      break;
    }
  }
  switch (i2) {
    case 0:
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setFilterMixMorph(i1, filterMixSlider[i1][0]->getValue(vl) / 1000.0);
      }
      break;
    case 1:
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setFilterMixMode(i1, filterMixSlider[i1][1]->getValue(vl) / 1000.0);
      }
      break;
    case 2:
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setFilterMixEnvAmount(i1, filterMixSlider[i1][2]->getValue(vl) / 1000.0);
      }
      break;
    case 3:
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setFilterMixDelay(i1, 0.03 * (double)model->getRate() * pow(10, 2.5 * (filterMixSlider[i1][3]->getValue(vl) - 400.0) / 600.0));
      }
      break;
    case 4:
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setFilterMixAttack(i1, 0.1 * (double)model->getRate() * pow(10, 2.5 * (filterMixSlider[i1][4]->getValue(vl) - 400.0) / 600.0) / (double)STEP);
      }
      break;
    case 5:
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setFilterMixDecay(i1, 0.1 * (double)model->getRate() * pow(10, 2.5 * (filterMixSlider[i1][5]->getValue(vl) - 400.0) / 600.0) / (double)STEP);
      }
      break;
  }  
}

void Gui::filterMixToggled(int value) {

  int i1, i2;
  bool found;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  found = false;
  for (i1 = 0; i1 < MAX_SOURCES; i1++) {
    for (i2 = 0; i2 < 3; i2++) {
      if (filterMixCheckBox[i1][i2] == sender()) {
        found = true;
        break;
      }
    }      
    if (found) {
      break;
    }
  }
  switch (i2) {
    case 0:
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setFilterMixLfo(i1, filterMixCheckBox[i1][0]->isChecked());
      }
      break;
    case 1:
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setFilterMixRetrigger(i1, filterMixCheckBox[i1][1]->isChecked());
      }
      break;
    case 2:
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setFilterMixHold(i1, filterMixCheckBox[i1][2]->isChecked());
      }
      break;
  }  
}

void Gui::setFilterMod(int value) {

  int i1, i2;
  bool found;
  double val;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  found = false;   
  for (i1 = 0; i1 < 2; i1++) {
    for (i2 = 0; i2 < 13; i2++) {
      if (filterModSlider[i1][i2] == sender()) {
        found = true;
        break;
      }     
    }
    if (found) {
      break;
    }
  }
  if (i2 < 7) {
    for (int vl = vStart; vl <= vEnd; vl++) {
      val = filterModSlider[i1][i2]->getValue(vl) / 10.0;
      modulationEnvelope e = model->getVoiceData(vl)->getFilterModEnvelope(i1); 
      switch(i2) {
        case 0:
          e.delay = (double)model->getRate() * 0.000001 * pow(val, 3.0);
          break;
        case 1:
          e.attack = (double)STEP/((double)model->getRate() * (1e-5 + 0.000005 * pow(val, 3.0)));
          break;
        case 2:
          e.decay1 = exp(-0.693147 * (double)STEP/(1e-5 + (double)model->getRate() * 0.000005 * pow(val, 3.0)));
          break;
        case 3:
          e.decay2 = exp(-0.693147 * (double)STEP/(1e-5 + (double)model->getRate() * 0.00005 * pow(val, 3.0)));
          break;
        case 4:
          e.level = log(1.0 + (exp(1.0) - 1.0) * val / 100.0);
          break;
        case 5:
          e.release = exp(-0.693147 * (double)STEP/(1e-5 + (double)model->getRate() * 0.000005 * pow(val, 3.0)));
          break;
        case 6:
          if (e.inverse) {
            e.amount = -1.5 * (pow(10, val / 50.0) - 1.0);
          } else {
            e.amount = 1.5 * (pow(10, val / 50.0) - 1.0); 
          }  
          break;
      }
      model->getVoiceData(vl)->setFilterModEnvelope(i1, e);
    }  
  } else if (i2 < 10) {
    for (int vl = vStart; vl <= vEnd; vl++) {
      val = filterModSlider[i1][i2]->getValue(vl) / 10.0;
      modulationLfo l = model->getVoiceData(vl)->getFilterModLfo(i1); 
      switch(i2) {
        case 7:
          if (l.fast) {
            l.freq = 2.0 * 0.006 * pow(val, 2.0) * (double)STEP / (double)model->getRate();
          } else {
            l.freq = 2.0 * 0.0002 * pow(val, 2.0) * (double)STEP / (double)model->getRate();
          }  
          break;
        case 8:
          if (l.inverse) {
            l.depth = -1.5 * (pow(10, val / 50.0) - 1.0);
          } else {
            l.depth = 1.5 * (pow(10, val / 50.0) - 1.0);
          }
          break;
        case 9:
          l.delay = (double)model->getRate() * 0.000001 * pow(val, 3.0);
          break;
      }
      model->getVoiceData(vl)->setFilterModLfo(i1, l);  
    }  
  } else {
    for (int vl = vStart; vl <= vEnd; vl++) {
      val = filterModSlider[i1][i2]->getValue(vl) / 10.0;
      modulationLfo l = model->getVoiceData(vl)->getFilterModSpacingLfo(i1); 
      switch(i2) {    
        case 10:
          if (l.fast) {
            l.freq = 2.0 * 0.006 * pow(val, 2.0) * (double)STEP / (double)model->getRate();
          } else {
            l.freq = 2.0 * 0.0002 * pow(val, 2.0) * (double)STEP / (double)model->getRate();
          }  
          break;
        case 11:
          if (l.inverse) {
            l.depth = -0.03 * (pow(10, val / 50.0) - 1.0);
          } else {
            l.depth = 0.03 * (pow(10, val / 50.0) - 1.0);
          }
          break;
        case 12:
          l.delay = (double)model->getRate() * 0.000001 * pow(val, 3.0);
          break;
      }    
      model->getVoiceData(vl)->setFilterModSpacingLfo(i1, l);
    }
  }
}

void Gui::filterModToggled(int value) {

  int i1, i2;
  bool found, on;
  double val;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  found = false;
  val = 0;   
  for (i1 = 0; i1 < 2; i1++) {
    for (i2 = 0; i2 < 7; i2++) {
      if (filterModCheckBox[i1][i2] == sender()) {
        found = true;
        break;
      }     
    }
    if (found) {
      break;
    }
  }
  on = filterModCheckBox[i1][i2]->isChecked();
  if (i2 < 1) {
    for (int vl = vStart; vl <= vEnd; vl++) {
      modulationEnvelope e = model->getVoiceData(vl)->getFilterModEnvelope(i1); 
      e.inverse = on;
      val = filterModSlider[i1][6]->getValue(vl) / 10.0;
      if (e.inverse) {
        e.amount = -1.5 * (pow(10, val / 50.0) - 1.0);
      } else {
        e.amount = 1.5 * (pow(10, val / 50.0) - 1.0);
      }
      model->getVoiceData(vl)->setFilterModEnvelope(i1, e);
    }  
  } else if (i2 < 4) {
    for (int vl = vStart; vl <= vEnd; vl++) {
      modulationLfo l = model->getVoiceData(vl)->getFilterModLfo(i1); 
      switch(i2) {
        case 1:
          l.fast = on;
          val = filterModSlider[i1][7]->getValue(vl) / 10.0;
          if (l.fast) {
            l.freq = 2.0 * 0.006 * pow(val, 2.0) * (double)STEP / (double)model->getRate();
          } else {
            l.freq = 2.0 * 0.0002 * pow(val, 2.0) * (double)STEP / (double)model->getRate();
          }  
          break;
        case 2:
          l.retrigger = on;
          break;
        case 3:
          l.inverse = on;
          val = filterModSlider[i1][8]->getValue(vl) / 10.0;
          if (l.inverse) {
            l.depth = -1.5 * (pow(10, val / 50.0) - 1.0);
          } else {
            l.depth = 1.5 * (pow(10, val / 50.0) - 1.0);
          }
          break;
      }
      model->getVoiceData(vl)->setFilterModLfo(i1, l);  
    }  
  } else {
    for (int vl = vStart; vl <= vEnd; vl++) {
      modulationLfo l = model->getVoiceData(vl)->getFilterModSpacingLfo(i1); 
      switch(i2) {    
        case 4:
          l.fast = on;
          val = filterModSlider[i1][10]->getValue(vl) / 10.0;
          if (l.fast) {
            l.freq = 2.0 * 0.006 * pow(val, 2.0) * (double)STEP / (double)model->getRate();
          } else {
            l.freq = 2.0 * 0.0002 * pow(val, 2.0) * (double)STEP / (double)model->getRate();
          }  
          break;
        case 5:
          l.retrigger = on;
          break;
        case 6:
          l.inverse = on;
          val = filterModSlider[i1][11]->getValue(vl) / 10.0;
          if (l.inverse) {
            l.depth = -0.03 * (pow(10, val / 50.0) - 1.0);
          } else {
            l.depth = 0.03 * (pow(10, val / 50.0) - 1.0);
          }
          break;
      }    
      model->getVoiceData(vl)->setFilterModSpacingLfo(i1, l);
    }  
  }  
}

void Gui::setModulation(int filterIndex, int paramIndex, int voiceIndex, double modValue, int value) {


  double c;
 
  if (paramIndex < 13) {
    c = (filterModSlider[filterIndex][paramIndex]->maximum() - filterModSlider[filterIndex][paramIndex]->minimum()) / 127.0;
    filterModSlider[filterIndex][paramIndex]->setValues(voiceIndex, modValue, filterModSlider[filterIndex][paramIndex]->minimum() + (int)(c * (double)value));
  } else {
    filterModCheckBox[filterIndex][paramIndex-13]->setChecked(value > 62);
  }
}

void Gui::setMasterVolume(int value) {
  
  double val;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  for (int vl = vStart; vl <= vEnd; vl++) {
    val = ((ModSlider *)sender())->getValue(vl);
    model->getVoiceData(vl)->setMasterVolume(32.0 * (pow(10, (double)val / 500.0) - 1.0));
  }
}

void Gui::setNoise(int value) {

  int i;
  double val;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  for (i = 0; i < 4; i++) {
    if (noiseSlider[i] == sender()) {
      switch (i) {
        case 0:
          for (int vl = vStart; vl <= vEnd; vl++) {
            val = ((ModSlider *)sender())->getValue(vl);
            model->getVoiceData(vl)->setDelta(4, 12.0 * (val / 500.0 - 1.0));
          }  
          break;
        case 1:
          for (int vl = vStart; vl <= vEnd; vl++) {
            val = ((ModSlider *)sender())->getValue(vl);
            model->getVoiceData(vl)->setDelta(5, 5.0 + 4.0 * (val / 500.0 - 1.0));
          }
          break;              
        case 2:
          for (int vl = vStart; vl <= vEnd; vl++) {
            val = ((ModSlider *)sender())->getValue(vl);
            model->getVoiceData(vl)->setEvenOdd(3, val / 1000.0);
          }
          break;              
        case 3:
          for (int vl = vStart; vl <= vEnd; vl++) {
            val = ((ModSlider *)sender())->getValue(vl);
            model->getVoiceData(vl)->setNoiseBandwidth(0.25 + 0.24 * (val / 500.0 - 1.0));
          }
          break;
      }
      break;
    }  
  }   
}

void Gui::setNoise(int objectType, int objectIndex, int voiceIndex, double modValue, int value) {

  double c;

  switch (objectIndex) {
    case 0:
      c = (noiseSlider[0]->maximum() - noiseSlider[0]->minimum()) / 127.0;
      noiseSlider[0]->setValues(voiceIndex, modValue, noiseSlider[0]->minimum() + (int)(c * (double)value));
      break;
    case 1:
      c = (noiseSlider[1]->maximum() - noiseSlider[1]->minimum()) / 127.0;
      noiseSlider[1]->setValues(voiceIndex, modValue, noiseSlider[1]->minimum() + (int)(c * (double)value));
      break;
    case 2:
      c = (noiseSlider[2]->maximum() - noiseSlider[2]->minimum()) / 127.0;
      noiseSlider[2]->setValues(voiceIndex, modValue, noiseSlider[2]->minimum() + (int)(c * (double)value));
      break;
    case 3:
      c = (noiseSlider[3]->maximum() - noiseSlider[3]->minimum()) / 127.0;
      noiseSlider[3]->setValues(voiceIndex, modValue, noiseSlider[3]->minimum() + (int)(c * (double)value));
      break;
    case 4:
      c = (noiseFreqDiffusionSlider->maximum() - noiseFreqDiffusionSlider->minimum()) / 127.0;
      noiseFreqDiffusionSlider->setValues(voiceIndex, modValue, noiseFreqDiffusionSlider->minimum() + (int)(c * (double)value));
      break;
    case 5:
      noiseSubHarmonicCheck->setChecked(value > 63);
      break;
  }
}

void Gui::setModDepth(int value) {

  if (!midiControllerTree->topLevelItemCount() || (midiControllerTree->currentItem() == NULL)) {
    modDepthLabel->setDisabled(true);
    modDepthSlider->setDisabled(true);
    modFullToggle->setDisabled(true);
    modInverseToggle->setDisabled(true);
    return;
  }
  QTreeWidgetItem *m = midiControllerTree->currentItem();
  model->setControllerModulation(m->parent(), m, value, modFullToggle->isChecked(), modInverseToggle->isChecked());
}

void Gui::modFullToggled(int value) {

  modDepthLabel->setDisabled(value);
  modDepthSlider->setDisabled(value);
  modInverseToggle->setDisabled(value); // TODO Inverse auch für Full Mode
  if (!midiControllerTree->topLevelItemCount() || (midiControllerTree->currentItem() == NULL)) {
    modFullToggle->setDisabled(true);
    return;
  }
  QTreeWidgetItem *m = midiControllerTree->currentItem();
  model->setControllerModulation(m->parent(), m, modDepthSlider->value(), modFullToggle->isChecked(), modInverseToggle->isChecked());
}

void Gui::modInverseToggled(int value) {

  if (!midiControllerTree->topLevelItemCount() || (midiControllerTree->currentItem() == NULL)) {
    modDepthLabel->setDisabled(true);
    modDepthSlider->setDisabled(true);
    modFullToggle->setDisabled(true);
    modInverseToggle->setDisabled(true);
    return;
  }
  QTreeWidgetItem *m = midiControllerTree->currentItem();
  model->setControllerModulation(m->parent(), m, modDepthSlider->value(), modFullToggle->isChecked(), modInverseToggle->isChecked());
}

void Gui::midiCurrentItemChanged(QTreeWidgetItem *current, QTreeWidgetItem *previous) {

  controlObject co;
  bool success;

  if (!midiControllerTree->topLevelItemCount() || (midiControllerTree->currentItem() == NULL)) {
    modDepthLabel->setDisabled(true);
    modDepthSlider->setDisabled(true);
    modFullToggle->setDisabled(true);
    modInverseToggle->setDisabled(true);
    return;
  }
  co = model->getControlObject(current->parent(), current, success); 
  if (success && (co.objectType < 15)) {
    modDepthLabel->setEnabled(true);
    modDepthSlider->setEnabled(true);
    modFullToggle->setEnabled(true);
    modInverseToggle->setEnabled(true);
    modDepthSlider->setValue(co.modDepth);
    modFullToggle->setChecked(co.full);
    modInverseToggle->setChecked(co.inverse);
  } else {
    modDepthLabel->setDisabled(true);
    modDepthSlider->setDisabled(true);
    modFullToggle->setDisabled(true);
    modInverseToggle->setDisabled(true);
  }
}

void Gui::setCompressor(int value) {

  int i1;
  double val;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);    
  for (i1 = 0; i1 < 4; i1++) {
    if (compressorSlider[i1] == sender()) {
      for (int vl = vStart; vl <= vEnd; vl++) {
        val = ((ModSlider *)sender())->getValue(vl);
        model->getVoiceData(vl)->setCompressor(i1, val);
      }
      break;
    }
  }  
}

void Gui::voiceRangeSet() {

  int i1, vStart, vEnd, old_vStart, old_vEnd, currentIndex;
  QString qs;
  VoiceData *vd;

  vStart = voiceRangeStart->value() - 1;
  vEnd = voiceRangeEnd->value() - 1;
  model->setEditRange(vStart, vEnd);
  for (i1 = vStart; i1 <= vEnd; i1++) {
    vd = model->getVoiceData(i1);
    vd->setChannel(voiceChannel->value() - 1);
    vd->setEditRange(vStart, vEnd);
  }
  if (vStart > 0) {
    vd = model->getVoiceData(vStart - 1);
    vd->getEditRange(old_vStart, old_vEnd);
    for (i1 = old_vStart; i1 < vStart; i1++) {
      vd = model->getVoiceData(i1);
      vd->setEditRange(old_vStart, vStart - 1);
    }
  }  
  if (vEnd < model->getPoly() - 1) {
    vd = model->getVoiceData(vEnd + 1);
    vd->getEditRange(old_vStart, old_vEnd);
    for (i1 = vEnd + 1; i1 < old_vEnd; i1++) {
      vd = model->getVoiceData(i1);
      vd->setEditRange(vEnd + 1, old_vEnd);
    }
  }  
  currentIndex = voiceTree->indexOfTopLevelItem(voiceTree->currentItem());
  if (currentIndex < 0) {
    currentIndex = vStart;
  }
  voiceTree->clear();
  for (i1 = 0; i1 < model->getPoly(); i1++) {
    vd = model->getVoiceData(i1);
    QTreeWidgetItem *item = new QTreeWidgetItem(voiceTree);
    qs = QString::number(i1 + 1);
    item->setText(0, qs);
    qs = QString::number(vd->getChannel() + 1);
    item->setText(1, qs);
    item->setText(2, vd->getFileName());
    if (i1 == currentIndex) {
      voiceTree->setCurrentItem(item);
    }
  }  
}

void Gui::voiceRangeStartChanged(int value) {


  if (value > voiceRangeEnd->value()) {
    voiceRangeEnd->setValue(value);
  }
}

void Gui::voiceRangeEndChanged(int value) {

  if (value < voiceRangeStart->value()) {
    voiceRangeStart->setValue(value);
  }
}

void Gui::voiceChannelChanged(int value) { 

}

void Gui::lowerRandomLevelChanged(int value) {

    lowerRandomLevel = value;
}

void Gui::upperRandomLevelChanged(int value) {

    upperRandomLevel = value;
}

void Gui::randomizeHarmonics() {

    harmonics[harmonicTab->currentIndex()]->randomizeHarmonics(lowerRandomLevel / 10, upperRandomLevel / 10, addRandomFlag);
}

void Gui::addRandomToggled(int value) {

    addRandomFlag = addRandomCheck->isChecked();
}

void Gui::showPolygonToggled(int value) {

    int i1;

    showPolygonFlag = showPolygonCheck->isChecked();
    for (i1 = 0; i1 < MAX_PARAMS; i1++) {
      harmonics[i1]->setShowPolygon(showPolygonFlag);
    }
}

void Gui::saveVoiceXML(int voiceIndex) {

  int i1, i2, i3;
  int d1, d2;
  QString fn, qs;
  QFile *f;
  int vStart, vEnd;
  VoiceData *vd;

  modifiedFlag = false;
  vd = model->getVoiceData(voiceIndex);
  vd->getEditRange(vStart, vEnd);
  fn = vd->getFileName();
  if (!fn.isEmpty()) {
    f = new QFile(fn);
    if (f->open(QIODevice::WriteOnly)) {
      voiceFileName = fn;
      voiceFileLabel->setText(fn);
      QXmlStreamWriter xmlWriter(f);
      xmlWriter.setAutoFormatting(true);
      xmlWriter.writeStartDocument();   
      xmlWriter.writeStartElement("Add64Sound");
      if (!comment.isEmpty()) {
        xmlWriter.writeStartElement("Comment");
        xmlWriter.writeTextElement("TEXT", comment);
        xmlWriter.writeEndElement();
      }
      xmlWriter.writeStartElement("Voice");
      xmlWriter.writeTextElement("MasterVolume", QString::number(masterVolume->value()));
      xmlWriter.writeTextElement("VolumeTracking", QString::number(volumeTrackingSlider->value()));
      xmlWriter.writeTextElement("VelocityDepth", QString::number(velocityDepthSlider->value()));
      xmlWriter.writeTextElement("Detune", QString::number(detuneSlider->value()));
      xmlWriter.writeTextElement("offsetDetune", QString::number(offsetDetuneSlider->value()));
      xmlWriter.writeTextElement("PitchLfoFreq", QString::number(pitchLFOfreq->value()));
      xmlWriter.writeTextElement("PitchLfoDepth", QString::number(pitchLFOdepth->value()));
      xmlWriter.writeTextElement("Morphing", QString::number(morphingSlider->value()));
      for (i1 = 0; i1 < 4; i1++) {
        xmlWriter.writeTextElement("Compressor_"+QString::number(i1), QString::number(compressorSlider[i1]->value()));
      }
      for (i1 = 0; i1 < 2; i1++) {
        xmlWriter.writeTextElement("Panning_"+QString::number(i1), QString::number(panSlider[i1]->value()));
      }
      xmlWriter.writeTextElement("PanMode", QString::number(panMode->currentIndex()));
      for (i1 = 0; i1 < 3; i1++) {
        xmlWriter.writeTextElement("EvenOdd_"+QString::number(i1), QString::number(evenOddSlider[i1]->value()));
      }
      for (i1 = 0; i1 < 4; i1++) {
        xmlWriter.writeTextElement("Noise_"+QString::number(i1), QString::number(noiseSlider[i1]->value()));
      }
      xmlWriter.writeTextElement("NoiseFreqDiffusion", QString::number(noiseFreqDiffusionSlider->value()));
      xmlWriter.writeTextElement("NoiseSubHarmonicMode", QString::number(noiseSubHarmonicCheck->isChecked()));
      xmlWriter.writeTextElement("Osc3Mode", QString::number(osc3ModeCombo->currentIndex()));
      xmlWriter.writeTextElement("Osc3FreqDiffusion", QString::number(osc3FreqDiffusionSlider->value()));
      for (i1 = 0; i1 < MAX_OSC - 1; i1++) {
        xmlWriter.writeTextElement("SpectrumOffset_"+QString::number(i1), QString::number(spectrumOffset[i1]->value()));
        xmlWriter.writeTextElement("SpectrumSpacing_"+QString::number(i1), QString::number(spectrumSpacing[i1]->value()));
      }  
      for (i1 = 0; i1 < 2; i1++) {
        xmlWriter.writeTextElement("SpectrumOffsetIndex_"+QString::number(i1), QString::number(spectrumOffsetCombo[i1]->currentIndex()));
        xmlWriter.writeTextElement("SpectrumSpacingIndex_"+QString::number(i1), QString::number(spectrumSpacingCombo[i1]->currentIndex()));
      }
      for (i1 = 0; i1 < MAX_SPLIT; i1++) {
        xmlWriter.writeTextElement("HarmonicSplit_"+QString::number(i1), QString::number(model->getHarmonicSplit(i1))); 
      }  
      for (i1 = 0; i1 < MAX_PARAMS; i1++) {
        xmlWriter.writeStartElement("Parameter_"+QString::number(i1));
        for (i2 = 0; i2 < MAX_SCENES * MAX_SOURCES; i2++) {
          harmonicScale[i1]->readBufValue(i2, d1, d2);
          xmlWriter.writeTextElement("Scale_"+QString::number(i2), QString::number(d1));
        }  
        for (i2 = 0; i2 < MAX_SCENES * MAX_SOURCES; i2++) {
          xmlWriter.writeStartElement("ControlGroup_"+QString::number(i2));
          for (i3 = 0; i3 < NUM_CONTROLPOINTS + 2; i3++) {
            xmlWriter.writeTextElement("ControlPointY_"+QString::number(i3), QString::number(harmonics[i1]->getControlPoint(i2, i3).y())); 
          }  
          xmlWriter.writeEndElement();
        }  
        for (i2 = 0; i2 < model->getNumHarmonics(); i2++) {
          xmlWriter.writeTextElement("H_"+QString::number(i2), QString::number(model->getVoiceData(vStart)->getHarmonic(i1, i2))); 
        }
        xmlWriter.writeEndElement();
      }
      for (i1 = 0; i1 < MAX_SOURCES; i1++) {
        xmlWriter.writeStartElement("Source_"+QString::number(i1));
        for (i2 = 0; i2 < 6; i2++) {
          xmlWriter.writeTextElement("FilterMix_"+QString::number(i2), QString::number(filterMixSlider[i1][i2]->value()));
        }
        for (i2 = 0; i2 < 3; i2++) {
          xmlWriter.writeTextElement("FilterMixSwitch_"+QString::number(i2), QString::number(filterMixCheckBox[i1][i2]->isChecked() ? 1 : 0));
        }
        xmlWriter.writeEndElement();
      }                  
      for (i1 = 0; i1 < 2; i1++) {
        xmlWriter.writeStartElement("Filter_"+QString::number(i1));
        for (i3 = 0; i3 < 2; i3++) {
          xmlWriter.writeTextElement("Cutoff_"+QString::number(i3), QString::number(filterCutoff[2 * i1 + i3]->value()));
          xmlWriter.writeTextElement("Spacing_"+QString::number(i3), QString::number(filterSpacing[2 * i1 + i3]->value()));
        }
        xmlWriter.writeTextElement("KeyTracking", QString::number(filterKeyTracking[i1]->value()));
        xmlWriter.writeTextElement("FilterDepth", QString::number(filterDepth[i1]->value()));
        xmlWriter.writeTextElement("FilterCutoffIndex", QString::number(filterCutoffCombo[i1]->currentIndex()));
        xmlWriter.writeTextElement("FilterSpacingIndex", QString::number(filterSpacingCombo[i1]->currentIndex()));
        xmlWriter.writeTextElement("FilterTrackingIndex", QString::number(filterTrackingCombo[i1]->currentIndex()));
        for (i2 = 0; i2 < FILTER_LEN; i2++) {
          xmlWriter.writeTextElement("F_"+QString::number(i2), QString::number(model->getVoiceData(vStart)->getFilter(i1, i2))); 
        }
        xmlWriter.writeEndElement();
      }
      for (i1 = 0; i1 < 2; i1++) {
        xmlWriter.writeStartElement("FilterModulation_"+QString::number(i1));
        for (i2 = 0; i2 < 13; i2++) {
          xmlWriter.writeTextElement("FilterMod_"+QString::number(i2), QString::number(filterModSlider[i1][i2]->value()));
        }
        for (i2 = 0; i2 < 7; i2++) {

        xmlWriter.writeTextElement("FilterModSwitch_"+QString::number(i2),
        QString::number(filterModCheckBox[i1][i2]->isChecked() ?  1 : 0)); }
        xmlWriter.writeEndElement();
      }                  
      xmlWriter.writeEndElement();
      xmlWriter.writeEndElement();
      xmlWriter.writeEndDocument();
      f->close();
    }  
  }   
}

void Gui::editVoice(int voiceIndex) {

  int vStart, vEnd;
  VoiceData *vd;

  modifiedFlag = false;
  vd = model->getVoiceData(voiceIndex);
  vd->getEditRange(vStart, vEnd);
  model->setEditRange(vStart, vEnd);
  voiceChannel->setValue(vd->getChannel() + 1);
  voiceRangeStart->setValue(vStart+1);
  voiceRangeEnd->setValue(vEnd+1);
  loadVoiceXML(voiceIndex);
}                

void Gui::presetIOsuccess() {

  int i1, i2, sendValue;
  
  for (i1 = 0; i1 < 4; i1++) {
    for (i2 = 0; i2 < 4; i2++) {
      sendValue =  (i1 == i2) ? 127 : 0;
      model->addMidiEvent(0, 0xB0, 0, 105 + i2, sendValue); //TODO use correct MIDI Channel
    }  
    QThread::msleep(100);
  }
  updatePresetLEDs();
}

void Gui::loadPreset() {

  QString fn;
  
  fn = presetPrefix.trimmed() + "Add64Preset_" + QString::number(presetFolder) + "_"  + QString::number(presetBank) + "_"  + QString::number(presetNum);
  loadXML(false, fn);
}

void Gui::savePreset() {

  QString fn;
    
  fn = presetPrefix.trimmed() + "Add64Preset_" + QString::number(presetFolder) + "_"  + QString::number(presetBank) + "_"  + QString::number(presetNum);
  saveXML(fn);
}

void Gui::loadVoiceXML(int voiceIndex) {

  QString fn;
  QFile *f;
  VoiceData *vd;
  QXmlSimpleReader xmlReader;
  bool ok;

  modifiedFlag = false;
  vd = model->getVoiceData(voiceIndex);
  fn = vd->getFileName();
  if (!fn.isEmpty()) {
    f = new QFile(fn);
    voiceFileLabel->setText(fn);
    if (f->exists()) {
      f->open(QIODevice::ReadOnly);
      vd->setComment("");
      QXmlInputSource *source = new QXmlInputSource(f);
      XmlHandler *xmlHandler = new XmlHandler(model, voiceIndex);
      xmlReader.setContentHandler(xmlHandler);
      ok = xmlReader.parse(source);
      while (ok) {
        ok = xmlReader.parseContinue();
      }  
      f->close();
      comment = vd->getComment();
      if (!comment.isEmpty()) {
        showComment();
      }
    }  
  }
  groupSelector->button(0)->setChecked(true);
  selectGroup(0);
  harmonicTab->setCurrentIndex(0);
  updateTab(0);
  model->resetLFO();
}                

void Gui::xmlInput(tokenCodeEnum code, int index1, int index2, int index3, int voiceIndex, double value) {

  int vStart, vEnd;

  model->getEditRange(vStart, vEnd);
  switch (code) {
    case MasterVolume:
      masterVolume->setValue(value);
      break;
    case VolumeTracking:
      volumeTrackingSlider->setValue(value);
      break;
    case VelocityDepth:
      velocityDepthSlider->setValue(value);
      break;
    case Detune:
      detuneSlider->setValue(value);
      break;
    case offsetDetune:
      offsetDetuneSlider->setValue(value);
      break;
    case PitchLfoFreq: 
      pitchLFOfreq->setValue(value);
      break; 
    case PitchLfoDepth: 
      pitchLFOdepth->setValue(value);
      break; 
    case Morphing: 
      morphingSlider->setValue(value);
      break; 
    case Compressor: 
      compressorSlider[index2]->setValue(value);
      break; 
    case Panning: 
      panSlider[index2]->setValue(value);
      break; 
    case PanMode: 
      panMode->setCurrentIndex(value);    
      break; 
    case EvenOdd: 
      evenOddSlider[index2]->setValue(value);
      break; 
    case Noise:
      noiseSlider[index2]->setValue(value);
      break;
    case NoiseSubHarmonicMode:
      noiseSubHarmonicCheck->setChecked(value);
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setNoiseSubHarmonicMode(value);
      }
      break;
    case NoiseFreqDiffusion:
      noiseFreqDiffusionSlider->setValue(value);
      break;
    case Osc3Mode:
      osc3ModeCombo->setCurrentIndex(value);
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setOsc3Mode(value);
      }
      break;
    case Osc3FreqDiffusion:
      osc3FreqDiffusionSlider->setValue(value);
      break;
    case SpectrumOffset: 
      spectrumOffset[index2]->setValue(value);
      break; 
    case SpectrumSpacing: 
      spectrumSpacing[index2]->setValue(value);
      break; 
    case SpectrumOffsetIndex: 
      spectrumOffsetCombo[index2]->setCurrentIndex(value);
      break; 
    case SpectrumSpacingIndex:  
      spectrumSpacingCombo[index2]->setCurrentIndex(value);
      break; 
    case HarmonicSplit: 
      model->setHarmonicSplit(index2, value);
      break;
    case Scale:  
      harmonicScale[index1]->writeBufValue(index2, value, 0);  
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setGroupScale(index2, index1, value);
      }  
      break; 
    case ControlPointY:
      harmonics[index1]->setControlPointY(index3, index2, value);
      break;
    case H: 
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setHarmonic(index1, index2, value);
      }  
      break; 
    case FilterMix: 
      filterMixSlider[index1][index2]->setValue(value);
      break; 
    case FilterMixSwitch: 
      filterMixCheckBox[index1][index2]->setChecked(value);
      break; 
    case Cutoff: 
      filterCutoff[2 * index1 + index2]->setValue(value);
      break; 
    case Spacing: 
      filterSpacing[2 * index1 + index2]->setValue(value);
      break; 
    case KeyTracking: 
      filterKeyTracking[index1]->setValue(value);
      break; 
    case FilterDepth: 
      filterDepth[index1]->setValue(value);
      break; 
    case FilterCutoffIndex:
      filterCutoffCombo[index1]->setCurrentIndex(value);
      break;
    case FilterSpacingIndex: 
      filterSpacingCombo[index1]->setCurrentIndex(value);
      break; 
    case FilterTrackingIndex: 
      filterTrackingCombo[index1]->setCurrentIndex(value);
      break; 
    case F: 
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setFilter(index1, index2, value);      
      }  
      break; 
    case FilterMod: 
      filterModSlider[index1][index2]->setValue(value);
      break; 
    case FilterModSwitch: 
      filterModCheckBox[index1][index2]->setChecked(value);
      break;
  }  
}

void Gui::voiceTreeChanged(QTreeWidgetItem *item, QTreeWidgetItem *previous) {

  int i1, i2;
  QString qs;
  int vStart, vEnd;
  VoiceData *vd;  
  QMessageBox::StandardButton sb;
  
  i1 = voiceTree->indexOfTopLevelItem(previous);
  i2 = voiceTree->indexOfTopLevelItem(item);
  if ((i1 < 0) || (i2 < 0)) {
    return;
  } else {
    vd = model->getVoiceData(i1);
    vd->getEditRange(vStart, vEnd);
    if ((i2 < vStart) || (i2 > vEnd)) {
      if (modifiedFlag) {
        qs = "Save "+vd->getFileName()+" ?";
        sb = QMessageBox::question(this, "Save Voice", qs, QMessageBox::Yes | QMessageBox::No, QMessageBox::Yes); 
        if (sb == QMessageBox::Yes) {
          saveVoiceXML(i1);
        }
      }  
      editVoice(i2);
    }  
  }  
}

void Gui::mainTabChanged(int index) {

  if (index != 10) {
    modifiedFlag = true;
  }  
}

void Gui::setPan(int value) {

  int i1;
  double val;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);    
  for (i1 = 0; i1 < 2; i1++) {
    if (panSlider[i1] == sender()) {
      for (int vl = vStart; vl <= vEnd; vl++) {
        val = ((ModSlider *)sender())->getValue(vl);
        model->getVoiceData(vl)->setPan(i1, val);
      }
      break;
    }
  }  
}

void Gui::setPanMode(int index) {

  int vStart, vEnd;

  model->getEditRange(vStart, vEnd);    
  for (int vl = vStart; vl <= vEnd; vl++) {
    model->getVoiceData(vl)->setPan(2, index);
  }  
}

void Gui::addComment() {

   textEditor->clear();
   textEditor->setReadOnly(false);
   textEditor->setCancel(true);
   textEditor->show();
   textEditor->raise();
}

void Gui::editComment() {

   textEditor->setReadOnly(false);
   textEditor->setCancel(true);
   textEditor->setText(comment);
   textEditor->show();
   textEditor->raise();
}

void Gui::showComment() {

   textEditor->setReadOnly(true);
   textEditor->setCancel(false);
   textEditor->setText(comment);
   textEditor->show();
   textEditor->raise();
}

void Gui::cancelComment() {

  textEditor->hide();
}

void Gui::commentOK() {

  comment = textEditor->getText();
  textEditor->hide();
}

void Gui::showScalaDialog() {

  scalaDialog->show();
  scalaDialog->raise();
}

void Gui::noiseSubHarmonicToggled(int value) {

  int vStart, vEnd;

  model->getEditRange(vStart, vEnd);
  for (int vl = vStart; vl <= vEnd; vl++) {
    model->getVoiceData(vl)->setNoiseSubHarmonicMode(noiseSubHarmonicCheck->isChecked());
  }
}

void Gui::setNoiseFreqDiffusion(int value) {

  int vStart, vEnd;

  model->getEditRange(vStart, vEnd);
  for (int vl = vStart; vl <= vEnd; vl++) {
    model->getVoiceData(vl)->setNoiseFreqDiffusion(value);
  }
}

void Gui::setOsc3ModeCombo(int index) {

  int vStart, vEnd;

  model->getEditRange(vStart, vEnd);
  for (int vl = vStart; vl <= vEnd; vl++) {
    model->getVoiceData(vl)->setOsc3Mode(index);
  }
}

void Gui::setOsc3FreqDiffusion(int value) {

  int vStart, vEnd;

  model->getEditRange(vStart, vEnd);
  for (int vl = vStart; vl <= vEnd; vl++) {
    model->getVoiceData(vl)->setOsc3FreqDiffusion(value);
  }
}

void Gui::setDetune(int value) {

  int vStart, vEnd;

  model->getEditRange(vStart, vEnd);
  for (int vl = vStart; vl <= vEnd; vl++) {
    model->getVoiceData(vl)->setDetune(0.001 * value);
  }
}

void Gui::setOffsetDetune(int value) {

  int vStart, vEnd;

  model->getEditRange(vStart, vEnd);
  for (int vl = vStart; vl <= vEnd; vl++) {
    model->getVoiceData(vl)->setOffsetDetune(0.001 * value);
  }
}

void Gui::setVoiceRandom(int value) {

  int vStart, vEnd;

  model->getEditRange(vStart, vEnd);
  for (int vl = vStart; vl <= vEnd; vl++) {
    model->getVoiceData(vl)->setVoiceRandom(0.001 * value);
  }
}

void Gui::process_MidiNoteOn(int voiceIndex) {

  model->getVoiceData(voiceIndex)->newCurrentVoiceDetune();
}

void Gui::setMidiGroup(int index) {

  int currentGroupIndex;

  if (index == 0) {
    currentGroupIndex = 0;
  } else if (index < 11) {
    currentGroupIndex = index + 3;
  } else if (index < 13) {
    currentGroupIndex = index - 9;
  } else {
    currentGroupIndex = index + 1;
  }
  model->setCurrentGroupIndex(currentGroupIndex);
}

int Gui::getDisplayGroupIndex(int index) {

  int displayGroupIndex;

  if (index == 0) {
    displayGroupIndex = 0;
  } else if (index == 1) {
    displayGroupIndex = -1; // Harmonics Group (für User nicht zuweisbar)
  } else if (index == 18) {
    displayGroupIndex = -2; // Scale Group (für User nicht zuweisbar)
  } else if (index == 19) {
    displayGroupIndex = -3; // Filter Curve Group (für User nicht zuweisbar)
  } else if ((index > 3) && (index < 14)) {
    displayGroupIndex = index - 3;
  } else if (index < 4) {
    displayGroupIndex = index + 9;
  } else {
    displayGroupIndex = index - 1;
  }
  return(displayGroupIndex);
}

int Gui::getCommon(int objectType, int objectIndex, int voiceIndex) {

  double c;
  int val;
  
  val = 0;  
  switch (objectIndex) {
    case 0:
      c = (masterVolume->maximum() - masterVolume->minimum()) / 127.0;
      val = (int)round((double)(masterVolume->getValue(voiceIndex) - masterVolume->minimum()) / c);
      break;
    case 1:
      c = (pitchLFOfreq->maximum() - pitchLFOfreq->minimum()) / 127.0;
      val = (int)round((double)(pitchLFOfreq->getValue(voiceIndex) - pitchLFOfreq->minimum()) / c);
      break;
    case 2:
      c = (pitchLFOdepth->maximum() - pitchLFOdepth->minimum()) / 127.0;
      val = (int)round((double)(pitchLFOdepth->getValue(voiceIndex) - pitchLFOdepth->minimum()) / c);
      break;
    case 3:
      c = (morphingSlider->maximum() - morphingSlider->minimum()) / 127.0;
      val = (int)round((double)(morphingSlider->getValue(voiceIndex) - morphingSlider->minimum()) / c);
      break;
    case 4:
      c = (compressorSlider[0]->maximum() - compressorSlider[0]->minimum()) / 127.0;
      val = (int)round((double)(compressorSlider[0]->getValue(voiceIndex) - compressorSlider[0]->minimum()) / c);
      break;
    case 5:
      c = (compressorSlider[1]->maximum() - compressorSlider[1]->minimum()) / 127.0;
      val = (int)round((double)(compressorSlider[1]->getValue(voiceIndex) - compressorSlider[1]->minimum()) / c);
      break;
    case 6:
      c = (compressorSlider[2]->maximum() - compressorSlider[2]->minimum()) / 127.0;
      val = (int)round((double)(compressorSlider[2]->getValue(voiceIndex) - compressorSlider[2]->minimum()) / c);
      break;
    case 7:
      c = (compressorSlider[3]->maximum() - compressorSlider[3]->minimum()) / 127.0;
      val = (int)round((double)(compressorSlider[3]->getValue(voiceIndex) - compressorSlider[3]->minimum()) / c);
      break;
    case 8:
      c = (panSlider[0]->maximum() - panSlider[0]->minimum()) / 127.0;
      val = (int)round((double)(panSlider[0]->getValue(voiceIndex) - panSlider[0]->minimum()) / c);
      break;
    case 9:
      c = (panSlider[1]->maximum() - panSlider[1]->minimum()) / 127.0;
      val = (int)round((double)(panSlider[1]->getValue(voiceIndex) - panSlider[1]->minimum()) / c);
      break;
    case 10:
      c = ((panMode->count() - 1.0) / 127.0);
      val = (int)round((double)panMode->currentIndex() / c);
      break;
    case 11:
      c = (detuneSlider->maximum() - detuneSlider->minimum()) / 127.0;
      val = (int)round((double)(detuneSlider->getValue(voiceIndex) - detuneSlider->minimum()) / c);
      break;
    case 12:
      c = (offsetDetuneSlider->maximum() - offsetDetuneSlider->minimum()) / 127.0;
      val = (int)round((double)(offsetDetuneSlider->getValue(voiceIndex) - offsetDetuneSlider->minimum()) / c);
      break;
    case 13:
      c = (randomSlider->maximum() - randomSlider->minimum()) / 127.0;
      val = (int)round((double)(randomSlider->getValue(voiceIndex) - randomSlider->minimum()) / c);
      break;
  }
  return(val);
}

int Gui::getOscillators(int objectType, int objectIndex, int voiceIndex) {

  double c;
  int val;

  val = 0;
  switch (objectIndex) {
    case 0:
      c = (evenOddSlider[0]->maximum() - evenOddSlider[0]->minimum()) / 127.0;
      val = (int)round((double)(evenOddSlider[0]->getValue(voiceIndex) - evenOddSlider[0]->minimum()) / c);
      break;
    case 1:
      c = (spectrumOffset[0]->maximum() - spectrumOffset[0]->minimum()) / 127.0;
      val = (int)round((double)(spectrumOffset[0]->getValue(voiceIndex) - spectrumOffset[0]->minimum()) / c);
      break;
    case 2:
      c = (spectrumOffset[1]->maximum() - spectrumOffset[1]->minimum()) / 127.0;
      val = (int)round((double)(spectrumOffset[1]->getValue(voiceIndex) - spectrumOffset[1]->minimum()) / c);
      break;
    case 3:
      c = (spectrumSpacing[0]->maximum() - spectrumSpacing[0]->minimum()) / 127.0;
      val = (int)round((double)(spectrumSpacing[0]->getValue(voiceIndex) - spectrumSpacing[0]->minimum()) / c);
      break;
    case 4:
      c = (spectrumSpacing[1]->maximum() - spectrumSpacing[1]->minimum()) / 127.0;
      val = (int)round((double)(spectrumSpacing[1]->getValue(voiceIndex) - spectrumSpacing[1]->minimum()) / c);
      break;
    case 5:
      c = ((spectrumOffsetCombo[0]->count() - 1.0) / 127.0);
      val = (int)round((double)spectrumOffsetCombo[0]->currentIndex() / c);
      break;
    case 6:
      c = ((spectrumSpacingCombo[0]->count() - 1.0) / 127.0);
      val = (int)round((double)spectrumSpacingCombo[0]->currentIndex() / c);
      break;
    case 7: 
      c = (evenOddSlider[1]->maximum() - evenOddSlider[1]->minimum()) / 127.0;
      val = (int)round((double)(evenOddSlider[1]->getValue(voiceIndex) - evenOddSlider[1]->minimum()) / c);
      break;
    case 8: 
      c = (spectrumOffset[2]->maximum() - spectrumOffset[2]->minimum()) / 127.0;
      val = (int)round((double)(spectrumOffset[2]->getValue(voiceIndex) - spectrumOffset[2]->minimum()) / c);
      break;
    case 9:
      c = (spectrumOffset[3]->maximum() - spectrumOffset[3]->minimum()) / 127.0;
      val = (int)round((double)(spectrumOffset[3]->getValue(voiceIndex) - spectrumOffset[3]->minimum()) / c);
      break;
    case 10:
      c = (spectrumSpacing[2]->maximum() - spectrumSpacing[2]->minimum()) / 127.0;
      val = (int)round((double)(spectrumSpacing[2]->getValue(voiceIndex) - spectrumSpacing[2]->minimum()) / c);
      break;
    case 11:
      c = (spectrumSpacing[3]->maximum() - spectrumSpacing[3]->minimum()) / 127.0;
      val = (int)round((double)(spectrumSpacing[3]->getValue(voiceIndex) - spectrumSpacing[3]->minimum()) / c);
      break;
    case 12:
      c = ((spectrumOffsetCombo[1]->count() - 1.0) / 127.0);
      val = (int)round((double)spectrumOffsetCombo[1]->currentIndex() / c);
      break;
    case 13:
      c = ((spectrumSpacingCombo[1]->count() - 1.0) / 127.0);
      val = (int)round((double)spectrumSpacingCombo[1]->currentIndex() / c);
      break;
    case 14:
      c = (evenOddSlider[2]->maximum() - evenOddSlider[2]->minimum()) / 127.0;
      val = (int)round((double)(evenOddSlider[2]->getValue(voiceIndex) - evenOddSlider[2]->minimum()) / c);
      break;
    case 15:
      c = (osc3FreqDiffusionSlider->maximum() - osc3FreqDiffusionSlider->minimum()) / 127.0;
      val = (int)round((double)(osc3FreqDiffusionSlider->getValue(voiceIndex) - osc3FreqDiffusionSlider->minimum()) / c);
      break;
    case 16:
      c = ((osc3ModeCombo->count() - 1.0) / 127.0);
      val = (int)round((double)osc3ModeCombo->currentIndex() / c);
      break;             
  }
  return(val);
}

int Gui::getNoise(int objectType, int objectIndex, int voiceIndex) { 

  double c;
  int val;

  val = 0;
  switch (objectIndex) {
    case 0:
      c = (noiseSlider[0]->maximum() - noiseSlider[0]->minimum()) / 127.0;
      val = (int)round((double)(noiseSlider[0]->getValue(voiceIndex) - noiseSlider[0]->minimum()) / c);
      break;
    case 1:
      c = (noiseSlider[1]->maximum() - noiseSlider[1]->minimum()) / 127.0;
      val = (int)round((double)(noiseSlider[1]->getValue(voiceIndex) - noiseSlider[1]->minimum()) / c);
      break;
    case 2:
      c = (noiseSlider[2]->maximum() - noiseSlider[2]->minimum()) / 127.0;
      val = (int)round((double)(noiseSlider[2]->getValue(voiceIndex) - noiseSlider[2]->minimum()) / c);
      break;
    case 3:
      c = (noiseSlider[3]->maximum() - noiseSlider[3]->minimum()) / 127.0;
      val = (int)round((double)(noiseSlider[3]->getValue(voiceIndex) - noiseSlider[3]->minimum()) / c);
      break;
    case 4:
      c = (noiseFreqDiffusionSlider->maximum() - noiseFreqDiffusionSlider->minimum()) / 127.0;
      val = (int)round((double)(noiseFreqDiffusionSlider->getValue(voiceIndex) - noiseFreqDiffusionSlider->minimum()) / c);
      break;
    case 5:
      val = (noiseSubHarmonicCheck->isChecked()) ? 127 : 0;
      break;
  }
  return(val);
}

int Gui::getMixer(int objectIndex, int voiceIndex) {                             

  double c;
  int i1, i2;
  int val;
  
  val = 0;
  i1 = objectIndex / 9;
  i2 = objectIndex % 9;
  switch (i2) {
    case 0:
      c = (filterMixSlider[i1][0]->maximum() - filterMixSlider[i1][0]->minimum()) / 127.0;
      val = (int)round((double)(filterMixSlider[i1][0]->getValue(voiceIndex) - filterMixSlider[i1][0]->minimum()) / c);
      break;
    case 1:
      c = (filterMixSlider[i1][1]->maximum() - filterMixSlider[i1][1]->minimum()) / 127.0;
      val = (int)round((double)(filterMixSlider[i1][1]->getValue(voiceIndex) - filterMixSlider[i1][1]->minimum()) / c);
      break;
    case 2:
      val = (filterMixCheckBox[i1][0]->isChecked()) ? 127 : 0;
      break;
    case 3:
      c = (filterMixSlider[i1][2]->maximum() - filterMixSlider[i1][2]->minimum()) / 127.0;
      val = (int)round((double)(filterMixSlider[i1][2]->getValue(voiceIndex) - filterMixSlider[i1][2]->minimum()) / c);
      break;
    case 4:
      c = (filterMixSlider[i1][3]->maximum() - filterMixSlider[i1][3]->minimum()) / 127.0;
      val = (int)round((double)(filterMixSlider[i1][3]->getValue(voiceIndex) - filterMixSlider[i1][3]->minimum()) / c);
      break;
    case 5:
      val = (filterMixCheckBox[i1][1]->isChecked()) ? 127 : 0;
      break;
    case 6:
      c = (filterMixSlider[i1][4]->maximum() - filterMixSlider[i1][4]->minimum()) / 127.0;
      val = (int)round((double)(filterMixSlider[i1][4]->getValue(voiceIndex) - filterMixSlider[i1][4]->minimum()) / c);
      break;
    case 7:
      c = (filterMixSlider[i1][5]->maximum() - filterMixSlider[i1][5]->minimum()) / 127.0;
      val = (int)round((double)(filterMixSlider[i1][5]->getValue(voiceIndex) - filterMixSlider[i1][5]->minimum()) / c);
      break;
    case 8:
      val = (filterMixCheckBox[i1][2]->isChecked()) ? 127 : 0;
      break;
  }
  return(val);
}

int Gui::getFilter(int objectIndex, int voiceIndex) {                             

  double c;
  int val;

  val = 0; 
  switch (objectIndex) {
    case 0:
      c = (filterCutoff[0]->maximum() - filterCutoff[0]->minimum()) / 127.0;
      val = (int)round((double)(filterCutoff[0]->getValue(voiceIndex) - filterCutoff[0]->minimum()) / c);
      break;
    case 1:
      c = (filterCutoff[1]->maximum() - filterCutoff[1]->minimum()) / 127.0;
      val = (int)round((double)(filterCutoff[1]->getValue(voiceIndex) - filterCutoff[1]->minimum()) / c);
      break;
    case 2:
      c = (filterSpacing[0]->maximum() - filterSpacing[0]->minimum()) / 127.0;
      val = (int)round((double)(filterSpacing[0]->getValue(voiceIndex) - filterSpacing[0]->minimum()) / c);
      break;
    case 3:
      c = (filterSpacing[1]->maximum() - filterSpacing[1]->minimum()) / 127.0;
      val = (int)round((double)(filterSpacing[1]->getValue(voiceIndex) - filterSpacing[1]->minimum()) / c);
      break;
    case 4:
      c = (filterKeyTracking[0]->maximum() - filterKeyTracking[0]->minimum()) / 127.0;
      val = (int)round((double)(filterKeyTracking[0]->getValue(voiceIndex) - filterKeyTracking[0]->minimum()) / c);
      break;
    case 5:
      c = (filterDepth[0]->maximum() - filterDepth[0]->minimum()) / 127.0;
      val = (int)round((double)(filterDepth[0]->getValue(voiceIndex) - filterDepth[0]->minimum()) / c);
      break;
    case 6:
      c = ((filterCutoffCombo[0]->count() - 1.0) / 127.0);
      val = (int)round((double)filterCutoffCombo[0]->currentIndex() / c);
      break;
    case 7:
      c = ((filterSpacingCombo[0]->count() - 1.0) / 127.0);
      val = (int)round((double)filterSpacingCombo[0]->currentIndex() / c);
      break;
    case 8:
      c = ((filterTrackingCombo[0]->count() - 1.0) / 127.0);
      val = (int)round((double)filterTrackingCombo[0]->currentIndex() / c);
      break;
    case 9:
      c = (filterCutoff[2]->maximum() - filterCutoff[2]->minimum()) / 127.0;
      val = (int)round((double)(filterCutoff[2]->getValue(voiceIndex) - filterCutoff[2]->minimum()) / c);
      break;
    case 10:
      c = (filterCutoff[3]->maximum() - filterCutoff[3]->minimum()) / 127.0;
      val = (int)round((double)(filterCutoff[3]->getValue(voiceIndex) - filterCutoff[3]->minimum()) / c);
      break;
    case 11:
      c = (filterSpacing[2]->maximum() - filterSpacing[2]->minimum()) / 127.0;
      val = (int)round((double)(filterSpacing[2]->getValue(voiceIndex) - filterSpacing[2]->minimum()) / c);
      break;
    case 12:
      c = (filterSpacing[3]->maximum() - filterSpacing[3]->minimum()) / 127.0;
      val = (int)round((double)(filterSpacing[3]->getValue(voiceIndex) - filterSpacing[3]->minimum()) / c);
      break;
    case 13:
      c = (filterKeyTracking[1]->maximum() - filterKeyTracking[1]->minimum()) / 127.0;
      val = (int)round((double)(filterKeyTracking[1]->getValue(voiceIndex) - filterKeyTracking[1]->minimum()) / c);
      break;
    case 14:
      c = (filterDepth[1]->maximum() - filterDepth[1]->minimum()) / 127.0;
      val = (int)round((double)(filterDepth[1]->getValue(voiceIndex) - filterDepth[1]->minimum()) / c);
      break;
    case 15:
      c = ((filterCutoffCombo[1]->count() - 1.0) / 127.0);
      val = (int)round((double)filterCutoffCombo[1]->currentIndex() / c);
      break;
    case 16:
      c = ((filterSpacingCombo[1]->count() - 1.0) / 127.0);
      val = (int)round((double)filterSpacingCombo[1]->currentIndex() / c);
      break;
    case 17:
      c = ((filterTrackingCombo[1]->count() - 1.0) / 127.0);
      val = (int)round((double)filterTrackingCombo[1]->currentIndex() / c);
      break;
  }
  return(val);
}

int Gui::getModulation(int filterIndex, int objectIndex, int voiceIndex) {               

  double c;
  int val;

  val = 0; 
  if (objectIndex < 13) {
    c = (filterModSlider[filterIndex][objectIndex]->maximum() - filterModSlider[filterIndex][objectIndex]->minimum()) / 127.0;
    val = (int)round((double)(filterModSlider[filterIndex][objectIndex]->getValue(voiceIndex) - filterModSlider[filterIndex][objectIndex]->minimum()) / c);
  } else {
    val = (filterModCheckBox[filterIndex][objectIndex-13]->isChecked()) ? 127 : 0;
  }
  return(val);
}

void Gui::setVolumeTracking(int value) {

  int vStart, vEnd;
    
  model->getEditRange(vStart, vEnd);
  for (int vl = vStart; vl <= vEnd; vl++) {
    model->getVoiceData(vl)->setVolumeTracking((double)volumeTrackingSlider->value() / 1000.0);
  } 
}

void Gui::setVelocityDepth(int value) {

  int vStart, vEnd;
    
  model->getEditRange(vStart, vEnd);
  for (int vl = vStart; vl <= vEnd; vl++) {
    model->getVoiceData(vl)->setVelocityDepth((double)velocityDepthSlider->value() / 1000.0);
  } 
}

void Gui::setVolumeTrackingMidi(int voiceIndex, int value) {

  volumeTrackingSlider->setValues(voiceIndex, 1234, value);
}

void Gui::setVelocityDepthMidi(int voiceIndex, int value) {

  velocityDepthSlider->setValues(voiceIndex, 1234, value);
}
                
int Gui::getVolume(int objectType, int objectIndex, int voiceIndex) {

  double c; 
  int val;

  val = 0;
  switch (objectIndex) {
    case 0:
      c = (volumeTrackingSlider->maximum() - volumeTrackingSlider->minimum()) / 127.0;  
      val = (int)round((double)(volumeTrackingSlider->getValue(voiceIndex) - volumeTrackingSlider->minimum()) / c);
      break;
    case 1:
      c = (velocityDepthSlider->maximum() - velocityDepthSlider->minimum()) / 127.0;  
      val = (int)round((double)(velocityDepthSlider->getValue(voiceIndex) - velocityDepthSlider->minimum()) / c);
      break;
  }    
  return(val);
}                
