// ---------------------------------------------------------------------------
// - TlsUtils.cpp                                                            -
// - afnix:tls service - tls utility class implementation                    -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2015 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Time.hpp"
#include "System.hpp"
#include "Utility.hpp"
#include "TlsUtils.hpp"
#include "Exception.hpp"

namespace afnix {

  // create a random array by size and time flag

  t_byte* TlsUtils::random (const long size, const bool tflg) {
    // check the array size
    if (size < 0L) {
      throw Exception ("tls-error", "invalid random array size");
    }
    // check for nil
    if (size == 0L) return nilp;
    // allocate the array and fill it
    t_byte* result = new t_byte[size];
    for (long k = 0; k < size; k++) result[k] = Utility::byternd ();
    // eventually set the unix time in the first 4 bytes
    if (tflg == true) {
      union {
	t_quad tunx;
	t_byte tval[4];
      };
      tunx = System::qswap (Time::getuclk ());
      result[0] = tval[0];
      result[1] = tval[1];
      result[2] = tval[2];
      result[3] = tval[3];
    }
    return result;
  }
}
