/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#ifndef __GCS_HISTORY_H
#define __GCS_HISTORY_H

#include <stack>
#include "core/log-stream.h"

namespace gcs
{

    template <class T> class HistoryNavigation
    {
        public:
            HistoryNavigation(void) : m_backStack(), m_fwdStack(), m_current(),
                                      m_initialized(false) {}
            virtual ~HistoryNavigation(void) {}

            typedef T value_type;

            value_type go_back(void)
            {
                LOG("pushing onto fwd stack: " << m_current);
                m_fwdStack.push(m_current);
                m_current = m_backStack.top();
                LOG("Set m_current to: " << m_current);
                m_backStack.pop();
                return m_current;
            }

            value_type go_forward(void)
            {
                LOG("pushing onto fwd stack: " << m_current);
                m_backStack.push(m_current);
                m_current = m_fwdStack.top();
                LOG("Set m_current to: " << m_current);
                m_fwdStack.pop();
                return m_current;
            }

            void add(value_type item)
            {
                if (item != m_current)
                {
                    if (m_initialized)
                    {
                        LOG("Adding to back stack: " << m_current);
                        m_backStack.push(m_current);
                    }
                    LOG("setting m_current to " << item);
                    m_current = item;
                    // clear forward stack, since we're adding a new 'fork' for the
                    // history
                    LOG("Clearing fwd stack");
                    while (!m_fwdStack.empty())
                        m_fwdStack.pop();
                    m_initialized = true;
                }
            }

            bool has_back(void) const { return !(m_backStack.empty()); }
            bool has_forward(void) const { return !(m_fwdStack.empty()); }

            const value_type& get_last(void) { return m_backStack.top(); }
            const value_type& get_next(void) { return m_fwdStack.top(); }

            friend std::ostream& operator<<(std::ostream& out, const HistoryNavigation& hist)
            {
                return out << "History: " << hist.m_backStack.size() << " back, "
                    << hist.m_fwdStack.size() << " forward" << std::endl;
            }

        private:
            std::stack<T> m_backStack;
            std::stack<T> m_fwdStack;
            T m_current;
            bool m_initialized;
    };

} // namespace gcs

#endif // __GCS_HISTORY_H
