# Copyright (c) 2006 William Pitcock, et al.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the authors nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

use strict;
use warnings;
use utf8;

my @lines = do { open my $fh, "<names/default" or die "names/default: $!"; <$fh> };

my %begin_sym = ( );
my %medial_sym = ( );
my %end_sym = ( );
my $which = 0;

my $begin_sym_cnt = 0;
my $medial_sym_cnt = 0;
my $end_sym_cnt = 0;

my $begin_syms = "";
my $medial_syms = "";
my $end_syms = "";

for my $line (@lines) {
   chomp $line;
   
   if ($line =~ /^%/) {
      $which++;
      next;
   }
   
   $begin_sym{$line} = $line if $which == 0;
   $medial_sym{$line} = $line if $which == 1;
   $end_sym{$line} = $line if $which == 2;
};

for my $sym (keys %begin_sym) {
   $begin_syms .= "\t\"$sym\",\n";
   $begin_sym_cnt++;
};

for my $sym (keys %medial_sym) {
   $medial_syms .= "\t\"$sym\",\n";
   $medial_sym_cnt++;
};

for my $sym (keys %end_sym) {
   $end_syms .= "\t\"$sym\",\n";
   $end_sym_cnt++;
};

print <<EOF;
/* Autogenerated by gen_namegen_tab.pl. Do not modify! */
#ifndef _NAMEGEN_H
#define _NAMEGEN_H

const char *begin_sym[] = {
$begin_syms};

#define BEGIN_SYM_SZ $begin_sym_cnt

const char *medial_sym[] = {
$medial_syms};

#define MEDIAL_SYM_SZ $medial_sym_cnt

const char *end_sym[] = {
$end_syms};

#define END_SYM_SZ $end_sym_cnt

#endif
EOF
