/*
// $Id: //open/dev/farrago/src/org/eigenbase/util/CancelFlag.java#4 $
// Package org.eigenbase is a class library of data management components.
// Copyright (C) 2008-2009 The Eigenbase Project
// Copyright (C) 2008-2009 SQLstream, Inc.
// Copyright (C) 2008-2009 LucidEra, Inc.
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package org.eigenbase.util;

/**
 * CancelFlag is used to post and check cancellation requests.
 *
 * @author John Sichi
 * @version $Id: //open/dev/farrago/src/org/eigenbase/util/CancelFlag.java#4 $
 */
public class CancelFlag
{
    //~ Instance fields --------------------------------------------------------

    private boolean cancelRequested;

    //~ Methods ----------------------------------------------------------------

    /**
     * @return whether a cancellation has been requested
     */
    public boolean isCancelRequested()
    {
        return cancelRequested;
    }

    /**
     * Requests a cancellation.
     */
    public void requestCancel()
    {
        cancelRequested = true;
    }

    /**
     * Clears any pending cancellation request.
     */
    public void clearCancel()
    {
        cancelRequested = false;
    }
}

// End CancelFlag.java
