/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __SHORTBONDEDINTERACTIONCPDATA_H
#define __SHORTBONDEDINTERACTIONCPDATA_H

// --- Project includes ---
#include "Model/BondedInteractionCpData.h"

// --- IO includes ---
#include <iostream>

using std::istream;
using std::ostream;

class CShortBondedInteraction;

/*!
  Helper class for checkpointing ShortBondedInteraction data
*/ 
class  ShortBondedInteractionCpData : public BondedInteractionCpData
{
 private:
  double m_r0;
  
 public:
  ShortBondedInteractionCpData();
  ShortBondedInteractionCpData(int,int,int,double);
  ShortBondedInteractionCpData(const CShortBondedInteraction&);

  virtual ~ShortBondedInteractionCpData(){}
  
  virtual void saveCheckPointData(ostream&);
  virtual void loadCheckPointData(istream&);
};
#endif // __SHORTBONDEDINTERACTIONCPDATA_H
