#!/usr/bin/perl
######################################################################
## Time-stamp: <January 20, 2004 5:09 PM -- Bruce Ravel>
my $cvs_info = '$Id:$ ';
######################################################################
##  This program is copyright (c) 2001 Bruce Ravel
##  <ravel@phys.washington.edu>
##  http://feff.phys.washington.edu/~ravel/
##
## -------------------------------------------------------------------
##     All rights reserved. This program is free software; you can
##     redistribute it and/or modify it under the same terms as Perl
##     itself.
##
##     This program is distributed in the hope that it will be useful,
##     but WITHOUT ANY WARRANTY; without even the implied warranty of
##     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##     Artistic License for more details.
## -------------------------------------------------------------------
######################################################################

BEGIN {
  my $extra_INC =		# Set this if you have Atoms installed
    "/home/bruce/perl";		# outside of Perl's normal search path
  ($extra_INC) and unshift @INC, $extra_INC;
}


use strict;
use constant PI    => 4 * atan2 1, 1;
use constant HBARC => 1973.27053324;
use Chemistry::Formula qw(parse_formula formula_data);
use Xray::Absorption;
Xray::Absorption -> load("Elam");
use CGI;			# load CGI routines
use CGI::Carp 'fatalsToBrowser';
$CGI::POST_MAX=1024 * 1000;	# max 1M posts
my $q = new CGI;		# create new CGI object


my $version        = (split(' ', $cvs_info))[2] || "0.04";
my $date           = (split(' ', $cvs_info))[3] || "14 May 2002";
my $bruce_home     = "http://feff.phys.washington.edu/~ravel/";
my $formula_url    = $bruce_home . "software/Formula/";
my $absorption_url = $bruce_home . "software/Absorption/";
my (%formula, %density);
&formula_data(\%formula, \%density);
my @formulas       = sort (keys %formula);
unshift @formulas, "";
my $answer         = "";
my $run            = 1;


my $table_row      = {qw(align CENTER valign CENTER)};
my $table_params   = {qw(border 1 cellspacing 0 cellpadding 5
			 align CENTER width 85% bgcolor white)};
my $table_top      = {qw(align center bgcolor #000077)};
my $table_top_span = {qw(align center bgcolor #000077 colspan 3)};



my $params;
if ($q->param('debug')) {
  foreach my $key ($q->param) {
    $params .= $q->b("$key -> ") . $q->param($key) . $q->br;
  };
};
if ($q->param('special')) {
  $q->param(formula=>$formula{$q->param('special')});
  $q->param(density=>$density{$q->param('special')});
  #$q->param(special=>"");
};
($q->param('formula')) and &parse_it; #($q->param('formula'), \%count);

print $q->header,			# create the HTTP header
  $q->start_html(-title=>'Absorption of X-rays by Materials',
		 -bgcolor=>'white',
		 -meta=>{'copyright'=>'copyright 2001-2002 Bruce Ravel'}
		),
  $q->h1({align=>'CENTER'}, 'Absorption of X-rays by Materials');

print $q->p({align=>"center"},
	    "This page will compute the absorption length. i.e. the thickness which will attenuate the x-ray beam e-fold, of a
material at a given energy given the chemical formula and density of
that material."),
  $q->p({align=>"center"}, "Specify a chemical formula and supply the density" .
	$q->br .
	"OR" .
	$q->br .
	"Select a material from the list of materials commonly found at a synchrotron") ,


  $q->startform(),

  ## data entry table
  $q->table($table_params,
	    $q->Tr($table_row,
		   $q->td($table_top_span,
			  $q->font({-color=>"white"},
				   $q->strong($q->font({size=>'+1'},
						       "Data entry"))),
			 )),
	    $q->Tr($table_row,
		   $q->td(
			  $q->strong("Formula: ") .
			  $q->textfield(-name=>'formula', -size=>50,
					-default=>"") .

			  $q->p .

			  $q->strong("Density: ") .
			  $q->textfield(-name=>'density', -size=>10,
					-default=>"")),
		   $q->td($q->strong($q->font({color=>"#990099", size=>'+2'},"OR"))),
		   $q->td(
			  $q->strong("Known Compounds: ") .
			  $q -> br .
			  $q->popup_menu(-name=>'special',
					 -default=>"",
					 -values=>[@formulas]))),
	    $q->Tr($table_row,
		   $q->td({colspan=>3},
			  $q->strong("Photon Energy: ") .
			  $q->textfield(-name=>'energy', -size=>6,
					-default=>9000) .
			  '&nbsp;' .
			  $q->popup_menu(-name=>'units',
					 -default=>"eV",
					 -values=>[qw(eV keV Angstrom)]) .
			  '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' .
			  $q->submit(-name=>'Compute',
				     -value=>'Compute') .
			  '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' .
			  $q->defaults(-name=>'Reset',
				       -value=>'Reset')

			 ),

		   ),
	   ),

  $q->p();

($answer) and
  print
  ## results of calculation
  $q->table($table_params,
	    $q->Tr($table_row,
		   $q->td($table_top,
			  $q->font({-color=>"white"},
				   $q->strong($q->font({size=>'+1'},"Results"))),
			 )),
	    (($params) ? $q->Tr($table_row, $q->td([$params])) : ()),
	    $q->Tr($table_row, $q->td([$answer])),
			 );

print
  $q->endform,

  ## bottom of page
  $q->hr(),
  $q->p("This web page isn't the most brilliant bit of programming.  If you want to specify your own compound and density, you need to select the blank item from the list of known compounds."),
  $q->hr(),
  $q->p({-align=>'right'},
	$q->small("formula.cgi version $version ($date), copyright &copy; 2001-2002 Bruce Ravel")),
  $q->p({-align=>'right'},
	$q->small("This cgi script uses the " .
		  $q->a({href=>$formula_url}, "Chemistry::Formula") .
		  " and " .
		  $q->a({href=>$absorption_url}, "Xray::Absorption") .
		  " perl modules.")),
  $q->p({-align=>'right'},
	$q->small($q->a({href=>$bruce_home}, "Bruce's homepage"))),
  $q->end_html, $/; # end the HTML


## parse formula and compute absorption.  Load results into $answer.
sub parse_it {
  my %count;
  unless ($q->param('formula')) {
    $answer = $q->pre("No formula given.\n");
    return;
  };
  my $ok = parse_formula($q->param('formula'), \%count);
  my $energy = $q->param('energy');
  ($q->param("units") eq "keV") and ($energy *= 1000);
  ($q->param("units") eq "Angstrom") and ($energy = 2*PI*HBARC / $energy);
  if ($ok) {
    #my ($weight, $xsec) = (0,0);
    my $dens = ($q->param('density') =~ /^(\d+\.?\d*|\.\d+)$/)
		? $q->param('density') : 0;
    my @list;
    my ($barns_per_formula_unit, $amu_per_formula_unit) = (0,0);
    foreach my $k (sort (keys(%count))) {
       if ($count{$k} > 0.001) {
	 push @list, $q->td({-align=>'center'}, [$k, sprintf("%6.3f", $count{$k})]);
       } else {
	 push @list, $q->td({-align=>'center'}, [$k, sprintf("%6g", $count{$k})]);
       };
       ## $weight  += Xray::Absorption -> get_atomic_weight($k) * $count{$k};
       $barns_per_formula_unit += Xray::Absorption -> cross_section($k, $energy) * $count{$k};
       $amu_per_formula_unit += Xray::Absorption -> get_atomic_weight($k) * $count{$k};
       ##       my $scale = ($q->param('density'))
       ## 	? Xray::Absorption -> get_conversion($k) : 1;
       ##       $xsec    +=
       ## 	Xray::Absorption ->
       ## 	  cross_section($k, $energy) * $count{$k} / $scale;
    };
    ## 1 amu = 1.6607143 x 10^-24 gm
    $xsec = $barns_per_formula_unit / $amu_per_formula_unit / 1.6607143;
    if ($xsec == 0) {
      $answer .= $q->p("The energy is too low or was not provided.  The absorption calculation was skipped.");
    } else {
      $xsec *= $dens;
      if ($xsec > 0) {
	my $length = (10000/$xsec > 500) ? sprintf("%.3f cm", 1/$xsec) :
	  sprintf("%.1f micron", 10000/$xsec);
	$answer .= $q->p("One absorbtion length is approximately " .
			 $q->strong($q->font({color=>"red"}, $length)) .
			 " at " .
			 sprintf("%.2f eV",  $energy));
      } else {
	$answer .= $q->p("The absorption length calculation\nrequires a value for density.");
      };
    };
    $answer .= $q->table($q->th(["element", "number"]),
			 $q->Tr(\@list)
			);
    ## $answer .= $q->p(sprintf("This weighs %.3f amu per formula
    ## unit.", $weight));
  } else {
    $answer = "\Input error: ".$count{error};
  };
};
