/**
 * \file pappsomspp/processing/cbor/psm/psmproteinmap.h
 * \date 05/07/2025
 * \author Olivier Langella
 * \brief PAPPSO CBOR protein map
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include <map>
#include <QString>
#include "../../../protein/protein.h"
#include "../cborstreamwriter.h"
#include "../cborstreamreader.h"


namespace pappso::cbor::psm
{

struct PsmProtein
{
  std::shared_ptr<Protein> protein_sp = nullptr;
  bool isTarget                       = true;
  bool isContaminant                  = false;
  QCborMap cborEval;
};
/**
 * @todo write docs
 */
class PsmProteinMap
{
  public:
  /**
   * Default constructor
   */
  PsmProteinMap();

  /**
   * Destructor
   */
  virtual ~PsmProteinMap();

  std::pair<std::map<QString, pappso::cbor::psm::PsmProtein>::iterator, bool>
  insert(const PsmProtein &psm_protein);

  void writeMap(CborStreamWriter &writer) const;

  void readMap(CborStreamReader &reader);

  std::size_t size() const;

  const pappso::cbor::psm::PsmProtein &getByAccession(const QString &accession) const;

  private:
  std::map<QString, PsmProtein> m_proteinMap;
};
} // namespace pappso::cbor::psm
