/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2007-2019 PCOpt/NTUA
    Modified code Copyright (C) 2013-2019 FOSS GP
    Modified code Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.


Class
    Foam::objectiveManagerIncompressible

Description
    class for managing incompressible objective functions.

SourceFiles
    objectiveManagerIncompressible.C

\*---------------------------------------------------------------------------*/

#ifndef objectiveManagerIncompressible_H
#define objectiveManagerIncompressible_H

#include "objectiveManager.H"
#include "objectiveIncompressible.H"
#include "runTimeSelectionTables.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
               Class objectiveManagerIncompressible Declaration
\*---------------------------------------------------------------------------*/

class objectiveManagerIncompressible
:
    public objectiveManager
{
private:

    // Private Member Functions

        //- Disallow default bitwise copy construct
        objectiveManagerIncompressible
        (
            const objectiveManagerIncompressible&
        ) = delete;

        //- Disallow default bitwise assignment
        void operator=(const objectiveManagerIncompressible&) = delete;


public:

    TypeName("objectiveManagerIncompressible");

    // Constructors

        //- Construct from components
        objectiveManagerIncompressible
        (
            const fvMesh& mesh,
            const dictionary& dict,
            const word& adjointSolverName,
            const word& primalSolverName
        );


    //- Destructor
    virtual ~objectiveManagerIncompressible() = default;


    // Member Functions

        //- Add contribution to adjoint momentum PDEs
        virtual void addUaEqnSource(fvVectorMatrix& UaEqn);

        //- Add contribution to adjoint momentum PDEs
        virtual void addPaEqnSource(fvScalarMatrix& paEqn);

        //- Add contribution to adjoint turbulence model PDE
        virtual void addTMEqn1Source(fvScalarMatrix& adjTMEqn1);

        //- Add contribution to adjoint turbulence model PDE
        virtual void addTMEqn2Source(fvScalarMatrix& adjTMEqn2);
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
