/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _FLOAT_HALF_CONVERTER_P_H_
#define _FLOAT_HALF_CONVERTER_P_H_

#include <GTLCore/Export.h>

namespace GTLCore {
  typedef unsigned short half;
};

/**
 * @internal
 * This function convert from half to float. It's private to OpenGTL, if
 * you want to use half channels in your application, you are invited to
 * use IlmBase (http://www.openexr.com/).
 * 
 * @ingroup GTLCore
 */
GTLCORE_EXPORT float half2float( GTLCore::half v );
/**
 * @internal
 * This function convert from float to half. It's private to OpenGTL, if
 * you want to use half channels in your application, you are invited to
 * use IlmBase (http://www.openexr.com/).
 * 
 * @ingroup GTLCore
 */
GTLCORE_EXPORT GTLCore::half float2half( float f );

#endif
