/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLFRAGMENT_LEXER_P_H_
#define _GTLFRAGMENT_LEXER_P_H_

#include <GTLCore/LexerBase_p.h>
#include <GTLFragment/Export.h>
#include "Library.h"

namespace GTLCore {
  class Token;
}

namespace GTLFragment {
  /**
   * @internal
   * @ingroup GTLFragment
   *
   * Lexer for Shiva kernels and Rijn sketches
   */
  class GTLFRAGMENT_EXPORT Lexer : public GTLCore::LexerBase {
    public:
      /**
       * Creates a new lexer with the given stream.
       * @code
       *  std::istringstream iss(sourceCode);
       *  OpenShiva::Lexer lng( &iss);
       * @endcode
       */
      Lexer(std::istream* sstream, Library::Type type);
      ~Lexer();
    public:
      /**
       * @return the next token
       */
      GTLCore::Token nextToken();
      Library::Type m_type;
  };
}

#endif
