/*
 *  Copyright (c) 2008, 2009 Cyrille Berger <cberger@cberger.net>
 *  Copyright (c) 2009 Matthew Woehlke <mw_triad@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __STDC_LIMIT_MACROS
  # define __STDC_LIMIT_MACROS
#endif
# include <stdlib.h>
#include <math.h>

#include "rand_salt.h"
#include "GTLCore/StdTypes.h"
#include "OpenShiva/Export.h"

inline gtl_uint64 permuteWhole(gtl_uint64 n, gtl_uint64 a, gtl_uint64 b)
{
  return ((n * a) + b);
}

inline gtl_uint64 part(gtl_uint64 n1, gtl_uint64 n2, int p)
{
  int b = p * 8;
  int i = (n1 >> b) & 0xFF;
  int j = (n2 >> b) & 0xFF;
  return gtl_uint64(salt[i][j]) << b;
}


gtl_uint64 random64At(gtl_int64 x, gtl_int64 y, gtl_int64 seed)
{
  const gtl_uint64 kxa = 427140578808118991LL;
  const gtl_uint64 kya = 166552399647317237LL;
  const gtl_uint64 kxb = 48058817213113801LL;
  const gtl_uint64 kyb = 9206429469018994469LL;

  // Generate salts
  gtl_uint64 n1 = (gtl_uint64(x + 5) * kxa) * seed;
  gtl_uint64 n2 = (gtl_uint64(y + 7) * kya) + (seed * 1040097393733LL);
  n1 = permuteWhole(n1, 8759824322359LL, 13);
  n2 = permuteWhole(n2, 200560490131LL, 2707);
  n1 = (n1 >> 32) ^ (n1 << 32);
  n2 = (n2 >> 32) ^ (n2 << 32);
  n1 ^= x ^ (gtl_uint64(y ^ seed) * kyb);
  n2 ^= y ^ (gtl_uint64(x + 13)   * kxb);

  // Combine salts
  gtl_uint64 v = 0;
  for (int p = 0; p < 8; ++p)
      v |= part(n1, n2, p);
  return v;
}

extern "C" {
  OPENSHIVA_EXPORT float floatRandomAt(gtl_int32 x, gtl_int32 y, gtl_int32 seed)
  {
    gtl_uint64 r = random64At(x, y, seed);
    float v = r / (float)UINT64_MAX;
    return v;
  }

  OPENSHIVA_EXPORT gtl_int32 intRandomAt(gtl_int32 x, gtl_int32 y, gtl_int32 seed)
  {
    return random64At(x, y, seed);
  }
}