# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1501-1 (dspam)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60435);
 script_cve_id("CVE-2007-6418");
 script_version ("$");
 script_tag(name:"cvss_base", value:"2.1");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1501-1 (dspam)";
 script_name(name);

 desc = "The remote host is missing an update to dspam
announced via advisory DSA 1501-1.

Tobias Gruetzmacher discovered that a Debian-provided CRON script in dspam,
a statistical spam filter, included a database password on the command line
when using the MySQL backend. This allowed a local attacker to read the
contents of the dspam database, such as emails.

For the stable distribution (etch), this problem has been fixed in version
3.6.8-5etch1. Packages for the mipsel architecture will be added as soon
as they become available.

The old stable distribution (sarge) does not contain the dspam package.

For the unstable distribution (sid), this problem has been fixed in
version 3.6.8-5.1.


We recommend that you upgrade your dspam package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201501-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1501-1 (dspam)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"dspam-doc", ver:"3.6.8-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dspam-webfrontend", ver:"3.6.8-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdspam7", ver:"3.6.8-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdspam7-drv-mysql", ver:"3.6.8-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdspam7-drv-pgsql", ver:"3.6.8-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdspam7-dev", ver:"3.6.8-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdspam7-drv-db4", ver:"3.6.8-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dspam", ver:"3.6.8-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdspam7-drv-sqlite3", ver:"3.6.8-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
