#
#VID ad4f6ca4-6720-11d8-9fb5-000a95bc6fae
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52510);
 script_bugtraq_id(9712);
 script_cve_id("CVE-2004-0158");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: lbreakout2";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: lbreakout2

CVE-2004-0158
Buffer overflow in lbreakout2 allows local users to gain 'games' group
privileges via a large HOME environment variable to (1) editor.c, (2)
theme.c, (3) manager.c, (4) config.c, (5) game.c, (6) levels.c, or (7)
main.c.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.debian.org/security/2004/dsa-445
http://www.securityfocus.com/archive/1/354760
http://www.vuxml.org/freebsd/ad4f6ca4-6720-11d8-9fb5-000a95bc6fae.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: lbreakout2";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"lbreakout2");
if(!isnull(bver) && revcomp(a:bver, b:"2.2.2_1")<=0) {
    security_note(0, data:"Package lbreakout2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
