###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for ncpfs FEDORA-2010-1168
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861734);
  script_version("$Revision: 7426 $: 1.0");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2010-1168");
  script_cve_id("CVE-2009-3297");
  script_name("Fedora Update for ncpfs FEDORA-2010-1168");
  desc = "

  Vulnerability Insight:
  Ncpfs is a filesystem which understands the Novell NetWare(TM) NCP
  protocol.  Functionally, NCP is used for NetWare the way NFS is used
  in the TCP/IP world.  For a Linux system to mount a NetWare
  filesystem, it needs a special mount program.  The ncpfs package
  contains such a mount program plus other tools for configuring and
  using the ncpfs filesystem.
  
  Install the ncpfs package if you need to use the ncpfs filesystem
  to use Novell NetWare files or services.


  Affected Software/OS:
  ncpfs on Fedora 11

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-January/034422.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ncpfs");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC11")
{

  if(isrpmvuln(pkg:"ncpfs", rpm:"ncpfs~2.2.6~12.fc11", rls:"FC11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}