###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for drakx-net MDKA-2007:091 (drakx-net)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830292);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDKA", value: "2007:091");
  script_name( "Mandriva Update for drakx-net MDKA-2007:091 (drakx-net)");
  desc = "

  Vulnerability Insight:

  Drakroam could erroneusly detect and reset the wireless mode to Master,
  instead of Managed. (bug 30303)
  
  Draksambashare would check shares' names for partial matches,
  preventing the use of a share name partially equal to another. (bug
  30099)
  
  Draknfs and draksambashare were using the wrong translation text
  domain, making these tools show only english interfaces. (bug 33221)
  
  Updated packages fix these issues.
  
  Net_applet was also improved to always show interfaces in left-click
  menu, and to not show empty menus.

  Affected Software/OS:
  drakx-net on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-10/msg00003.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of drakx-net");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"drakx-net", rpm:"drakx-net~0.12~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"drakx-net-text", rpm:"drakx-net-text~0.12~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdrakx-net", rpm:"libdrakx-net~0.12~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}