###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_xvid_detect_win.nasl 2632 2009-06-03 14:50:37Z jun $
#
# Xvid Version Detection (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800579);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Xvid Version Detection (Win)");
  desc = "
  Overview : This script retrieves Xvid version for Windows and saves the
  result in KB.

  Risk factor : None";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_summary("Set Version of Xvid in KB for Windows");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  xvidName = registry_get_sz(key:key +item, item:"DisplayName");
  if(xvidName =~ "Xvi[D|d]")
  {
    xvidVer = eregmatch(pattern:"Xvi[d|D].*([0-9]\.[0-9]\.[0-9]+)", string:xvidName);
    if(xvidVer[1] != NULL){
      set_kb_item(name:"Xvid/Win/Ver", value:xvidVer[1]);
      security_note(data:"Xvid version " + xvidVer[1] + " was detected on the host");
    }
    exit(0);
  }
}
