#
# Josh Zlatin-Amishav (josh at ramat dot cc)
# GPLv2
# Modified by Michael Meyer <michael.meyer@intevation.de>

 desc = "
Synopsis :

The remote host has a patch management software installed on it.

Description :

This script uses Windows credentials to detect whether the remote host
is running Patchlink and extracts the version number if so. 

Patchlink is a fully Internet-based, automated, cross-platform, security
patch management system. 

See also : 
http://www.patchlink.com/

Risk Factor: 
None";

if(description)
{
 script_id(80039);
 script_version("$Revision: 1.2 $");
 script_tag(name:"risk_factor", value:"None");
 name = "Patchlink Detection";
 script_name(name);
 script_description(desc);
 summary = "Checks for the presence of Patchlink";
 script_summary(summary);
 script_category(ACT_GATHER_INFO);
 script_copyright("Copyright (C) 2005 Josh Zlatin-Amishav and Tenable Network Security");
 family = "Windows";
 script_family(family);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(get_kb_item("SMB/samba"))exit(0);

key = "SOFTWARE\PatchLink\Agent Installer";

if(!registry_key_exists(key:key)){
 exit(0);
} 

version = registry_get_sz(item:"Version", key:key);

if (version)
{
  info = string("Patchlink version ", version, " is installed on the remote host.");

  report = string (desc,
		"\n\nPlugin output :\n\n",
		info);

  security_note(port:port, data:report);

  set_kb_item(name:"SMB/Patchlink/version", value:version);
}

exit(0);
