##############################################################################
#
#  Simple Machines Forum Password Reset Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/17
#
#  Revision: 1.1
#
#  Log: ssharath
#  Issue #0176
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900118);
 script_cve_id("CVE-2008-6971");
 script_bugtraq_id(31053);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_tag(name:"cvss_base", value:"6.4");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_name("Simple Machines Forum Password Reset Vulnerability");
 script_summary("Check for the vulnerable version of Simple Machines");
 desc = "
 Overview : The host has Simple Machines Forum, which is prone to security
 bypass vulnerability.

 Vulnerability Insight :

        The vulnerability exists due to the application generating weak
        validation codes for the password reset functionality which allows
        for easy validation code guessing attack. 

        Impact: Attackers can guess the validation code and reset the user
        password to the one of their choice. 

 Impact Level : Application

 Affected Software/OS : 
        Simple Machines Forum versions prior to 1.1.6 on 

 Fix : Update to version 1.1.6
 http://download.simplemachines.org/

 References :
 http://milw0rm.com/exploits/6392
 http://secunia.com/advisories/31750/
 http://www.simplemachines.org/community/index.php?topic=260145.0

 CVSS Score :
        CVSS Base Score      : 6.4 (AV:N/AC:L/Au:NR/C:P/I:P/A:N)
        CVSS  Temporal Score : 5.0
 Risk factor : Medium";

 script_description(desc);
 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


 include("http_func.inc");
 include("http_keepalive.inc");

 port = get_http_port(default:80);
 if(!port){
        exit(0);
 }

 foreach path (make_list("/sm_forum", cgi_dirs()))
 {
        sndReq = http_get(item:string(path, "/index.php"), port:port);
        rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
        if(rcvRes == NULL){
                exit(0);
        }

	if(egrep(pattern:"sm_forum", string:rcvRes) &&
           egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
	{
		if(egrep(pattern:"SMF (1\.0(\..*)?|1\.1(\.[0-5])?)[^.0-9]",
			 string:rcvRes)){
			security_hole(port);
		} 
		exit(0);
       }
 }
