###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tfm_mmplayer_detect.nasl 3596 2009-07-23 16:25:02Z jul $
#
# TFM MMPlayer Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900596);
  script_version("$Revision: 1.0$");
  script_tag(name:"risk_factor", value:"None");
  script_name("TFM MMPlayer Version Detection");
  desc = "
  Overview: This script detects the version of TFM MMPlayer and
  sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets KB for the version of TFM MMPlayer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

tfmKey = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\MMPlayer_is1";
tfmName = registry_get_sz(key:tfmKey, item:"DisplayName");

if("MMPlayer" >< tfmName)
{
  tfmPath = registry_get_sz(key:tfmKey, item:"UninstallString");
  tfmPath = ereg_replace(pattern:'\"(.*)\"', replace:"\1", string:tfmPath);

  if(tfmPath != NULL)
  {
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:tfmPath);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                        string:tfmPath - "\unins000.exe" + "\MMPlayer.exe");
    # Get the version of .exe file
    mmplayerVer = GetVer(file:file, share:share);

    if(mmplayerVer != NULL){
      set_kb_item(name:"TFM/MMPlayer/Ver", value:mmplayerVer);
      security_note(data:"TFM MMPlayer version " + mmplayerVer +
                         " was detected on the host");
    }
  }
}
