/* valagvariantmodule.c generated by valac, the Vala compiler
 * generated from valagvariantmodule.vala, do not modify */

/* valagvariantmodule.vala
 *
 * Copyright (C) 2010-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_GVARIANT_MODULE_TYPE_BASIC_TYPE_INFO (vala_gvariant_module_basic_type_info_get_type ())
typedef struct _ValaGVariantModuleBasicTypeInfo ValaGVariantModuleBasicTypeInfo;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGVariantModuleBasicTypeInfo {
	const gchar* signature;
	const gchar* type_name;
	gboolean is_string;
};


static gpointer vala_gvariant_module_parent_class = NULL;

static GType vala_gvariant_module_basic_type_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGVariantModuleBasicTypeInfo* vala_gvariant_module_basic_type_info_dup (const ValaGVariantModuleBasicTypeInfo* self);
static void vala_gvariant_module_basic_type_info_free (ValaGVariantModuleBasicTypeInfo* self);
static gboolean vala_gvariant_module_is_string_marshalled_enum (ValaTypeSymbol* symbol);
static gchar* vala_gvariant_module_get_dbus_value (ValaGVariantModule* self,
                                            ValaEnumValue* value,
                                            const gchar* default_value);
static gboolean vala_gvariant_module_get_basic_type_info (ValaGVariantModule* self,
                                                   const gchar* signature,
                                                   ValaGVariantModuleBasicTypeInfo* basic_type);
static void vala_gvariant_module_real_visit_enum (ValaCodeVisitor* base,
                                           ValaEnum* en);
static gboolean vala_gvariant_module_real_generate_enum_declaration (ValaCCodeBaseModule* base,
                                                              ValaEnum* en,
                                                              ValaCCodeFile* decl_space);
static ValaCCodeExpression* vala_gvariant_module_get_array_length (ValaGVariantModule* self,
                                                            ValaCCodeExpression* expr,
                                                            gint dim);
static ValaCCodeExpression* vala_gvariant_module_generate_enum_value_from_string (ValaGVariantModule* self,
                                                                           ValaEnumValueType* type,
                                                                           ValaCCodeExpression* expr,
                                                                           ValaCCodeExpression* error_expr);
static ValaCCodeExpression* vala_gvariant_module_deserialize_basic (ValaGVariantModule* self,
                                                             ValaGVariantModuleBasicTypeInfo* basic_type,
                                                             ValaCCodeExpression* variant_expr,
                                                             gboolean transfer);
static ValaCCodeExpression* vala_gvariant_module_deserialize_array (ValaGVariantModule* self,
                                                             ValaArrayType* array_type,
                                                             ValaCCodeExpression* variant_expr,
                                                             ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_gvariant_module_deserialize_buffer_array (ValaGVariantModule* self,
                                                                    ValaArrayType* array_type,
                                                                    ValaCCodeExpression* variant_expr,
                                                                    ValaCCodeExpression* expr);
static void vala_gvariant_module_deserialize_array_dim (ValaGVariantModule* self,
                                                 ValaArrayType* array_type,
                                                 gint dim,
                                                 const gchar* temp_name,
                                                 ValaCCodeExpression* variant_expr,
                                                 ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_gvariant_module_deserialize_struct (ValaGVariantModule* self,
                                                              ValaStruct* st,
                                                              ValaCCodeExpression* variant_expr);
static ValaCCodeExpression* vala_gvariant_module_deserialize_hash_table (ValaGVariantModule* self,
                                                                  ValaObjectType* type,
                                                                  ValaCCodeExpression* variant_expr);
static ValaCCodeExpression* vala_gvariant_module_real_deserialize_expression (ValaCCodeBaseModule* base,
                                                                       ValaDataType* type,
                                                                       ValaCCodeExpression* variant_expr,
                                                                       ValaCCodeExpression* expr,
                                                                       ValaCCodeExpression* error_expr,
                                                                       gboolean* may_fail);
static ValaCCodeExpression* vala_gvariant_module_generate_enum_value_to_string (ValaGVariantModule* self,
                                                                         ValaEnumValueType* type,
                                                                         ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_gvariant_module_serialize_basic (ValaGVariantModule* self,
                                                           ValaGVariantModuleBasicTypeInfo* basic_type,
                                                           ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_gvariant_module_serialize_array (ValaGVariantModule* self,
                                                           ValaArrayType* array_type,
                                                           ValaCCodeExpression* array_expr);
static ValaCCodeExpression* vala_gvariant_module_serialize_buffer_array (ValaGVariantModule* self,
                                                                  ValaArrayType* array_type,
                                                                  ValaCCodeExpression* array_expr);
static ValaCCodeExpression* vala_gvariant_module_serialize_array_dim (ValaGVariantModule* self,
                                                               ValaArrayType* array_type,
                                                               gint dim,
                                                               ValaCCodeExpression* array_expr,
                                                               ValaCCodeExpression* array_iter_expr);
static ValaCCodeExpression* vala_gvariant_module_serialize_struct (ValaGVariantModule* self,
                                                            ValaStruct* st,
                                                            ValaCCodeExpression* struct_expr);
static ValaCCodeExpression* vala_gvariant_module_serialize_hash_table (ValaGVariantModule* self,
                                                                ValaObjectType* type,
                                                                ValaCCodeExpression* hash_table_expr);
static ValaCCodeExpression* vala_gvariant_module_real_serialize_expression (ValaCCodeBaseModule* base,
                                                                     ValaDataType* type,
                                                                     ValaCCodeExpression* expr);

static const ValaGVariantModuleBasicTypeInfo VALA_GVARIANT_MODULE_basic_types[12] = {{"y", "byte", FALSE}, {"b", "boolean", FALSE}, {"n", "int16", FALSE}, {"q", "uint16", FALSE}, {"i", "int32", FALSE}, {"u", "uint32", FALSE}, {"x", "int64", FALSE}, {"t", "uint64", FALSE}, {"d", "double", FALSE}, {"s", "string", TRUE}, {"o", "object_path", TRUE}, {"g", "signature", TRUE}};

static gboolean
vala_gvariant_module_is_string_marshalled_enum (ValaTypeSymbol* symbol)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if (symbol != NULL) {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_ENUM);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = vala_code_node_get_attribute_bool ((ValaCodeNode*) symbol, "DBus", "use_string_marshalling", FALSE);
		return result;
	}
	result = FALSE;
	return result;
}


static gchar*
vala_gvariant_module_get_dbus_value (ValaGVariantModule* self,
                                     ValaEnumValue* value,
                                     const gchar* default_value)
{
	gchar* result = NULL;
	gchar* dbus_value = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (default_value != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) value, "DBus", "value", NULL);
	dbus_value = _tmp0_;
	_tmp1_ = dbus_value;
	if (_tmp1_ != NULL) {
		result = dbus_value;
		return result;
	}
	_tmp2_ = g_strdup (default_value);
	result = _tmp2_;
	_g_free0 (dbus_value);
	return result;
}


gchar*
vala_gvariant_module_get_dbus_signature (ValaSymbol* symbol)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) symbol, "DBus", "signature", NULL);
	result = _tmp0_;
	return result;
}


static gboolean
vala_gvariant_module_get_basic_type_info (ValaGVariantModule* self,
                                          const gchar* signature,
                                          ValaGVariantModuleBasicTypeInfo* basic_type)
{
	ValaGVariantModuleBasicTypeInfo _vala_basic_type = {0};
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (signature != NULL) {
		{
			ValaGVariantModuleBasicTypeInfo* info_collection = NULL;
			gint info_collection_length1 = 0;
			gint _info_collection_size_ = 0;
			gint info_it = 0;
			info_collection = VALA_GVARIANT_MODULE_basic_types;
			info_collection_length1 = G_N_ELEMENTS (VALA_GVARIANT_MODULE_basic_types);
			for (info_it = 0; info_it < info_collection_length1; info_it = info_it + 1) {
				ValaGVariantModuleBasicTypeInfo info = {0};
				info = info_collection[info_it];
				{
					ValaGVariantModuleBasicTypeInfo _tmp0_;
					const gchar* _tmp1_;
					_tmp0_ = info;
					_tmp1_ = _tmp0_.signature;
					if (g_strcmp0 (_tmp1_, signature) == 0) {
						ValaGVariantModuleBasicTypeInfo _tmp2_;
						_tmp2_ = info;
						_vala_basic_type = _tmp2_;
						result = TRUE;
						if (basic_type) {
							*basic_type = _vala_basic_type;
						}
						return result;
					}
				}
			}
		}
	}
	memset (&_vala_basic_type, 0, sizeof (ValaGVariantModuleBasicTypeInfo));
	result = FALSE;
	if (basic_type) {
		*basic_type = _vala_basic_type;
	}
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally11;
	__catch11_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}


gchar*
vala_gvariant_module_get_type_signature (ValaDataType* datatype,
                                         ValaSymbol* symbol)
{
	gchar* result = NULL;
	ValaArrayType* array_type = NULL;
	ValaArrayType* _tmp2_;
	ValaArrayType* _tmp3_;
	g_return_val_if_fail (datatype != NULL, NULL);
	if (symbol != NULL) {
		gchar* sig = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = vala_gvariant_module_get_dbus_signature (symbol);
		sig = _tmp0_;
		_tmp1_ = sig;
		if (_tmp1_ != NULL) {
			result = sig;
			return result;
		}
		_g_free0 (sig);
	}
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (datatype, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) datatype) : NULL);
	array_type = _tmp2_;
	_tmp3_ = array_type;
	if (_tmp3_ != NULL) {
		gchar* element_type_signature = NULL;
		ValaArrayType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		ValaArrayType* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp4_ = array_type;
		_tmp5_ = vala_array_type_get_element_type (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_gvariant_module_get_type_signature (_tmp6_, NULL);
		element_type_signature = _tmp7_;
		_tmp8_ = element_type_signature;
		if (_tmp8_ == NULL) {
			result = NULL;
			_g_free0 (element_type_signature);
			_vala_code_node_unref0 (array_type);
			return result;
		}
		_tmp9_ = array_type;
		_tmp10_ = vala_array_type_get_rank (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strnfill ((gsize) _tmp11_, 'a');
		_tmp13_ = _tmp12_;
		_tmp14_ = element_type_signature;
		_tmp15_ = g_strconcat (_tmp13_, _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp13_);
		result = _tmp16_;
		_g_free0 (element_type_signature);
		_vala_code_node_unref0 (array_type);
		return result;
	} else {
		ValaTypeSymbol* _tmp17_;
		ValaTypeSymbol* _tmp18_;
		_tmp17_ = vala_data_type_get_data_type (datatype);
		_tmp18_ = _tmp17_;
		if (vala_gvariant_module_is_string_marshalled_enum (_tmp18_)) {
			gchar* _tmp19_;
			_tmp19_ = g_strdup ("s");
			result = _tmp19_;
			_vala_code_node_unref0 (array_type);
			return result;
		} else {
			ValaTypeSymbol* _tmp20_;
			ValaTypeSymbol* _tmp21_;
			_tmp20_ = vala_data_type_get_data_type (datatype);
			_tmp21_ = _tmp20_;
			if (_tmp21_ != NULL) {
				gchar* sig = NULL;
				ValaTypeSymbol* _tmp22_;
				ValaTypeSymbol* _tmp23_;
				gchar* _tmp24_;
				ValaStruct* st = NULL;
				ValaTypeSymbol* _tmp25_;
				ValaTypeSymbol* _tmp26_;
				ValaStruct* _tmp27_;
				ValaEnum* en = NULL;
				ValaTypeSymbol* _tmp28_;
				ValaTypeSymbol* _tmp29_;
				ValaEnum* _tmp30_;
				gboolean _tmp31_ = FALSE;
				const gchar* _tmp32_;
				ValaList* type_args = NULL;
				ValaList* _tmp69_;
				gboolean _tmp70_ = FALSE;
				gboolean _tmp71_ = FALSE;
				const gchar* _tmp72_;
				gboolean _tmp98_ = FALSE;
				const gchar* _tmp99_;
				_tmp22_ = vala_data_type_get_data_type (datatype);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp23_, "CCode", "type_signature", NULL);
				sig = _tmp24_;
				_tmp25_ = vala_data_type_get_data_type (datatype);
				_tmp26_ = _tmp25_;
				_tmp27_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp26_) : NULL);
				st = _tmp27_;
				_tmp28_ = vala_data_type_get_data_type (datatype);
				_tmp29_ = _tmp28_;
				_tmp30_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_ENUM) ? ((ValaEnum*) _tmp29_) : NULL);
				en = _tmp30_;
				_tmp32_ = sig;
				if (_tmp32_ == NULL) {
					ValaStruct* _tmp33_;
					_tmp33_ = st;
					_tmp31_ = _tmp33_ != NULL;
				} else {
					_tmp31_ = FALSE;
				}
				if (_tmp31_) {
					GString* str = NULL;
					GString* _tmp34_;
					GString* _tmp35_;
					GString* _tmp57_;
					GString* _tmp58_;
					const gchar* _tmp59_;
					gchar* _tmp60_;
					_tmp34_ = g_string_new ("");
					str = _tmp34_;
					_tmp35_ = str;
					g_string_append_c (_tmp35_, '(');
					{
						ValaList* _f_list = NULL;
						ValaStruct* _tmp36_;
						ValaList* _tmp37_;
						gint _f_size = 0;
						ValaList* _tmp38_;
						gint _tmp39_;
						gint _tmp40_;
						gint _f_index = 0;
						_tmp36_ = st;
						_tmp37_ = vala_struct_get_fields (_tmp36_);
						_f_list = _tmp37_;
						_tmp38_ = _f_list;
						_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
						_tmp40_ = _tmp39_;
						_f_size = _tmp40_;
						_f_index = -1;
						while (TRUE) {
							gint _tmp41_;
							gint _tmp42_;
							gint _tmp43_;
							ValaField* f = NULL;
							ValaList* _tmp44_;
							gint _tmp45_;
							gpointer _tmp46_;
							ValaField* _tmp47_;
							ValaMemberBinding _tmp48_;
							ValaMemberBinding _tmp49_;
							_tmp41_ = _f_index;
							_f_index = _tmp41_ + 1;
							_tmp42_ = _f_index;
							_tmp43_ = _f_size;
							if (!(_tmp42_ < _tmp43_)) {
								break;
							}
							_tmp44_ = _f_list;
							_tmp45_ = _f_index;
							_tmp46_ = vala_list_get (_tmp44_, _tmp45_);
							f = (ValaField*) _tmp46_;
							_tmp47_ = f;
							_tmp48_ = vala_field_get_binding (_tmp47_);
							_tmp49_ = _tmp48_;
							if (_tmp49_ == VALA_MEMBER_BINDING_INSTANCE) {
								GString* _tmp50_;
								ValaField* _tmp51_;
								ValaDataType* _tmp52_;
								ValaDataType* _tmp53_;
								ValaField* _tmp54_;
								gchar* _tmp55_;
								gchar* _tmp56_;
								_tmp50_ = str;
								_tmp51_ = f;
								_tmp52_ = vala_variable_get_variable_type ((ValaVariable*) _tmp51_);
								_tmp53_ = _tmp52_;
								_tmp54_ = f;
								_tmp55_ = vala_gvariant_module_get_type_signature (_tmp53_, (ValaSymbol*) _tmp54_);
								_tmp56_ = _tmp55_;
								g_string_append (_tmp50_, _tmp56_);
								_g_free0 (_tmp56_);
							}
							_vala_code_node_unref0 (f);
						}
						_vala_iterable_unref0 (_f_list);
					}
					_tmp57_ = str;
					g_string_append_c (_tmp57_, ')');
					_tmp58_ = str;
					_tmp59_ = _tmp58_->str;
					_tmp60_ = g_strdup (_tmp59_);
					_g_free0 (sig);
					sig = _tmp60_;
					_g_string_free0 (str);
				} else {
					gboolean _tmp61_ = FALSE;
					const gchar* _tmp62_;
					_tmp62_ = sig;
					if (_tmp62_ == NULL) {
						ValaEnum* _tmp63_;
						_tmp63_ = en;
						_tmp61_ = _tmp63_ != NULL;
					} else {
						_tmp61_ = FALSE;
					}
					if (_tmp61_) {
						ValaEnum* _tmp64_;
						gboolean _tmp65_;
						gboolean _tmp66_;
						_tmp64_ = en;
						_tmp65_ = vala_enum_get_is_flags (_tmp64_);
						_tmp66_ = _tmp65_;
						if (_tmp66_) {
							gchar* _tmp67_;
							_tmp67_ = g_strdup ("u");
							result = _tmp67_;
							_vala_code_node_unref0 (en);
							_vala_code_node_unref0 (st);
							_g_free0 (sig);
							_vala_code_node_unref0 (array_type);
							return result;
						} else {
							gchar* _tmp68_;
							_tmp68_ = g_strdup ("i");
							result = _tmp68_;
							_vala_code_node_unref0 (en);
							_vala_code_node_unref0 (st);
							_g_free0 (sig);
							_vala_code_node_unref0 (array_type);
							return result;
						}
					}
				}
				_tmp69_ = vala_data_type_get_type_arguments (datatype);
				type_args = _tmp69_;
				_tmp72_ = sig;
				if (_tmp72_ != NULL) {
					const gchar* _tmp73_;
					_tmp73_ = sig;
					_tmp71_ = string_contains (_tmp73_, "%s");
				} else {
					_tmp71_ = FALSE;
				}
				if (_tmp71_) {
					ValaList* _tmp74_;
					gint _tmp75_;
					gint _tmp76_;
					_tmp74_ = type_args;
					_tmp75_ = vala_collection_get_size ((ValaCollection*) _tmp74_);
					_tmp76_ = _tmp75_;
					_tmp70_ = _tmp76_ > 0;
				} else {
					_tmp70_ = FALSE;
				}
				if (_tmp70_) {
					gchar* element_sig = NULL;
					gchar* _tmp77_;
					const gchar* _tmp95_;
					const gchar* _tmp96_;
					gchar* _tmp97_;
					_tmp77_ = g_strdup ("");
					element_sig = _tmp77_;
					{
						ValaList* _type_arg_list = NULL;
						ValaList* _tmp78_;
						ValaList* _tmp79_;
						gint _type_arg_size = 0;
						ValaList* _tmp80_;
						gint _tmp81_;
						gint _tmp82_;
						gint _type_arg_index = 0;
						_tmp78_ = type_args;
						_tmp79_ = _vala_iterable_ref0 (_tmp78_);
						_type_arg_list = _tmp79_;
						_tmp80_ = _type_arg_list;
						_tmp81_ = vala_collection_get_size ((ValaCollection*) _tmp80_);
						_tmp82_ = _tmp81_;
						_type_arg_size = _tmp82_;
						_type_arg_index = -1;
						while (TRUE) {
							gint _tmp83_;
							gint _tmp84_;
							gint _tmp85_;
							ValaDataType* type_arg = NULL;
							ValaList* _tmp86_;
							gint _tmp87_;
							gpointer _tmp88_;
							gchar* s = NULL;
							ValaDataType* _tmp89_;
							gchar* _tmp90_;
							const gchar* _tmp91_;
							_tmp83_ = _type_arg_index;
							_type_arg_index = _tmp83_ + 1;
							_tmp84_ = _type_arg_index;
							_tmp85_ = _type_arg_size;
							if (!(_tmp84_ < _tmp85_)) {
								break;
							}
							_tmp86_ = _type_arg_list;
							_tmp87_ = _type_arg_index;
							_tmp88_ = vala_list_get (_tmp86_, _tmp87_);
							type_arg = (ValaDataType*) _tmp88_;
							_tmp89_ = type_arg;
							_tmp90_ = vala_gvariant_module_get_type_signature (_tmp89_, NULL);
							s = _tmp90_;
							_tmp91_ = s;
							if (_tmp91_ != NULL) {
								const gchar* _tmp92_;
								const gchar* _tmp93_;
								gchar* _tmp94_;
								_tmp92_ = element_sig;
								_tmp93_ = s;
								_tmp94_ = g_strconcat (_tmp92_, _tmp93_, NULL);
								_g_free0 (element_sig);
								element_sig = _tmp94_;
							}
							_g_free0 (s);
							_vala_code_node_unref0 (type_arg);
						}
						_vala_iterable_unref0 (_type_arg_list);
					}
					_tmp95_ = sig;
					_tmp96_ = element_sig;
					_tmp97_ = string_replace (_tmp95_, "%s", _tmp96_);
					_g_free0 (sig);
					sig = _tmp97_;
					_g_free0 (element_sig);
				}
				_tmp99_ = sig;
				if (_tmp99_ == NULL) {
					gboolean _tmp100_ = FALSE;
					gboolean _tmp101_ = FALSE;
					ValaTypeSymbol* _tmp102_;
					ValaTypeSymbol* _tmp103_;
					gchar* _tmp104_;
					gchar* _tmp105_;
					gboolean _tmp106_;
					_tmp102_ = vala_data_type_get_data_type (datatype);
					_tmp103_ = _tmp102_;
					_tmp104_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = g_strcmp0 (_tmp105_, "GLib.UnixInputStream") == 0;
					_g_free0 (_tmp105_);
					if (_tmp106_) {
						_tmp101_ = TRUE;
					} else {
						ValaTypeSymbol* _tmp107_;
						ValaTypeSymbol* _tmp108_;
						gchar* _tmp109_;
						gchar* _tmp110_;
						_tmp107_ = vala_data_type_get_data_type (datatype);
						_tmp108_ = _tmp107_;
						_tmp109_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp108_);
						_tmp110_ = _tmp109_;
						_tmp101_ = g_strcmp0 (_tmp110_, "GLib.UnixOutputStream") == 0;
						_g_free0 (_tmp110_);
					}
					if (_tmp101_) {
						_tmp100_ = TRUE;
					} else {
						ValaTypeSymbol* _tmp111_;
						ValaTypeSymbol* _tmp112_;
						gchar* _tmp113_;
						gchar* _tmp114_;
						_tmp111_ = vala_data_type_get_data_type (datatype);
						_tmp112_ = _tmp111_;
						_tmp113_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp112_);
						_tmp114_ = _tmp113_;
						_tmp100_ = g_strcmp0 (_tmp114_, "GLib.Socket") == 0;
						_g_free0 (_tmp114_);
					}
					_tmp98_ = _tmp100_;
				} else {
					_tmp98_ = FALSE;
				}
				if (_tmp98_) {
					gchar* _tmp115_;
					_tmp115_ = g_strdup ("h");
					result = _tmp115_;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (en);
					_vala_code_node_unref0 (st);
					_g_free0 (sig);
					_vala_code_node_unref0 (array_type);
					return result;
				}
				result = sig;
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (en);
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (array_type);
				return result;
			} else {
				result = NULL;
				_vala_code_node_unref0 (array_type);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (array_type);
}


static void
vala_gvariant_module_real_visit_enum (ValaCodeVisitor* base,
                                      ValaEnum* en)
{
	ValaGVariantModule * self;
	self = (ValaGVariantModule*) base;
	g_return_if_fail (en != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gvariant_module_parent_class)->visit_enum ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GASYNC_MODULE, ValaGAsyncModule), en);
	if (vala_gvariant_module_is_string_marshalled_enum ((ValaTypeSymbol*) en)) {
		ValaCCodeFile* _tmp0_;
		ValaCCodeFile* _tmp1_;
		ValaCCodeFile* _tmp2_;
		ValaCCodeFunction* _tmp3_;
		ValaCCodeFunction* _tmp4_;
		ValaCCodeFile* _tmp5_;
		ValaCCodeFunction* _tmp6_;
		ValaCCodeFunction* _tmp7_;
		_tmp0_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp0_, "string.h", FALSE);
		_tmp1_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1_, "gio/gio.h", FALSE);
		_tmp2_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp3_ = vala_gvariant_module_generate_enum_from_string_function (self, en);
		_tmp4_ = _tmp3_;
		vala_ccode_file_add_function (_tmp2_, _tmp4_);
		_vala_ccode_node_unref0 (_tmp4_);
		_tmp5_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp6_ = vala_gvariant_module_generate_enum_to_string_function (self, en);
		_tmp7_ = _tmp6_;
		vala_ccode_file_add_function (_tmp5_, _tmp7_);
		_vala_ccode_node_unref0 (_tmp7_);
	}
}


static gboolean
vala_gvariant_module_real_generate_enum_declaration (ValaCCodeBaseModule* base,
                                                     ValaEnum* en,
                                                     ValaCCodeFile* decl_space)
{
	ValaGVariantModule * self;
	gboolean result = FALSE;
	self = (ValaGVariantModule*) base;
	g_return_val_if_fail (en != NULL, FALSE);
	g_return_val_if_fail (decl_space != NULL, FALSE);
	if (VALA_CCODE_BASE_MODULE_CLASS (vala_gvariant_module_parent_class)->generate_enum_declaration ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GASYNC_MODULE, ValaGAsyncModule), en, decl_space)) {
		if (vala_gvariant_module_is_string_marshalled_enum ((ValaTypeSymbol*) en)) {
			ValaCCodeFunction* _tmp0_;
			ValaCCodeFunction* _tmp1_;
			ValaCCodeFunction* _tmp2_;
			ValaCCodeFunction* _tmp3_;
			_tmp0_ = vala_gvariant_module_generate_enum_from_string_function_declaration (self, en);
			_tmp1_ = _tmp0_;
			vala_ccode_file_add_function_declaration (decl_space, _tmp1_);
			_vala_ccode_node_unref0 (_tmp1_);
			_tmp2_ = vala_gvariant_module_generate_enum_to_string_function_declaration (self, en);
			_tmp3_ = _tmp2_;
			vala_ccode_file_add_function_declaration (decl_space, _tmp3_);
			_vala_ccode_node_unref0 (_tmp3_);
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static ValaCCodeExpression*
vala_gvariant_module_get_array_length (ValaGVariantModule* self,
                                       ValaCCodeExpression* expr,
                                       gint dim)
{
	ValaCCodeExpression* result = NULL;
	ValaCCodeIdentifier* id = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeMemberAccess* ma = NULL;
	ValaCCodeMemberAccess* _tmp1_;
	ValaCCodeIdentifier* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp0_ = _vala_ccode_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (expr, VALA_TYPE_CCODE_IDENTIFIER) ? ((ValaCCodeIdentifier*) expr) : NULL);
	id = _tmp0_;
	_tmp1_ = _vala_ccode_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (expr, VALA_TYPE_CCODE_MEMBER_ACCESS) ? ((ValaCCodeMemberAccess*) expr) : NULL);
	ma = _tmp1_;
	_tmp2_ = id;
	if (_tmp2_ != NULL) {
		ValaCCodeIdentifier* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		ValaCCodeIdentifier* _tmp8_;
		ValaCCodeExpression* _tmp9_;
		_tmp3_ = id;
		_tmp4_ = vala_ccode_identifier_get_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%s_length%d", _tmp5_, dim);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_ccode_identifier_new (_tmp7_);
		_tmp9_ = (ValaCCodeExpression*) _tmp8_;
		_g_free0 (_tmp7_);
		result = _tmp9_;
		_vala_ccode_node_unref0 (ma);
		_vala_ccode_node_unref0 (id);
		return result;
	} else {
		ValaCCodeMemberAccess* _tmp10_;
		_tmp10_ = ma;
		if (_tmp10_ != NULL) {
			ValaCCodeMemberAccess* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp11_ = ma;
			_tmp12_ = vala_ccode_member_access_get_is_pointer (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_) {
				ValaCCodeMemberAccess* _tmp14_;
				ValaCCodeExpression* _tmp15_;
				ValaCCodeExpression* _tmp16_;
				ValaCCodeMemberAccess* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				ValaCCodeMemberAccess* _tmp22_;
				ValaCCodeExpression* _tmp23_;
				_tmp14_ = ma;
				_tmp15_ = vala_ccode_member_access_get_inner (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = ma;
				_tmp18_ = vala_ccode_member_access_get_member_name (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strdup_printf ("%s_length%d", _tmp19_, dim);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_ccode_member_access_new_pointer (_tmp16_, _tmp21_);
				_tmp23_ = (ValaCCodeExpression*) _tmp22_;
				_g_free0 (_tmp21_);
				result = _tmp23_;
				_vala_ccode_node_unref0 (ma);
				_vala_ccode_node_unref0 (id);
				return result;
			} else {
				ValaCCodeMemberAccess* _tmp24_;
				ValaCCodeExpression* _tmp25_;
				ValaCCodeExpression* _tmp26_;
				ValaCCodeMemberAccess* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				ValaCCodeMemberAccess* _tmp32_;
				ValaCCodeExpression* _tmp33_;
				_tmp24_ = ma;
				_tmp25_ = vala_ccode_member_access_get_inner (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = ma;
				_tmp28_ = vala_ccode_member_access_get_member_name (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strdup_printf ("%s_length%d", _tmp29_, dim);
				_tmp31_ = _tmp30_;
				_tmp32_ = vala_ccode_member_access_new (_tmp26_, _tmp31_, FALSE);
				_tmp33_ = (ValaCCodeExpression*) _tmp32_;
				_g_free0 (_tmp31_);
				result = _tmp33_;
				_vala_ccode_node_unref0 (ma);
				_vala_ccode_node_unref0 (id);
				return result;
			}
		} else {
			ValaCCodeFunctionCall* len_call = NULL;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeFunctionCall* _tmp36_;
			ValaCCodeFunctionCall* _tmp37_;
			ValaCCodeFunctionCall* _tmp38_;
			_tmp34_ = vala_ccode_identifier_new ("g_strv_length");
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp35_);
			_tmp37_ = _tmp36_;
			_vala_ccode_node_unref0 (_tmp35_);
			len_call = _tmp37_;
			_tmp38_ = len_call;
			vala_ccode_function_call_add_argument (_tmp38_, expr);
			result = (ValaCCodeExpression*) len_call;
			_vala_ccode_node_unref0 (ma);
			_vala_ccode_node_unref0 (id);
			return result;
		}
	}
	_vala_ccode_node_unref0 (ma);
	_vala_ccode_node_unref0 (id);
}


static ValaCCodeExpression*
vala_gvariant_module_generate_enum_value_from_string (ValaGVariantModule* self,
                                                      ValaEnumValueType* type,
                                                      ValaCCodeExpression* expr,
                                                      ValaCCodeExpression* error_expr)
{
	ValaCCodeExpression* result = NULL;
	ValaEnum* en = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaEnum* _tmp2_;
	gchar* from_string_name = NULL;
	ValaEnum* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaCCodeFunctionCall* from_string_call = NULL;
	const gchar* _tmp8_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	ValaCCodeFunctionCall* _tmp12_;
	ValaCCodeFunctionCall* _tmp13_;
	ValaCCodeExpression* _tmp14_ = NULL;
	ValaCCodeFunctionCall* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = vala_value_type_get_type_symbol ((ValaValueType*) type);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_ENUM) ? ((ValaEnum*) _tmp1_) : NULL);
	en = _tmp2_;
	_tmp3_ = en;
	_tmp4_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s_from_string", _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	from_string_name = _tmp7_;
	_tmp8_ = from_string_name;
	_tmp9_ = vala_ccode_identifier_new (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp10_);
	_tmp12_ = _tmp11_;
	_vala_ccode_node_unref0 (_tmp10_);
	from_string_call = _tmp12_;
	_tmp13_ = from_string_call;
	vala_ccode_function_call_add_argument (_tmp13_, expr);
	if (error_expr != NULL) {
		ValaCCodeExpression* _tmp15_;
		_tmp15_ = _vala_ccode_node_ref0 (error_expr);
		_vala_ccode_node_unref0 (_tmp14_);
		_tmp14_ = _tmp15_;
	} else {
		ValaCCodeConstant* _tmp16_;
		_tmp16_ = vala_ccode_constant_new ("NULL");
		_vala_ccode_node_unref0 (_tmp14_);
		_tmp14_ = (ValaCCodeExpression*) _tmp16_;
	}
	_tmp17_ = from_string_call;
	vala_ccode_function_call_add_argument (_tmp17_, _tmp14_);
	result = (ValaCCodeExpression*) from_string_call;
	_vala_ccode_node_unref0 (_tmp14_);
	_g_free0 (from_string_name);
	_vala_code_node_unref0 (en);
	return result;
}


ValaCCodeFunction*
vala_gvariant_module_generate_enum_from_string_function_declaration (ValaGVariantModule* self,
                                                                     ValaEnum* en)
{
	ValaCCodeFunction* result = NULL;
	gchar* from_string_name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFunction* from_string_func = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeParameter* _tmp8_;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeParameter* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s_from_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	from_string_name = _tmp3_;
	_tmp4_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_function_new (from_string_name, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	from_string_func = _tmp7_;
	_tmp8_ = vala_ccode_parameter_new ("str", "const char*");
	_tmp9_ = _tmp8_;
	vala_ccode_function_add_parameter (from_string_func, _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = vala_ccode_parameter_new ("error", "GError**");
	_tmp11_ = _tmp10_;
	vala_ccode_function_add_parameter (from_string_func, _tmp11_);
	_vala_ccode_node_unref0 (_tmp11_);
	result = from_string_func;
	_g_free0 (from_string_name);
	return result;
}


ValaCCodeFunction*
vala_gvariant_module_generate_enum_from_string_function (ValaGVariantModule* self,
                                                         ValaEnum* en)
{
	ValaCCodeFunction* result = NULL;
	gchar* from_string_name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFunction* from_string_func = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	ValaCCodeParameter* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeParameter* _tmp13_;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValaCCodeConstant* _tmp20_;
	ValaCCodeConstant* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	gboolean firstif = FALSE;
	ValaCCodeFunction* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunctionCall* set_error = NULL;
	ValaCCodeIdentifier* _tmp75_;
	ValaCCodeIdentifier* _tmp76_;
	ValaCCodeFunctionCall* _tmp77_;
	ValaCCodeFunctionCall* _tmp78_;
	ValaCCodeIdentifier* _tmp79_;
	ValaCCodeIdentifier* _tmp80_;
	ValaCCodeIdentifier* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeIdentifier* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	ValaCCodeConstant* _tmp89_;
	ValaCCodeConstant* _tmp90_;
	ValaCCodeFunction* _tmp91_;
	ValaCCodeFunction* _tmp92_;
	ValaCCodeFunction* _tmp93_;
	ValaCCodeFunction* _tmp94_;
	ValaCCodeFunction* _tmp95_;
	ValaCCodeFunction* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeIdentifier* _tmp98_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s_from_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	from_string_name = _tmp3_;
	_tmp4_ = from_string_name;
	_tmp5_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_function_new (_tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	from_string_func = _tmp8_;
	_tmp9_ = from_string_func;
	_tmp10_ = vala_ccode_parameter_new ("str", "const char*");
	_tmp11_ = _tmp10_;
	vala_ccode_function_add_parameter (_tmp9_, _tmp11_);
	_vala_ccode_node_unref0 (_tmp11_);
	_tmp12_ = from_string_func;
	_tmp13_ = vala_ccode_parameter_new ("error", "GError**");
	_tmp14_ = _tmp13_;
	vala_ccode_function_add_parameter (_tmp12_, _tmp14_);
	_vala_ccode_node_unref0 (_tmp14_);
	_tmp15_ = from_string_func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_ccode_constant_new ("0");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new_zero ("value", (ValaCCodeExpression*) _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp17_, _tmp19_, (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_vala_ccode_node_unref0 (_tmp21_);
	_g_free0 (_tmp19_);
	firstif = TRUE;
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp24_;
		gint _enum_value_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _enum_value_index = 0;
		_tmp24_ = vala_enum_get_values (en);
		_enum_value_list = _tmp24_;
		_tmp25_ = _enum_value_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_enum_value_size = _tmp27_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			gchar* dbus_value = NULL;
			ValaEnumValue* _tmp34_;
			ValaEnumValue* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			ValaCCodeFunctionCall* string_comparison = NULL;
			ValaCCodeIdentifier* _tmp39_;
			ValaCCodeIdentifier* _tmp40_;
			ValaCCodeFunctionCall* _tmp41_;
			ValaCCodeFunctionCall* _tmp42_;
			ValaCCodeFunctionCall* _tmp43_;
			ValaCCodeIdentifier* _tmp44_;
			ValaCCodeIdentifier* _tmp45_;
			ValaCCodeFunctionCall* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			ValaCCodeConstant* _tmp50_;
			ValaCCodeConstant* _tmp51_;
			ValaCCodeBinaryExpression* cond = NULL;
			ValaCCodeFunctionCall* _tmp52_;
			ValaCCodeConstant* _tmp53_;
			ValaCCodeConstant* _tmp54_;
			ValaCCodeBinaryExpression* _tmp55_;
			ValaCCodeBinaryExpression* _tmp56_;
			gboolean _tmp57_;
			ValaCCodeFunction* _tmp64_;
			ValaCCodeFunction* _tmp65_;
			ValaCCodeIdentifier* _tmp66_;
			ValaCCodeIdentifier* _tmp67_;
			ValaEnumValue* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			ValaCCodeIdentifier* _tmp71_;
			ValaCCodeIdentifier* _tmp72_;
			_tmp28_ = _enum_value_index;
			_enum_value_index = _tmp28_ + 1;
			_tmp29_ = _enum_value_index;
			_tmp30_ = _enum_value_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _enum_value_list;
			_tmp32_ = _enum_value_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			enum_value = (ValaEnumValue*) _tmp33_;
			_tmp34_ = enum_value;
			_tmp35_ = enum_value;
			_tmp36_ = vala_symbol_get_name ((ValaSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_gvariant_module_get_dbus_value (self, _tmp34_, _tmp37_);
			dbus_value = _tmp38_;
			_tmp39_ = vala_ccode_identifier_new ("strcmp");
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp40_);
			_tmp42_ = _tmp41_;
			_vala_ccode_node_unref0 (_tmp40_);
			string_comparison = _tmp42_;
			_tmp43_ = string_comparison;
			_tmp44_ = vala_ccode_identifier_new ("str");
			_tmp45_ = _tmp44_;
			vala_ccode_function_call_add_argument (_tmp43_, (ValaCCodeExpression*) _tmp45_);
			_vala_ccode_node_unref0 (_tmp45_);
			_tmp46_ = string_comparison;
			_tmp47_ = dbus_value;
			_tmp48_ = g_strdup_printf ("\"%s\"", _tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_ccode_constant_new (_tmp49_);
			_tmp51_ = _tmp50_;
			vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp51_);
			_vala_ccode_node_unref0 (_tmp51_);
			_g_free0 (_tmp49_);
			_tmp52_ = string_comparison;
			_tmp53_ = vala_ccode_constant_new ("0");
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp52_, (ValaCCodeExpression*) _tmp54_);
			_tmp56_ = _tmp55_;
			_vala_ccode_node_unref0 (_tmp54_);
			cond = _tmp56_;
			_tmp57_ = firstif;
			if (_tmp57_) {
				ValaCCodeFunction* _tmp58_;
				ValaCCodeFunction* _tmp59_;
				ValaCCodeBinaryExpression* _tmp60_;
				_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp59_ = _tmp58_;
				_tmp60_ = cond;
				vala_ccode_function_open_if (_tmp59_, (ValaCCodeExpression*) _tmp60_);
				firstif = FALSE;
			} else {
				ValaCCodeFunction* _tmp61_;
				ValaCCodeFunction* _tmp62_;
				ValaCCodeBinaryExpression* _tmp63_;
				_tmp61_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp62_ = _tmp61_;
				_tmp63_ = cond;
				vala_ccode_function_else_if (_tmp62_, (ValaCCodeExpression*) _tmp63_);
			}
			_tmp64_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_ccode_identifier_new ("value");
			_tmp67_ = _tmp66_;
			_tmp68_ = enum_value;
			_tmp69_ = vala_get_ccode_name ((ValaCodeNode*) _tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = vala_ccode_identifier_new (_tmp70_);
			_tmp72_ = _tmp71_;
			vala_ccode_function_add_assignment (_tmp65_, (ValaCCodeExpression*) _tmp67_, (ValaCCodeExpression*) _tmp72_);
			_vala_ccode_node_unref0 (_tmp72_);
			_g_free0 (_tmp70_);
			_vala_ccode_node_unref0 (_tmp67_);
			_vala_ccode_node_unref0 (cond);
			_vala_ccode_node_unref0 (string_comparison);
			_g_free0 (dbus_value);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp73_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp74_ = _tmp73_;
	vala_ccode_function_add_else (_tmp74_);
	_tmp75_ = vala_ccode_identifier_new ("g_set_error");
	_tmp76_ = _tmp75_;
	_tmp77_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp76_);
	_tmp78_ = _tmp77_;
	_vala_ccode_node_unref0 (_tmp76_);
	set_error = _tmp78_;
	_tmp79_ = vala_ccode_identifier_new ("error");
	_tmp80_ = _tmp79_;
	vala_ccode_function_call_add_argument (set_error, (ValaCCodeExpression*) _tmp80_);
	_vala_ccode_node_unref0 (_tmp80_);
	_tmp81_ = vala_ccode_identifier_new ("G_DBUS_ERROR");
	_tmp82_ = _tmp81_;
	vala_ccode_function_call_add_argument (set_error, (ValaCCodeExpression*) _tmp82_);
	_vala_ccode_node_unref0 (_tmp82_);
	_tmp83_ = vala_ccode_identifier_new ("G_DBUS_ERROR_INVALID_ARGS");
	_tmp84_ = _tmp83_;
	vala_ccode_function_call_add_argument (set_error, (ValaCCodeExpression*) _tmp84_);
	_vala_ccode_node_unref0 (_tmp84_);
	_tmp85_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp86_ = _tmp85_;
	_tmp87_ = g_strdup_printf ("\"Invalid value for enum `%s'\"", _tmp86_);
	_tmp88_ = _tmp87_;
	_tmp89_ = vala_ccode_constant_new (_tmp88_);
	_tmp90_ = _tmp89_;
	vala_ccode_function_call_add_argument (set_error, (ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (_tmp90_);
	_g_free0 (_tmp88_);
	_g_free0 (_tmp86_);
	_tmp91_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp92_ = _tmp91_;
	vala_ccode_function_add_expression (_tmp92_, (ValaCCodeExpression*) set_error);
	_tmp93_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp94_ = _tmp93_;
	vala_ccode_function_close (_tmp94_);
	_tmp95_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp96_ = _tmp95_;
	_tmp97_ = vala_ccode_identifier_new ("value");
	_tmp98_ = _tmp97_;
	vala_ccode_function_add_return (_tmp96_, (ValaCCodeExpression*) _tmp98_);
	_vala_ccode_node_unref0 (_tmp98_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	result = from_string_func;
	_vala_ccode_node_unref0 (set_error);
	_g_free0 (from_string_name);
	return result;
}


static ValaCCodeExpression*
vala_gvariant_module_deserialize_basic (ValaGVariantModule* self,
                                        ValaGVariantModuleBasicTypeInfo* basic_type,
                                        ValaCCodeExpression* variant_expr,
                                        gboolean transfer)
{
	ValaCCodeExpression* result = NULL;
	ValaCCodeFunctionCall* get_call = NULL;
	ValaGVariantModuleBasicTypeInfo _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeFunctionCall* _tmp6_;
	ValaCCodeFunctionCall* _tmp7_;
	ValaCCodeFunctionCall* _tmp8_;
	ValaGVariantModuleBasicTypeInfo _tmp9_;
	gboolean _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (basic_type != NULL, NULL);
	g_return_val_if_fail (variant_expr != NULL, NULL);
	_tmp0_ = *basic_type;
	_tmp1_ = _tmp0_.type_name;
	_tmp2_ = g_strconcat ("g_variant_get_", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_identifier_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_ccode_node_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	get_call = _tmp7_;
	_tmp8_ = get_call;
	vala_ccode_function_call_add_argument (_tmp8_, variant_expr);
	_tmp9_ = *basic_type;
	_tmp10_ = _tmp9_.is_string;
	if (_tmp10_) {
		ValaCCodeFunctionCall* _tmp17_;
		ValaCCodeConstant* _tmp18_;
		ValaCCodeConstant* _tmp19_;
		if (transfer) {
			ValaCCodeFunctionCall* _tmp11_;
			ValaCCodeIdentifier* _tmp12_;
			ValaCCodeIdentifier* _tmp13_;
			_tmp11_ = get_call;
			_tmp12_ = vala_ccode_identifier_new ("g_variant_get_string");
			_tmp13_ = _tmp12_;
			vala_ccode_function_call_set_call (_tmp11_, (ValaCCodeExpression*) _tmp13_);
			_vala_ccode_node_unref0 (_tmp13_);
		} else {
			ValaCCodeFunctionCall* _tmp14_;
			ValaCCodeIdentifier* _tmp15_;
			ValaCCodeIdentifier* _tmp16_;
			_tmp14_ = get_call;
			_tmp15_ = vala_ccode_identifier_new ("g_variant_dup_string");
			_tmp16_ = _tmp15_;
			vala_ccode_function_call_set_call (_tmp14_, (ValaCCodeExpression*) _tmp16_);
			_vala_ccode_node_unref0 (_tmp16_);
		}
		_tmp17_ = get_call;
		_tmp18_ = vala_ccode_constant_new ("NULL");
		_tmp19_ = _tmp18_;
		vala_ccode_function_call_add_argument (_tmp17_, (ValaCCodeExpression*) _tmp19_);
		_vala_ccode_node_unref0 (_tmp19_);
	}
	result = (ValaCCodeExpression*) get_call;
	return result;
}


static ValaCCodeExpression*
vala_gvariant_module_deserialize_array (ValaGVariantModule* self,
                                        ValaArrayType* array_type,
                                        ValaCCodeExpression* variant_expr,
                                        ValaCCodeExpression* expr)
{
	ValaCCodeExpression* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gchar* temp_name = NULL;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	ValaCCodeFunctionCall* new_call = NULL;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	ValaCCodeFunctionCall* _tmp12_;
	ValaCCodeFunctionCall* _tmp13_;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeFunctionCall* _tmp20_;
	ValaCCodeConstant* _tmp21_;
	ValaCCodeConstant* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeVariableDeclarator* _tmp29_;
	ValaCCodeVariableDeclarator* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	ValaCCodeFunction* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	ValaCCodeConstant* _tmp36_;
	ValaCCodeConstant* _tmp37_;
	ValaCCodeVariableDeclarator* _tmp38_;
	ValaCCodeVariableDeclarator* _tmp39_;
	ValaCCodeFunction* _tmp40_;
	ValaCCodeFunction* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeConstant* _tmp46_;
	ValaCCodeVariableDeclarator* _tmp47_;
	ValaCCodeVariableDeclarator* _tmp48_;
	const gchar* _tmp49_;
	ValaDataType* _tmp50_;
	ValaDataType* _tmp51_;
	const gchar* _tmp68_;
	ValaCCodeIdentifier* _tmp69_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	g_return_val_if_fail (variant_expr != NULL, NULL);
	_tmp1_ = vala_array_type_get_rank (array_type);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 1) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = vala_gvariant_module_get_type_signature ((ValaDataType*) array_type, NULL);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, "ay") == 0;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeExpression* _tmp5_;
		_tmp5_ = vala_gvariant_module_deserialize_buffer_array (self, array_type, variant_expr, expr);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp7_ = _tmp6_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp7_ + 1);
	_tmp8_ = g_strdup_printf ("_tmp%d_", _tmp7_);
	temp_name = _tmp8_;
	_tmp9_ = vala_ccode_identifier_new ("g_new");
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp10_);
	_tmp12_ = _tmp11_;
	_vala_ccode_node_unref0 (_tmp10_);
	new_call = _tmp12_;
	_tmp13_ = new_call;
	_tmp14_ = vala_array_type_get_element_type (array_type);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_get_ccode_name ((ValaCodeNode*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_identifier_new (_tmp17_);
	_tmp19_ = _tmp18_;
	vala_ccode_function_call_add_argument (_tmp13_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_g_free0 (_tmp17_);
	_tmp20_ = new_call;
	_tmp21_ = vala_ccode_constant_new ("5");
	_tmp22_ = _tmp21_;
	vala_ccode_function_call_add_argument (_tmp20_, (ValaCCodeExpression*) _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_get_ccode_name ((ValaCodeNode*) array_type);
	_tmp26_ = _tmp25_;
	_tmp27_ = temp_name;
	_tmp28_ = new_call;
	_tmp29_ = vala_ccode_variable_declarator_new (_tmp27_, (ValaCCodeExpression*) _tmp28_, NULL);
	_tmp30_ = _tmp29_;
	vala_ccode_function_add_declaration (_tmp24_, _tmp26_, (ValaCCodeDeclarator*) _tmp30_, 0);
	_vala_ccode_node_unref0 (_tmp30_);
	_g_free0 (_tmp26_);
	_tmp31_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp32_ = _tmp31_;
	_tmp33_ = temp_name;
	_tmp34_ = g_strconcat (_tmp33_, "_length", NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_ccode_constant_new ("0");
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_ccode_variable_declarator_new (_tmp35_, (ValaCCodeExpression*) _tmp37_, NULL);
	_tmp39_ = _tmp38_;
	vala_ccode_function_add_declaration (_tmp32_, "int", (ValaCCodeDeclarator*) _tmp39_, 0);
	_vala_ccode_node_unref0 (_tmp39_);
	_vala_ccode_node_unref0 (_tmp37_);
	_g_free0 (_tmp35_);
	_tmp40_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp41_ = _tmp40_;
	_tmp42_ = temp_name;
	_tmp43_ = g_strconcat (_tmp42_, "_size", NULL);
	_tmp44_ = _tmp43_;
	_tmp45_ = vala_ccode_constant_new ("4");
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_ccode_variable_declarator_new (_tmp44_, (ValaCCodeExpression*) _tmp46_, NULL);
	_tmp48_ = _tmp47_;
	vala_ccode_function_add_declaration (_tmp41_, "int", (ValaCCodeDeclarator*) _tmp48_, 0);
	_vala_ccode_node_unref0 (_tmp48_);
	_vala_ccode_node_unref0 (_tmp46_);
	_g_free0 (_tmp44_);
	_tmp49_ = temp_name;
	vala_gvariant_module_deserialize_array_dim (self, array_type, 1, _tmp49_, variant_expr, expr);
	_tmp50_ = vala_array_type_get_element_type (array_type);
	_tmp51_ = _tmp50_;
	if (vala_data_type_is_reference_type_or_type_parameter (_tmp51_)) {
		ValaCCodeIdentifier* length = NULL;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		ValaCCodeIdentifier* _tmp55_;
		ValaCCodeIdentifier* _tmp56_;
		ValaCCodeElementAccess* element_access = NULL;
		const gchar* _tmp57_;
		ValaCCodeIdentifier* _tmp58_;
		ValaCCodeIdentifier* _tmp59_;
		ValaCCodeIdentifier* _tmp60_;
		ValaCCodeElementAccess* _tmp61_;
		ValaCCodeElementAccess* _tmp62_;
		ValaCCodeFunction* _tmp63_;
		ValaCCodeFunction* _tmp64_;
		ValaCCodeElementAccess* _tmp65_;
		ValaCCodeIdentifier* _tmp66_;
		ValaCCodeIdentifier* _tmp67_;
		_tmp52_ = temp_name;
		_tmp53_ = g_strconcat (_tmp52_, "_length", NULL);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_ccode_identifier_new (_tmp54_);
		_tmp56_ = _tmp55_;
		_g_free0 (_tmp54_);
		length = _tmp56_;
		_tmp57_ = temp_name;
		_tmp58_ = vala_ccode_identifier_new (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = length;
		_tmp61_ = vala_ccode_element_access_new ((ValaCCodeExpression*) _tmp59_, (ValaCCodeExpression*) _tmp60_);
		_tmp62_ = _tmp61_;
		_vala_ccode_node_unref0 (_tmp59_);
		element_access = _tmp62_;
		_tmp63_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp64_ = _tmp63_;
		_tmp65_ = element_access;
		_tmp66_ = vala_ccode_identifier_new ("NULL");
		_tmp67_ = _tmp66_;
		vala_ccode_function_add_assignment (_tmp64_, (ValaCCodeExpression*) _tmp65_, (ValaCCodeExpression*) _tmp67_);
		_vala_ccode_node_unref0 (_tmp67_);
		_vala_ccode_node_unref0 (element_access);
		_vala_ccode_node_unref0 (length);
	}
	_tmp68_ = temp_name;
	_tmp69_ = vala_ccode_identifier_new (_tmp68_);
	result = (ValaCCodeExpression*) _tmp69_;
	_vala_ccode_node_unref0 (new_call);
	_g_free0 (temp_name);
	return result;
}


static void
vala_gvariant_module_deserialize_array_dim (ValaGVariantModule* self,
                                            ValaArrayType* array_type,
                                            gint dim,
                                            const gchar* temp_name,
                                            ValaCCodeExpression* variant_expr,
                                            ValaCCodeExpression* expr)
{
	gchar* subiter_name = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* element_name = NULL;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	ValaCCodeConstant* _tmp10_;
	ValaCCodeConstant* _tmp11_;
	ValaCCodeVariableDeclarator* _tmp12_;
	ValaCCodeVariableDeclarator* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	const gchar* _tmp16_;
	ValaCCodeVariableDeclarator* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	const gchar* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* iter_call = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	const gchar* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeIdentifier* _tmp31_;
	ValaCCodeUnaryExpression* _tmp32_;
	ValaCCodeUnaryExpression* _tmp33_;
	ValaCCodeFunctionCall* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunction* _tmp36_;
	ValaCCodeFunctionCall* _tmp37_;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeIdentifier* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	const gchar* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeIdentifier* _tmp44_;
	ValaCCodeUnaryExpression* _tmp45_;
	ValaCCodeUnaryExpression* _tmp46_;
	ValaCCodeBinaryExpression* cforcond = NULL;
	const gchar* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeAssignment* _tmp51_;
	ValaCCodeAssignment* _tmp52_;
	ValaCCodeConstant* _tmp53_;
	ValaCCodeConstant* _tmp54_;
	ValaCCodeBinaryExpression* _tmp55_;
	ValaCCodeBinaryExpression* _tmp56_;
	ValaCCodeUnaryExpression* cforiter = NULL;
	gchar* _tmp57_;
	gchar* _tmp58_;
	ValaCCodeIdentifier* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeUnaryExpression* _tmp61_;
	ValaCCodeUnaryExpression* _tmp62_;
	ValaCCodeFunction* _tmp63_;
	ValaCCodeFunction* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeUnaryExpression* _tmp66_;
	gint _tmp67_;
	gint _tmp68_;
	ValaCCodeFunctionCall* unref = NULL;
	ValaCCodeIdentifier* _tmp151_;
	ValaCCodeIdentifier* _tmp152_;
	ValaCCodeFunctionCall* _tmp153_;
	ValaCCodeFunctionCall* _tmp154_;
	ValaCCodeFunctionCall* _tmp155_;
	const gchar* _tmp156_;
	ValaCCodeIdentifier* _tmp157_;
	ValaCCodeIdentifier* _tmp158_;
	ValaCCodeFunction* _tmp159_;
	ValaCCodeFunction* _tmp160_;
	ValaCCodeFunctionCall* _tmp161_;
	ValaCCodeFunction* _tmp162_;
	ValaCCodeFunction* _tmp163_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (array_type != NULL);
	g_return_if_fail (temp_name != NULL);
	g_return_if_fail (variant_expr != NULL);
	_tmp0_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp1_ + 1);
	_tmp2_ = g_strdup_printf ("_tmp%d_", _tmp1_);
	subiter_name = _tmp2_;
	_tmp3_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp4_ = _tmp3_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp4_ + 1);
	_tmp5_ = g_strdup_printf ("_tmp%d_", _tmp4_);
	element_name = _tmp5_;
	_tmp6_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%s_length%d", temp_name, dim);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_ccode_constant_new ("0");
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_ccode_variable_declarator_new (_tmp9_, (ValaCCodeExpression*) _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	vala_ccode_function_add_declaration (_tmp7_, "int", (ValaCCodeDeclarator*) _tmp13_, 0);
	_vala_ccode_node_unref0 (_tmp13_);
	_vala_ccode_node_unref0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp14_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = subiter_name;
	_tmp17_ = vala_ccode_variable_declarator_new (_tmp16_, NULL, NULL);
	_tmp18_ = _tmp17_;
	vala_ccode_function_add_declaration (_tmp15_, "GVariantIter", (ValaCCodeDeclarator*) _tmp18_, 0);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp20_ = _tmp19_;
	_tmp21_ = element_name;
	_tmp22_ = vala_ccode_variable_declarator_new (_tmp21_, NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp20_, "GVariant*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("g_variant_iter_init");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	iter_call = _tmp27_;
	_tmp28_ = iter_call;
	_tmp29_ = subiter_name;
	_tmp30_ = vala_ccode_identifier_new (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp31_);
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_vala_ccode_node_unref0 (_tmp31_);
	_tmp34_ = iter_call;
	vala_ccode_function_call_add_argument (_tmp34_, variant_expr);
	_tmp35_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp36_ = _tmp35_;
	_tmp37_ = iter_call;
	vala_ccode_function_add_expression (_tmp36_, (ValaCCodeExpression*) _tmp37_);
	_tmp38_ = vala_ccode_identifier_new ("g_variant_iter_next_value");
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp39_);
	_vala_ccode_node_unref0 (iter_call);
	iter_call = _tmp40_;
	_vala_ccode_node_unref0 (_tmp39_);
	_tmp41_ = iter_call;
	_tmp42_ = subiter_name;
	_tmp43_ = vala_ccode_identifier_new (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp44_);
	_tmp46_ = _tmp45_;
	vala_ccode_function_call_add_argument (_tmp41_, (ValaCCodeExpression*) _tmp46_);
	_vala_ccode_node_unref0 (_tmp46_);
	_vala_ccode_node_unref0 (_tmp44_);
	_tmp47_ = element_name;
	_tmp48_ = vala_ccode_identifier_new (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = iter_call;
	_tmp51_ = vala_ccode_assignment_new ((ValaCCodeExpression*) _tmp49_, (ValaCCodeExpression*) _tmp50_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_ccode_constant_new ("NULL");
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp52_, (ValaCCodeExpression*) _tmp54_);
	_tmp56_ = _tmp55_;
	_vala_ccode_node_unref0 (_tmp54_);
	_vala_ccode_node_unref0 (_tmp52_);
	_vala_ccode_node_unref0 (_tmp49_);
	cforcond = _tmp56_;
	_tmp57_ = g_strdup_printf ("%s_length%d", temp_name, dim);
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_ccode_identifier_new (_tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) _tmp60_);
	_tmp62_ = _tmp61_;
	_vala_ccode_node_unref0 (_tmp60_);
	_g_free0 (_tmp58_);
	cforiter = _tmp62_;
	_tmp63_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp64_ = _tmp63_;
	_tmp65_ = cforcond;
	_tmp66_ = cforiter;
	vala_ccode_function_open_for (_tmp64_, NULL, (ValaCCodeExpression*) _tmp65_, (ValaCCodeExpression*) _tmp66_);
	_tmp67_ = vala_array_type_get_rank (array_type);
	_tmp68_ = _tmp67_;
	if (dim < _tmp68_) {
		const gchar* _tmp69_;
		ValaCCodeIdentifier* _tmp70_;
		ValaCCodeIdentifier* _tmp71_;
		_tmp69_ = element_name;
		_tmp70_ = vala_ccode_identifier_new (_tmp69_);
		_tmp71_ = _tmp70_;
		vala_gvariant_module_deserialize_array_dim (self, array_type, dim + 1, temp_name, (ValaCCodeExpression*) _tmp71_, expr);
		_vala_ccode_node_unref0 (_tmp71_);
	} else {
		ValaCCodeBinaryExpression* size_check = NULL;
		gchar* _tmp72_;
		gchar* _tmp73_;
		ValaCCodeIdentifier* _tmp74_;
		ValaCCodeIdentifier* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		ValaCCodeIdentifier* _tmp78_;
		ValaCCodeIdentifier* _tmp79_;
		ValaCCodeBinaryExpression* _tmp80_;
		ValaCCodeBinaryExpression* _tmp81_;
		ValaCCodeFunction* _tmp82_;
		ValaCCodeFunction* _tmp83_;
		ValaCCodeBinaryExpression* _tmp84_;
		ValaCCodeBinaryExpression* new_size = NULL;
		ValaCCodeConstant* _tmp85_;
		ValaCCodeConstant* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		ValaCCodeIdentifier* _tmp89_;
		ValaCCodeIdentifier* _tmp90_;
		ValaCCodeBinaryExpression* _tmp91_;
		ValaCCodeBinaryExpression* _tmp92_;
		ValaCCodeFunction* _tmp93_;
		ValaCCodeFunction* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		ValaCCodeIdentifier* _tmp97_;
		ValaCCodeIdentifier* _tmp98_;
		ValaCCodeBinaryExpression* _tmp99_;
		ValaCCodeFunctionCall* renew_call = NULL;
		ValaCCodeIdentifier* _tmp100_;
		ValaCCodeIdentifier* _tmp101_;
		ValaCCodeFunctionCall* _tmp102_;
		ValaCCodeFunctionCall* _tmp103_;
		ValaCCodeFunctionCall* _tmp104_;
		ValaDataType* _tmp105_;
		ValaDataType* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
		ValaCCodeIdentifier* _tmp109_;
		ValaCCodeIdentifier* _tmp110_;
		ValaCCodeFunctionCall* _tmp111_;
		ValaCCodeIdentifier* _tmp112_;
		ValaCCodeIdentifier* _tmp113_;
		ValaCCodeFunctionCall* _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
		ValaCCodeIdentifier* _tmp117_;
		ValaCCodeIdentifier* _tmp118_;
		ValaCCodeConstant* _tmp119_;
		ValaCCodeConstant* _tmp120_;
		ValaCCodeBinaryExpression* _tmp121_;
		ValaCCodeBinaryExpression* _tmp122_;
		ValaCCodeFunction* _tmp123_;
		ValaCCodeFunction* _tmp124_;
		ValaCCodeIdentifier* _tmp125_;
		ValaCCodeIdentifier* _tmp126_;
		ValaCCodeFunctionCall* _tmp127_;
		ValaCCodeFunction* _tmp128_;
		ValaCCodeFunction* _tmp129_;
		ValaCCodeElementAccess* element_access = NULL;
		ValaCCodeIdentifier* _tmp130_;
		ValaCCodeIdentifier* _tmp131_;
		gchar* _tmp132_;
		gchar* _tmp133_;
		ValaCCodeIdentifier* _tmp134_;
		ValaCCodeIdentifier* _tmp135_;
		ValaCCodeUnaryExpression* _tmp136_;
		ValaCCodeUnaryExpression* _tmp137_;
		ValaCCodeElementAccess* _tmp138_;
		ValaCCodeElementAccess* _tmp139_;
		ValaCCodeExpression* element_expr = NULL;
		ValaDataType* _tmp140_;
		ValaDataType* _tmp141_;
		const gchar* _tmp142_;
		ValaCCodeIdentifier* _tmp143_;
		ValaCCodeIdentifier* _tmp144_;
		ValaCCodeExpression* _tmp145_;
		ValaCCodeExpression* _tmp146_;
		ValaCCodeFunction* _tmp147_;
		ValaCCodeFunction* _tmp148_;
		ValaCCodeElementAccess* _tmp149_;
		ValaCCodeExpression* _tmp150_;
		_tmp72_ = g_strconcat (temp_name, "_size", NULL);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_ccode_identifier_new (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_strconcat (temp_name, "_length", NULL);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_ccode_identifier_new (_tmp77_);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp75_, (ValaCCodeExpression*) _tmp79_);
		_tmp81_ = _tmp80_;
		_vala_ccode_node_unref0 (_tmp79_);
		_g_free0 (_tmp77_);
		_vala_ccode_node_unref0 (_tmp75_);
		_g_free0 (_tmp73_);
		size_check = _tmp81_;
		_tmp82_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp83_ = _tmp82_;
		_tmp84_ = size_check;
		vala_ccode_function_open_if (_tmp83_, (ValaCCodeExpression*) _tmp84_);
		_tmp85_ = vala_ccode_constant_new ("2");
		_tmp86_ = _tmp85_;
		_tmp87_ = g_strconcat (temp_name, "_size", NULL);
		_tmp88_ = _tmp87_;
		_tmp89_ = vala_ccode_identifier_new (_tmp88_);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp86_, (ValaCCodeExpression*) _tmp90_);
		_tmp92_ = _tmp91_;
		_vala_ccode_node_unref0 (_tmp90_);
		_g_free0 (_tmp88_);
		_vala_ccode_node_unref0 (_tmp86_);
		new_size = _tmp92_;
		_tmp93_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp94_ = _tmp93_;
		_tmp95_ = g_strconcat (temp_name, "_size", NULL);
		_tmp96_ = _tmp95_;
		_tmp97_ = vala_ccode_identifier_new (_tmp96_);
		_tmp98_ = _tmp97_;
		_tmp99_ = new_size;
		vala_ccode_function_add_assignment (_tmp94_, (ValaCCodeExpression*) _tmp98_, (ValaCCodeExpression*) _tmp99_);
		_vala_ccode_node_unref0 (_tmp98_);
		_g_free0 (_tmp96_);
		_tmp100_ = vala_ccode_identifier_new ("g_renew");
		_tmp101_ = _tmp100_;
		_tmp102_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp101_);
		_tmp103_ = _tmp102_;
		_vala_ccode_node_unref0 (_tmp101_);
		renew_call = _tmp103_;
		_tmp104_ = renew_call;
		_tmp105_ = vala_array_type_get_element_type (array_type);
		_tmp106_ = _tmp105_;
		_tmp107_ = vala_get_ccode_name ((ValaCodeNode*) _tmp106_);
		_tmp108_ = _tmp107_;
		_tmp109_ = vala_ccode_identifier_new (_tmp108_);
		_tmp110_ = _tmp109_;
		vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp110_);
		_vala_ccode_node_unref0 (_tmp110_);
		_g_free0 (_tmp108_);
		_tmp111_ = renew_call;
		_tmp112_ = vala_ccode_identifier_new (temp_name);
		_tmp113_ = _tmp112_;
		vala_ccode_function_call_add_argument (_tmp111_, (ValaCCodeExpression*) _tmp113_);
		_vala_ccode_node_unref0 (_tmp113_);
		_tmp114_ = renew_call;
		_tmp115_ = g_strconcat (temp_name, "_size", NULL);
		_tmp116_ = _tmp115_;
		_tmp117_ = vala_ccode_identifier_new (_tmp116_);
		_tmp118_ = _tmp117_;
		_tmp119_ = vala_ccode_constant_new ("1");
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp118_, (ValaCCodeExpression*) _tmp120_);
		_tmp122_ = _tmp121_;
		vala_ccode_function_call_add_argument (_tmp114_, (ValaCCodeExpression*) _tmp122_);
		_vala_ccode_node_unref0 (_tmp122_);
		_vala_ccode_node_unref0 (_tmp120_);
		_vala_ccode_node_unref0 (_tmp118_);
		_g_free0 (_tmp116_);
		_tmp123_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp124_ = _tmp123_;
		_tmp125_ = vala_ccode_identifier_new (temp_name);
		_tmp126_ = _tmp125_;
		_tmp127_ = renew_call;
		vala_ccode_function_add_assignment (_tmp124_, (ValaCCodeExpression*) _tmp126_, (ValaCCodeExpression*) _tmp127_);
		_vala_ccode_node_unref0 (_tmp126_);
		_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp129_ = _tmp128_;
		vala_ccode_function_close (_tmp129_);
		_tmp130_ = vala_ccode_identifier_new (temp_name);
		_tmp131_ = _tmp130_;
		_tmp132_ = g_strconcat (temp_name, "_length", NULL);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_ccode_identifier_new (_tmp133_);
		_tmp135_ = _tmp134_;
		_tmp136_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) _tmp135_);
		_tmp137_ = _tmp136_;
		_tmp138_ = vala_ccode_element_access_new ((ValaCCodeExpression*) _tmp131_, (ValaCCodeExpression*) _tmp137_);
		_tmp139_ = _tmp138_;
		_vala_ccode_node_unref0 (_tmp137_);
		_vala_ccode_node_unref0 (_tmp135_);
		_g_free0 (_tmp133_);
		_vala_ccode_node_unref0 (_tmp131_);
		element_access = _tmp139_;
		_tmp140_ = vala_array_type_get_element_type (array_type);
		_tmp141_ = _tmp140_;
		_tmp142_ = element_name;
		_tmp143_ = vala_ccode_identifier_new (_tmp142_);
		_tmp144_ = _tmp143_;
		_tmp145_ = vala_ccode_base_module_deserialize_expression ((ValaCCodeBaseModule*) self, _tmp141_, (ValaCCodeExpression*) _tmp144_, NULL, NULL, NULL);
		_tmp146_ = _tmp145_;
		_vala_ccode_node_unref0 (_tmp144_);
		element_expr = _tmp146_;
		_tmp147_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp148_ = _tmp147_;
		_tmp149_ = element_access;
		_tmp150_ = element_expr;
		vala_ccode_function_add_assignment (_tmp148_, (ValaCCodeExpression*) _tmp149_, _tmp150_);
		_vala_ccode_node_unref0 (element_expr);
		_vala_ccode_node_unref0 (element_access);
		_vala_ccode_node_unref0 (renew_call);
		_vala_ccode_node_unref0 (new_size);
		_vala_ccode_node_unref0 (size_check);
	}
	_tmp151_ = vala_ccode_identifier_new ("g_variant_unref");
	_tmp152_ = _tmp151_;
	_tmp153_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp152_);
	_tmp154_ = _tmp153_;
	_vala_ccode_node_unref0 (_tmp152_);
	unref = _tmp154_;
	_tmp155_ = unref;
	_tmp156_ = element_name;
	_tmp157_ = vala_ccode_identifier_new (_tmp156_);
	_tmp158_ = _tmp157_;
	vala_ccode_function_call_add_argument (_tmp155_, (ValaCCodeExpression*) _tmp158_);
	_vala_ccode_node_unref0 (_tmp158_);
	_tmp159_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp160_ = _tmp159_;
	_tmp161_ = unref;
	vala_ccode_function_add_expression (_tmp160_, (ValaCCodeExpression*) _tmp161_);
	_tmp162_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp163_ = _tmp162_;
	vala_ccode_function_close (_tmp163_);
	if (expr != NULL) {
		ValaCCodeFunction* _tmp164_;
		ValaCCodeFunction* _tmp165_;
		ValaCCodeExpression* _tmp166_;
		ValaCCodeExpression* _tmp167_;
		gchar* _tmp168_;
		gchar* _tmp169_;
		ValaCCodeIdentifier* _tmp170_;
		ValaCCodeIdentifier* _tmp171_;
		_tmp164_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp165_ = _tmp164_;
		_tmp166_ = vala_gvariant_module_get_array_length (self, expr, dim);
		_tmp167_ = _tmp166_;
		_tmp168_ = g_strdup_printf ("%s_length%d", temp_name, dim);
		_tmp169_ = _tmp168_;
		_tmp170_ = vala_ccode_identifier_new (_tmp169_);
		_tmp171_ = _tmp170_;
		vala_ccode_function_add_assignment (_tmp165_, _tmp167_, (ValaCCodeExpression*) _tmp171_);
		_vala_ccode_node_unref0 (_tmp171_);
		_g_free0 (_tmp169_);
		_vala_ccode_node_unref0 (_tmp167_);
	}
	_vala_ccode_node_unref0 (unref);
	_vala_ccode_node_unref0 (cforiter);
	_vala_ccode_node_unref0 (cforcond);
	_vala_ccode_node_unref0 (iter_call);
	_g_free0 (element_name);
	_g_free0 (subiter_name);
}


static ValaCCodeExpression*
vala_gvariant_module_deserialize_buffer_array (ValaGVariantModule* self,
                                               ValaArrayType* array_type,
                                               ValaCCodeExpression* variant_expr,
                                               ValaCCodeExpression* expr)
{
	ValaCCodeExpression* result = NULL;
	gchar* temp_name = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	ValaCCodeFunctionCall* get_data_call = NULL;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* _tmp6_;
	ValaCCodeFunctionCall* _tmp7_;
	ValaCCodeFunctionCall* get_size_call = NULL;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeFunctionCall* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	ValaCCodeFunctionCall* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	ValaCCodeFunctionCall* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeVariableDeclarator* _tmp20_;
	ValaCCodeIdentifier* length = NULL;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* dup_call = NULL;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeIdentifier* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeFunctionCall* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeFunctionCall* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeVariableDeclarator* _tmp40_;
	ValaCCodeVariableDeclarator* _tmp41_;
	const gchar* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	g_return_val_if_fail (variant_expr != NULL, NULL);
	_tmp0_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp1_ + 1);
	_tmp2_ = g_strdup_printf ("_tmp%d_", _tmp1_);
	temp_name = _tmp2_;
	_tmp3_ = vala_ccode_identifier_new ("g_variant_get_data");
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp4_);
	_tmp6_ = _tmp5_;
	_vala_ccode_node_unref0 (_tmp4_);
	get_data_call = _tmp6_;
	_tmp7_ = get_data_call;
	vala_ccode_function_call_add_argument (_tmp7_, variant_expr);
	_tmp8_ = vala_ccode_identifier_new ("g_variant_get_size");
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp9_);
	_tmp11_ = _tmp10_;
	_vala_ccode_node_unref0 (_tmp9_);
	get_size_call = _tmp11_;
	_tmp12_ = get_size_call;
	vala_ccode_function_call_add_argument (_tmp12_, variant_expr);
	_tmp13_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = temp_name;
	_tmp16_ = g_strconcat (_tmp15_, "_length", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = get_size_call;
	_tmp19_ = vala_ccode_variable_declarator_new (_tmp17_, (ValaCCodeExpression*) _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	vala_ccode_function_add_declaration (_tmp14_, "gsize", (ValaCCodeDeclarator*) _tmp20_, 0);
	_vala_ccode_node_unref0 (_tmp20_);
	_g_free0 (_tmp17_);
	_tmp21_ = temp_name;
	_tmp22_ = g_strconcat (_tmp21_, "_length", NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_ccode_identifier_new (_tmp23_);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	length = _tmp25_;
	_tmp26_ = vala_ccode_identifier_new ("g_memdup");
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp27_);
	_tmp29_ = _tmp28_;
	_vala_ccode_node_unref0 (_tmp27_);
	dup_call = _tmp29_;
	_tmp30_ = dup_call;
	_tmp31_ = get_data_call;
	vala_ccode_function_call_add_argument (_tmp30_, (ValaCCodeExpression*) _tmp31_);
	_tmp32_ = dup_call;
	_tmp33_ = length;
	vala_ccode_function_call_add_argument (_tmp32_, (ValaCCodeExpression*) _tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_get_ccode_name ((ValaCodeNode*) array_type);
	_tmp37_ = _tmp36_;
	_tmp38_ = temp_name;
	_tmp39_ = dup_call;
	_tmp40_ = vala_ccode_variable_declarator_new (_tmp38_, (ValaCCodeExpression*) _tmp39_, NULL);
	_tmp41_ = _tmp40_;
	vala_ccode_function_add_declaration (_tmp35_, _tmp37_, (ValaCCodeDeclarator*) _tmp41_, 0);
	_vala_ccode_node_unref0 (_tmp41_);
	_g_free0 (_tmp37_);
	if (expr != NULL) {
		ValaCCodeFunction* _tmp42_;
		ValaCCodeFunction* _tmp43_;
		ValaCCodeExpression* _tmp44_;
		ValaCCodeExpression* _tmp45_;
		ValaCCodeIdentifier* _tmp46_;
		_tmp42_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_gvariant_module_get_array_length (self, expr, 1);
		_tmp45_ = _tmp44_;
		_tmp46_ = length;
		vala_ccode_function_add_assignment (_tmp43_, _tmp45_, (ValaCCodeExpression*) _tmp46_);
		_vala_ccode_node_unref0 (_tmp45_);
	}
	_tmp47_ = temp_name;
	_tmp48_ = vala_ccode_identifier_new (_tmp47_);
	result = (ValaCCodeExpression*) _tmp48_;
	_vala_ccode_node_unref0 (dup_call);
	_vala_ccode_node_unref0 (length);
	_vala_ccode_node_unref0 (get_size_call);
	_vala_ccode_node_unref0 (get_data_call);
	_g_free0 (temp_name);
	return result;
}


static ValaCCodeExpression*
vala_gvariant_module_deserialize_struct (ValaGVariantModule* self,
                                         ValaStruct* st,
                                         ValaCCodeExpression* variant_expr)
{
	ValaCCodeExpression* result = NULL;
	gchar* temp_name = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* subiter_name = NULL;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	ValaCCodeVariableDeclarator* _tmp11_;
	ValaCCodeVariableDeclarator* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	const gchar* _tmp15_;
	ValaCCodeVariableDeclarator* _tmp16_;
	ValaCCodeVariableDeclarator* _tmp17_;
	ValaCCodeFunctionCall* iter_call = NULL;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeFunctionCall* _tmp20_;
	ValaCCodeFunctionCall* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	const gchar* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeUnaryExpression* _tmp26_;
	ValaCCodeUnaryExpression* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFunction* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	gboolean field_found = FALSE;
	gboolean _tmp60_;
	const gchar* _tmp61_;
	ValaCCodeIdentifier* _tmp62_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (st != NULL, NULL);
	g_return_val_if_fail (variant_expr != NULL, NULL);
	_tmp0_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp1_ + 1);
	_tmp2_ = g_strdup_printf ("_tmp%d_", _tmp1_);
	temp_name = _tmp2_;
	_tmp3_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp4_ = _tmp3_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp4_ + 1);
	_tmp5_ = g_strdup_printf ("_tmp%d_", _tmp4_);
	subiter_name = _tmp5_;
	_tmp6_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_get_ccode_name ((ValaCodeNode*) st);
	_tmp9_ = _tmp8_;
	_tmp10_ = temp_name;
	_tmp11_ = vala_ccode_variable_declarator_new (_tmp10_, NULL, NULL);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_declaration (_tmp7_, _tmp9_, (ValaCCodeDeclarator*) _tmp12_, 0);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp9_);
	_tmp13_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = subiter_name;
	_tmp16_ = vala_ccode_variable_declarator_new (_tmp15_, NULL, NULL);
	_tmp17_ = _tmp16_;
	vala_ccode_function_add_declaration (_tmp14_, "GVariantIter", (ValaCCodeDeclarator*) _tmp17_, 0);
	_vala_ccode_node_unref0 (_tmp17_);
	_tmp18_ = vala_ccode_identifier_new ("g_variant_iter_init");
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp19_);
	_tmp21_ = _tmp20_;
	_vala_ccode_node_unref0 (_tmp19_);
	iter_call = _tmp21_;
	_tmp22_ = iter_call;
	_tmp23_ = subiter_name;
	_tmp24_ = vala_ccode_identifier_new (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	vala_ccode_function_call_add_argument (_tmp22_, (ValaCCodeExpression*) _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp28_ = iter_call;
	vala_ccode_function_call_add_argument (_tmp28_, variant_expr);
	_tmp29_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp30_ = _tmp29_;
	_tmp31_ = iter_call;
	vala_ccode_function_add_expression (_tmp30_, (ValaCCodeExpression*) _tmp31_);
	field_found = FALSE;
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp32_;
		gint _f_size = 0;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _f_index = 0;
		_tmp32_ = vala_struct_get_fields (st);
		_f_list = _tmp32_;
		_tmp33_ = _f_list;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_f_size = _tmp35_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			ValaField* f = NULL;
			ValaList* _tmp39_;
			gint _tmp40_;
			gpointer _tmp41_;
			ValaField* _tmp42_;
			ValaMemberBinding _tmp43_;
			ValaMemberBinding _tmp44_;
			ValaField* _tmp45_;
			ValaDataType* _tmp46_;
			ValaDataType* _tmp47_;
			const gchar* _tmp48_;
			ValaCCodeIdentifier* _tmp49_;
			ValaCCodeIdentifier* _tmp50_;
			const gchar* _tmp51_;
			ValaCCodeIdentifier* _tmp52_;
			ValaCCodeIdentifier* _tmp53_;
			ValaField* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			ValaCCodeMemberAccess* _tmp57_;
			ValaCCodeMemberAccess* _tmp58_;
			ValaField* _tmp59_;
			_tmp36_ = _f_index;
			_f_index = _tmp36_ + 1;
			_tmp37_ = _f_index;
			_tmp38_ = _f_size;
			if (!(_tmp37_ < _tmp38_)) {
				break;
			}
			_tmp39_ = _f_list;
			_tmp40_ = _f_index;
			_tmp41_ = vala_list_get (_tmp39_, _tmp40_);
			f = (ValaField*) _tmp41_;
			_tmp42_ = f;
			_tmp43_ = vala_field_get_binding (_tmp42_);
			_tmp44_ = _tmp43_;
			if (_tmp44_ != VALA_MEMBER_BINDING_INSTANCE) {
				_vala_code_node_unref0 (f);
				continue;
			}
			field_found = TRUE;
			_tmp45_ = f;
			_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = subiter_name;
			_tmp49_ = vala_ccode_identifier_new (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = temp_name;
			_tmp52_ = vala_ccode_identifier_new (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = f;
			_tmp55_ = vala_get_ccode_name ((ValaCodeNode*) _tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp53_, _tmp56_, FALSE);
			_tmp58_ = _tmp57_;
			_tmp59_ = f;
			vala_gvariant_module_read_expression (self, _tmp47_, (ValaCCodeExpression*) _tmp50_, (ValaCCodeExpression*) _tmp58_, (ValaSymbol*) _tmp59_, NULL, NULL);
			_vala_ccode_node_unref0 (_tmp58_);
			_g_free0 (_tmp56_);
			_vala_ccode_node_unref0 (_tmp53_);
			_vala_ccode_node_unref0 (_tmp50_);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	_tmp60_ = field_found;
	if (!_tmp60_) {
		result = NULL;
		_vala_ccode_node_unref0 (iter_call);
		_g_free0 (subiter_name);
		_g_free0 (temp_name);
		return result;
	}
	_tmp61_ = temp_name;
	_tmp62_ = vala_ccode_identifier_new (_tmp61_);
	result = (ValaCCodeExpression*) _tmp62_;
	_vala_ccode_node_unref0 (iter_call);
	_g_free0 (subiter_name);
	_g_free0 (temp_name);
	return result;
}


static ValaCCodeExpression*
vala_gvariant_module_deserialize_hash_table (ValaGVariantModule* self,
                                             ValaObjectType* type,
                                             ValaCCodeExpression* variant_expr)
{
	ValaCCodeExpression* result = NULL;
	gchar* temp_name = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* subiter_name = NULL;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* key_name = NULL;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* value_name = NULL;
	gint _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	ValaList* type_args = NULL;
	ValaList* _tmp12_;
	ValaList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	ValaDataType* key_type = NULL;
	ValaList* _tmp16_;
	gpointer _tmp17_;
	ValaDataType* value_type = NULL;
	ValaList* _tmp18_;
	gpointer _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	const gchar* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeVariableDeclarator* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	const gchar* _tmp27_;
	ValaCCodeVariableDeclarator* _tmp28_;
	ValaCCodeVariableDeclarator* _tmp29_;
	ValaCCodeFunction* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	const gchar* _tmp32_;
	ValaCCodeVariableDeclarator* _tmp33_;
	ValaCCodeVariableDeclarator* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunction* _tmp36_;
	const gchar* _tmp37_;
	ValaCCodeVariableDeclarator* _tmp38_;
	ValaCCodeVariableDeclarator* _tmp39_;
	ValaCCodeFunctionCall* hash_table_new = NULL;
	ValaCCodeIdentifier* _tmp40_;
	ValaCCodeIdentifier* _tmp41_;
	ValaCCodeFunctionCall* _tmp42_;
	ValaCCodeFunctionCall* _tmp43_;
	ValaDataType* _tmp44_;
	ValaTypeSymbol* _tmp45_;
	ValaTypeSymbol* _tmp46_;
	ValaDataType* _tmp47_;
	ValaTypeSymbol* _tmp48_;
	ValaTypeSymbol* _tmp49_;
	ValaDataType* _tmp72_;
	ValaTypeSymbol* _tmp73_;
	ValaTypeSymbol* _tmp74_;
	ValaDataType* _tmp75_;
	ValaTypeSymbol* _tmp76_;
	ValaTypeSymbol* _tmp77_;
	ValaDataType* _tmp104_;
	ValaTypeSymbol* _tmp105_;
	ValaTypeSymbol* _tmp106_;
	ValaDataType* _tmp107_;
	ValaTypeSymbol* _tmp108_;
	ValaTypeSymbol* _tmp109_;
	ValaCCodeFunction* _tmp136_;
	ValaCCodeFunction* _tmp137_;
	const gchar* _tmp138_;
	ValaCCodeIdentifier* _tmp139_;
	ValaCCodeIdentifier* _tmp140_;
	ValaCCodeFunctionCall* _tmp141_;
	ValaCCodeFunctionCall* iter_call = NULL;
	ValaCCodeIdentifier* _tmp142_;
	ValaCCodeIdentifier* _tmp143_;
	ValaCCodeFunctionCall* _tmp144_;
	ValaCCodeFunctionCall* _tmp145_;
	ValaCCodeFunctionCall* _tmp146_;
	const gchar* _tmp147_;
	ValaCCodeIdentifier* _tmp148_;
	ValaCCodeIdentifier* _tmp149_;
	ValaCCodeUnaryExpression* _tmp150_;
	ValaCCodeUnaryExpression* _tmp151_;
	ValaCCodeFunctionCall* _tmp152_;
	ValaCCodeFunction* _tmp153_;
	ValaCCodeFunction* _tmp154_;
	ValaCCodeFunctionCall* _tmp155_;
	ValaCCodeIdentifier* _tmp156_;
	ValaCCodeIdentifier* _tmp157_;
	ValaCCodeFunctionCall* _tmp158_;
	ValaCCodeFunctionCall* _tmp159_;
	const gchar* _tmp160_;
	ValaCCodeIdentifier* _tmp161_;
	ValaCCodeIdentifier* _tmp162_;
	ValaCCodeUnaryExpression* _tmp163_;
	ValaCCodeUnaryExpression* _tmp164_;
	ValaCCodeFunctionCall* _tmp165_;
	ValaCCodeConstant* _tmp166_;
	ValaCCodeConstant* _tmp167_;
	ValaCCodeFunctionCall* _tmp168_;
	const gchar* _tmp169_;
	ValaCCodeIdentifier* _tmp170_;
	ValaCCodeIdentifier* _tmp171_;
	ValaCCodeUnaryExpression* _tmp172_;
	ValaCCodeUnaryExpression* _tmp173_;
	ValaCCodeFunctionCall* _tmp174_;
	const gchar* _tmp175_;
	ValaCCodeIdentifier* _tmp176_;
	ValaCCodeIdentifier* _tmp177_;
	ValaCCodeUnaryExpression* _tmp178_;
	ValaCCodeUnaryExpression* _tmp179_;
	ValaCCodeFunction* _tmp180_;
	ValaCCodeFunction* _tmp181_;
	ValaCCodeFunctionCall* _tmp182_;
	ValaCCodeExpression* key_expr = NULL;
	ValaDataType* _tmp183_;
	const gchar* _tmp184_;
	ValaCCodeIdentifier* _tmp185_;
	ValaCCodeIdentifier* _tmp186_;
	ValaCCodeExpression* _tmp187_;
	ValaCCodeExpression* _tmp188_;
	ValaCCodeExpression* value_expr = NULL;
	ValaDataType* _tmp189_;
	const gchar* _tmp190_;
	ValaCCodeIdentifier* _tmp191_;
	ValaCCodeIdentifier* _tmp192_;
	ValaCCodeExpression* _tmp193_;
	ValaCCodeExpression* _tmp194_;
	gboolean _tmp195_ = FALSE;
	ValaCCodeExpression* _tmp196_;
	ValaCCodeFunctionCall* hash_table_insert = NULL;
	ValaCCodeIdentifier* _tmp198_;
	ValaCCodeIdentifier* _tmp199_;
	ValaCCodeFunctionCall* _tmp200_;
	ValaCCodeFunctionCall* _tmp201_;
	ValaCCodeFunctionCall* _tmp202_;
	const gchar* _tmp203_;
	ValaCCodeIdentifier* _tmp204_;
	ValaCCodeIdentifier* _tmp205_;
	ValaCCodeFunctionCall* _tmp206_;
	ValaCCodeExpression* _tmp207_;
	ValaDataType* _tmp208_;
	ValaCCodeExpression* _tmp209_;
	ValaCCodeExpression* _tmp210_;
	ValaCCodeFunctionCall* _tmp211_;
	ValaCCodeExpression* _tmp212_;
	ValaDataType* _tmp213_;
	ValaCCodeExpression* _tmp214_;
	ValaCCodeExpression* _tmp215_;
	ValaCCodeFunction* _tmp216_;
	ValaCCodeFunction* _tmp217_;
	ValaCCodeFunctionCall* _tmp218_;
	ValaCCodeFunction* _tmp219_;
	ValaCCodeFunction* _tmp220_;
	const gchar* _tmp221_;
	ValaCCodeIdentifier* _tmp222_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (variant_expr != NULL, NULL);
	_tmp0_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp1_ + 1);
	_tmp2_ = g_strdup_printf ("_tmp%d_", _tmp1_);
	temp_name = _tmp2_;
	_tmp3_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp4_ = _tmp3_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp4_ + 1);
	_tmp5_ = g_strdup_printf ("_tmp%d_", _tmp4_);
	subiter_name = _tmp5_;
	_tmp6_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp7_ = _tmp6_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp7_ + 1);
	_tmp8_ = g_strdup_printf ("_tmp%d_", _tmp7_);
	key_name = _tmp8_;
	_tmp9_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp10_ + 1);
	_tmp11_ = g_strdup_printf ("_tmp%d_", _tmp10_);
	value_name = _tmp11_;
	_tmp12_ = vala_data_type_get_type_arguments ((ValaDataType*) type);
	type_args = _tmp12_;
	_tmp13_ = type_args;
	_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_assert (_tmp15_ == 2, "type_args.size == 2");
	_tmp16_ = type_args;
	_tmp17_ = vala_list_get (_tmp16_, 0);
	key_type = (ValaDataType*) _tmp17_;
	_tmp18_ = type_args;
	_tmp19_ = vala_list_get (_tmp18_, 1);
	value_type = (ValaDataType*) _tmp19_;
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = temp_name;
	_tmp23_ = vala_ccode_variable_declarator_new (_tmp22_, NULL, NULL);
	_tmp24_ = _tmp23_;
	vala_ccode_function_add_declaration (_tmp21_, "GHashTable*", (ValaCCodeDeclarator*) _tmp24_, 0);
	_vala_ccode_node_unref0 (_tmp24_);
	_tmp25_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp26_ = _tmp25_;
	_tmp27_ = subiter_name;
	_tmp28_ = vala_ccode_variable_declarator_new (_tmp27_, NULL, NULL);
	_tmp29_ = _tmp28_;
	vala_ccode_function_add_declaration (_tmp26_, "GVariantIter", (ValaCCodeDeclarator*) _tmp29_, 0);
	_vala_ccode_node_unref0 (_tmp29_);
	_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp31_ = _tmp30_;
	_tmp32_ = key_name;
	_tmp33_ = vala_ccode_variable_declarator_new (_tmp32_, NULL, NULL);
	_tmp34_ = _tmp33_;
	vala_ccode_function_add_declaration (_tmp31_, "GVariant*", (ValaCCodeDeclarator*) _tmp34_, 0);
	_vala_ccode_node_unref0 (_tmp34_);
	_tmp35_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp36_ = _tmp35_;
	_tmp37_ = value_name;
	_tmp38_ = vala_ccode_variable_declarator_new (_tmp37_, NULL, NULL);
	_tmp39_ = _tmp38_;
	vala_ccode_function_add_declaration (_tmp36_, "GVariant*", (ValaCCodeDeclarator*) _tmp39_, 0);
	_vala_ccode_node_unref0 (_tmp39_);
	_tmp40_ = vala_ccode_identifier_new ("g_hash_table_new_full");
	_tmp41_ = _tmp40_;
	_tmp42_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp41_);
	_tmp43_ = _tmp42_;
	_vala_ccode_node_unref0 (_tmp41_);
	hash_table_new = _tmp43_;
	_tmp44_ = key_type;
	_tmp45_ = vala_data_type_get_data_type (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = ((ValaCCodeBaseModule*) self)->string_type;
	_tmp48_ = vala_data_type_get_data_type (_tmp47_);
	_tmp49_ = _tmp48_;
	if (vala_typesymbol_is_subtype_of (_tmp46_, _tmp49_)) {
		ValaCCodeFunctionCall* _tmp50_;
		ValaCCodeIdentifier* _tmp51_;
		ValaCCodeIdentifier* _tmp52_;
		ValaCCodeFunctionCall* _tmp53_;
		ValaCCodeIdentifier* _tmp54_;
		ValaCCodeIdentifier* _tmp55_;
		_tmp50_ = hash_table_new;
		_tmp51_ = vala_ccode_identifier_new ("g_str_hash");
		_tmp52_ = _tmp51_;
		vala_ccode_function_call_add_argument (_tmp50_, (ValaCCodeExpression*) _tmp52_);
		_vala_ccode_node_unref0 (_tmp52_);
		_tmp53_ = hash_table_new;
		_tmp54_ = vala_ccode_identifier_new ("g_str_equal");
		_tmp55_ = _tmp54_;
		vala_ccode_function_call_add_argument (_tmp53_, (ValaCCodeExpression*) _tmp55_);
		_vala_ccode_node_unref0 (_tmp55_);
	} else {
		ValaDataType* _tmp56_;
		ValaTypeSymbol* _tmp57_;
		ValaTypeSymbol* _tmp58_;
		ValaClass* _tmp59_;
		_tmp56_ = key_type;
		_tmp57_ = vala_data_type_get_data_type (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = ((ValaCCodeBaseModule*) self)->gvariant_type;
		if (_tmp58_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
			ValaCCodeFunctionCall* _tmp60_;
			ValaCCodeIdentifier* _tmp61_;
			ValaCCodeIdentifier* _tmp62_;
			ValaCCodeFunctionCall* _tmp63_;
			ValaCCodeIdentifier* _tmp64_;
			ValaCCodeIdentifier* _tmp65_;
			_tmp60_ = hash_table_new;
			_tmp61_ = vala_ccode_identifier_new ("g_variant_hash");
			_tmp62_ = _tmp61_;
			vala_ccode_function_call_add_argument (_tmp60_, (ValaCCodeExpression*) _tmp62_);
			_vala_ccode_node_unref0 (_tmp62_);
			_tmp63_ = hash_table_new;
			_tmp64_ = vala_ccode_identifier_new ("g_variant_equal");
			_tmp65_ = _tmp64_;
			vala_ccode_function_call_add_argument (_tmp63_, (ValaCCodeExpression*) _tmp65_);
			_vala_ccode_node_unref0 (_tmp65_);
		} else {
			ValaCCodeFunctionCall* _tmp66_;
			ValaCCodeIdentifier* _tmp67_;
			ValaCCodeIdentifier* _tmp68_;
			ValaCCodeFunctionCall* _tmp69_;
			ValaCCodeIdentifier* _tmp70_;
			ValaCCodeIdentifier* _tmp71_;
			_tmp66_ = hash_table_new;
			_tmp67_ = vala_ccode_identifier_new ("g_direct_hash");
			_tmp68_ = _tmp67_;
			vala_ccode_function_call_add_argument (_tmp66_, (ValaCCodeExpression*) _tmp68_);
			_vala_ccode_node_unref0 (_tmp68_);
			_tmp69_ = hash_table_new;
			_tmp70_ = vala_ccode_identifier_new ("g_direct_equal");
			_tmp71_ = _tmp70_;
			vala_ccode_function_call_add_argument (_tmp69_, (ValaCCodeExpression*) _tmp71_);
			_vala_ccode_node_unref0 (_tmp71_);
		}
	}
	_tmp72_ = key_type;
	_tmp73_ = vala_data_type_get_data_type (_tmp72_);
	_tmp74_ = _tmp73_;
	_tmp75_ = ((ValaCCodeBaseModule*) self)->string_type;
	_tmp76_ = vala_data_type_get_data_type (_tmp75_);
	_tmp77_ = _tmp76_;
	if (vala_typesymbol_is_subtype_of (_tmp74_, _tmp77_)) {
		ValaCCodeFunctionCall* _tmp78_;
		ValaCCodeIdentifier* _tmp79_;
		ValaCCodeIdentifier* _tmp80_;
		_tmp78_ = hash_table_new;
		_tmp79_ = vala_ccode_identifier_new ("g_free");
		_tmp80_ = _tmp79_;
		vala_ccode_function_call_add_argument (_tmp78_, (ValaCCodeExpression*) _tmp80_);
		_vala_ccode_node_unref0 (_tmp80_);
	} else {
		ValaDataType* _tmp81_;
		ValaTypeSymbol* _tmp82_;
		ValaTypeSymbol* _tmp83_;
		ValaClass* _tmp84_;
		_tmp81_ = key_type;
		_tmp82_ = vala_data_type_get_data_type (_tmp81_);
		_tmp83_ = _tmp82_;
		_tmp84_ = ((ValaCCodeBaseModule*) self)->gvariant_type;
		if (_tmp83_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
			ValaCCodeFunctionCall* _tmp85_;
			ValaCCodeIdentifier* _tmp86_;
			ValaCCodeIdentifier* _tmp87_;
			ValaCCodeCastExpression* _tmp88_;
			ValaCCodeCastExpression* _tmp89_;
			_tmp85_ = hash_table_new;
			_tmp86_ = vala_ccode_identifier_new ("g_variant_unref");
			_tmp87_ = _tmp86_;
			_tmp88_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp87_, "GDestroyNotify");
			_tmp89_ = _tmp88_;
			vala_ccode_function_call_add_argument (_tmp85_, (ValaCCodeExpression*) _tmp89_);
			_vala_ccode_node_unref0 (_tmp89_);
			_vala_ccode_node_unref0 (_tmp87_);
		} else {
			ValaDataType* _tmp90_;
			ValaTypeSymbol* _tmp91_;
			ValaTypeSymbol* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			gboolean _tmp95_;
			_tmp90_ = key_type;
			_tmp91_ = vala_data_type_get_data_type (_tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = g_strcmp0 (_tmp94_, "GLib.HashTable") == 0;
			_g_free0 (_tmp94_);
			if (_tmp95_) {
				ValaCCodeFunctionCall* _tmp96_;
				ValaCCodeIdentifier* _tmp97_;
				ValaCCodeIdentifier* _tmp98_;
				ValaCCodeCastExpression* _tmp99_;
				ValaCCodeCastExpression* _tmp100_;
				_tmp96_ = hash_table_new;
				_tmp97_ = vala_ccode_identifier_new ("g_hash_table_unref");
				_tmp98_ = _tmp97_;
				_tmp99_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp98_, "GDestroyNotify");
				_tmp100_ = _tmp99_;
				vala_ccode_function_call_add_argument (_tmp96_, (ValaCCodeExpression*) _tmp100_);
				_vala_ccode_node_unref0 (_tmp100_);
				_vala_ccode_node_unref0 (_tmp98_);
			} else {
				ValaCCodeFunctionCall* _tmp101_;
				ValaCCodeIdentifier* _tmp102_;
				ValaCCodeIdentifier* _tmp103_;
				_tmp101_ = hash_table_new;
				_tmp102_ = vala_ccode_identifier_new ("NULL");
				_tmp103_ = _tmp102_;
				vala_ccode_function_call_add_argument (_tmp101_, (ValaCCodeExpression*) _tmp103_);
				_vala_ccode_node_unref0 (_tmp103_);
			}
		}
	}
	_tmp104_ = value_type;
	_tmp105_ = vala_data_type_get_data_type (_tmp104_);
	_tmp106_ = _tmp105_;
	_tmp107_ = ((ValaCCodeBaseModule*) self)->string_type;
	_tmp108_ = vala_data_type_get_data_type (_tmp107_);
	_tmp109_ = _tmp108_;
	if (vala_typesymbol_is_subtype_of (_tmp106_, _tmp109_)) {
		ValaCCodeFunctionCall* _tmp110_;
		ValaCCodeIdentifier* _tmp111_;
		ValaCCodeIdentifier* _tmp112_;
		_tmp110_ = hash_table_new;
		_tmp111_ = vala_ccode_identifier_new ("g_free");
		_tmp112_ = _tmp111_;
		vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
		_vala_ccode_node_unref0 (_tmp112_);
	} else {
		ValaDataType* _tmp113_;
		ValaTypeSymbol* _tmp114_;
		ValaTypeSymbol* _tmp115_;
		ValaClass* _tmp116_;
		_tmp113_ = value_type;
		_tmp114_ = vala_data_type_get_data_type (_tmp113_);
		_tmp115_ = _tmp114_;
		_tmp116_ = ((ValaCCodeBaseModule*) self)->gvariant_type;
		if (_tmp115_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
			ValaCCodeFunctionCall* _tmp117_;
			ValaCCodeIdentifier* _tmp118_;
			ValaCCodeIdentifier* _tmp119_;
			ValaCCodeCastExpression* _tmp120_;
			ValaCCodeCastExpression* _tmp121_;
			_tmp117_ = hash_table_new;
			_tmp118_ = vala_ccode_identifier_new ("g_variant_unref");
			_tmp119_ = _tmp118_;
			_tmp120_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp119_, "GDestroyNotify");
			_tmp121_ = _tmp120_;
			vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp121_);
			_vala_ccode_node_unref0 (_tmp121_);
			_vala_ccode_node_unref0 (_tmp119_);
		} else {
			ValaDataType* _tmp122_;
			ValaTypeSymbol* _tmp123_;
			ValaTypeSymbol* _tmp124_;
			gchar* _tmp125_;
			gchar* _tmp126_;
			gboolean _tmp127_;
			_tmp122_ = value_type;
			_tmp123_ = vala_data_type_get_data_type (_tmp122_);
			_tmp124_ = _tmp123_;
			_tmp125_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp124_);
			_tmp126_ = _tmp125_;
			_tmp127_ = g_strcmp0 (_tmp126_, "GLib.HashTable") == 0;
			_g_free0 (_tmp126_);
			if (_tmp127_) {
				ValaCCodeFunctionCall* _tmp128_;
				ValaCCodeIdentifier* _tmp129_;
				ValaCCodeIdentifier* _tmp130_;
				ValaCCodeCastExpression* _tmp131_;
				ValaCCodeCastExpression* _tmp132_;
				_tmp128_ = hash_table_new;
				_tmp129_ = vala_ccode_identifier_new ("g_hash_table_unref");
				_tmp130_ = _tmp129_;
				_tmp131_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp130_, "GDestroyNotify");
				_tmp132_ = _tmp131_;
				vala_ccode_function_call_add_argument (_tmp128_, (ValaCCodeExpression*) _tmp132_);
				_vala_ccode_node_unref0 (_tmp132_);
				_vala_ccode_node_unref0 (_tmp130_);
			} else {
				ValaCCodeFunctionCall* _tmp133_;
				ValaCCodeIdentifier* _tmp134_;
				ValaCCodeIdentifier* _tmp135_;
				_tmp133_ = hash_table_new;
				_tmp134_ = vala_ccode_identifier_new ("NULL");
				_tmp135_ = _tmp134_;
				vala_ccode_function_call_add_argument (_tmp133_, (ValaCCodeExpression*) _tmp135_);
				_vala_ccode_node_unref0 (_tmp135_);
			}
		}
	}
	_tmp136_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp137_ = _tmp136_;
	_tmp138_ = temp_name;
	_tmp139_ = vala_ccode_identifier_new (_tmp138_);
	_tmp140_ = _tmp139_;
	_tmp141_ = hash_table_new;
	vala_ccode_function_add_assignment (_tmp137_, (ValaCCodeExpression*) _tmp140_, (ValaCCodeExpression*) _tmp141_);
	_vala_ccode_node_unref0 (_tmp140_);
	_tmp142_ = vala_ccode_identifier_new ("g_variant_iter_init");
	_tmp143_ = _tmp142_;
	_tmp144_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp143_);
	_tmp145_ = _tmp144_;
	_vala_ccode_node_unref0 (_tmp143_);
	iter_call = _tmp145_;
	_tmp146_ = iter_call;
	_tmp147_ = subiter_name;
	_tmp148_ = vala_ccode_identifier_new (_tmp147_);
	_tmp149_ = _tmp148_;
	_tmp150_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp149_);
	_tmp151_ = _tmp150_;
	vala_ccode_function_call_add_argument (_tmp146_, (ValaCCodeExpression*) _tmp151_);
	_vala_ccode_node_unref0 (_tmp151_);
	_vala_ccode_node_unref0 (_tmp149_);
	_tmp152_ = iter_call;
	vala_ccode_function_call_add_argument (_tmp152_, variant_expr);
	_tmp153_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp154_ = _tmp153_;
	_tmp155_ = iter_call;
	vala_ccode_function_add_expression (_tmp154_, (ValaCCodeExpression*) _tmp155_);
	_tmp156_ = vala_ccode_identifier_new ("g_variant_iter_loop");
	_tmp157_ = _tmp156_;
	_tmp158_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp157_);
	_vala_ccode_node_unref0 (iter_call);
	iter_call = _tmp158_;
	_vala_ccode_node_unref0 (_tmp157_);
	_tmp159_ = iter_call;
	_tmp160_ = subiter_name;
	_tmp161_ = vala_ccode_identifier_new (_tmp160_);
	_tmp162_ = _tmp161_;
	_tmp163_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp162_);
	_tmp164_ = _tmp163_;
	vala_ccode_function_call_add_argument (_tmp159_, (ValaCCodeExpression*) _tmp164_);
	_vala_ccode_node_unref0 (_tmp164_);
	_vala_ccode_node_unref0 (_tmp162_);
	_tmp165_ = iter_call;
	_tmp166_ = vala_ccode_constant_new ("\"{?*}\"");
	_tmp167_ = _tmp166_;
	vala_ccode_function_call_add_argument (_tmp165_, (ValaCCodeExpression*) _tmp167_);
	_vala_ccode_node_unref0 (_tmp167_);
	_tmp168_ = iter_call;
	_tmp169_ = key_name;
	_tmp170_ = vala_ccode_identifier_new (_tmp169_);
	_tmp171_ = _tmp170_;
	_tmp172_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp171_);
	_tmp173_ = _tmp172_;
	vala_ccode_function_call_add_argument (_tmp168_, (ValaCCodeExpression*) _tmp173_);
	_vala_ccode_node_unref0 (_tmp173_);
	_vala_ccode_node_unref0 (_tmp171_);
	_tmp174_ = iter_call;
	_tmp175_ = value_name;
	_tmp176_ = vala_ccode_identifier_new (_tmp175_);
	_tmp177_ = _tmp176_;
	_tmp178_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp177_);
	_tmp179_ = _tmp178_;
	vala_ccode_function_call_add_argument (_tmp174_, (ValaCCodeExpression*) _tmp179_);
	_vala_ccode_node_unref0 (_tmp179_);
	_vala_ccode_node_unref0 (_tmp177_);
	_tmp180_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp181_ = _tmp180_;
	_tmp182_ = iter_call;
	vala_ccode_function_open_while (_tmp181_, (ValaCCodeExpression*) _tmp182_);
	_tmp183_ = key_type;
	_tmp184_ = key_name;
	_tmp185_ = vala_ccode_identifier_new (_tmp184_);
	_tmp186_ = _tmp185_;
	_tmp187_ = vala_ccode_base_module_deserialize_expression ((ValaCCodeBaseModule*) self, _tmp183_, (ValaCCodeExpression*) _tmp186_, NULL, NULL, NULL);
	_tmp188_ = _tmp187_;
	_vala_ccode_node_unref0 (_tmp186_);
	key_expr = _tmp188_;
	_tmp189_ = value_type;
	_tmp190_ = value_name;
	_tmp191_ = vala_ccode_identifier_new (_tmp190_);
	_tmp192_ = _tmp191_;
	_tmp193_ = vala_ccode_base_module_deserialize_expression ((ValaCCodeBaseModule*) self, _tmp189_, (ValaCCodeExpression*) _tmp192_, NULL, NULL, NULL);
	_tmp194_ = _tmp193_;
	_vala_ccode_node_unref0 (_tmp192_);
	value_expr = _tmp194_;
	_tmp196_ = key_expr;
	if (_tmp196_ == NULL) {
		_tmp195_ = TRUE;
	} else {
		ValaCCodeExpression* _tmp197_;
		_tmp197_ = value_expr;
		_tmp195_ = _tmp197_ == NULL;
	}
	if (_tmp195_) {
		result = NULL;
		_vala_ccode_node_unref0 (value_expr);
		_vala_ccode_node_unref0 (key_expr);
		_vala_ccode_node_unref0 (iter_call);
		_vala_ccode_node_unref0 (hash_table_new);
		_vala_code_node_unref0 (value_type);
		_vala_code_node_unref0 (key_type);
		_vala_iterable_unref0 (type_args);
		_g_free0 (value_name);
		_g_free0 (key_name);
		_g_free0 (subiter_name);
		_g_free0 (temp_name);
		return result;
	}
	_tmp198_ = vala_ccode_identifier_new ("g_hash_table_insert");
	_tmp199_ = _tmp198_;
	_tmp200_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp199_);
	_tmp201_ = _tmp200_;
	_vala_ccode_node_unref0 (_tmp199_);
	hash_table_insert = _tmp201_;
	_tmp202_ = hash_table_insert;
	_tmp203_ = temp_name;
	_tmp204_ = vala_ccode_identifier_new (_tmp203_);
	_tmp205_ = _tmp204_;
	vala_ccode_function_call_add_argument (_tmp202_, (ValaCCodeExpression*) _tmp205_);
	_vala_ccode_node_unref0 (_tmp205_);
	_tmp206_ = hash_table_insert;
	_tmp207_ = key_expr;
	_tmp208_ = key_type;
	_tmp209_ = vala_ccode_base_module_convert_to_generic_pointer ((ValaCCodeBaseModule*) self, _tmp207_, _tmp208_);
	_tmp210_ = _tmp209_;
	vala_ccode_function_call_add_argument (_tmp206_, _tmp210_);
	_vala_ccode_node_unref0 (_tmp210_);
	_tmp211_ = hash_table_insert;
	_tmp212_ = value_expr;
	_tmp213_ = value_type;
	_tmp214_ = vala_ccode_base_module_convert_to_generic_pointer ((ValaCCodeBaseModule*) self, _tmp212_, _tmp213_);
	_tmp215_ = _tmp214_;
	vala_ccode_function_call_add_argument (_tmp211_, _tmp215_);
	_vala_ccode_node_unref0 (_tmp215_);
	_tmp216_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp217_ = _tmp216_;
	_tmp218_ = hash_table_insert;
	vala_ccode_function_add_expression (_tmp217_, (ValaCCodeExpression*) _tmp218_);
	_tmp219_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp220_ = _tmp219_;
	vala_ccode_function_close (_tmp220_);
	_tmp221_ = temp_name;
	_tmp222_ = vala_ccode_identifier_new (_tmp221_);
	result = (ValaCCodeExpression*) _tmp222_;
	_vala_ccode_node_unref0 (hash_table_insert);
	_vala_ccode_node_unref0 (value_expr);
	_vala_ccode_node_unref0 (key_expr);
	_vala_ccode_node_unref0 (iter_call);
	_vala_ccode_node_unref0 (hash_table_new);
	_vala_code_node_unref0 (value_type);
	_vala_code_node_unref0 (key_type);
	_vala_iterable_unref0 (type_args);
	_g_free0 (value_name);
	_g_free0 (key_name);
	_g_free0 (subiter_name);
	_g_free0 (temp_name);
	return result;
}


static ValaCCodeExpression*
vala_gvariant_module_real_deserialize_expression (ValaCCodeBaseModule* base,
                                                  ValaDataType* type,
                                                  ValaCCodeExpression* variant_expr,
                                                  ValaCCodeExpression* expr,
                                                  ValaCCodeExpression* error_expr,
                                                  gboolean* may_fail)
{
	ValaGVariantModule * self;
	gboolean _vala_may_fail = FALSE;
	ValaCCodeExpression* result = NULL;
	ValaGVariantModuleBasicTypeInfo basic_type = {0};
	ValaCCodeExpression* _result_ = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaCCodeExpression* _tmp66_;
	self = (ValaGVariantModule*) base;
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (variant_expr != NULL, NULL);
	_result_ = NULL;
	_vala_may_fail = FALSE;
	_tmp0_ = vala_data_type_get_data_type (type);
	_tmp1_ = _tmp0_;
	if (vala_gvariant_module_is_string_marshalled_enum (_tmp1_)) {
		ValaGVariantModuleBasicTypeInfo _tmp2_ = {0};
		ValaGVariantModuleBasicTypeInfo _tmp3_;
		ValaCCodeExpression* _tmp4_;
		ValaCCodeExpression* _tmp5_;
		ValaCCodeExpression* _tmp6_;
		vala_gvariant_module_get_basic_type_info (self, "s", &_tmp2_);
		basic_type = _tmp2_;
		_tmp3_ = basic_type;
		_tmp4_ = vala_gvariant_module_deserialize_basic (self, &_tmp3_, variant_expr, TRUE);
		_vala_ccode_node_unref0 (_result_);
		_result_ = _tmp4_;
		_tmp5_ = _result_;
		_tmp6_ = vala_gvariant_module_generate_enum_value_from_string (self, G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ENUM_VALUE_TYPE) ? ((ValaEnumValueType*) type) : NULL, _tmp5_, error_expr);
		_vala_ccode_node_unref0 (_result_);
		_result_ = _tmp6_;
		_vala_may_fail = TRUE;
	} else {
		gchar* _tmp7_;
		gchar* _tmp8_;
		ValaGVariantModuleBasicTypeInfo _tmp9_ = {0};
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp7_ = vala_gvariant_module_get_type_signature (type, NULL);
		_tmp8_ = _tmp7_;
		_tmp10_ = vala_gvariant_module_get_basic_type_info (self, _tmp8_, &_tmp9_);
		basic_type = _tmp9_;
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp8_);
		if (_tmp11_) {
			ValaGVariantModuleBasicTypeInfo _tmp12_;
			ValaCCodeExpression* _tmp13_;
			_tmp12_ = basic_type;
			_tmp13_ = vala_gvariant_module_deserialize_basic (self, &_tmp12_, variant_expr, FALSE);
			_vala_ccode_node_unref0 (_result_);
			_result_ = _tmp13_;
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ARRAY_TYPE)) {
				ValaCCodeExpression* _tmp14_;
				_tmp14_ = vala_gvariant_module_deserialize_array (self, G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_ARRAY_TYPE, ValaArrayType), variant_expr, expr);
				_vala_ccode_node_unref0 (_result_);
				_result_ = _tmp14_;
			} else {
				ValaTypeSymbol* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				_tmp15_ = vala_data_type_get_data_type (type);
				_tmp16_ = _tmp15_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_STRUCT)) {
					ValaStruct* st = NULL;
					ValaTypeSymbol* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					ValaStruct* _tmp19_;
					ValaStruct* _tmp20_;
					ValaCCodeExpression* _tmp21_;
					gboolean _tmp22_ = FALSE;
					ValaCCodeExpression* _tmp23_;
					_tmp17_ = vala_data_type_get_data_type (type);
					_tmp18_ = _tmp17_;
					_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp19_;
					_tmp20_ = st;
					_tmp21_ = vala_gvariant_module_deserialize_struct (self, _tmp20_, variant_expr);
					_vala_ccode_node_unref0 (_result_);
					_result_ = _tmp21_;
					_tmp23_ = _result_;
					if (_tmp23_ != NULL) {
						gboolean _tmp24_;
						gboolean _tmp25_;
						_tmp24_ = vala_data_type_get_nullable (type);
						_tmp25_ = _tmp24_;
						_tmp22_ = _tmp25_;
					} else {
						_tmp22_ = FALSE;
					}
					if (_tmp22_) {
						ValaCCodeFunctionCall* csizeof = NULL;
						ValaCCodeIdentifier* _tmp26_;
						ValaCCodeIdentifier* _tmp27_;
						ValaCCodeFunctionCall* _tmp28_;
						ValaCCodeFunctionCall* _tmp29_;
						ValaCCodeFunctionCall* _tmp30_;
						ValaStruct* _tmp31_;
						gchar* _tmp32_;
						gchar* _tmp33_;
						ValaCCodeIdentifier* _tmp34_;
						ValaCCodeIdentifier* _tmp35_;
						ValaCCodeFunctionCall* cdup = NULL;
						ValaCCodeIdentifier* _tmp36_;
						ValaCCodeIdentifier* _tmp37_;
						ValaCCodeFunctionCall* _tmp38_;
						ValaCCodeFunctionCall* _tmp39_;
						ValaCCodeFunctionCall* _tmp40_;
						ValaCCodeExpression* _tmp41_;
						ValaCCodeUnaryExpression* _tmp42_;
						ValaCCodeUnaryExpression* _tmp43_;
						ValaCCodeFunctionCall* _tmp44_;
						ValaCCodeFunctionCall* _tmp45_;
						ValaCCodeFunctionCall* _tmp46_;
						ValaCCodeExpression* _tmp47_;
						_tmp26_ = vala_ccode_identifier_new ("sizeof");
						_tmp27_ = _tmp26_;
						_tmp28_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp27_);
						_tmp29_ = _tmp28_;
						_vala_ccode_node_unref0 (_tmp27_);
						csizeof = _tmp29_;
						_tmp30_ = csizeof;
						_tmp31_ = st;
						_tmp32_ = vala_get_ccode_name ((ValaCodeNode*) _tmp31_);
						_tmp33_ = _tmp32_;
						_tmp34_ = vala_ccode_identifier_new (_tmp33_);
						_tmp35_ = _tmp34_;
						vala_ccode_function_call_add_argument (_tmp30_, (ValaCCodeExpression*) _tmp35_);
						_vala_ccode_node_unref0 (_tmp35_);
						_g_free0 (_tmp33_);
						_tmp36_ = vala_ccode_identifier_new ("g_memdup");
						_tmp37_ = _tmp36_;
						_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp37_);
						_tmp39_ = _tmp38_;
						_vala_ccode_node_unref0 (_tmp37_);
						cdup = _tmp39_;
						_tmp40_ = cdup;
						_tmp41_ = _result_;
						_tmp42_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp41_);
						_tmp43_ = _tmp42_;
						vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp43_);
						_vala_ccode_node_unref0 (_tmp43_);
						_tmp44_ = cdup;
						_tmp45_ = csizeof;
						vala_ccode_function_call_add_argument (_tmp44_, (ValaCCodeExpression*) _tmp45_);
						_tmp46_ = cdup;
						_tmp47_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp46_);
						_vala_ccode_node_unref0 (_result_);
						_result_ = _tmp47_;
						_vala_ccode_node_unref0 (cdup);
						_vala_ccode_node_unref0 (csizeof);
					}
					_vala_code_node_unref0 (st);
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_OBJECT_TYPE)) {
						ValaTypeSymbol* _tmp48_;
						ValaTypeSymbol* _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						gboolean _tmp52_;
						_tmp48_ = vala_data_type_get_data_type (type);
						_tmp49_ = _tmp48_;
						_tmp50_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp49_);
						_tmp51_ = _tmp50_;
						_tmp52_ = g_strcmp0 (_tmp51_, "GLib.Variant") == 0;
						_g_free0 (_tmp51_);
						if (_tmp52_) {
							ValaCCodeFunctionCall* variant_get = NULL;
							ValaCCodeIdentifier* _tmp53_;
							ValaCCodeIdentifier* _tmp54_;
							ValaCCodeFunctionCall* _tmp55_;
							ValaCCodeFunctionCall* _tmp56_;
							ValaCCodeFunctionCall* _tmp57_;
							ValaCCodeFunctionCall* _tmp58_;
							ValaCCodeExpression* _tmp59_;
							_tmp53_ = vala_ccode_identifier_new ("g_variant_get_variant");
							_tmp54_ = _tmp53_;
							_tmp55_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp54_);
							_tmp56_ = _tmp55_;
							_vala_ccode_node_unref0 (_tmp54_);
							variant_get = _tmp56_;
							_tmp57_ = variant_get;
							vala_ccode_function_call_add_argument (_tmp57_, variant_expr);
							_tmp58_ = variant_get;
							_tmp59_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp58_);
							_vala_ccode_node_unref0 (_result_);
							_result_ = _tmp59_;
							_vala_ccode_node_unref0 (variant_get);
						} else {
							ValaTypeSymbol* _tmp60_;
							ValaTypeSymbol* _tmp61_;
							gchar* _tmp62_;
							gchar* _tmp63_;
							gboolean _tmp64_;
							_tmp60_ = vala_data_type_get_data_type (type);
							_tmp61_ = _tmp60_;
							_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp61_);
							_tmp63_ = _tmp62_;
							_tmp64_ = g_strcmp0 (_tmp63_, "GLib.HashTable") == 0;
							_g_free0 (_tmp63_);
							if (_tmp64_) {
								ValaCCodeExpression* _tmp65_;
								_tmp65_ = vala_gvariant_module_deserialize_hash_table (self, G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_OBJECT_TYPE, ValaObjectType), variant_expr);
								_vala_ccode_node_unref0 (_result_);
								_result_ = _tmp65_;
							}
						}
					}
				}
			}
		}
	}
	_tmp66_ = _result_;
	if (_tmp66_ == NULL) {
		ValaSourceReference* _tmp67_;
		ValaSourceReference* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		ValaCCodeInvalidExpression* _tmp73_;
		_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) type);
		_tmp68_ = _tmp67_;
		_tmp69_ = vala_code_node_to_string ((ValaCodeNode*) type);
		_tmp70_ = _tmp69_;
		_tmp71_ = g_strdup_printf ("GVariant deserialization of type `%s' is not supported", _tmp70_);
		_tmp72_ = _tmp71_;
		vala_report_error (_tmp68_, _tmp72_);
		_g_free0 (_tmp72_);
		_g_free0 (_tmp70_);
		_tmp73_ = vala_ccode_invalid_expression_new ();
		result = (ValaCCodeExpression*) _tmp73_;
		_vala_ccode_node_unref0 (_result_);
		if (may_fail) {
			*may_fail = _vala_may_fail;
		}
		return result;
	}
	result = _result_;
	if (may_fail) {
		*may_fail = _vala_may_fail;
	}
	return result;
}


void
vala_gvariant_module_read_expression (ValaGVariantModule* self,
                                      ValaDataType* type,
                                      ValaCCodeExpression* iter_expr,
                                      ValaCCodeExpression* target_expr,
                                      ValaSymbol* sym,
                                      ValaCCodeExpression* error_expr,
                                      gboolean* may_fail)
{
	gboolean _vala_may_fail = FALSE;
	ValaCCodeFunctionCall* iter_call = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeUnaryExpression* _tmp5_;
	ValaCCodeUnaryExpression* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gchar* temp_name = NULL;
	gint _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	const gchar* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeVariableDeclarator* _tmp20_;
	ValaCCodeIdentifier* variant_expr = NULL;
	const gchar* _tmp21_;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeExpression* _result_ = NULL;
	ValaCCodeIdentifier* _tmp27_;
	gboolean _tmp28_ = FALSE;
	ValaCCodeExpression* _tmp29_;
	ValaCCodeExpression* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	ValaCCodeFunction* _tmp32_;
	ValaCCodeExpression* _tmp33_;
	ValaCCodeFunctionCall* unref = NULL;
	ValaCCodeIdentifier* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeFunctionCall* _tmp37_;
	ValaCCodeFunctionCall* _tmp38_;
	ValaCCodeIdentifier* _tmp39_;
	ValaCCodeFunction* _tmp40_;
	ValaCCodeFunction* _tmp41_;
	ValaCCodeFunctionCall* _tmp42_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (target_expr != NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_variant_iter_next_value");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	iter_call = _tmp3_;
	_tmp4_ = iter_call;
	_tmp5_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr);
	_tmp6_ = _tmp5_;
	vala_ccode_function_call_add_argument (_tmp4_, (ValaCCodeExpression*) _tmp6_);
	_vala_ccode_node_unref0 (_tmp6_);
	if (sym != NULL) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = vala_gvariant_module_get_dbus_signature (sym);
		_tmp9_ = _tmp8_;
		_tmp7_ = _tmp9_ != NULL;
		_g_free0 (_tmp9_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaCCodeFunction* _tmp10_;
		ValaCCodeFunction* _tmp11_;
		ValaCCodeFunctionCall* _tmp12_;
		_tmp10_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = iter_call;
		vala_ccode_function_add_assignment (_tmp11_, target_expr, (ValaCCodeExpression*) _tmp12_);
		_vala_may_fail = FALSE;
		_vala_ccode_node_unref0 (iter_call);
		if (may_fail) {
			*may_fail = _vala_may_fail;
		}
		return;
	}
	_tmp13_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp14_ + 1);
	_tmp15_ = g_strdup_printf ("_tmp%d_", _tmp14_);
	temp_name = _tmp15_;
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = temp_name;
	_tmp19_ = vala_ccode_variable_declarator_new (_tmp18_, NULL, NULL);
	_tmp20_ = _tmp19_;
	vala_ccode_function_add_declaration (_tmp17_, "GVariant*", (ValaCCodeDeclarator*) _tmp20_, 0);
	_vala_ccode_node_unref0 (_tmp20_);
	_tmp21_ = temp_name;
	_tmp22_ = vala_ccode_identifier_new (_tmp21_);
	variant_expr = _tmp22_;
	_tmp23_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp24_ = _tmp23_;
	_tmp25_ = variant_expr;
	_tmp26_ = iter_call;
	vala_ccode_function_add_assignment (_tmp24_, (ValaCCodeExpression*) _tmp25_, (ValaCCodeExpression*) _tmp26_);
	_tmp27_ = variant_expr;
	_tmp29_ = vala_ccode_base_module_deserialize_expression ((ValaCCodeBaseModule*) self, type, (ValaCCodeExpression*) _tmp27_, target_expr, error_expr, &_tmp28_);
	_vala_may_fail = _tmp28_;
	_result_ = _tmp29_;
	_tmp30_ = _result_;
	if (_tmp30_ == NULL) {
		_vala_ccode_node_unref0 (_result_);
		_vala_ccode_node_unref0 (variant_expr);
		_g_free0 (temp_name);
		_vala_ccode_node_unref0 (iter_call);
		if (may_fail) {
			*may_fail = _vala_may_fail;
		}
		return;
	}
	_tmp31_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp32_ = _tmp31_;
	_tmp33_ = _result_;
	vala_ccode_function_add_assignment (_tmp32_, target_expr, _tmp33_);
	_tmp34_ = vala_ccode_identifier_new ("g_variant_unref");
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp35_);
	_tmp37_ = _tmp36_;
	_vala_ccode_node_unref0 (_tmp35_);
	unref = _tmp37_;
	_tmp38_ = unref;
	_tmp39_ = variant_expr;
	vala_ccode_function_call_add_argument (_tmp38_, (ValaCCodeExpression*) _tmp39_);
	_tmp40_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp41_ = _tmp40_;
	_tmp42_ = unref;
	vala_ccode_function_add_expression (_tmp41_, (ValaCCodeExpression*) _tmp42_);
	_vala_ccode_node_unref0 (unref);
	_vala_ccode_node_unref0 (_result_);
	_vala_ccode_node_unref0 (variant_expr);
	_g_free0 (temp_name);
	_vala_ccode_node_unref0 (iter_call);
	if (may_fail) {
		*may_fail = _vala_may_fail;
	}
}


static ValaCCodeExpression*
vala_gvariant_module_generate_enum_value_to_string (ValaGVariantModule* self,
                                                    ValaEnumValueType* type,
                                                    ValaCCodeExpression* expr)
{
	ValaCCodeExpression* result = NULL;
	ValaEnum* en = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaEnum* _tmp2_;
	gchar* to_string_name = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaCCodeFunctionCall* to_string_call = NULL;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeFunctionCall* _tmp9_;
	ValaCCodeFunctionCall* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = vala_value_type_get_type_symbol ((ValaValueType*) type);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_ENUM) ? ((ValaEnum*) _tmp1_) : NULL);
	en = _tmp2_;
	_tmp3_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_to_string", _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	to_string_name = _tmp6_;
	_tmp7_ = vala_ccode_identifier_new (to_string_name);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_ccode_node_unref0 (_tmp8_);
	to_string_call = _tmp10_;
	vala_ccode_function_call_add_argument (to_string_call, expr);
	result = (ValaCCodeExpression*) to_string_call;
	_g_free0 (to_string_name);
	_vala_code_node_unref0 (en);
	return result;
}


ValaCCodeFunction*
vala_gvariant_module_generate_enum_to_string_function_declaration (ValaGVariantModule* self,
                                                                   ValaEnum* en)
{
	ValaCCodeFunction* result = NULL;
	gchar* to_string_name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFunction* to_string_func = NULL;
	ValaCCodeFunction* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeParameter* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_name = _tmp3_;
	_tmp4_ = vala_ccode_function_new (to_string_name, "const char*");
	to_string_func = _tmp4_;
	_tmp5_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_parameter_new ("value", _tmp6_);
	_tmp8_ = _tmp7_;
	vala_ccode_function_add_parameter (to_string_func, _tmp8_);
	_vala_ccode_node_unref0 (_tmp8_);
	_g_free0 (_tmp6_);
	result = to_string_func;
	_g_free0 (to_string_name);
	return result;
}


ValaCCodeFunction*
vala_gvariant_module_generate_enum_to_string_function (ValaGVariantModule* self,
                                                       ValaEnum* en)
{
	ValaCCodeFunction* result = NULL;
	gchar* to_string_name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFunction* to_string_func = NULL;
	const gchar* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeParameter* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	ValaCCodeFunction* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeIdentifier* _tmp58_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_name = _tmp3_;
	_tmp4_ = to_string_name;
	_tmp5_ = vala_ccode_function_new (_tmp4_, "const char*");
	to_string_func = _tmp5_;
	_tmp6_ = to_string_func;
	_tmp7_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_ccode_parameter_new ("value", _tmp8_);
	_tmp10_ = _tmp9_;
	vala_ccode_function_add_parameter (_tmp6_, _tmp10_);
	_vala_ccode_node_unref0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp11_ = to_string_func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("str", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "const char *", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_identifier_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			gchar* dbus_value = NULL;
			ValaEnumValue* _tmp30_;
			ValaEnumValue* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			ValaCCodeFunction* _tmp35_;
			ValaCCodeFunction* _tmp36_;
			ValaEnumValue* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			ValaCCodeIdentifier* _tmp40_;
			ValaCCodeIdentifier* _tmp41_;
			ValaCCodeFunction* _tmp42_;
			ValaCCodeFunction* _tmp43_;
			ValaCCodeIdentifier* _tmp44_;
			ValaCCodeIdentifier* _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			ValaCCodeConstant* _tmp49_;
			ValaCCodeConstant* _tmp50_;
			ValaCCodeFunction* _tmp51_;
			ValaCCodeFunction* _tmp52_;
			_tmp24_ = _enum_value_index;
			_enum_value_index = _tmp24_ + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = _enum_value_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			enum_value = (ValaEnumValue*) _tmp29_;
			_tmp30_ = enum_value;
			_tmp31_ = enum_value;
			_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_gvariant_module_get_dbus_value (self, _tmp30_, _tmp33_);
			dbus_value = _tmp34_;
			_tmp35_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp36_ = _tmp35_;
			_tmp37_ = enum_value;
			_tmp38_ = vala_get_ccode_name ((ValaCodeNode*) _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_ccode_identifier_new (_tmp39_);
			_tmp41_ = _tmp40_;
			vala_ccode_function_add_case (_tmp36_, (ValaCCodeExpression*) _tmp41_);
			_vala_ccode_node_unref0 (_tmp41_);
			_g_free0 (_tmp39_);
			_tmp42_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_ccode_identifier_new ("str");
			_tmp45_ = _tmp44_;
			_tmp46_ = dbus_value;
			_tmp47_ = g_strdup_printf ("\"%s\"", _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_ccode_constant_new (_tmp48_);
			_tmp50_ = _tmp49_;
			vala_ccode_function_add_assignment (_tmp43_, (ValaCCodeExpression*) _tmp45_, (ValaCCodeExpression*) _tmp50_);
			_vala_ccode_node_unref0 (_tmp50_);
			_g_free0 (_tmp48_);
			_vala_ccode_node_unref0 (_tmp45_);
			_tmp51_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp52_ = _tmp51_;
			vala_ccode_function_add_break (_tmp52_);
			_g_free0 (dbus_value);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp54_ = _tmp53_;
	vala_ccode_function_close (_tmp54_);
	_tmp55_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp56_ = _tmp55_;
	_tmp57_ = vala_ccode_identifier_new ("str");
	_tmp58_ = _tmp57_;
	vala_ccode_function_add_return (_tmp56_, (ValaCCodeExpression*) _tmp58_);
	_vala_ccode_node_unref0 (_tmp58_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_g_free0 (to_string_name);
	return result;
}


static ValaCCodeExpression*
vala_gvariant_module_serialize_basic (ValaGVariantModule* self,
                                      ValaGVariantModuleBasicTypeInfo* basic_type,
                                      ValaCCodeExpression* expr)
{
	ValaCCodeExpression* result = NULL;
	ValaCCodeFunctionCall* new_call = NULL;
	ValaGVariantModuleBasicTypeInfo _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeFunctionCall* _tmp6_;
	ValaCCodeFunctionCall* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (basic_type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp0_ = *basic_type;
	_tmp1_ = _tmp0_.type_name;
	_tmp2_ = g_strconcat ("g_variant_new_", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_identifier_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_ccode_node_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	new_call = _tmp7_;
	vala_ccode_function_call_add_argument (new_call, expr);
	result = (ValaCCodeExpression*) new_call;
	return result;
}


static ValaCCodeExpression*
vala_gvariant_module_serialize_array (ValaGVariantModule* self,
                                      ValaArrayType* array_type,
                                      ValaCCodeExpression* array_expr)
{
	ValaCCodeExpression* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gchar* array_iter_name = NULL;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	const gchar* _tmp18_;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeIdentifier* _tmp20_;
	const gchar* _tmp21_;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeExpression* _tmp24_;
	ValaCCodeExpression* _tmp25_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	g_return_val_if_fail (array_expr != NULL, NULL);
	_tmp1_ = vala_array_type_get_rank (array_type);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 1) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = vala_gvariant_module_get_type_signature ((ValaDataType*) array_type, NULL);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, "ay") == 0;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeExpression* _tmp5_;
		_tmp5_ = vala_gvariant_module_serialize_buffer_array (self, array_type, array_expr);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp7_ = _tmp6_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp7_ + 1);
	_tmp8_ = g_strdup_printf ("_tmp%d_", _tmp7_);
	array_iter_name = _tmp8_;
	_tmp9_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_get_ccode_name ((ValaCodeNode*) array_type);
	_tmp12_ = _tmp11_;
	_tmp13_ = array_iter_name;
	_tmp14_ = vala_ccode_variable_declarator_new (_tmp13_, NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp10_, _tmp12_, (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_g_free0 (_tmp12_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = array_iter_name;
	_tmp19_ = vala_ccode_identifier_new (_tmp18_);
	_tmp20_ = _tmp19_;
	vala_ccode_function_add_assignment (_tmp17_, (ValaCCodeExpression*) _tmp20_, array_expr);
	_vala_ccode_node_unref0 (_tmp20_);
	_tmp21_ = array_iter_name;
	_tmp22_ = vala_ccode_identifier_new (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_gvariant_module_serialize_array_dim (self, array_type, 1, array_expr, (ValaCCodeExpression*) _tmp23_);
	_tmp25_ = _tmp24_;
	_vala_ccode_node_unref0 (_tmp23_);
	result = _tmp25_;
	_g_free0 (array_iter_name);
	return result;
}


static ValaCCodeExpression*
vala_gvariant_module_serialize_array_dim (ValaGVariantModule* self,
                                          ValaArrayType* array_type,
                                          gint dim,
                                          ValaCCodeExpression* array_expr,
                                          ValaCCodeExpression* array_iter_expr)
{
	ValaCCodeExpression* result = NULL;
	gchar* builder_name = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* index_name = NULL;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	const gchar* _tmp8_;
	ValaCCodeVariableDeclarator* _tmp9_;
	ValaCCodeVariableDeclarator* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	const gchar* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunctionCall* gvariant_type = NULL;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeFunctionCall* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaArrayType* array_type_copy = NULL;
	ValaDataType* _tmp20_;
	ValaArrayType* _tmp21_;
	ValaArrayType* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaArrayType* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	ValaCCodeConstant* _tmp31_;
	ValaCCodeConstant* _tmp32_;
	ValaCCodeFunctionCall* builder_init = NULL;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeIdentifier* _tmp34_;
	ValaCCodeFunctionCall* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeFunctionCall* _tmp37_;
	const gchar* _tmp38_;
	ValaCCodeIdentifier* _tmp39_;
	ValaCCodeIdentifier* _tmp40_;
	ValaCCodeUnaryExpression* _tmp41_;
	ValaCCodeUnaryExpression* _tmp42_;
	ValaCCodeFunctionCall* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunction* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunctionCall* _tmp47_;
	ValaCCodeAssignment* cforinit = NULL;
	const gchar* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeIdentifier* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeAssignment* _tmp53_;
	ValaCCodeAssignment* _tmp54_;
	ValaCCodeBinaryExpression* cforcond = NULL;
	const gchar* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeExpression* _tmp58_;
	ValaCCodeExpression* _tmp59_;
	ValaCCodeBinaryExpression* _tmp60_;
	ValaCCodeBinaryExpression* _tmp61_;
	ValaCCodeUnaryExpression* cforiter = NULL;
	const gchar* _tmp62_;
	ValaCCodeIdentifier* _tmp63_;
	ValaCCodeIdentifier* _tmp64_;
	ValaCCodeUnaryExpression* _tmp65_;
	ValaCCodeUnaryExpression* _tmp66_;
	ValaCCodeFunction* _tmp67_;
	ValaCCodeFunction* _tmp68_;
	ValaCCodeAssignment* _tmp69_;
	ValaCCodeBinaryExpression* _tmp70_;
	ValaCCodeUnaryExpression* _tmp71_;
	ValaCCodeExpression* element_variant = NULL;
	gint _tmp72_;
	gint _tmp73_;
	ValaCCodeFunctionCall* builder_add = NULL;
	ValaCCodeIdentifier* _tmp80_;
	ValaCCodeIdentifier* _tmp81_;
	ValaCCodeFunctionCall* _tmp82_;
	ValaCCodeFunctionCall* _tmp83_;
	ValaCCodeFunctionCall* _tmp84_;
	const gchar* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeUnaryExpression* _tmp88_;
	ValaCCodeUnaryExpression* _tmp89_;
	ValaCCodeFunctionCall* _tmp90_;
	ValaCCodeExpression* _tmp91_;
	ValaCCodeFunction* _tmp92_;
	ValaCCodeFunction* _tmp93_;
	ValaCCodeFunctionCall* _tmp94_;
	gint _tmp95_;
	gint _tmp96_;
	ValaCCodeFunction* _tmp101_;
	ValaCCodeFunction* _tmp102_;
	ValaCCodeFunctionCall* builder_end = NULL;
	ValaCCodeIdentifier* _tmp103_;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeFunctionCall* _tmp105_;
	ValaCCodeFunctionCall* _tmp106_;
	const gchar* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeUnaryExpression* _tmp110_;
	ValaCCodeUnaryExpression* _tmp111_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	g_return_val_if_fail (array_expr != NULL, NULL);
	g_return_val_if_fail (array_iter_expr != NULL, NULL);
	_tmp0_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp1_ + 1);
	_tmp2_ = g_strdup_printf ("_tmp%d_", _tmp1_);
	builder_name = _tmp2_;
	_tmp3_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp4_ = _tmp3_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp4_ + 1);
	_tmp5_ = g_strdup_printf ("_tmp%d_", _tmp4_);
	index_name = _tmp5_;
	_tmp6_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = builder_name;
	_tmp9_ = vala_ccode_variable_declarator_new (_tmp8_, NULL, NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_function_add_declaration (_tmp7_, "GVariantBuilder", (ValaCCodeDeclarator*) _tmp10_, 0);
	_vala_ccode_node_unref0 (_tmp10_);
	_tmp11_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = index_name;
	_tmp14_ = vala_ccode_variable_declarator_new (_tmp13_, NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp12_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_identifier_new ("G_VARIANT_TYPE");
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp17_);
	_tmp19_ = _tmp18_;
	_vala_ccode_node_unref0 (_tmp17_);
	gvariant_type = _tmp19_;
	_tmp20_ = vala_data_type_copy ((ValaDataType*) array_type);
	array_type_copy = G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
	_tmp21_ = array_type_copy;
	_tmp22_ = array_type_copy;
	_tmp23_ = vala_array_type_get_rank (_tmp22_);
	_tmp24_ = _tmp23_;
	vala_array_type_set_rank (_tmp22_, _tmp24_ - (dim - 1));
	_tmp25_ = gvariant_type;
	_tmp26_ = array_type_copy;
	_tmp27_ = vala_gvariant_module_get_type_signature ((ValaDataType*) _tmp26_, NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strdup_printf ("\"%s\"", _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_ccode_constant_new (_tmp30_);
	_tmp32_ = _tmp31_;
	vala_ccode_function_call_add_argument (_tmp25_, (ValaCCodeExpression*) _tmp32_);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_tmp33_ = vala_ccode_identifier_new ("g_variant_builder_init");
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp34_);
	_tmp36_ = _tmp35_;
	_vala_ccode_node_unref0 (_tmp34_);
	builder_init = _tmp36_;
	_tmp37_ = builder_init;
	_tmp38_ = builder_name;
	_tmp39_ = vala_ccode_identifier_new (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp40_);
	_tmp42_ = _tmp41_;
	vala_ccode_function_call_add_argument (_tmp37_, (ValaCCodeExpression*) _tmp42_);
	_vala_ccode_node_unref0 (_tmp42_);
	_vala_ccode_node_unref0 (_tmp40_);
	_tmp43_ = builder_init;
	_tmp44_ = gvariant_type;
	vala_ccode_function_call_add_argument (_tmp43_, (ValaCCodeExpression*) _tmp44_);
	_tmp45_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp46_ = _tmp45_;
	_tmp47_ = builder_init;
	vala_ccode_function_add_expression (_tmp46_, (ValaCCodeExpression*) _tmp47_);
	_tmp48_ = index_name;
	_tmp49_ = vala_ccode_identifier_new (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_ccode_constant_new ("0");
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_ccode_assignment_new ((ValaCCodeExpression*) _tmp50_, (ValaCCodeExpression*) _tmp52_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp54_ = _tmp53_;
	_vala_ccode_node_unref0 (_tmp52_);
	_vala_ccode_node_unref0 (_tmp50_);
	cforinit = _tmp54_;
	_tmp55_ = index_name;
	_tmp56_ = vala_ccode_identifier_new (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_gvariant_module_get_array_length (self, array_expr, dim);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) _tmp57_, _tmp59_);
	_tmp61_ = _tmp60_;
	_vala_ccode_node_unref0 (_tmp59_);
	_vala_ccode_node_unref0 (_tmp57_);
	cforcond = _tmp61_;
	_tmp62_ = index_name;
	_tmp63_ = vala_ccode_identifier_new (_tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	_vala_ccode_node_unref0 (_tmp64_);
	cforiter = _tmp66_;
	_tmp67_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp68_ = _tmp67_;
	_tmp69_ = cforinit;
	_tmp70_ = cforcond;
	_tmp71_ = cforiter;
	vala_ccode_function_open_for (_tmp68_, (ValaCCodeExpression*) _tmp69_, (ValaCCodeExpression*) _tmp70_, (ValaCCodeExpression*) _tmp71_);
	_tmp72_ = vala_array_type_get_rank (array_type);
	_tmp73_ = _tmp72_;
	if (dim < _tmp73_) {
		ValaCCodeExpression* _tmp74_;
		_tmp74_ = vala_gvariant_module_serialize_array_dim (self, array_type, dim + 1, array_expr, array_iter_expr);
		_vala_ccode_node_unref0 (element_variant);
		element_variant = _tmp74_;
	} else {
		ValaCCodeUnaryExpression* element_expr = NULL;
		ValaCCodeUnaryExpression* _tmp75_;
		ValaDataType* _tmp76_;
		ValaDataType* _tmp77_;
		ValaCCodeUnaryExpression* _tmp78_;
		ValaCCodeExpression* _tmp79_;
		_tmp75_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, array_iter_expr);
		element_expr = _tmp75_;
		_tmp76_ = vala_array_type_get_element_type (array_type);
		_tmp77_ = _tmp76_;
		_tmp78_ = element_expr;
		_tmp79_ = vala_ccode_base_module_serialize_expression ((ValaCCodeBaseModule*) self, _tmp77_, (ValaCCodeExpression*) _tmp78_);
		_vala_ccode_node_unref0 (element_variant);
		element_variant = _tmp79_;
		_vala_ccode_node_unref0 (element_expr);
	}
	_tmp80_ = vala_ccode_identifier_new ("g_variant_builder_add_value");
	_tmp81_ = _tmp80_;
	_tmp82_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp81_);
	_tmp83_ = _tmp82_;
	_vala_ccode_node_unref0 (_tmp81_);
	builder_add = _tmp83_;
	_tmp84_ = builder_add;
	_tmp85_ = builder_name;
	_tmp86_ = vala_ccode_identifier_new (_tmp85_);
	_tmp87_ = _tmp86_;
	_tmp88_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp87_);
	_tmp89_ = _tmp88_;
	vala_ccode_function_call_add_argument (_tmp84_, (ValaCCodeExpression*) _tmp89_);
	_vala_ccode_node_unref0 (_tmp89_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp90_ = builder_add;
	_tmp91_ = element_variant;
	vala_ccode_function_call_add_argument (_tmp90_, _tmp91_);
	_tmp92_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp93_ = _tmp92_;
	_tmp94_ = builder_add;
	vala_ccode_function_add_expression (_tmp93_, (ValaCCodeExpression*) _tmp94_);
	_tmp95_ = vala_array_type_get_rank (array_type);
	_tmp96_ = _tmp95_;
	if (dim == _tmp96_) {
		ValaCCodeUnaryExpression* array_iter_incr = NULL;
		ValaCCodeUnaryExpression* _tmp97_;
		ValaCCodeFunction* _tmp98_;
		ValaCCodeFunction* _tmp99_;
		ValaCCodeUnaryExpression* _tmp100_;
		_tmp97_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, array_iter_expr);
		array_iter_incr = _tmp97_;
		_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = array_iter_incr;
		vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
		_vala_ccode_node_unref0 (array_iter_incr);
	}
	_tmp101_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp102_ = _tmp101_;
	vala_ccode_function_close (_tmp102_);
	_tmp103_ = vala_ccode_identifier_new ("g_variant_builder_end");
	_tmp104_ = _tmp103_;
	_tmp105_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp104_);
	_tmp106_ = _tmp105_;
	_vala_ccode_node_unref0 (_tmp104_);
	builder_end = _tmp106_;
	_tmp107_ = builder_name;
	_tmp108_ = vala_ccode_identifier_new (_tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp109_);
	_tmp111_ = _tmp110_;
	vala_ccode_function_call_add_argument (builder_end, (ValaCCodeExpression*) _tmp111_);
	_vala_ccode_node_unref0 (_tmp111_);
	_vala_ccode_node_unref0 (_tmp109_);
	result = (ValaCCodeExpression*) builder_end;
	_vala_ccode_node_unref0 (builder_add);
	_vala_ccode_node_unref0 (element_variant);
	_vala_ccode_node_unref0 (cforiter);
	_vala_ccode_node_unref0 (cforcond);
	_vala_ccode_node_unref0 (cforinit);
	_vala_ccode_node_unref0 (builder_init);
	_vala_code_node_unref0 (array_type_copy);
	_vala_ccode_node_unref0 (gvariant_type);
	_g_free0 (index_name);
	_g_free0 (builder_name);
	return result;
}


static ValaCCodeExpression*
vala_gvariant_module_serialize_buffer_array (ValaGVariantModule* self,
                                             ValaArrayType* array_type,
                                             ValaCCodeExpression* array_expr)
{
	ValaCCodeExpression* result = NULL;
	gchar* buffer_name = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	ValaCCodeFunctionCall* gvariant_type = NULL;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeConstant* _tmp11_;
	ValaCCodeConstant* _tmp12_;
	ValaCCodeFunctionCall* dup_call = NULL;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeExpression* _tmp17_;
	ValaCCodeExpression* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeVariableDeclarator* _tmp24_;
	ValaCCodeFunctionCall* new_call = NULL;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeExpression* _tmp31_;
	ValaCCodeExpression* _tmp32_;
	ValaCCodeConstant* _tmp33_;
	ValaCCodeConstant* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeIdentifier* _tmp36_;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeIdentifier* _tmp38_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	g_return_val_if_fail (array_expr != NULL, NULL);
	_tmp0_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp1_ + 1);
	_tmp2_ = g_strdup_printf ("_tmp%d_", _tmp1_);
	buffer_name = _tmp2_;
	_tmp3_ = vala_ccode_identifier_new ("G_VARIANT_TYPE");
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp4_);
	_tmp6_ = _tmp5_;
	_vala_ccode_node_unref0 (_tmp4_);
	gvariant_type = _tmp6_;
	_tmp7_ = vala_gvariant_module_get_type_signature ((ValaDataType*) array_type, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("\"%s\"", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_constant_new (_tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_call_add_argument (gvariant_type, (ValaCCodeExpression*) _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp13_ = vala_ccode_identifier_new ("g_memdup");
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp14_);
	_tmp16_ = _tmp15_;
	_vala_ccode_node_unref0 (_tmp14_);
	dup_call = _tmp16_;
	vala_ccode_function_call_add_argument (dup_call, array_expr);
	_tmp17_ = vala_gvariant_module_get_array_length (self, array_expr, 1);
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (dup_call, _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_get_ccode_name ((ValaCodeNode*) array_type);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_ccode_variable_declarator_new (buffer_name, (ValaCCodeExpression*) dup_call, NULL);
	_tmp24_ = _tmp23_;
	vala_ccode_function_add_declaration (_tmp20_, _tmp22_, (ValaCCodeDeclarator*) _tmp24_, 0);
	_vala_ccode_node_unref0 (_tmp24_);
	_g_free0 (_tmp22_);
	_tmp25_ = vala_ccode_identifier_new ("g_variant_new_from_data");
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp26_);
	_tmp28_ = _tmp27_;
	_vala_ccode_node_unref0 (_tmp26_);
	new_call = _tmp28_;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) gvariant_type);
	_tmp29_ = vala_ccode_identifier_new (buffer_name);
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = vala_gvariant_module_get_array_length (self, array_expr, 1);
	_tmp32_ = _tmp31_;
	vala_ccode_function_call_add_argument (new_call, _tmp32_);
	_vala_ccode_node_unref0 (_tmp32_);
	_tmp33_ = vala_ccode_constant_new ("TRUE");
	_tmp34_ = _tmp33_;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) _tmp34_);
	_vala_ccode_node_unref0 (_tmp34_);
	_tmp35_ = vala_ccode_identifier_new ("g_free");
	_tmp36_ = _tmp35_;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	_tmp37_ = vala_ccode_identifier_new (buffer_name);
	_tmp38_ = _tmp37_;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) _tmp38_);
	_vala_ccode_node_unref0 (_tmp38_);
	result = (ValaCCodeExpression*) new_call;
	_vala_ccode_node_unref0 (dup_call);
	_vala_ccode_node_unref0 (gvariant_type);
	_g_free0 (buffer_name);
	return result;
}


static ValaCCodeExpression*
vala_gvariant_module_serialize_struct (ValaGVariantModule* self,
                                       ValaStruct* st,
                                       ValaCCodeExpression* struct_expr)
{
	ValaCCodeExpression* result = NULL;
	gchar* builder_name = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	ValaCCodeFunction* _tmp3_;
	ValaCCodeFunction* _tmp4_;
	const gchar* _tmp5_;
	ValaCCodeVariableDeclarator* _tmp6_;
	ValaCCodeVariableDeclarator* _tmp7_;
	ValaCCodeFunctionCall* iter_call = NULL;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeFunctionCall* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	ValaCCodeFunctionCall* _tmp12_;
	const gchar* _tmp13_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeUnaryExpression* _tmp16_;
	ValaCCodeUnaryExpression* _tmp17_;
	ValaCCodeFunctionCall* _tmp18_;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	gboolean field_found = FALSE;
	gboolean _tmp49_;
	ValaCCodeFunctionCall* builder_end = NULL;
	ValaCCodeIdentifier* _tmp50_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeFunctionCall* _tmp53_;
	ValaCCodeFunctionCall* _tmp54_;
	const gchar* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeUnaryExpression* _tmp58_;
	ValaCCodeUnaryExpression* _tmp59_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (st != NULL, NULL);
	g_return_val_if_fail (struct_expr != NULL, NULL);
	_tmp0_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp1_ + 1);
	_tmp2_ = g_strdup_printf ("_tmp%d_", _tmp1_);
	builder_name = _tmp2_;
	_tmp3_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = builder_name;
	_tmp6_ = vala_ccode_variable_declarator_new (_tmp5_, NULL, NULL);
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_declaration (_tmp4_, "GVariantBuilder", (ValaCCodeDeclarator*) _tmp7_, 0);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = vala_ccode_identifier_new ("g_variant_builder_init");
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp9_);
	_tmp11_ = _tmp10_;
	_vala_ccode_node_unref0 (_tmp9_);
	iter_call = _tmp11_;
	_tmp12_ = iter_call;
	_tmp13_ = builder_name;
	_tmp14_ = vala_ccode_identifier_new (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp15_);
	_tmp17_ = _tmp16_;
	vala_ccode_function_call_add_argument (_tmp12_, (ValaCCodeExpression*) _tmp17_);
	_vala_ccode_node_unref0 (_tmp17_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp18_ = iter_call;
	_tmp19_ = vala_ccode_identifier_new ("G_VARIANT_TYPE_TUPLE");
	_tmp20_ = _tmp19_;
	vala_ccode_function_call_add_argument (_tmp18_, (ValaCCodeExpression*) _tmp20_);
	_vala_ccode_node_unref0 (_tmp20_);
	_tmp21_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp22_ = _tmp21_;
	_tmp23_ = iter_call;
	vala_ccode_function_add_expression (_tmp22_, (ValaCCodeExpression*) _tmp23_);
	field_found = FALSE;
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp24_;
		gint _f_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _f_index = 0;
		_tmp24_ = vala_struct_get_fields (st);
		_f_list = _tmp24_;
		_tmp25_ = _f_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_f_size = _tmp27_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaField* f = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaField* _tmp34_;
			ValaMemberBinding _tmp35_;
			ValaMemberBinding _tmp36_;
			ValaField* _tmp37_;
			ValaDataType* _tmp38_;
			ValaDataType* _tmp39_;
			const gchar* _tmp40_;
			ValaCCodeIdentifier* _tmp41_;
			ValaCCodeIdentifier* _tmp42_;
			ValaField* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaCCodeMemberAccess* _tmp46_;
			ValaCCodeMemberAccess* _tmp47_;
			ValaField* _tmp48_;
			_tmp28_ = _f_index;
			_f_index = _tmp28_ + 1;
			_tmp29_ = _f_index;
			_tmp30_ = _f_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _f_list;
			_tmp32_ = _f_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			f = (ValaField*) _tmp33_;
			_tmp34_ = f;
			_tmp35_ = vala_field_get_binding (_tmp34_);
			_tmp36_ = _tmp35_;
			if (_tmp36_ != VALA_MEMBER_BINDING_INSTANCE) {
				_vala_code_node_unref0 (f);
				continue;
			}
			field_found = TRUE;
			_tmp37_ = f;
			_tmp38_ = vala_variable_get_variable_type ((ValaVariable*) _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = builder_name;
			_tmp41_ = vala_ccode_identifier_new (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = f;
			_tmp44_ = vala_get_ccode_name ((ValaCodeNode*) _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_ccode_member_access_new (struct_expr, _tmp45_, FALSE);
			_tmp47_ = _tmp46_;
			_tmp48_ = f;
			vala_gvariant_module_write_expression (self, _tmp39_, (ValaCCodeExpression*) _tmp42_, (ValaCCodeExpression*) _tmp47_, (ValaSymbol*) _tmp48_);
			_vala_ccode_node_unref0 (_tmp47_);
			_g_free0 (_tmp45_);
			_vala_ccode_node_unref0 (_tmp42_);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	_tmp49_ = field_found;
	if (!_tmp49_) {
		result = NULL;
		_vala_ccode_node_unref0 (iter_call);
		_g_free0 (builder_name);
		return result;
	}
	_tmp50_ = vala_ccode_identifier_new ("g_variant_builder_end");
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp51_);
	_tmp53_ = _tmp52_;
	_vala_ccode_node_unref0 (_tmp51_);
	builder_end = _tmp53_;
	_tmp54_ = builder_end;
	_tmp55_ = builder_name;
	_tmp56_ = vala_ccode_identifier_new (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp57_);
	_tmp59_ = _tmp58_;
	vala_ccode_function_call_add_argument (_tmp54_, (ValaCCodeExpression*) _tmp59_);
	_vala_ccode_node_unref0 (_tmp59_);
	_vala_ccode_node_unref0 (_tmp57_);
	result = (ValaCCodeExpression*) builder_end;
	_vala_ccode_node_unref0 (iter_call);
	_g_free0 (builder_name);
	return result;
}


static ValaCCodeExpression*
vala_gvariant_module_serialize_hash_table (ValaGVariantModule* self,
                                           ValaObjectType* type,
                                           ValaCCodeExpression* hash_table_expr)
{
	ValaCCodeExpression* result = NULL;
	gchar* subiter_name = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* tableiter_name = NULL;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* key_name = NULL;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* value_name = NULL;
	gint _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	ValaList* type_args = NULL;
	ValaList* _tmp12_;
	ValaList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	ValaDataType* key_type = NULL;
	ValaList* _tmp16_;
	gpointer _tmp17_;
	ValaDataType* value_type = NULL;
	ValaList* _tmp18_;
	gpointer _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	const gchar* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeVariableDeclarator* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	const gchar* _tmp27_;
	ValaCCodeVariableDeclarator* _tmp28_;
	ValaCCodeVariableDeclarator* _tmp29_;
	ValaCCodeFunction* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	const gchar* _tmp32_;
	ValaCCodeVariableDeclarator* _tmp33_;
	ValaCCodeVariableDeclarator* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunction* _tmp36_;
	const gchar* _tmp37_;
	ValaCCodeVariableDeclarator* _tmp38_;
	ValaCCodeVariableDeclarator* _tmp39_;
	ValaCCodeFunctionCall* iter_init_call = NULL;
	ValaCCodeIdentifier* _tmp40_;
	ValaCCodeIdentifier* _tmp41_;
	ValaCCodeFunctionCall* _tmp42_;
	ValaCCodeFunctionCall* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	const gchar* _tmp45_;
	ValaCCodeIdentifier* _tmp46_;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeUnaryExpression* _tmp48_;
	ValaCCodeUnaryExpression* _tmp49_;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeFunction* _tmp52_;
	ValaCCodeFunctionCall* _tmp53_;
	ValaCCodeFunctionCall* gvariant_type = NULL;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeIdentifier* _tmp55_;
	ValaCCodeFunctionCall* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeFunctionCall* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeFunctionCall* iter_call = NULL;
	ValaCCodeIdentifier* _tmp65_;
	ValaCCodeIdentifier* _tmp66_;
	ValaCCodeFunctionCall* _tmp67_;
	ValaCCodeFunctionCall* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	const gchar* _tmp70_;
	ValaCCodeIdentifier* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeUnaryExpression* _tmp73_;
	ValaCCodeUnaryExpression* _tmp74_;
	ValaCCodeFunctionCall* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunction* _tmp77_;
	ValaCCodeFunction* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* iter_next_call = NULL;
	ValaCCodeIdentifier* _tmp80_;
	ValaCCodeIdentifier* _tmp81_;
	ValaCCodeFunctionCall* _tmp82_;
	ValaCCodeFunctionCall* _tmp83_;
	ValaCCodeFunctionCall* _tmp84_;
	const gchar* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeUnaryExpression* _tmp88_;
	ValaCCodeUnaryExpression* _tmp89_;
	ValaCCodeFunctionCall* _tmp90_;
	const gchar* _tmp91_;
	ValaCCodeIdentifier* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeUnaryExpression* _tmp94_;
	ValaCCodeUnaryExpression* _tmp95_;
	ValaCCodeFunctionCall* _tmp96_;
	const gchar* _tmp97_;
	ValaCCodeIdentifier* _tmp98_;
	ValaCCodeIdentifier* _tmp99_;
	ValaCCodeUnaryExpression* _tmp100_;
	ValaCCodeUnaryExpression* _tmp101_;
	ValaCCodeFunction* _tmp102_;
	ValaCCodeFunction* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeFunction* _tmp105_;
	ValaCCodeFunction* _tmp106_;
	ValaDataType* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	ValaCCodeVariableDeclarator* _tmp110_;
	ValaCCodeVariableDeclarator* _tmp111_;
	ValaCCodeFunction* _tmp112_;
	ValaCCodeFunction* _tmp113_;
	ValaDataType* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	ValaCCodeVariableDeclarator* _tmp117_;
	ValaCCodeVariableDeclarator* _tmp118_;
	ValaCCodeFunction* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	ValaCCodeIdentifier* _tmp121_;
	ValaCCodeIdentifier* _tmp122_;
	const gchar* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeIdentifier* _tmp125_;
	ValaDataType* _tmp126_;
	ValaCCodeExpression* _tmp127_;
	ValaCCodeExpression* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeFunction* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeIdentifier* _tmp132_;
	const gchar* _tmp133_;
	ValaCCodeIdentifier* _tmp134_;
	ValaCCodeIdentifier* _tmp135_;
	ValaDataType* _tmp136_;
	ValaCCodeExpression* _tmp137_;
	ValaCCodeExpression* _tmp138_;
	ValaCCodeExpression* serialized_key = NULL;
	ValaDataType* _tmp139_;
	ValaCCodeIdentifier* _tmp140_;
	ValaCCodeIdentifier* _tmp141_;
	ValaCCodeExpression* _tmp142_;
	ValaCCodeExpression* _tmp143_;
	ValaCCodeExpression* serialized_value = NULL;
	ValaDataType* _tmp144_;
	ValaCCodeIdentifier* _tmp145_;
	ValaCCodeIdentifier* _tmp146_;
	ValaCCodeExpression* _tmp147_;
	ValaCCodeExpression* _tmp148_;
	gboolean _tmp149_ = FALSE;
	ValaCCodeExpression* _tmp150_;
	ValaCCodeIdentifier* _tmp152_;
	ValaCCodeIdentifier* _tmp153_;
	ValaCCodeFunctionCall* _tmp154_;
	ValaCCodeFunctionCall* _tmp155_;
	const gchar* _tmp156_;
	ValaCCodeIdentifier* _tmp157_;
	ValaCCodeIdentifier* _tmp158_;
	ValaCCodeUnaryExpression* _tmp159_;
	ValaCCodeUnaryExpression* _tmp160_;
	ValaCCodeFunctionCall* _tmp161_;
	ValaCCodeConstant* _tmp162_;
	ValaCCodeConstant* _tmp163_;
	ValaCCodeFunctionCall* _tmp164_;
	ValaCCodeExpression* _tmp165_;
	ValaCCodeFunctionCall* _tmp166_;
	ValaCCodeExpression* _tmp167_;
	ValaCCodeFunction* _tmp168_;
	ValaCCodeFunction* _tmp169_;
	ValaCCodeFunctionCall* _tmp170_;
	ValaCCodeFunction* _tmp171_;
	ValaCCodeFunction* _tmp172_;
	ValaCCodeIdentifier* _tmp173_;
	ValaCCodeIdentifier* _tmp174_;
	ValaCCodeFunctionCall* _tmp175_;
	ValaCCodeFunctionCall* _tmp176_;
	const gchar* _tmp177_;
	ValaCCodeIdentifier* _tmp178_;
	ValaCCodeIdentifier* _tmp179_;
	ValaCCodeUnaryExpression* _tmp180_;
	ValaCCodeUnaryExpression* _tmp181_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (hash_table_expr != NULL, NULL);
	_tmp0_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp1_ + 1);
	_tmp2_ = g_strdup_printf ("_tmp%d_", _tmp1_);
	subiter_name = _tmp2_;
	_tmp3_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp4_ = _tmp3_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp4_ + 1);
	_tmp5_ = g_strdup_printf ("_tmp%d_", _tmp4_);
	tableiter_name = _tmp5_;
	_tmp6_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp7_ = _tmp6_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp7_ + 1);
	_tmp8_ = g_strdup_printf ("_tmp%d_", _tmp7_);
	key_name = _tmp8_;
	_tmp9_ = vala_ccode_base_module_get_next_temp_var_id ((ValaCCodeBaseModule*) self);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_set_next_temp_var_id ((ValaCCodeBaseModule*) self, _tmp10_ + 1);
	_tmp11_ = g_strdup_printf ("_tmp%d_", _tmp10_);
	value_name = _tmp11_;
	_tmp12_ = vala_data_type_get_type_arguments ((ValaDataType*) type);
	type_args = _tmp12_;
	_tmp13_ = type_args;
	_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_assert (_tmp15_ == 2, "type_args.size == 2");
	_tmp16_ = type_args;
	_tmp17_ = vala_list_get (_tmp16_, 0);
	key_type = (ValaDataType*) _tmp17_;
	_tmp18_ = type_args;
	_tmp19_ = vala_list_get (_tmp18_, 1);
	value_type = (ValaDataType*) _tmp19_;
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = subiter_name;
	_tmp23_ = vala_ccode_variable_declarator_new (_tmp22_, NULL, NULL);
	_tmp24_ = _tmp23_;
	vala_ccode_function_add_declaration (_tmp21_, "GVariantBuilder", (ValaCCodeDeclarator*) _tmp24_, 0);
	_vala_ccode_node_unref0 (_tmp24_);
	_tmp25_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp26_ = _tmp25_;
	_tmp27_ = tableiter_name;
	_tmp28_ = vala_ccode_variable_declarator_new (_tmp27_, NULL, NULL);
	_tmp29_ = _tmp28_;
	vala_ccode_function_add_declaration (_tmp26_, "GHashTableIter", (ValaCCodeDeclarator*) _tmp29_, 0);
	_vala_ccode_node_unref0 (_tmp29_);
	_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp31_ = _tmp30_;
	_tmp32_ = key_name;
	_tmp33_ = vala_ccode_variable_declarator_new (_tmp32_, NULL, NULL);
	_tmp34_ = _tmp33_;
	vala_ccode_function_add_declaration (_tmp31_, "gpointer", (ValaCCodeDeclarator*) _tmp34_, 0);
	_vala_ccode_node_unref0 (_tmp34_);
	_tmp35_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp36_ = _tmp35_;
	_tmp37_ = value_name;
	_tmp38_ = vala_ccode_variable_declarator_new (_tmp37_, NULL, NULL);
	_tmp39_ = _tmp38_;
	vala_ccode_function_add_declaration (_tmp36_, "gpointer", (ValaCCodeDeclarator*) _tmp39_, 0);
	_vala_ccode_node_unref0 (_tmp39_);
	_tmp40_ = vala_ccode_identifier_new ("g_hash_table_iter_init");
	_tmp41_ = _tmp40_;
	_tmp42_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp41_);
	_tmp43_ = _tmp42_;
	_vala_ccode_node_unref0 (_tmp41_);
	iter_init_call = _tmp43_;
	_tmp44_ = iter_init_call;
	_tmp45_ = tableiter_name;
	_tmp46_ = vala_ccode_identifier_new (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp47_);
	_tmp49_ = _tmp48_;
	vala_ccode_function_call_add_argument (_tmp44_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_vala_ccode_node_unref0 (_tmp47_);
	_tmp50_ = iter_init_call;
	vala_ccode_function_call_add_argument (_tmp50_, hash_table_expr);
	_tmp51_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp52_ = _tmp51_;
	_tmp53_ = iter_init_call;
	vala_ccode_function_add_expression (_tmp52_, (ValaCCodeExpression*) _tmp53_);
	_tmp54_ = vala_ccode_identifier_new ("G_VARIANT_TYPE");
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp55_);
	_tmp57_ = _tmp56_;
	_vala_ccode_node_unref0 (_tmp55_);
	gvariant_type = _tmp57_;
	_tmp58_ = gvariant_type;
	_tmp59_ = vala_gvariant_module_get_type_signature ((ValaDataType*) type, NULL);
	_tmp60_ = _tmp59_;
	_tmp61_ = g_strdup_printf ("\"%s\"", _tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = vala_ccode_constant_new (_tmp62_);
	_tmp64_ = _tmp63_;
	vala_ccode_function_call_add_argument (_tmp58_, (ValaCCodeExpression*) _tmp64_);
	_vala_ccode_node_unref0 (_tmp64_);
	_g_free0 (_tmp62_);
	_g_free0 (_tmp60_);
	_tmp65_ = vala_ccode_identifier_new ("g_variant_builder_init");
	_tmp66_ = _tmp65_;
	_tmp67_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp66_);
	_tmp68_ = _tmp67_;
	_vala_ccode_node_unref0 (_tmp66_);
	iter_call = _tmp68_;
	_tmp69_ = iter_call;
	_tmp70_ = subiter_name;
	_tmp71_ = vala_ccode_identifier_new (_tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp72_);
	_tmp74_ = _tmp73_;
	vala_ccode_function_call_add_argument (_tmp69_, (ValaCCodeExpression*) _tmp74_);
	_vala_ccode_node_unref0 (_tmp74_);
	_vala_ccode_node_unref0 (_tmp72_);
	_tmp75_ = iter_call;
	_tmp76_ = gvariant_type;
	vala_ccode_function_call_add_argument (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp78_ = _tmp77_;
	_tmp79_ = iter_call;
	vala_ccode_function_add_expression (_tmp78_, (ValaCCodeExpression*) _tmp79_);
	_tmp80_ = vala_ccode_identifier_new ("g_hash_table_iter_next");
	_tmp81_ = _tmp80_;
	_tmp82_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp81_);
	_tmp83_ = _tmp82_;
	_vala_ccode_node_unref0 (_tmp81_);
	iter_next_call = _tmp83_;
	_tmp84_ = iter_next_call;
	_tmp85_ = tableiter_name;
	_tmp86_ = vala_ccode_identifier_new (_tmp85_);
	_tmp87_ = _tmp86_;
	_tmp88_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp87_);
	_tmp89_ = _tmp88_;
	vala_ccode_function_call_add_argument (_tmp84_, (ValaCCodeExpression*) _tmp89_);
	_vala_ccode_node_unref0 (_tmp89_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp90_ = iter_next_call;
	_tmp91_ = key_name;
	_tmp92_ = vala_ccode_identifier_new (_tmp91_);
	_tmp93_ = _tmp92_;
	_tmp94_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp93_);
	_tmp95_ = _tmp94_;
	vala_ccode_function_call_add_argument (_tmp90_, (ValaCCodeExpression*) _tmp95_);
	_vala_ccode_node_unref0 (_tmp95_);
	_vala_ccode_node_unref0 (_tmp93_);
	_tmp96_ = iter_next_call;
	_tmp97_ = value_name;
	_tmp98_ = vala_ccode_identifier_new (_tmp97_);
	_tmp99_ = _tmp98_;
	_tmp100_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp99_);
	_tmp101_ = _tmp100_;
	vala_ccode_function_call_add_argument (_tmp96_, (ValaCCodeExpression*) _tmp101_);
	_vala_ccode_node_unref0 (_tmp101_);
	_vala_ccode_node_unref0 (_tmp99_);
	_tmp102_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp103_ = _tmp102_;
	_tmp104_ = iter_next_call;
	vala_ccode_function_open_while (_tmp103_, (ValaCCodeExpression*) _tmp104_);
	_tmp105_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp106_ = _tmp105_;
	_tmp107_ = key_type;
	_tmp108_ = vala_get_ccode_name ((ValaCodeNode*) _tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_ccode_variable_declarator_new ("_key", NULL, NULL);
	_tmp111_ = _tmp110_;
	vala_ccode_function_add_declaration (_tmp106_, _tmp109_, (ValaCCodeDeclarator*) _tmp111_, 0);
	_vala_ccode_node_unref0 (_tmp111_);
	_g_free0 (_tmp109_);
	_tmp112_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp113_ = _tmp112_;
	_tmp114_ = value_type;
	_tmp115_ = vala_get_ccode_name ((ValaCodeNode*) _tmp114_);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_ccode_variable_declarator_new ("_value", NULL, NULL);
	_tmp118_ = _tmp117_;
	vala_ccode_function_add_declaration (_tmp113_, _tmp116_, (ValaCCodeDeclarator*) _tmp118_, 0);
	_vala_ccode_node_unref0 (_tmp118_);
	_g_free0 (_tmp116_);
	_tmp119_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_identifier_new ("_key");
	_tmp122_ = _tmp121_;
	_tmp123_ = key_name;
	_tmp124_ = vala_ccode_identifier_new (_tmp123_);
	_tmp125_ = _tmp124_;
	_tmp126_ = key_type;
	_tmp127_ = vala_ccode_base_module_convert_from_generic_pointer ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp125_, _tmp126_);
	_tmp128_ = _tmp127_;
	vala_ccode_function_add_assignment (_tmp120_, (ValaCCodeExpression*) _tmp122_, _tmp128_);
	_vala_ccode_node_unref0 (_tmp128_);
	_vala_ccode_node_unref0 (_tmp125_);
	_vala_ccode_node_unref0 (_tmp122_);
	_tmp129_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp130_ = _tmp129_;
	_tmp131_ = vala_ccode_identifier_new ("_value");
	_tmp132_ = _tmp131_;
	_tmp133_ = value_name;
	_tmp134_ = vala_ccode_identifier_new (_tmp133_);
	_tmp135_ = _tmp134_;
	_tmp136_ = value_type;
	_tmp137_ = vala_ccode_base_module_convert_from_generic_pointer ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp135_, _tmp136_);
	_tmp138_ = _tmp137_;
	vala_ccode_function_add_assignment (_tmp130_, (ValaCCodeExpression*) _tmp132_, _tmp138_);
	_vala_ccode_node_unref0 (_tmp138_);
	_vala_ccode_node_unref0 (_tmp135_);
	_vala_ccode_node_unref0 (_tmp132_);
	_tmp139_ = key_type;
	_tmp140_ = vala_ccode_identifier_new ("_key");
	_tmp141_ = _tmp140_;
	_tmp142_ = vala_ccode_base_module_serialize_expression ((ValaCCodeBaseModule*) self, _tmp139_, (ValaCCodeExpression*) _tmp141_);
	_tmp143_ = _tmp142_;
	_vala_ccode_node_unref0 (_tmp141_);
	serialized_key = _tmp143_;
	_tmp144_ = value_type;
	_tmp145_ = vala_ccode_identifier_new ("_value");
	_tmp146_ = _tmp145_;
	_tmp147_ = vala_ccode_base_module_serialize_expression ((ValaCCodeBaseModule*) self, _tmp144_, (ValaCCodeExpression*) _tmp146_);
	_tmp148_ = _tmp147_;
	_vala_ccode_node_unref0 (_tmp146_);
	serialized_value = _tmp148_;
	_tmp150_ = serialized_key;
	if (_tmp150_ == NULL) {
		_tmp149_ = TRUE;
	} else {
		ValaCCodeExpression* _tmp151_;
		_tmp151_ = serialized_value;
		_tmp149_ = _tmp151_ == NULL;
	}
	if (_tmp149_) {
		result = NULL;
		_vala_ccode_node_unref0 (serialized_value);
		_vala_ccode_node_unref0 (serialized_key);
		_vala_ccode_node_unref0 (iter_next_call);
		_vala_ccode_node_unref0 (iter_call);
		_vala_ccode_node_unref0 (gvariant_type);
		_vala_ccode_node_unref0 (iter_init_call);
		_vala_code_node_unref0 (value_type);
		_vala_code_node_unref0 (key_type);
		_vala_iterable_unref0 (type_args);
		_g_free0 (value_name);
		_g_free0 (key_name);
		_g_free0 (tableiter_name);
		_g_free0 (subiter_name);
		return result;
	}
	_tmp152_ = vala_ccode_identifier_new ("g_variant_builder_add");
	_tmp153_ = _tmp152_;
	_tmp154_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp153_);
	_vala_ccode_node_unref0 (iter_call);
	iter_call = _tmp154_;
	_vala_ccode_node_unref0 (_tmp153_);
	_tmp155_ = iter_call;
	_tmp156_ = subiter_name;
	_tmp157_ = vala_ccode_identifier_new (_tmp156_);
	_tmp158_ = _tmp157_;
	_tmp159_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp158_);
	_tmp160_ = _tmp159_;
	vala_ccode_function_call_add_argument (_tmp155_, (ValaCCodeExpression*) _tmp160_);
	_vala_ccode_node_unref0 (_tmp160_);
	_vala_ccode_node_unref0 (_tmp158_);
	_tmp161_ = iter_call;
	_tmp162_ = vala_ccode_constant_new ("\"{?*}\"");
	_tmp163_ = _tmp162_;
	vala_ccode_function_call_add_argument (_tmp161_, (ValaCCodeExpression*) _tmp163_);
	_vala_ccode_node_unref0 (_tmp163_);
	_tmp164_ = iter_call;
	_tmp165_ = serialized_key;
	vala_ccode_function_call_add_argument (_tmp164_, _tmp165_);
	_tmp166_ = iter_call;
	_tmp167_ = serialized_value;
	vala_ccode_function_call_add_argument (_tmp166_, _tmp167_);
	_tmp168_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp169_ = _tmp168_;
	_tmp170_ = iter_call;
	vala_ccode_function_add_expression (_tmp169_, (ValaCCodeExpression*) _tmp170_);
	_tmp171_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp172_ = _tmp171_;
	vala_ccode_function_close (_tmp172_);
	_tmp173_ = vala_ccode_identifier_new ("g_variant_builder_end");
	_tmp174_ = _tmp173_;
	_tmp175_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp174_);
	_vala_ccode_node_unref0 (iter_call);
	iter_call = _tmp175_;
	_vala_ccode_node_unref0 (_tmp174_);
	_tmp176_ = iter_call;
	_tmp177_ = subiter_name;
	_tmp178_ = vala_ccode_identifier_new (_tmp177_);
	_tmp179_ = _tmp178_;
	_tmp180_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp179_);
	_tmp181_ = _tmp180_;
	vala_ccode_function_call_add_argument (_tmp176_, (ValaCCodeExpression*) _tmp181_);
	_vala_ccode_node_unref0 (_tmp181_);
	_vala_ccode_node_unref0 (_tmp179_);
	result = (ValaCCodeExpression*) iter_call;
	_vala_ccode_node_unref0 (serialized_value);
	_vala_ccode_node_unref0 (serialized_key);
	_vala_ccode_node_unref0 (iter_next_call);
	_vala_ccode_node_unref0 (gvariant_type);
	_vala_ccode_node_unref0 (iter_init_call);
	_vala_code_node_unref0 (value_type);
	_vala_code_node_unref0 (key_type);
	_vala_iterable_unref0 (type_args);
	_g_free0 (value_name);
	_g_free0 (key_name);
	_g_free0 (tableiter_name);
	_g_free0 (subiter_name);
	return result;
}


static ValaCCodeExpression*
vala_gvariant_module_real_serialize_expression (ValaCCodeBaseModule* base,
                                                ValaDataType* type,
                                                ValaCCodeExpression* expr)
{
	ValaGVariantModule * self;
	ValaCCodeExpression* result = NULL;
	ValaGVariantModuleBasicTypeInfo basic_type = {0};
	ValaCCodeExpression* _result_ = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaCCodeExpression* _tmp44_;
	self = (ValaGVariantModule*) base;
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = vala_data_type_get_data_type (type);
	_tmp1_ = _tmp0_;
	if (vala_gvariant_module_is_string_marshalled_enum (_tmp1_)) {
		ValaGVariantModuleBasicTypeInfo _tmp2_ = {0};
		ValaCCodeExpression* _tmp3_;
		ValaGVariantModuleBasicTypeInfo _tmp4_;
		ValaCCodeExpression* _tmp5_;
		ValaCCodeExpression* _tmp6_;
		vala_gvariant_module_get_basic_type_info (self, "s", &_tmp2_);
		basic_type = _tmp2_;
		_tmp3_ = vala_gvariant_module_generate_enum_value_to_string (self, G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ENUM_VALUE_TYPE) ? ((ValaEnumValueType*) type) : NULL, expr);
		_vala_ccode_node_unref0 (_result_);
		_result_ = _tmp3_;
		_tmp4_ = basic_type;
		_tmp5_ = _result_;
		_tmp6_ = vala_gvariant_module_serialize_basic (self, &_tmp4_, _tmp5_);
		_vala_ccode_node_unref0 (_result_);
		_result_ = _tmp6_;
	} else {
		gchar* _tmp7_;
		gchar* _tmp8_;
		ValaGVariantModuleBasicTypeInfo _tmp9_ = {0};
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp7_ = vala_gvariant_module_get_type_signature (type, NULL);
		_tmp8_ = _tmp7_;
		_tmp10_ = vala_gvariant_module_get_basic_type_info (self, _tmp8_, &_tmp9_);
		basic_type = _tmp9_;
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp8_);
		if (_tmp11_) {
			ValaGVariantModuleBasicTypeInfo _tmp12_;
			ValaCCodeExpression* _tmp13_;
			_tmp12_ = basic_type;
			_tmp13_ = vala_gvariant_module_serialize_basic (self, &_tmp12_, expr);
			_vala_ccode_node_unref0 (_result_);
			_result_ = _tmp13_;
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ARRAY_TYPE)) {
				ValaCCodeExpression* _tmp14_;
				_tmp14_ = vala_gvariant_module_serialize_array (self, G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_ARRAY_TYPE, ValaArrayType), expr);
				_vala_ccode_node_unref0 (_result_);
				_result_ = _tmp14_;
			} else {
				ValaTypeSymbol* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				_tmp15_ = vala_data_type_get_data_type (type);
				_tmp16_ = _tmp15_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_STRUCT)) {
					ValaCCodeExpression* st_expr = NULL;
					ValaCCodeExpression* _tmp17_;
					gboolean _tmp18_;
					gboolean _tmp19_;
					ValaTypeSymbol* _tmp22_;
					ValaTypeSymbol* _tmp23_;
					ValaCCodeExpression* _tmp24_;
					ValaCCodeExpression* _tmp25_;
					_tmp17_ = _vala_ccode_node_ref0 (expr);
					st_expr = _tmp17_;
					_tmp18_ = vala_data_type_get_nullable (type);
					_tmp19_ = _tmp18_;
					if (_tmp19_) {
						ValaCCodeExpression* _tmp20_;
						ValaCCodeUnaryExpression* _tmp21_;
						_tmp20_ = st_expr;
						_tmp21_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, _tmp20_);
						_vala_ccode_node_unref0 (st_expr);
						st_expr = (ValaCCodeExpression*) _tmp21_;
					}
					_tmp22_ = vala_data_type_get_data_type (type);
					_tmp23_ = _tmp22_;
					_tmp24_ = st_expr;
					_tmp25_ = vala_gvariant_module_serialize_struct (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_STRUCT, ValaStruct), _tmp24_);
					_vala_ccode_node_unref0 (_result_);
					_result_ = _tmp25_;
					_vala_ccode_node_unref0 (st_expr);
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_OBJECT_TYPE)) {
						ValaTypeSymbol* _tmp26_;
						ValaTypeSymbol* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gboolean _tmp30_;
						_tmp26_ = vala_data_type_get_data_type (type);
						_tmp27_ = _tmp26_;
						_tmp28_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp27_);
						_tmp29_ = _tmp28_;
						_tmp30_ = g_strcmp0 (_tmp29_, "GLib.Variant") == 0;
						_g_free0 (_tmp29_);
						if (_tmp30_) {
							ValaCCodeFunctionCall* variant_new = NULL;
							ValaCCodeIdentifier* _tmp31_;
							ValaCCodeIdentifier* _tmp32_;
							ValaCCodeFunctionCall* _tmp33_;
							ValaCCodeFunctionCall* _tmp34_;
							ValaCCodeFunctionCall* _tmp35_;
							ValaCCodeFunctionCall* _tmp36_;
							ValaCCodeExpression* _tmp37_;
							_tmp31_ = vala_ccode_identifier_new ("g_variant_new_variant");
							_tmp32_ = _tmp31_;
							_tmp33_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp32_);
							_tmp34_ = _tmp33_;
							_vala_ccode_node_unref0 (_tmp32_);
							variant_new = _tmp34_;
							_tmp35_ = variant_new;
							vala_ccode_function_call_add_argument (_tmp35_, expr);
							_tmp36_ = variant_new;
							_tmp37_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp36_);
							_vala_ccode_node_unref0 (_result_);
							_result_ = _tmp37_;
							_vala_ccode_node_unref0 (variant_new);
						} else {
							ValaTypeSymbol* _tmp38_;
							ValaTypeSymbol* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
							gboolean _tmp42_;
							_tmp38_ = vala_data_type_get_data_type (type);
							_tmp39_ = _tmp38_;
							_tmp40_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp39_);
							_tmp41_ = _tmp40_;
							_tmp42_ = g_strcmp0 (_tmp41_, "GLib.HashTable") == 0;
							_g_free0 (_tmp41_);
							if (_tmp42_) {
								ValaCCodeExpression* _tmp43_;
								_tmp43_ = vala_gvariant_module_serialize_hash_table (self, G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_OBJECT_TYPE, ValaObjectType), expr);
								_vala_ccode_node_unref0 (_result_);
								_result_ = _tmp43_;
							}
						}
					}
				}
			}
		}
	}
	_tmp44_ = _result_;
	if (_tmp44_ == NULL) {
		ValaSourceReference* _tmp45_;
		ValaSourceReference* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		ValaCCodeInvalidExpression* _tmp51_;
		_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) type);
		_tmp46_ = _tmp45_;
		_tmp47_ = vala_code_node_to_string ((ValaCodeNode*) type);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strdup_printf ("GVariant serialization of type `%s' is not supported", _tmp48_);
		_tmp50_ = _tmp49_;
		vala_report_error (_tmp46_, _tmp50_);
		_g_free0 (_tmp50_);
		_g_free0 (_tmp48_);
		_tmp51_ = vala_ccode_invalid_expression_new ();
		result = (ValaCCodeExpression*) _tmp51_;
		_vala_ccode_node_unref0 (_result_);
		return result;
	}
	result = _result_;
	return result;
}


void
vala_gvariant_module_write_expression (ValaGVariantModule* self,
                                       ValaDataType* type,
                                       ValaCCodeExpression* builder_expr,
                                       ValaCCodeExpression* expr,
                                       ValaSymbol* sym)
{
	ValaCCodeExpression* variant_expr = NULL;
	ValaCCodeExpression* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaCCodeExpression* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (builder_expr != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = _vala_ccode_node_ref0 (expr);
	variant_expr = _tmp0_;
	if (sym == NULL) {
		_tmp1_ = TRUE;
	} else {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = vala_gvariant_module_get_dbus_signature (sym);
		_tmp3_ = _tmp2_;
		_tmp1_ = _tmp3_ == NULL;
		_g_free0 (_tmp3_);
	}
	if (_tmp1_) {
		ValaCCodeExpression* _tmp4_;
		_tmp4_ = vala_ccode_base_module_serialize_expression ((ValaCCodeBaseModule*) self, type, expr);
		_vala_ccode_node_unref0 (variant_expr);
		variant_expr = _tmp4_;
	}
	_tmp5_ = variant_expr;
	if (_tmp5_ != NULL) {
		ValaCCodeFunctionCall* builder_add = NULL;
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeIdentifier* _tmp7_;
		ValaCCodeFunctionCall* _tmp8_;
		ValaCCodeFunctionCall* _tmp9_;
		ValaCCodeFunctionCall* _tmp10_;
		ValaCCodeUnaryExpression* _tmp11_;
		ValaCCodeUnaryExpression* _tmp12_;
		ValaCCodeFunctionCall* _tmp13_;
		ValaCCodeExpression* _tmp14_;
		ValaCCodeFunction* _tmp15_;
		ValaCCodeFunction* _tmp16_;
		ValaCCodeFunctionCall* _tmp17_;
		_tmp6_ = vala_ccode_identifier_new ("g_variant_builder_add_value");
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp7_);
		_tmp9_ = _tmp8_;
		_vala_ccode_node_unref0 (_tmp7_);
		builder_add = _tmp9_;
		_tmp10_ = builder_add;
		_tmp11_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, builder_expr);
		_tmp12_ = _tmp11_;
		vala_ccode_function_call_add_argument (_tmp10_, (ValaCCodeExpression*) _tmp12_);
		_vala_ccode_node_unref0 (_tmp12_);
		_tmp13_ = builder_add;
		_tmp14_ = variant_expr;
		vala_ccode_function_call_add_argument (_tmp13_, _tmp14_);
		_tmp15_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = builder_add;
		vala_ccode_function_add_expression (_tmp16_, (ValaCCodeExpression*) _tmp17_);
		_vala_ccode_node_unref0 (builder_add);
	}
	_vala_ccode_node_unref0 (variant_expr);
}


ValaGVariantModule*
vala_gvariant_module_construct (GType object_type)
{
	ValaGVariantModule* self = NULL;
	self = (ValaGVariantModule*) vala_gasync_module_construct (object_type);
	return self;
}


ValaGVariantModule*
vala_gvariant_module_new (void)
{
	return vala_gvariant_module_construct (VALA_TYPE_GVARIANT_MODULE);
}


static ValaGVariantModuleBasicTypeInfo*
vala_gvariant_module_basic_type_info_dup (const ValaGVariantModuleBasicTypeInfo* self)
{
	ValaGVariantModuleBasicTypeInfo* dup;
	dup = g_new0 (ValaGVariantModuleBasicTypeInfo, 1);
	memcpy (dup, self, sizeof (ValaGVariantModuleBasicTypeInfo));
	return dup;
}


static void
vala_gvariant_module_basic_type_info_free (ValaGVariantModuleBasicTypeInfo* self)
{
	g_free (self);
}


static GType
vala_gvariant_module_basic_type_info_get_type (void)
{
	static volatile gsize vala_gvariant_module_basic_type_info_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gvariant_module_basic_type_info_type_id__volatile)) {
		GType vala_gvariant_module_basic_type_info_type_id;
		vala_gvariant_module_basic_type_info_type_id = g_boxed_type_register_static ("ValaGVariantModuleBasicTypeInfo", (GBoxedCopyFunc) vala_gvariant_module_basic_type_info_dup, (GBoxedFreeFunc) vala_gvariant_module_basic_type_info_free);
		g_once_init_leave (&vala_gvariant_module_basic_type_info_type_id__volatile, vala_gvariant_module_basic_type_info_type_id);
	}
	return vala_gvariant_module_basic_type_info_type_id__volatile;
}


static void
vala_gvariant_module_class_init (ValaGVariantModuleClass * klass)
{
	vala_gvariant_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor*, ValaEnum*)) vala_gvariant_module_real_visit_enum;
	((ValaCCodeBaseModuleClass *) klass)->generate_enum_declaration = (gboolean (*) (ValaCCodeBaseModule*, ValaEnum*, ValaCCodeFile*)) vala_gvariant_module_real_generate_enum_declaration;
	((ValaCCodeBaseModuleClass *) klass)->deserialize_expression = (ValaCCodeExpression* (*) (ValaCCodeBaseModule*, ValaDataType*, ValaCCodeExpression*, ValaCCodeExpression*, ValaCCodeExpression*, gboolean*)) vala_gvariant_module_real_deserialize_expression;
	((ValaCCodeBaseModuleClass *) klass)->serialize_expression = (ValaCCodeExpression* (*) (ValaCCodeBaseModule*, ValaDataType*, ValaCCodeExpression*)) vala_gvariant_module_real_serialize_expression;
}


static void
vala_gvariant_module_instance_init (ValaGVariantModule * self)
{
}


GType
vala_gvariant_module_get_type (void)
{
	static volatile gsize vala_gvariant_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gvariant_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGVariantModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gvariant_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGVariantModule), 0, (GInstanceInitFunc) vala_gvariant_module_instance_init, NULL };
		GType vala_gvariant_module_type_id;
		vala_gvariant_module_type_id = g_type_register_static (VALA_TYPE_GASYNC_MODULE, "ValaGVariantModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gvariant_module_type_id__volatile, vala_gvariant_module_type_id);
	}
	return vala_gvariant_module_type_id__volatile;
}



