/* valaenum.c generated by valac, the Vala compiler
 * generated from valaenum.vala, do not modify */

/* valaenum.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaEnumPrivate {
	ValaList* values;
	ValaList* methods;
	ValaList* constants;
	gboolean* _is_flags;
};


static gpointer vala_enum_parent_class = NULL;

#define VALA_ENUM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ENUM, ValaEnumPrivate))
static void vala_enum_real_add_method (ValaSymbol* base,
                                ValaMethod* m);
static void vala_enum_real_add_constant (ValaSymbol* base,
                                  ValaConstant* c);
static void vala_enum_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor);
static void vala_enum_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static gboolean vala_enum_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_enum_real_check (ValaCodeNode* base,
                               ValaCodeContext* context);
static gboolean* _bool_dup (gboolean* self);
static void vala_enum_finalize (ValaCodeNode * obj);


/**
 * Creates a new enum.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @return                 newly created enum
 */
ValaEnum*
vala_enum_construct (GType object_type,
                     const gchar* name,
                     ValaSourceReference* source_reference,
                     ValaComment* comment)
{
	ValaEnum* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaEnum*) vala_typesymbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaEnum*
vala_enum_new (const gchar* name,
               ValaSourceReference* source_reference,
               ValaComment* comment)
{
	return vala_enum_construct (VALA_TYPE_ENUM, name, source_reference, comment);
}


/**
 * Appends the specified enum value to the list of values.
 *
 * @param value an enum value
 */
void
vala_enum_add_value (ValaEnum* self,
                     ValaEnumValue* value)
{
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	vala_symbol_set_access ((ValaSymbol*) value, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp0_ = self->priv->values;
	vala_collection_add ((ValaCollection*) _tmp0_, value);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) value);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) value);
}


/**
 * Adds the specified method as a member to this enum.
 *
 * @param m a method
 */
static void
vala_enum_real_add_method (ValaSymbol* base,
                           ValaMethod* m)
{
	ValaEnum * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp16_ = FALSE;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaList* _tmp33_;
	ValaScope* _tmp34_;
	ValaScope* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	self = (ValaEnum*) base;
	g_return_if_fail (m != NULL);
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaEnumValueType* _tmp4_;
		ValaEnumValueType* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp4_ = vala_enum_value_type_new (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		vala_method_set_this_parameter (m, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_method_get_this_parameter (m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_method_get_this_parameter (m);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp17_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp18_ = _tmp17_;
	if (!VALA_IS_VOID_TYPE (_tmp18_)) {
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp19_ = vala_method_get_postconditions (m);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = _tmp22_ > 0;
		_vala_iterable_unref0 (_tmp20_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaDataType* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		_tmp23_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_data_type_copy (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_local_variable_new (_tmp26_, "result", NULL, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
		_vala_code_node_unref0 (_tmp26_);
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		vala_local_variable_set_is_result (_tmp32_, TRUE);
	}
	_tmp33_ = self->priv->methods;
	vala_collection_add ((ValaCollection*) _tmp33_, m);
	_tmp34_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp37_ = _tmp36_;
	vala_scope_add (_tmp35_, _tmp37_, (ValaSymbol*) m);
}


/**
 * Adds the specified constant as a member to this enum.
 *
 * @param c a constant
 */
static void
vala_enum_real_add_constant (ValaSymbol* base,
                             ValaConstant* c)
{
	ValaEnum * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaEnum*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->constants;
	vala_collection_add ((ValaCollection*) _tmp0_, c);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) c);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) c);
}


/**
 * Returns a copy of the list of enum values.
 *
 * @return list of enum values
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_enum_get_values (ValaEnum* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->values;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


void
vala_enum_remove_all_values (ValaEnum* self)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->values;
	vala_collection_clear ((ValaCollection*) _tmp0_);
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
ValaList*
vala_enum_get_methods (ValaEnum* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->methods;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
ValaList*
vala_enum_get_constants (ValaEnum* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_enum_real_accept (ValaCodeNode* base,
                       ValaCodeVisitor* visitor)
{
	ValaEnum * self;
	self = (ValaEnum*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_enum (visitor, self);
}


static void
vala_enum_real_accept_children (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaEnum * self;
	self = (ValaEnum*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _value_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _value_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _value_index = 0;
		_tmp0_ = self->priv->values;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_value_list = _tmp1_;
		_tmp2_ = _value_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_value_size = _tmp4_;
		_value_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaEnumValue* value = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaEnumValue* _tmp11_;
			_tmp5_ = _value_index;
			_value_index = _tmp5_ + 1;
			_tmp6_ = _value_index;
			_tmp7_ = _value_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _value_list;
			_tmp9_ = _value_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			value = (ValaEnumValue*) _tmp10_;
			_tmp11_ = value;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (value);
		}
		_vala_iterable_unref0 (_value_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _m_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _m_index = 0;
		_tmp12_ = self->priv->methods;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_m_list = _tmp13_;
		_tmp14_ = _m_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_m_size = _tmp16_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaMethod* m = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaMethod* _tmp23_;
			_tmp17_ = _m_index;
			_m_index = _tmp17_ + 1;
			_tmp18_ = _m_index;
			_tmp19_ = _m_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _m_list;
			_tmp21_ = _m_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			m = (ValaMethod*) _tmp22_;
			_tmp23_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp23_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp24_;
		ValaList* _tmp25_;
		gint _c_size = 0;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _c_index = 0;
		_tmp24_ = self->priv->constants;
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_c_list = _tmp25_;
		_tmp26_ = _c_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_c_size = _tmp28_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			ValaConstant* c = NULL;
			ValaList* _tmp32_;
			gint _tmp33_;
			gpointer _tmp34_;
			ValaConstant* _tmp35_;
			_tmp29_ = _c_index;
			_c_index = _tmp29_ + 1;
			_tmp30_ = _c_index;
			_tmp31_ = _c_size;
			if (!(_tmp30_ < _tmp31_)) {
				break;
			}
			_tmp32_ = _c_list;
			_tmp33_ = _c_index;
			_tmp34_ = vala_list_get (_tmp32_, _tmp33_);
			c = (ValaConstant*) _tmp34_;
			_tmp35_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp35_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
}


static gboolean
vala_enum_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaEnum * self;
	gboolean result = FALSE;
	self = (ValaEnum*) base;
	result = FALSE;
	return result;
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_enum_real_check (ValaCodeNode* base,
                      ValaCodeContext* context)
{
	ValaEnum * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	ValaSemanticAnalyzer* _tmp69_;
	ValaSemanticAnalyzer* _tmp70_;
	ValaSourceFile* _tmp71_;
	ValaSemanticAnalyzer* _tmp72_;
	ValaSemanticAnalyzer* _tmp73_;
	ValaSymbol* _tmp74_;
	gboolean _tmp75_;
	gboolean _tmp76_;
	self = (ValaEnum*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = self->priv->values;
	_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ <= 0) {
		ValaSourceReference* _tmp27_;
		ValaSourceReference* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strdup_printf ("Enum `%s' requires at least one value", _tmp30_);
		_tmp32_ = _tmp31_;
		vala_report_error (_tmp28_, _tmp32_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp30_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _value_list = NULL;
		ValaList* _tmp33_;
		ValaList* _tmp34_;
		gint _value_size = 0;
		ValaList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _value_index = 0;
		_tmp33_ = self->priv->values;
		_tmp34_ = _vala_iterable_ref0 (_tmp33_);
		_value_list = _tmp34_;
		_tmp35_ = _value_list;
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_value_size = _tmp37_;
		_value_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			ValaEnumValue* value = NULL;
			ValaList* _tmp41_;
			gint _tmp42_;
			gpointer _tmp43_;
			ValaEnumValue* _tmp44_;
			_tmp38_ = _value_index;
			_value_index = _tmp38_ + 1;
			_tmp39_ = _value_index;
			_tmp40_ = _value_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _value_list;
			_tmp42_ = _value_index;
			_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
			value = (ValaEnumValue*) _tmp43_;
			_tmp44_ = value;
			vala_code_node_check ((ValaCodeNode*) _tmp44_, context);
			_vala_code_node_unref0 (value);
		}
		_vala_iterable_unref0 (_value_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp45_;
		ValaList* _tmp46_;
		gint _m_size = 0;
		ValaList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _m_index = 0;
		_tmp45_ = self->priv->methods;
		_tmp46_ = _vala_iterable_ref0 (_tmp45_);
		_m_list = _tmp46_;
		_tmp47_ = _m_list;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_m_size = _tmp49_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			ValaMethod* m = NULL;
			ValaList* _tmp53_;
			gint _tmp54_;
			gpointer _tmp55_;
			ValaMethod* _tmp56_;
			_tmp50_ = _m_index;
			_m_index = _tmp50_ + 1;
			_tmp51_ = _m_index;
			_tmp52_ = _m_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _m_list;
			_tmp54_ = _m_index;
			_tmp55_ = vala_list_get (_tmp53_, _tmp54_);
			m = (ValaMethod*) _tmp55_;
			_tmp56_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp56_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp57_;
		ValaList* _tmp58_;
		gint _c_size = 0;
		ValaList* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gint _c_index = 0;
		_tmp57_ = self->priv->constants;
		_tmp58_ = _vala_iterable_ref0 (_tmp57_);
		_c_list = _tmp58_;
		_tmp59_ = _c_list;
		_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
		_tmp61_ = _tmp60_;
		_c_size = _tmp61_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			ValaConstant* c = NULL;
			ValaList* _tmp65_;
			gint _tmp66_;
			gpointer _tmp67_;
			ValaConstant* _tmp68_;
			_tmp62_ = _c_index;
			_c_index = _tmp62_ + 1;
			_tmp63_ = _c_index;
			_tmp64_ = _c_size;
			if (!(_tmp63_ < _tmp64_)) {
				break;
			}
			_tmp65_ = _c_list;
			_tmp66_ = _c_index;
			_tmp67_ = vala_list_get (_tmp65_, _tmp66_);
			c = (ValaConstant*) _tmp67_;
			_tmp68_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp68_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	_tmp69_ = vala_code_context_get_analyzer (context);
	_tmp70_ = _tmp69_;
	_tmp71_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp70_, _tmp71_);
	_tmp72_ = vala_code_context_get_analyzer (context);
	_tmp73_ = _tmp72_;
	_tmp74_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp73_, _tmp74_);
	_tmp75_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp76_ = _tmp75_;
	result = !_tmp76_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}


gboolean
vala_enum_get_is_flags (ValaEnum* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_flags;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		ValaAttribute* _tmp2_;
		gboolean _tmp3_;
		gboolean* _tmp4_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Flags");
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_ != NULL;
		_tmp4_ = __bool_dup0 (&_tmp3_);
		_g_free0 (self->priv->_is_flags);
		self->priv->_is_flags = _tmp4_;
		_vala_code_node_unref0 (_tmp2_);
	}
	_tmp5_ = self->priv->_is_flags;
	result = *_tmp5_;
	return result;
}


static void
vala_enum_class_init (ValaEnumClass * klass)
{
	vala_enum_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_enum_finalize;
	g_type_class_add_private (klass, sizeof (ValaEnumPrivate));
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_enum_real_add_method;
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol*, ValaConstant*)) vala_enum_real_add_constant;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_enum_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_enum_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_enum_real_is_reference_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_enum_real_check;
}


static void
vala_enum_instance_init (ValaEnum * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	self->priv = VALA_ENUM_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_ENUM_VALUE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->values = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->methods = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->constants = (ValaList*) _tmp5_;
}


static void
vala_enum_finalize (ValaCodeNode * obj)
{
	ValaEnum * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ENUM, ValaEnum);
	_vala_iterable_unref0 (self->priv->values);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->constants);
	_g_free0 (self->priv->_is_flags);
	VALA_CODE_NODE_CLASS (vala_enum_parent_class)->finalize (obj);
}


/**
 * Represents an enum declaration in the source code.
 */
GType
vala_enum_get_type (void)
{
	static volatile gsize vala_enum_type_id__volatile = 0;
	if (g_once_init_enter (&vala_enum_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaEnumClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_enum_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaEnum), 0, (GInstanceInitFunc) vala_enum_instance_init, NULL };
		GType vala_enum_type_id;
		vala_enum_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaEnum", &g_define_type_info, 0);
		g_once_init_leave (&vala_enum_type_id__volatile, vala_enum_type_id);
	}
	return vala_enum_type_id__volatile;
}



