/*
 * ===========================
 * VDK Visual Development Kit
 * xdb subsystem
 * ===========================
 *
 * Copyright (C) 1998,2004, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
 
 #include <vdkxdb2/vdkxparser.h>
 
 //
 VDKXParser::VDKXParser(VDKXDatabase* xdb,VDKXTable* table):
   xdb(xdb),table(table),type('U')
 {
 
 }

VDKXParser::~VDKXParser() { if(expr) delete[] expr; }

//  
char* 
VDKXParser::Expression() { return expr; }
//
char 
VDKXParser::ResultType() { return type; }
//
int 
VDKXParser::GetIntResult() { return xdb->GetIntResult(); }
//
double 
VDKXParser::GetDoubleResult(){  return xdb->GetDoubleResult(); }
//
const char* 
VDKXParser::GetStringResult() { return xdb->GetStringResult().c_str(); } 

xbShort
VDKXParser::Parse( char* opnd1, char* opr, char* opnd2 )
{ 
xbShort rc; 
XB_EXPRESSION *e;
int l1 = strlen(opnd1);
int lopr = opr ? strlen(opr) : 0 ;
int l2 = opnd2 ? strlen(opnd2) : 0 ;
if(expr)
    delete[] expr;
expr = new char[l1+lopr+l2+16];
sprintf(expr,"%s%s%s",opnd1,opr ? opr : "",opnd2 ? opnd2: "");
if(( rc = xdb->ParseExpression( expr, table )) != XB_NO_ERROR ) 
	return rc; 
e = xdb->GetExpressionHandle(); 
if(( rc = xdb->ProcessExpression( e )) != XB_NO_ERROR ) 
	return rc; 
type = xdb->GetExpressionResultType( e ); 
switch (type)
    {
        case 'C':
        case 'N':
        case 'L':
          return XB_NO_ERROR;
          break;
        default:
          return XB_PARSE_ERROR;
    }
}
