// Copyright (c) 2018 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "dominator_analysis.h"

#include <unordered_set>

namespace spvtools {
namespace opt {

ir::BasicBlock* DominatorAnalysisBase::CommonDominator(
    ir::BasicBlock* b1, ir::BasicBlock* b2) const {
  if (!b1 || !b2) return nullptr;

  std::unordered_set<ir::BasicBlock*> seen;
  ir::BasicBlock* block = b1;
  while (block && seen.insert(block).second) {
    block = ImmediateDominator(block);
  }

  block = b2;
  while (block && !seen.count(block)) {
    block = ImmediateDominator(block);
  }

  return block;
}

}  // namespace opt
}  // namespace spvtools
